/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.bis.dao.GlobeDeployStatusDao;
import com.hs.atic.sdk.bis.service.IBaseLineService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.zone.dao.ZoneIpStatusDao;
import com.hs.atic.zone.dao.ZoneListPortMapStateDao;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneStatusDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterDeviceInfoDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterDeviceStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZonePolicyApplyDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceStatusDao;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceInfo;
import com.hs.vsm.secservice.ddos.model.ZonePolicyApplyInfo;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IServiceLearningParamService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceForm;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.resource.dao.AticDeviceNfaClusterDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeleteDevicePolicyService {
    private static final int SLLEEP_TIME = 1000;
    private static final int LOOP_COUNT = 100;
    private IBaseLineService baseLineService;
    private IServiceLearningParamService serviceLearningParamService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneDeviceDao zoneDeviceDao;
    private ZoneServiceDao zoneServiceDao;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private ZoneServiceStatusDao zoneServiceStatusDao;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private ZonePolicyApplyDao zonePolicyApplyDao;
    private ICommonUtilService commonUtilService;
    private IAticDeviceService aticDeviceService;
    private IZoneService userService;
    private IFilterDeviceZoneInfoService filterZoneService;
    private FilterDeviceZoneStatusDao filterDeviceZoneStatusDao;
    private FilterDeviceDao filterDeviceDao;
    private NPFilterDeviceInfoDao npFilterDeviceInfoDao;
    private NPFilterDeviceStatusDao npFilterDeviceStatusDao;
    private IZoneServiceService zoneServiceService;
    private IClusterService clusterService;
    private GlobeDeployStatusDao globeDeployStatusDao;
    private ZoneIpStatusDao zoneIpStatusDao;
    private ZoneListPortMapStateDao zoneListPortMapStateDao;
    private AticDeviceNfaClusterDao aticDeviceNfaClusterDao;

    public void deleteDevice(List<AticDeviceForm> deviceList) {
        this.logger.info((Object)"MsgReceiverOnDeleteDevice");
        if (null != deviceList && !deviceList.isEmpty()) {
            for (AticDeviceForm device : deviceList) {
                try {
                    this.logger.info((Object)("device id:" + device.getMoId()));
                    this.globeDeployStatusDao.deleteIpDeployStatus(device.getMoId());
                    this.logger.info((Object)"call abnormalDfnService.deleteByDeviceId");
                    if (device.getDeviceType() != 1 && device.getDeviceType() != 8 && 9 != device.getDeviceType()) continue;
                    List<Long> zoneIdList = this.zoneDeviceDao.getByDevId(device.getMoId());
                    if (9 == device.getDeviceType()) {
                        List nfaList = this.clusterService.getBindNfaDevice(Long.valueOf(device.getMoId()));
                        ArrayList nfaListCopy = new ArrayList();
                        nfaListCopy.addAll(nfaList);
                        this.zoneDeviceDao.deleteByDeviceId(device.getMoId());
                        this.clusterService.deleteByClusterId(Long.valueOf(device.getMoId()));
                        for (AticDeviceNfaCluster itemNfa : nfaListCopy) {
                            this.zoneDeviceDeployStatusDao.deleteByDeviceId(itemNfa.getDeviceId());
                            this.zoneFeatureStatusDao.deleteByDeviceId(itemNfa.getDeviceId());
                            this.zoneServiceStatusDao.deleteByDeviceId(itemNfa.getDeviceId());
                            this.zoneIpStatusDao.deleteIpByDeviceId(itemNfa.getDeviceId());
                        }
                        this.zoneServiceService.deleteByDeviceId(device.getMoId());
                        this.filterZoneService.delFilterRelationByDeviceId(device.getMoId());
                        for (AticDeviceNfaCluster itemNfa : nfaListCopy) {
                            this.filterDeviceZoneStatusDao.deleteByDeviceId(itemNfa.getDeviceId());
                            this.filterDeviceDao.deleteByDeviceId(itemNfa.getDeviceId());
                        }
                    } else {
                        this.zoneDeviceDao.deleteByDeviceId(device.getMoId());
                        this.zoneDeviceDeployStatusDao.deleteByDeviceId(device.getMoId());
                        this.zoneFeatureStatusDao.deleteByDeviceId(device.getMoId());
                        this.zoneServiceStatusDao.deleteByDeviceId(device.getMoId());
                        this.zoneServiceService.deleteByDeviceId(device.getMoId());
                        this.zoneIpStatusDao.deleteIpByDeviceId(device.getMoId());
                        this.zoneListPortMapStateDao.deleteByDeviceId(device.getMoId());
                        this.filterZoneService.delFilterRelationByDeviceId(device.getMoId());
                        this.filterDeviceZoneStatusDao.deleteByDeviceId(device.getMoId());
                        this.filterDeviceDao.deleteByDeviceId(device.getMoId());
                        this.npFilterDeviceInfoDao.deleteByDeviceId(device.getMoId());
                        this.npFilterDeviceStatusDao.deleteByDeviceId(device.getMoId());
                    }
                    this.updateZonePolicyDeployState(zoneIdList);
                }
                catch (RuntimeException e) {
                    this.logger.error((Object)e.getMessage());
                }
            }
        } else {
            this.logger.error((Object)"moidList is null or empty");
        }
    }

    private void updateZonePolicyDeployState(List<Long> zoneIdList) {
        if (zoneIdList != null && !zoneIdList.isEmpty()) {
            for (long zoneId : zoneIdList) {
                int deployTotal = 0;
                int deploySucess = 0;
                int deployFailed = 0;
                List<ZoneDeviceDeployStatusInfo> zoneDeviceDeployStatusInfoList = this.zoneDeviceDeployStatusDao.queryByZoneId(zoneId);
                if (zoneDeviceDeployStatusInfoList != null) {
                    for (ZoneDeviceDeployStatusInfo deployInfo : zoneDeviceDeployStatusInfoList) {
                        if (deployInfo.getDeployState() != null && deployInfo.getDeployState().booleanValue()) {
                            ++deploySucess;
                        } else {
                            ++deployFailed;
                        }
                        ++deployTotal;
                    }
                }
                if (deployTotal == 0) {
                    this.zonePolicyApplyDao.updateDeployStateByZoneId(zoneId, "UNDEPLOY");
                } else if (deployFailed > 0) {
                    this.zonePolicyApplyDao.updateDeployStateByZoneId(zoneId, "PART_SUCCESS");
                } else {
                    this.zonePolicyApplyDao.updateDeployStateByZoneId(zoneId, "SUCCESS");
                }
                List<FilterDeviceZoneStatusInfo> zoneFilterStatusList = this.filterDeviceZoneStatusDao.getByZoneId(zoneId);
                deployTotal = 0;
                deploySucess = 0;
                deployFailed = 0;
                for (FilterDeviceZoneStatusInfo deployInfo : zoneFilterStatusList) {
                    if (deployInfo.getDeployState() != null && deployInfo.getDeployState().booleanValue()) {
                        ++deploySucess;
                    } else {
                        ++deployFailed;
                    }
                    ++deployTotal;
                }
                if (deployTotal == 0) {
                    this.zonePolicyApplyDao.updateFilterDeployStateByZoneId(zoneId, "UNDEPLOY");
                } else if (deployFailed > 0) {
                    this.zonePolicyApplyDao.updateFilterDeployStateByZoneId(zoneId, "PART_SUCCESS");
                } else if (deploySucess > 0) {
                    this.zonePolicyApplyDao.updateFilterDeployStateByZoneId(zoneId, "SUCCESS");
                }
                this.updateAbnormalState(zoneId);
                this.dealBaseLineAndServiceLearn(zoneId);
            }
        }
    }

    private void dealBaseLineAndServiceLearn(Long zoneId) {
        HashSet<Long> devSet = new HashSet<Long>();
        this.serviceLearningParamService.stopServiceLearnintTaskByDevice(zoneId, devSet);
        List<ZoneDeviceInfo> zoneDeviceInfos = this.getZoneDeviceDao().getByZoneId(zoneId);
        this.dealServAndBaseLineRemainDev(zoneDeviceInfos, zoneId);
    }

    private void dealServAndBaseLineRemainDev(List<ZoneDeviceInfo> zoneDeviceInfos, Long zoneId) {
        ZonePolicyApplyInfo policyForm;
        Boolean supportServiceLearn = false;
        if (null == zoneDeviceInfos || zoneDeviceInfos.isEmpty()) {
            this.getBaseLineService().stopBaseLineTaskByZoneId(zoneId);
        }
        if (null != zoneDeviceInfos) {
            for (ZoneDeviceInfo zoneDeviceInfo : zoneDeviceInfos) {
                AticDevice device = this.aticDeviceService.getDeviceByMoid(zoneDeviceInfo.getDeviceId().longValue());
                Boolean temp = this.getCommonUtilService().isSupportSrvLearning(device.getIpAddress());
                if (!temp.booleanValue()) continue;
                supportServiceLearn = temp;
            }
        }
        if (!supportServiceLearn.booleanValue()) {
            this.serviceLearningParamService.stopServiceLearningTask(zoneId);
        }
        if (null != (policyForm = this.zonePolicyApplyDao.getBaseZonePolicyApplyInfoByZoneId(zoneId)) && "UNDEPLOY".equals(policyForm.getDeployState())) {
            this.getBaseLineService().stopBaseLineTaskByZoneId(zoneId);
        }
    }

    private void updateAbnormalState(Long zoneId) {
        List<ZonePolicyApplyInfo> zonePolicyApplyInfos = this.zonePolicyApplyDao.getListByZoneId(zoneId);
        if (!zonePolicyApplyInfos.isEmpty()) {
            if (!String.valueOf("NORMAL").equals(zonePolicyApplyInfos.get(0).getAbnormalState()) && (null == zonePolicyApplyInfos.get(0).getZoneDeviceInfos() || zonePolicyApplyInfos.get(0).getZoneDeviceInfos().isEmpty())) {
                zonePolicyApplyInfos.get(0).setAbnormalState("NORMAL");
            }
            this.zonePolicyApplyDao.saveOrUpdate(zonePolicyApplyInfos.get(0));
        }
    }

    private IBaseLineService getBaseLineService() {
        for (int i = 0; null == this.baseLineService && i < 100; ++i) {
            try {
                this.baseLineService = (IBaseLineService)ServiceContext.getInstance().getService("baselineService", IBaseLineService.class);
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.error((Object)e.getMessage());
            }
        }
        return this.baseLineService;
    }

    public FilterDeviceZoneStatusDao getFilterDeviceZoneStatusDao() {
        return this.filterDeviceZoneStatusDao;
    }

    public void setFilterDeviceZoneStatusDao(FilterDeviceZoneStatusDao filterDeviceZoneStatusDao) {
        this.filterDeviceZoneStatusDao = filterDeviceZoneStatusDao;
    }

    public FilterDeviceDao getFilterDeviceDao() {
        return this.filterDeviceDao;
    }

    public void setFilterDeviceDao(FilterDeviceDao filterDeviceDao) {
        this.filterDeviceDao = filterDeviceDao;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public IFilterDeviceZoneInfoService getFilterZoneService() {
        return this.filterZoneService;
    }

    public void setFilterZoneService(IFilterDeviceZoneInfoService filterZoneService) {
        this.filterZoneService = filterZoneService;
    }

    public NPFilterDeviceInfoDao getNpFilterDeviceInfoDao() {
        return this.npFilterDeviceInfoDao;
    }

    public void setNpFilterDeviceInfoDao(NPFilterDeviceInfoDao npFilterDeviceInfoDao) {
        this.npFilterDeviceInfoDao = npFilterDeviceInfoDao;
    }

    public NPFilterDeviceStatusDao getNpFilterDeviceStatusDao() {
        return this.npFilterDeviceStatusDao;
    }

    public void setNpFilterDeviceStatusDao(NPFilterDeviceStatusDao npFilterDeviceStatusDao) {
        this.npFilterDeviceStatusDao = npFilterDeviceStatusDao;
    }

    public IZoneService getUserService() {
        return this.userService;
    }

    public void setUserService(IZoneService userService) {
        this.userService = userService;
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public IServiceLearningParamService getServiceLearningParamService() {
        return this.serviceLearningParamService;
    }

    public void setServiceLearningParamService(IServiceLearningParamService serviceLearningParamService) {
        this.serviceLearningParamService = serviceLearningParamService;
    }

    public ZoneDeviceDao getZoneDeviceDao() {
        return this.zoneDeviceDao;
    }

    public void setZoneDeviceDao(ZoneDeviceDao zoneDeviceDao) {
        this.zoneDeviceDao = zoneDeviceDao;
    }

    public ZoneServiceDao getZoneServiceDao() {
        return this.zoneServiceDao;
    }

    public void setZoneServiceDao(ZoneServiceDao zoneServiceDao) {
        this.zoneServiceDao = zoneServiceDao;
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public ZoneServiceStatusDao getZoneServiceStatusDao() {
        return this.zoneServiceStatusDao;
    }

    public void setZoneServiceStatusDao(ZoneServiceStatusDao zoneServiceStatusDao) {
        this.zoneServiceStatusDao = zoneServiceStatusDao;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public ZonePolicyApplyDao getZonePolicyApplyDao() {
        return this.zonePolicyApplyDao;
    }

    public void setZonePolicyApplyDao(ZonePolicyApplyDao zonePolicyApplyDao) {
        this.zonePolicyApplyDao = zonePolicyApplyDao;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public IZoneServiceService getZoneServiceService() {
        return this.zoneServiceService;
    }

    public void setZoneServiceService(IZoneServiceService zoneServiceService) {
        this.zoneServiceService = zoneServiceService;
    }

    public GlobeDeployStatusDao getGlobeDeployStatusDao() {
        return this.globeDeployStatusDao;
    }

    public void setGlobeDeployStatusDao(GlobeDeployStatusDao globeDeployStatusDao) {
        this.globeDeployStatusDao = globeDeployStatusDao;
    }

    public ZoneIpStatusDao getZoneIpStatusDao() {
        return this.zoneIpStatusDao;
    }

    public void setZoneIpStatusDao(ZoneIpStatusDao zoneIpStatusDao) {
        this.zoneIpStatusDao = zoneIpStatusDao;
    }

    public ZoneListPortMapStateDao getZoneListPortMapStateDao() {
        return this.zoneListPortMapStateDao;
    }

    public void setZoneListPortMapStateDao(ZoneListPortMapStateDao zoneListPortMapStateDao) {
        this.zoneListPortMapStateDao = zoneListPortMapStateDao;
    }

    public AticDeviceNfaClusterDao getAticDeviceNfaClusterDao() {
        return this.aticDeviceNfaClusterDao;
    }

    public void setAticDeviceNfaClusterDao(AticDeviceNfaClusterDao aticDeviceNfaClusterDao) {
        this.aticDeviceNfaClusterDao = aticDeviceNfaClusterDao;
    }
}

