/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.secservice.ddos.dao.NfaPolicyDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceDao;
import com.hs.vsm.secservice.ddos.model.NfaPolicyInfo;
import com.hs.vsm.secservice.nfa.util.NfaPolicyUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyEditService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

public class NfaPolicyEditServiceImpl
implements INfaPolicyEditService {
    private NfaPolicyDao nfaPolicyDao;
    private ZoneServiceDao zoneServiceDao;

    public Long create(NfaPolicyEditForm form) {
        Iterator<NfaPolicyForm> iterator;
        List<NfaPolicyForm> nfaPolicyForms;
        if (null != form && !(nfaPolicyForms = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(form)).isEmpty() && (iterator = nfaPolicyForms.iterator()).hasNext()) {
            NfaPolicyForm nfaPolicyForm = iterator.next();
            Long pkid = null;
            NfaPolicyInfo info = this.tranFormInfo(nfaPolicyForm);
            pkid = (Long)this.nfaPolicyDao.create(info);
            return pkid;
        }
        return null;
    }

    public void createOrUpdate(NfaPolicyEditForm form) {
        List<NfaPolicyForm> nfaPolicyForms = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(form);
        if (!nfaPolicyForms.isEmpty()) {
            for (NfaPolicyForm nfaForm : nfaPolicyForms) {
                NfaPolicyInfo nfaInfo = new NfaPolicyInfo();
                NfaPolicyUtil.nfaPolicyFormTransInfo(nfaForm, nfaInfo);
                this.nfaPolicyDao.createOrUpdate(nfaInfo);
            }
        }
    }

    @Override
    public NfaPolicyEditForm queryNfaPolicyByServiceId(Long serviceId) {
        NfaPolicyEditForm nfaPolicyEditForm = null;
        List<NfaPolicyInfo> nfaPolicyInfos = this.nfaPolicyDao.queryListByServiceId(serviceId);
        ArrayList<NfaPolicyForm> nfaPolicyForms = new ArrayList<NfaPolicyForm>();
        if (null != nfaPolicyInfos && !nfaPolicyInfos.isEmpty()) {
            for (NfaPolicyInfo nfaInfo : nfaPolicyInfos) {
                NfaPolicyForm nfaForm = new NfaPolicyForm();
                NfaPolicyUtil.nfaPolicyInfoTransForm(nfaInfo, nfaForm);
                nfaPolicyForms.add(nfaForm);
            }
        }
        try {
            nfaPolicyEditForm = NfaPolicyUtil.nfaPolicyFormConvNfaPolicyEditFrom(nfaPolicyForms);
        }
        catch (Exception e) {
            return null;
        }
        return nfaPolicyEditForm;
    }

    public void save(NfaPolicyEditForm form) {
        List<NfaPolicyForm> nfaPolicyForms = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(form);
        boolean onlyOutbound = false;
        if (!nfaPolicyForms.isEmpty()) {
            NfaPolicyInfo nfaInfo;
            for (NfaPolicyForm nfaForm : nfaPolicyForms) {
                nfaInfo = new NfaPolicyInfo();
                NfaPolicyUtil.nfaPolicyFormTransInfo(nfaForm, nfaInfo);
                if (nfaInfo.getDirection() != 2) continue;
                onlyOutbound = true;
                this.nfaPolicyDao.save(nfaInfo);
            }
            if (!onlyOutbound) {
                for (NfaPolicyForm nfaForm : nfaPolicyForms) {
                    nfaInfo = new NfaPolicyInfo();
                    NfaPolicyUtil.nfaPolicyFormTransInfo(nfaForm, nfaInfo);
                    if (nfaInfo.getDirection() != 1) continue;
                    this.nfaPolicyDao.save(nfaInfo);
                }
            }
        }
    }

    public void update(NfaPolicyEditForm form) {
        List<NfaPolicyForm> nfaPolicyForms = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(form);
        if (!nfaPolicyForms.isEmpty()) {
            for (NfaPolicyForm nfaForm : nfaPolicyForms) {
                NfaPolicyInfo nfaInfo = new NfaPolicyInfo();
                NfaPolicyUtil.nfaPolicyFormTransInfo(nfaForm, nfaInfo);
                try {
                    this.nfaPolicyDao.update(nfaInfo);
                }
                catch (DataAccessException e) {
                    return;
                }
            }
        }
    }

    @Override
    public NfaPolicyEditForm queryNfaPolicyByTemplateId(Long templateId, String deviceType) {
        NfaPolicyEditForm nfaPolicyEditForm = null;
        List<NfaPolicyInfo> nfaPolicyInfos = this.nfaPolicyDao.queryListByTemplateId(templateId, deviceType);
        ArrayList<NfaPolicyForm> nfaPolicyForms = new ArrayList<NfaPolicyForm>();
        if (null != nfaPolicyInfos && !nfaPolicyInfos.isEmpty()) {
            for (NfaPolicyInfo nfaInfo : nfaPolicyInfos) {
                NfaPolicyForm nfaForm = new NfaPolicyForm();
                NfaPolicyUtil.nfaPolicyInfoTransForm(nfaInfo, nfaForm);
                nfaPolicyForms.add(nfaForm);
            }
        }
        nfaPolicyEditForm = NfaPolicyUtil.nfaPolicyFormConvNfaPolicyEditFrom(nfaPolicyForms);
        return nfaPolicyEditForm;
    }

    @Override
    public void deleteByZoneId(Long zoneId) {
        this.nfaPolicyDao.deleteNfaPolicy(zoneId);
    }

    @Override
    public void deleteByTemplateId(Long templateId) {
        this.nfaPolicyDao.deleteNfaPolicyTemplate(templateId);
    }

    @Override
    public NfaPolicyEditForm queryByServiceId(Long serviceId) {
        List<NfaPolicyInfo> nfaPolicyInfos = this.nfaPolicyDao.queryByServiceId(serviceId);
        ArrayList<NfaPolicyForm> nfaPolicyForms = new ArrayList<NfaPolicyForm>();
        if (null != nfaPolicyInfos && !nfaPolicyInfos.isEmpty()) {
            for (NfaPolicyInfo nfaPolicyInfo : nfaPolicyInfos) {
                NfaPolicyForm nfaPolicyForm = new NfaPolicyForm();
                NfaPolicyUtil.nfaPolicyInfoTransForm(nfaPolicyInfo, nfaPolicyForm);
                nfaPolicyForms.add(nfaPolicyForm);
            }
        }
        NfaPolicyEditForm nfaPolicyEditForm = NfaPolicyUtil.nfaPolicyFormConvNfaPolicyEditFrom(nfaPolicyForms);
        return nfaPolicyEditForm;
    }

    private NfaPolicyInfo tranFormInfo(NfaPolicyForm form) {
        NfaPolicyInfo nfaInfo = new NfaPolicyInfo();
        NfaPolicyUtil.nfaPolicyFormTransInfo(form, nfaInfo);
        return nfaInfo;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.nfaPolicyDao.queryByPage(queryMap, start, pageSize);
        List infoList = page.getData();
        ArrayList<NfaPolicyForm> formList = new ArrayList<NfaPolicyForm>();
        for (NfaPolicyInfo info : infoList) {
            NfaPolicyForm form = new NfaPolicyForm();
            AticUtil.copyProperties((Object)info, (Object)form);
            formList.add(form);
        }
        page.setData(formList);
        return page;
    }

    public void delete(Long id) {
    }

    public void delete(NfaPolicyEditForm form) {
        List<NfaPolicyForm> nfaPolicyForms;
        if (null != form && !(nfaPolicyForms = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(form)).isEmpty()) {
            for (NfaPolicyForm nfaForm : nfaPolicyForms) {
                if (null == nfaForm.getPkid()) continue;
                NfaPolicyInfo nfaInfo = new NfaPolicyInfo();
                NfaPolicyUtil.nfaPolicyFormTransInfo(nfaForm, nfaInfo);
                this.nfaPolicyDao.delete(nfaInfo.getPkid());
            }
        }
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        return null;
    }

    public NfaPolicyEditForm query(Long id) {
        NfaPolicyEditForm nfaPolicyEditForm = null;
        List<NfaPolicyInfo> nfaPolicyInfos = this.nfaPolicyDao.queryListByServiceId(id);
        ArrayList<NfaPolicyForm> nfaPolicyForms = new ArrayList<NfaPolicyForm>();
        if (null != nfaPolicyInfos && !nfaPolicyInfos.isEmpty()) {
            for (NfaPolicyInfo nfaInfo : nfaPolicyInfos) {
                NfaPolicyForm nfaForm = new NfaPolicyForm();
                NfaPolicyUtil.nfaPolicyInfoTransForm(nfaInfo, nfaForm);
                nfaPolicyForms.add(nfaForm);
            }
        }
        try {
            nfaPolicyEditForm = NfaPolicyUtil.nfaPolicyFormConvNfaPolicyEditFrom(nfaPolicyForms);
        }
        catch (Exception e) {
            return null;
        }
        return nfaPolicyEditForm;
    }

    @Override
    public void deleteNfaDevice(Long zoneId, Long deviceId) {
        this.nfaPolicyDao.deleteNfaDevice(zoneId, deviceId);
    }

    @Override
    public void deleteByServiceId(Long serviceId) {
        if (null == serviceId) {
            return;
        }
        NfaPolicyEditForm form = this.queryNfaPolicyByServiceId(serviceId);
        if (null != form) {
            this.delete(form);
        }
    }

    @Override
    public NfaPolicyEditForm queryOutboundNfaPolicy(Long serviceId, int direction) {
        NfaPolicyEditForm nfaPolicyEditForm = new NfaPolicyEditForm();
        List<NfaPolicyInfo> nfaPolicyInfos = this.nfaPolicyDao.queryListByServiceId(serviceId, direction);
        ArrayList<NfaPolicyForm> nfaPolicyForms = new ArrayList<NfaPolicyForm>();
        Long zoneId = null;
        if (null != nfaPolicyInfos && !nfaPolicyInfos.isEmpty()) {
            for (NfaPolicyInfo nfaInfo : nfaPolicyInfos) {
                zoneId = nfaInfo.getZoneId();
                NfaPolicyForm nfaForm = new NfaPolicyForm();
                NfaPolicyUtil.nfaPolicyInfoTransForm(nfaInfo, nfaForm);
                nfaPolicyForms.add(nfaForm);
            }
            nfaPolicyEditForm = NfaPolicyUtil.nfaPolicyFormConvNfaPolicyEditFrom(nfaPolicyForms);
            nfaPolicyEditForm.setServiceId(serviceId);
            nfaPolicyEditForm.setZoneId(zoneId);
        }
        return nfaPolicyEditForm;
    }

    public NfaPolicyDao getNfaPolicyDao() {
        return this.nfaPolicyDao;
    }

    public void setNfaPolicyDao(NfaPolicyDao nfaPolicyDao) {
        this.nfaPolicyDao = nfaPolicyDao;
    }

    public ZoneServiceDao getZoneServiceDao() {
        return this.zoneServiceDao;
    }

    public void setZoneServiceDao(ZoneServiceDao zoneServiceDao) {
        this.zoneServiceDao = zoneServiceDao;
    }
}

