/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.secservice.ddos.dao.NfaPolicyDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceDao;
import com.hs.vsm.secservice.ddos.model.NfaPolicyInfo;
import com.hs.vsm.secservice.ddos.model.ZoneServiceInfo;
import com.hs.vsm.secservice.nfa.util.NfaPolicyUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NfaPolicyServiceImpl
implements INfaPolicyService {
    private NfaPolicyDao nfaPolicyDao;
    private ZoneServiceDao zoneServiceDao;

    public Long create(NfaPolicyForm form) {
        Long pkid = 0L;
        if (null != form) {
            NfaPolicyInfo info = this.tranForm2Info1(form);
            pkid = (Long)this.nfaPolicyDao.create(info);
        }
        return pkid;
    }

    private NfaPolicyInfo tranForm2Info1(NfaPolicyForm form) {
        NfaPolicyInfo nfaInfo = new NfaPolicyInfo();
        NfaPolicyUtil.nfaPolicyFormTransInfo(form, nfaInfo);
        return nfaInfo;
    }

    public void delete(Long id) {
        this.nfaPolicyDao.delete(id);
    }

    public void save(NfaPolicyForm form) {
        NfaPolicyInfo info = new NfaPolicyInfo();
        NfaPolicyUtil.nfaPolicyFormTransInfo(form, info);
        this.nfaPolicyDao.save(info);
    }

    public void setFirstPacketCheckDao(NfaPolicyDao nfaPolicyDaos) {
        this.nfaPolicyDao = nfaPolicyDaos;
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        return null;
    }

    public NfaPolicyForm query(Long id) {
        return null;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        return null;
    }

    public void update(NfaPolicyForm form) {
    }

    public void createOrUpdate(NfaPolicyForm form) {
    }

    public void delete(NfaPolicyForm form) {
    }

    @Override
    public List<NfaPolicyForm> queryByZoneId(Long zoneId) {
        ArrayList<NfaPolicyForm> nfaPolicyForms = new ArrayList<NfaPolicyForm>();
        List<NfaPolicyInfo> nfaPolicyInfos = this.nfaPolicyDao.queryByZoneId(zoneId);
        if (null != nfaPolicyInfos && !nfaPolicyInfos.isEmpty()) {
            for (NfaPolicyInfo nfaPolicyInfo : nfaPolicyInfos) {
                NfaPolicyForm nfaForm = new NfaPolicyForm();
                NfaPolicyUtil.nfaPolicyInfoTransForm(nfaPolicyInfo, nfaForm);
                nfaPolicyForms.add(nfaForm);
            }
        }
        return nfaPolicyForms;
    }

    @Override
    public List<NfaPolicyForm> getNfaPolicyForm(Long zoneId, Long deviceId) {
        ArrayList<NfaPolicyForm> nfaPolicyForms = new ArrayList<NfaPolicyForm>();
        List<ZoneServiceInfo> zoneServiceInfos = this.zoneServiceDao.getZoneServiceInfoListByZoneIdAndDeviceId(zoneId, deviceId);
        for (ZoneServiceInfo zoneServiceInfo : zoneServiceInfos) {
            List<NfaPolicyInfo> nfaPolicyInfos = this.nfaPolicyDao.queryNfaPolicyByServiceId(zoneServiceInfo.getPkid(), 1);
            if (null == nfaPolicyInfos || nfaPolicyInfos.size() != 16) continue;
            for (NfaPolicyInfo nfaPolicyInfo : nfaPolicyInfos) {
                NfaPolicyForm nfaForm = new NfaPolicyForm();
                NfaPolicyUtil.nfaPolicyInfoTransForm(nfaPolicyInfo, nfaForm);
                nfaPolicyForms.add(nfaForm);
            }
        }
        return nfaPolicyForms;
    }

    @Override
    public List<NfaPolicyForm> getOutboundNfaPolicyForm(Long zoneId, Long deviceId) {
        ArrayList<NfaPolicyForm> nfaPolicyForms = new ArrayList<NfaPolicyForm>();
        List<ZoneServiceInfo> zoneServiceInfos = this.zoneServiceDao.getZoneServiceInfoListByZoneIdAndDeviceId(zoneId, deviceId);
        for (ZoneServiceInfo zoneServiceInfo : zoneServiceInfos) {
            List<NfaPolicyInfo> nfaPolicyInfos = this.nfaPolicyDao.queryNfaPolicyByServiceId(zoneServiceInfo.getPkid(), 2);
            if (null == nfaPolicyInfos) continue;
            for (NfaPolicyInfo nfaPolicyInfo : nfaPolicyInfos) {
                NfaPolicyForm nfaForm = new NfaPolicyForm();
                NfaPolicyUtil.nfaPolicyInfoTransForm(nfaPolicyInfo, nfaForm);
                nfaPolicyForms.add(nfaForm);
            }
        }
        return nfaPolicyForms;
    }

    public NfaPolicyDao getNfaPolicyDao() {
        return this.nfaPolicyDao;
    }

    public void setNfaPolicyDao(NfaPolicyDao nfaPolicyDao) {
        this.nfaPolicyDao = nfaPolicyDao;
    }

    public ZoneServiceDao getZoneServiceDao() {
        return this.zoneServiceDao;
    }

    public void setZoneServiceDao(ZoneServiceDao zoneServiceDao) {
        this.zoneServiceDao = zoneServiceDao;
    }
}

