/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.dao.VpnDeviceDao;
import com.hs.vsm.secservice.ddos.model.VpnDeviceInfo;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.VpnDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IVpnDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.VpnAddressFamily;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VpnDeviceServiceImpl
implements IVpnDeviceService {
    private static final String IPMASK_REGEX = "[\\S]+/[\\d]+";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private VpnDeviceDao dao;
    private IAticDeviceService aticDeviceService;
    private IZoneDeviceService zoneDeviceService;

    public Long create(VpnDeviceForm form) {
        return null;
    }

    public void createOrUpdate(VpnDeviceForm form) {
    }

    public void delete(Long id) {
    }

    @Override
    public void delete(String[] deleteIdList) {
        this.dao.delete(deleteIdList);
    }

    public void delete(VpnDeviceForm form) {
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        return null;
    }

    public VpnDeviceForm query(Long id) {
        return null;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.dao.queryByPage(queryMap, start, pageSize);
        List infoList = page.getData();
        ArrayList<VpnDeviceForm> formList = new ArrayList<VpnDeviceForm>();
        for (VpnDeviceInfo info : infoList) {
            VpnDeviceForm form = new VpnDeviceForm();
            VsmUtil.getInstance().copyProperties(info, form);
            AticDevice device = this.aticDeviceService.getDeviceByMoid(form.getDeviceId().longValue());
            form.setDeviceName(device.getName());
            formList.add(form);
        }
        page.setData(formList);
        return page;
    }

    public void save(VpnDeviceForm form) {
        VpnDeviceInfo info = new VpnDeviceInfo();
        VsmUtil.getInstance().copyProperties(form, info);
        this.dao.saveOrUpdate(info);
        this.logger.info((Object)("save vpn info. " + this.getcleanedMessage(info.getVpnName()) + ", " + this.getcleanedMessage(info.getIpMask())));
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public void update(VpnDeviceForm form) {
    }

    public VpnDeviceDao getDao() {
        return this.dao;
    }

    public void setDao(VpnDeviceDao dao) {
        this.dao = dao;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    @Override
    public String getIncludedVpn(Long deviceId, Long zoneId, String ip, Integer mask) {
        String endIp;
        String vpn = "";
        String[] ips = IPUtil.getSubnetRange((String)ip, (int)mask);
        String startIp = ips[0];
        List<VpnDeviceInfo> list = this.dao.findIncludedVpn(deviceId, zoneId, startIp, endIp = ips[1]);
        if (list != null && !list.isEmpty()) {
            vpn = list.get(0).getVpnName();
        }
        return vpn;
    }

    @Override
    public boolean isVpnIncluded(Long deviceId, Long zoneId) {
        List<VpnDeviceInfo> list = this.dao.findIncludedVpn(deviceId, zoneId);
        if (list != null) {
            return !list.isEmpty();
        }
        return false;
    }

    @Override
    public boolean isVpnExcluded(Long deviceId, Long zoneId, String ip, Integer mask) {
        String endIp;
        String[] ips = IPUtil.getSubnetRange((String)ip, (int)mask);
        String startIp = ips[0];
        List<VpnDeviceInfo> list = this.dao.findExcludedVpn(deviceId, zoneId, startIp, endIp = ips[1]);
        if (list != null) {
            return !list.isEmpty();
        }
        return false;
    }

    @Override
    public void syncIncludeVpn(Long zoneId) {
        this.logger.info((Object)"sync include vpn info.");
        ArrayList<VpnDeviceForm> formList = new ArrayList<VpnDeviceForm>();
        List zoneDeviceFormsList = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(zoneId);
        if (!zoneDeviceFormsList.isEmpty()) {
            for (ZoneDeviceForm zoneDeviceForm : zoneDeviceFormsList) {
                Long deviceId = zoneDeviceForm.getDeviceId();
                List<VpnAddressFamily> vpnList = this.getVpnInstance(deviceId);
                List<VpnDeviceForm> forms = this.getVpnDeviceForm(deviceId, zoneId, vpnList);
                formList.addAll(forms);
            }
        }
        this.dao.deleteIncludeVpnByZoneId(zoneId);
        this.logger.info((Object)"delete old vpn route info. ");
        for (VpnDeviceForm vpnDeviceForm : formList) {
            this.save(vpnDeviceForm);
        }
        this.logger.info((Object)"save new vpn route info. ");
    }

    private List<VpnAddressFamily> getVpnInstance(Long deviceId) {
        ArrayList<VpnAddressFamily> vpnList = new ArrayList<VpnAddressFamily>();
        String res = CmdUtil.execCmds(deviceId, this.displayVpnInstance()).get(0);
        String[] tmp = res.split("\r\n");
        for (int i = 5; i < tmp.length - 1; ++i) {
            String line = tmp[i].trim();
            if ("".equals(line)) continue;
            String[] lineArr = line.split(" ");
            ArrayList<String> vpnInfo = new ArrayList<String>();
            for (int j = 0; j < lineArr.length; ++j) {
                if ("".equals(lineArr[j])) continue;
                vpnInfo.add(lineArr[j]);
            }
            VpnAddressFamily addressFamily = new VpnAddressFamily();
            if (vpnInfo.size() == 3 && !"Address-family".equalsIgnoreCase((String)vpnInfo.get(2))) {
                addressFamily.setVpnName((String)vpnInfo.get(0));
                addressFamily.setAddressFamily((String)vpnInfo.get(2));
                vpnList.add(addressFamily);
                continue;
            }
            if (vpnInfo.size() != 2) continue;
            addressFamily.setVpnName((String)vpnInfo.get(0));
            addressFamily.setAddressFamily((String)vpnInfo.get(1));
            vpnList.add(addressFamily);
        }
        this.logger.info((Object)("get vpn instance: " + vpnList));
        return vpnList;
    }

    private List<VpnDeviceForm> getVpnDeviceForm(Long deviceId, Long zoneId, List<VpnAddressFamily> vpnList) {
        ArrayList<VpnDeviceForm> formList = new ArrayList<VpnDeviceForm>();
        List<String> resList = CmdUtil.execCmds(deviceId, this.displayVpnRoute(vpnList));
        for (int i = 0; i < resList.size(); ++i) {
            String res = resList.get(i);
            String[] tmp = res.split("\r\n");
            String vpnName = vpnList.get(i).getVpnName();
            String vpnAddressFamily = vpnList.get(i).getAddressFamily();
            for (int j = 0; j < tmp.length - 2; ++j) {
                String line = tmp[j].trim();
                if ("IPv4".equalsIgnoreCase(vpnAddressFamily)) {
                    String ip;
                    String ipMask = line.split(" ")[0];
                    Pattern pattern = Pattern.compile(IPMASK_REGEX);
                    Matcher matcher = pattern.matcher(ipMask);
                    if (!matcher.find() || ipMask.split("/").length <= 1 || this.isDefaultRouting(ipMask) || "255.255.255.255".equals(ip = ipMask.split("/")[0])) continue;
                    String mask = ipMask.split("/")[1];
                    String[] ips = IPUtil.getSubnetRange((String)ip, (int)Integer.parseInt(mask));
                    String startIp = ips[0];
                    String endIp = ips[1];
                    VpnDeviceForm form = new VpnDeviceForm();
                    form.setIpMask(ipMask);
                    form.setDeviceId(deviceId);
                    form.setZoneId(zoneId);
                    form.setVpnName(vpnName);
                    form.setVpnType(1);
                    form.setStartIp(IPUtil4Atic.convert2CompleteIp((String)startIp));
                    form.setEndIp(IPUtil4Atic.convert2CompleteIp((String)endIp));
                    formList.add(form);
                    continue;
                }
                if (!line.contains("Destination") || !line.contains("PrefixLength")) continue;
                String destination = line.substring("Destination :".length() + 1, line.indexOf("PrefixLength") - 1).trim();
                String prefixLength = line.substring(line.indexOf("PrefixLength :") + "PrefixLength :".length()).trim();
                String[] ips = IPUtil.getSubnetRange((String)destination, (int)Integer.parseInt(prefixLength));
                VpnDeviceForm form = new VpnDeviceForm();
                form.setIpMask(destination + "/" + prefixLength);
                form.setDeviceId(deviceId);
                form.setZoneId(zoneId);
                form.setVpnName(vpnName);
                form.setVpnType(1);
                form.setStartIp(IPUtil.convert2CompleteIpV6AllZero((String)ips[0]));
                form.setEndIp(IPUtil.convert2CompleteIpV6AllZero((String)ips[1]));
                formList.add(form);
            }
        }
        this.logger.info((Object)("get vpn route info, list size: " + formList.size()));
        return formList;
    }

    private boolean isDefaultRouting(String ipMask) {
        if (ipMask == null) {
            return false;
        }
        if (ipMask.trim().equals("0.0.0.0/0")) {
            return true;
        }
        return ipMask.trim().equals("255.255.255.255/32");
    }

    private List<String> displayVpnInstance() {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("display ip vpn-instance");
        return cmdList;
    }

    private List<String> displayVpnRoute(List<VpnAddressFamily> vpnList) {
        ArrayList<String> cmdList = new ArrayList<String>();
        for (int i = 0; i < vpnList.size(); ++i) {
            if ("Ipv6".equalsIgnoreCase(vpnList.get(i).getAddressFamily())) {
                cmdList.add("display ipv6 routing-table vpn-instance " + vpnList.get(i).getVpnName());
                continue;
            }
            cmdList.add("display ip routing-table vpn-instance " + vpnList.get(i).getVpnName());
        }
        return cmdList;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }
}

