/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.service.data.ZoneConfigData;
import com.hs.vsm.secservice.sdk.common.util.CrcUtil;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneFeatureStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneFeatureStatusService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;

public class ZoneFeatureStatusServiceImpl
implements IZoneFeatureStatusService {
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private IAticDeviceService aticDeviceService;

    @Override
    public void deleteByZoneId(long zoneId) {
        this.zoneFeatureStatusDao.deleteByZoneId(zoneId);
    }

    @Override
    public void saveZoneFeatureStatusForm(ZoneFeatureStatusForm zoneFeatureStatusForm) {
        ZoneFeatureStatusInfo zoneFeatureStatusInfo = new ZoneFeatureStatusInfo();
        VsmUtil.getInstance().copyProperties(zoneFeatureStatusForm, zoneFeatureStatusInfo);
        this.zoneFeatureStatusDao.save(zoneFeatureStatusInfo);
    }

    @Override
    public void deleteByDeviceId(long deviceId) {
        this.zoneFeatureStatusDao.deleteByDeviceId(deviceId);
    }

    @Override
    public ZoneFeatureStatusForm getZoneFeatureByZoneIdAndDeviceId(Long zoneId, String deviceIp, String featureType, Long featureId) {
        AticDevice device = this.aticDeviceService.getDeviceByIp(deviceIp);
        if (device == null) {
            return null;
        }
        Long deviceId = device.getMoId();
        ZoneFeatureStatusInfo info = this.zoneFeatureStatusDao.getZoneFeatureByZoneIdAndDeviceId(zoneId, deviceId, featureType, featureId);
        if (null != info) {
            ZoneFeatureStatusForm form = new ZoneFeatureStatusForm();
            VsmUtil.getInstance().copyProperties(info, form);
            return form;
        }
        return null;
    }

    @Override
    public void updateDeviceIdByZoneId(Long zoneId, Long lastTimeDeviceId, Long deviceId) {
        this.zoneFeatureStatusDao.updateDeviceIdByZoneId(zoneId, lastTimeDeviceId, deviceId);
    }

    @Override
    public void deleteByDeviceIdAndZoneId(long deviceId, long zoneId) {
        this.zoneFeatureStatusDao.deleteByDeviceIdAndZoneId(deviceId, zoneId);
    }

    @Override
    public ZoneFeatureStatusForm getByZoneIdAndDeviceIdAndFeatureTypeAndFeatureId(Long zoneId, Long deviceId, String featureType, Long featureId) {
        ZoneFeatureStatusInfo info = this.zoneFeatureStatusDao.getZoneFeatureByZoneIdAndDeviceId(zoneId, deviceId, featureType, featureId);
        if (null != info) {
            ZoneFeatureStatusForm form = new ZoneFeatureStatusForm();
            VsmUtil.getInstance().copyProperties(info, form);
            return form;
        }
        return null;
    }

    @Override
    public void createOrUpdateZoneIpFeatureStatus(ZoneInfoForm zoneInfoForm, Long deviceId) {
        Long zoneId = zoneInfoForm.getZoneId();
        ZoneFeatureStatusInfo info = new ZoneFeatureStatusInfo();
        info.setZoneId(zoneId);
        info.setDeviceId(deviceId);
        info.setFeatureId(zoneId);
        info.setFeatureType("ZoneIpForm");
        info.setDeployState(true);
        info.setDefendMode(0);
        String zoneIpCrc = ZoneConfigData.getZoneIpCalcCrcString(zoneInfoForm);
        Long crc = CrcUtil.getCrcValue(zoneIpCrc);
        info.setDeployCrc(crc);
        ZoneFeatureStatusInfo zoneFeatureStatusInfo = this.zoneFeatureStatusDao.queryZoneFeature(deviceId, zoneId);
        if (null == zoneFeatureStatusInfo) {
            this.zoneFeatureStatusDao.create(info);
        } else {
            zoneFeatureStatusInfo.setDeployState(true);
            zoneFeatureStatusInfo.setDefendMode(0);
            zoneFeatureStatusInfo.setDeployCrc(crc);
            this.zoneFeatureStatusDao.update(zoneFeatureStatusInfo);
        }
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }
}

