/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.service.FaultSeverityRuleService;
import com.hs.atic.sdk.bis.service.IAttackDataService;
import com.hs.atic.sdk.bis.service.IFoundDefaultIdService;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticConstants;
import com.hs.atic.zone.dao.ZoneDao;
import com.hs.atic.zone.dao.ZoneListIpDao;
import com.hs.atic.zone.dao.ZoneListPortMapDao;
import com.hs.atic.zone.model.ZoneInfo;
import com.hs.atic.zone.model.ZoneListIpInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.LegoDataProtectorWrapper;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.dao.BlackWhiteListDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneInfoDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneIpLocationDao;
import com.hs.vsm.secservice.ddos.dao.ZonePolicyApplyDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceStatusDao;
import com.hs.vsm.secservice.ddos.model.BlackWhiteListInfo;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceInfo;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneIpLocationInfo;
import com.hs.vsm.secservice.ddos.model.ZonePolicyApplyInfo;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.service.data.ConfigDataTools;
import com.hs.vsm.secservice.ddos.service.data.ZoneConfigData;
import com.hs.vsm.secservice.ddos.service.data.ZoneToDeployData;
import com.hs.vsm.secservice.sdk.common.util.CrcUtil;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.IcmpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.OtherDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SipDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.UdpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneModifyDetailForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IBlackWhiteListService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyEditService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyMgrService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.policy.third.service.IDivertForPolicy;
import com.huawei.atic.policy.third.service.IOutboundDivertForPolicy;
import com.huawei.atic.policy.third.service.IPacketTaskService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZonePolicyApplyServiceImpl
implements IZonePolicyApplyService {
    private static final int SLLEEP_TIME = 1000;
    private static final int LOOP_COUNT = 100;
    private static final int DEFENDSTATE_ZERO = 0;
    private static final int DEFENDSTATE_ONE = 1;
    private static final int DEFENDSTATE_TWO = 2;
    private static final int DEFENDSTATE_FOUR = 4;
    private IPacketTaskService packetTaskService = null;
    private IDivertForPolicy divertTacticsService = null;
    private IOutboundDivertForPolicy outboundDivertTacticsService = null;
    private IAttackDataService attackDataService = null;
    private IZoneServiceService zoneService;
    private IAticDeviceService aticDeviceService;
    private ICommonUtilService commonUtilService;
    private ZonePolicyApplyDao userPolicyApplyDao;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private ZoneServiceStatusDao zoneServiceStatusDao;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private ZoneServiceDao zoneServiceDao;
    private IZonePolicyMgrService zonePolicyMgrService;
    private IZoneService zoneDefineService;
    private IFoundDefaultIdService foundDefaultIdService;
    private ConfigDataTools configDataTools;
    private FilterDeviceZoneInfoDao filterDeviceZoneInfoDao;
    private ZoneIpLocationDao zoneIpLocationDao;
    private ZoneListIpDao zoneListIpDao;
    private ZoneListPortMapDao zoneListPortMapDao;
    private INfaPolicyEditService nfaPolicyEditService;
    private IFilterService filterService;
    private ZoneDeviceDao zoneDeviceDao;
    private FaultSeverityRuleService faultSeverityRuleService;
    private ILicenseOutboundService licenseOutboundService;
    private ZoneDao zoneDao;
    private BlackWhiteListDao blackWhiteListDao;
    private IBlackWhiteListService blackWhiteListService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        this.logger.info((Object)"enter queryByPage");
        Paging page = this.userPolicyApplyDao.queryByPage(queryMap, start, pageSize);
        ArrayList<ZonePolicyApplyForm> formList = new ArrayList<ZonePolicyApplyForm>();
        List infoList = page.getData();
        this.zoneDefineService = this.getZoneDefineService();
        if (null == this.zoneDefineService) {
            page.setData(formList);
            this.logger.error((Object)"zoneDefineService is null");
            return page;
        }
        List deviceList = this.aticDeviceService.getAllDevice();
        for (int i = 0; i < infoList.size(); ++i) {
            ZonePolicyApplyInfo zonePolicyApplyInfo = (ZonePolicyApplyInfo)infoList.get(i);
            ZonePolicyApplyForm userPolicyApplyForm = this.tranInfo2Form(deviceList, zonePolicyApplyInfo);
            long zoneId = userPolicyApplyForm.getZoneId();
            ZoneInfoForm zoneInfoForm = this.zoneDefineService.getById(zoneId);
            if (null == zoneInfoForm) {
                this.logger.error((Object)("zoneInfoForm is null. zoneId is " + zoneId));
                continue;
            }
            userPolicyApplyForm.setZoneType(zoneInfoForm.getZoneType());
            userPolicyApplyForm.setServiceLearnState(this.getServiceLearnState(zoneId));
            userPolicyApplyForm.setBaseLineState(this.getBaseLineState(zoneId));
            try {
                int defendState = this.getDefendState(zoneId, zonePolicyApplyInfo);
                userPolicyApplyForm.setDefendState(defendState);
            }
            catch (Exception e) {
                this.logger.error((Object)("queryByPage getDefendState error" + e.getMessage()));
            }
            userPolicyApplyForm.setDivertState(this.getZoneDivertState(zoneId));
            userPolicyApplyForm.setCaptureState(this.getZoneCaptureState(zoneId));
            formList.add(userPolicyApplyForm);
        }
        page.setData(formList);
        this.logger.info((Object)"leave queryByPage");
        return page;
    }

    @Override
    public Boolean isDeviceRelDefaultZone(Long deviceId) {
        List<Long> zoneIdList = this.zoneDeviceDao.getByDevId(deviceId);
        List<ZoneInfoForm> zoneInfoFormList = this.zoneDefineService.getAllDefaultZones();
        HashSet<Long> defaultZoneIdSet = new HashSet<Long>();
        for (ZoneInfoForm form : zoneInfoFormList) {
            defaultZoneIdSet.add(form.getZoneId());
        }
        for (Long zoneId : zoneIdList) {
            if (!defaultZoneIdSet.contains(zoneId)) continue;
            return true;
        }
        return false;
    }

    private int getDefendState(long zoneId, ZonePolicyApplyInfo zonePolicyApplyInfo) {
        String abnormalState = zonePolicyApplyInfo.getAbnormalState();
        List<ZoneDeviceInfo> zoneDevices = this.zoneDeviceDao.getByZoneId(zoneId);
        if (zoneDevices.isEmpty() || null != abnormalState && "NORMAL".equals(abnormalState)) {
            return 0;
        }
        List<ZoneFeatureStatusInfo> zoneFeatureStatusInfos = this.zoneFeatureStatusDao.queryByZoneIdWithDefend(zoneId);
        boolean flag = true;
        for (int i = 0; i < zoneDevices.size(); ++i) {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(zoneDevices.get(i).getDeviceId().longValue());
            if (8 == aticDevice.getDeviceType()) continue;
            flag = false;
            break;
        }
        if (!flag && (null == zoneFeatureStatusInfos || zoneFeatureStatusInfos.isEmpty())) {
            return 1;
        }
        HashSet<Integer> defendModeSet = new HashSet<Integer>();
        for (ZoneFeatureStatusInfo zoneFeatureStatusInfo : zoneFeatureStatusInfos) {
            if (null == zoneFeatureStatusInfo.getDefendMode()) {
                defendModeSet.add(Constant.DEFENDMODE_DEFEND_AUTO);
                continue;
            }
            defendModeSet.add(zoneFeatureStatusInfo.getDefendMode());
        }
        if (defendModeSet.size() == 1) {
            Iterator it = defendModeSet.iterator();
            Integer defendMode = (Integer)it.next();
            return this.dispathDefendState(zoneId, defendMode, abnormalState);
        }
        if (defendModeSet.isEmpty()) {
            List<ZoneFeatureStatusInfo> zoneFeatureStatusInfo = this.zoneFeatureStatusDao.queryByZoneId(zoneId);
            Integer defendMode = zoneFeatureStatusInfo.get(0).getDefendMode();
            return this.dispathDefendState(zoneId, defendMode, abnormalState);
        }
        HashSet<Integer> states = new HashSet<Integer>();
        for (ZoneFeatureStatusInfo zoneFeatureStatusInfo : zoneFeatureStatusInfos) {
            Integer defendStateTemp = this.getDefendStateByZoneFeature(zoneFeatureStatusInfo);
            if (null == defendStateTemp || Constant.ZONE_DEFENDS_STATUS_OF_NO_ENEVT.equals(defendStateTemp)) continue;
            states.add(defendStateTemp);
        }
        if (states.isEmpty()) {
            return 2;
        }
        if (states.size() == 1) {
            Iterator iterator = states.iterator();
            return (Integer)iterator.next();
        }
        return 3;
    }

    private int getDefendStateByZoneFeature(ZoneFeatureStatusInfo zoneFeatureStatusInfo) {
        Integer initDefendState = 0;
        Integer devDefendMode = zoneFeatureStatusInfo.getDefendMode();
        if (Constant.DEFENDMODE_DEFEND_UNDEFEND.equals(devDefendMode)) {
            initDefendState = 2;
        }
        if (Constant.DEFENDMODE_DEFEND_AUTO.equals(devDefendMode) || Constant.DEFENDMODE_DEFEND_MANUAL.equals(devDefendMode)) {
            AticDevice device = this.aticDeviceService.getDeviceByMoid(zoneFeatureStatusInfo.getDeviceId().longValue());
            String deviceIp = device.getIpAddress();
            this.attackDataService = this.getAttackDateService();
            if (this.attackDataService != null) {
                int state = this.attackDataService.getDefendState(zoneFeatureStatusInfo.getZoneId(), zoneFeatureStatusInfo.getDeviceId(), deviceIp);
                if (Constant.DEFENDMODE_DEFEND_AUTO.equals(devDefendMode) || 2 == state) {
                    return 4;
                }
                if (4 == state) {
                    return Constant.ZONE_DEFENDS_STATUS_OF_NO_ENEVT;
                }
                if (0 == state) {
                    return 2;
                }
                if (1 == state) {
                    return 3;
                }
            }
        }
        return initDefendState;
    }

    private int dispathDefendState(Long zoneId, Integer defendMode, String abnormalState) {
        List<ZoneDeviceInfo> zoneDevices = this.zoneDeviceDao.getByZoneId(zoneId);
        if (null == defendMode) {
            return -1;
        }
        if (Constant.DEFENDMODE_DEFEND_UNDEFEND.equals(defendMode)) {
            return 5;
        }
        if (zoneDevices.isEmpty() || "NORMAL".equals(abnormalState)) {
            return 0;
        }
        if (Constant.DEFENDMODE_DEFEND_AUTO.equals(defendMode)) {
            boolean flag = true;
            for (int i = 0; i < zoneDevices.size(); ++i) {
                AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(zoneDevices.get(i).getDeviceId().longValue());
                if (8 == aticDevice.getDeviceType()) continue;
                flag = false;
                break;
            }
            if (!flag) {
                return 1;
            }
            return 0;
        }
        return this.abnormalDefendState(zoneDevices, zoneId);
    }

    private int abnormalDefendState(List<ZoneDeviceInfo> zoneDevices, long zoneId) {
        this.attackDataService = this.getAttackDateService();
        if (this.attackDataService != null) {
            ArrayList<Long> devIds = new ArrayList<Long>();
            for (ZoneDeviceInfo each : zoneDevices) {
                devIds.add(each.getDeviceId());
            }
            int state = this.attackDataService.getZoneDefendState(zoneId, devIds);
            if (2 == state) {
                return 4;
            }
            if (1 == state) {
                return 3;
            }
        }
        return 2;
    }

    private int getServiceLearnState(long zoneId) {
        if (this.userPolicyApplyDao != null) {
            return this.userPolicyApplyDao.getServiceLearnState(zoneId);
        }
        return -1;
    }

    private int getBaseLineState(long zoneId) {
        if (this.userPolicyApplyDao != null) {
            return this.userPolicyApplyDao.getBaseLineState(zoneId);
        }
        return -1;
    }

    @Override
    public int getZoneCaptureState(long zoneId) {
        this.packetTaskService = this.getPacketTaskService();
        if (this.packetTaskService != null) {
            return this.packetTaskService.getZoneCaputreStauts(zoneId);
        }
        return -1;
    }

    private int getZoneDivertState(long zoneId) {
        this.divertTacticsService = this.getDivertTacticsService();
        this.outboundDivertTacticsService = this.getOutboundDivertTacticsService();
        if (this.divertTacticsService != null && null != this.outboundDivertTacticsService) {
            int out = this.outboundDivertTacticsService.getZoneDivertState(zoneId);
            int in = this.divertTacticsService.getZoneDivertState(zoneId);
            if (1 == in) {
                if (1 == out || 0 == out) {
                    return 1;
                }
                return 2;
            }
            if (0 == in) {
                if (1 == out) {
                    return 1;
                }
                if (0 == out) {
                    return 0;
                }
                return 2;
            }
            if (2 == in) {
                return 2;
            }
            return in;
        }
        return -1;
    }

    public void save(ZonePolicyApplyForm form) {
        ZonePolicyApplyForm formNew = null;
        if (null != form) {
            ZonePolicyApplyInfo zonePolicyApplyInfo = this.tranForm2Info(form);
            ZonePolicyApplyInfo infoInDb = null;
            infoInDb = this.userPolicyApplyDao.getByZoneId(form.getZoneId());
            formNew = this.query(form.getZoneId());
            if (null == formNew) {
                this.logger.error((Object)"formNew is null");
                return;
            }
            this.userPolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
            Set<ZoneDeviceInfo> deleteDevice = this.getDeleteDevice(infoInDb, zonePolicyApplyInfo);
            this.zoneDeviceDao.deleteAll(new ArrayList<ZoneDeviceInfo>(deleteDevice));
            Long configCrcBeforeDB = CrcUtil.getCrcValue(form.getCalcCrcString());
            Long configCrcAfterDB = CrcUtil.getCrcValue(formNew.getCalcCrcString());
            if (!configCrcBeforeDB.equals(configCrcAfterDB)) {
                ZonePolicyApplyInfo info = this.userPolicyApplyDao.getByZoneId(form.getZoneId());
                if (!"UNDEPLOY".equals(infoInDb.getDeployState())) {
                    info.setDeployState("INCREAMENT_UNDEPLOY");
                }
                this.userPolicyApplyDao.saveOrUpdate(info);
            }
        }
    }

    private Set<ZoneDeviceInfo> getDeleteDevice(ZonePolicyApplyInfo infoInDb, ZonePolicyApplyInfo zonePolicyApplyInfo) {
        Set<ZoneDeviceInfo> zoneDeviceInfosInDb = infoInDb.getZoneDeviceInfos();
        Set<ZoneDeviceInfo> zoneDeviceInfosInCache = zonePolicyApplyInfo.getZoneDeviceInfos();
        HashSet<ZoneDeviceInfo> result = new HashSet<ZoneDeviceInfo>();
        for (ZoneDeviceInfo each : zoneDeviceInfosInDb) {
            Boolean isEqual = false;
            for (ZoneDeviceInfo eachInCache : zoneDeviceInfosInCache) {
                if (!each.getDeviceId().equals(eachInCache.getDeviceId())) continue;
                isEqual = true;
            }
            if (isEqual.booleanValue()) continue;
            result.add(each);
        }
        return result;
    }

    private Set<ZoneDeviceInfo> getNewRelDevice(ZonePolicyApplyInfo infoInDb, ZonePolicyApplyInfo zonePolicyApplyInfo) {
        Set<ZoneDeviceInfo> zoneDeviceInfosInDb = infoInDb.getZoneDeviceInfos();
        Set<ZoneDeviceInfo> zoneDeviceInfosInCache = zonePolicyApplyInfo.getZoneDeviceInfos();
        HashSet<ZoneDeviceInfo> result = new HashSet<ZoneDeviceInfo>();
        for (ZoneDeviceInfo each : zoneDeviceInfosInCache) {
            Boolean isEqual = false;
            for (ZoneDeviceInfo eachInCache : zoneDeviceInfosInDb) {
                if (!each.getDeviceId().equals(eachInCache.getDeviceId())) continue;
                isEqual = true;
            }
            if (isEqual.booleanValue()) continue;
            result.add(each);
        }
        return result;
    }

    private void createDefaultServiceByDevice(Set<ZoneDeviceInfo> newRelDevice) {
        for (ZoneDeviceInfo zoneDevice : newRelDevice) {
            if (null == zoneDevice.getDeviceId()) continue;
            ZoneServiceForm zoneServiceForm = null;
            ZoneInfo zoneInfo = this.zoneDao.getByZoneId(zoneDevice.getZoneId());
            if (null != zoneInfo && AticConstants.ZONE_TYPE_CUSTOME.equals(zoneInfo.getZoneType())) {
                zoneServiceForm = this.initZoneServiceForm(true);
                zoneServiceForm.setDirection(2);
                this.initZoneServicedData(zoneDevice, zoneServiceForm, true);
                try {
                    this.zoneService.create(zoneServiceForm);
                }
                catch (Exception e) {
                    this.logger.error((Object)("create outbound Service error." + e.getMessage()));
                }
            }
            zoneServiceForm = this.initZoneServiceForm(false);
            zoneServiceForm.setDirection(1);
            this.initZoneServicedData(zoneDevice, zoneServiceForm, false);
            try {
                this.zoneService.create(zoneServiceForm);
            }
            catch (Exception e) {
                this.logger.error((Object)("create inbound DefaultService  error." + e.getMessage()));
            }
        }
        try {
            this.getFoundDefaultIdService().refeshDefaultBizData();
        }
        catch (Exception e) {
            this.logger.error((Object)("refeshDefaultBizData error : " + e.getMessage()));
        }
    }

    private void initZoneServicedData(ZoneDeviceInfo zoneDevice, ZoneServiceForm zoneServiceForm, boolean isSupportOutbound) {
        zoneServiceForm.setZoneId(zoneDevice.getZoneId());
        zoneServiceForm.setProtocol("DEFAULT");
        zoneServiceForm.setDeviceId(zoneDevice.getDeviceId());
        zoneServiceForm.setServiceType(0);
        zoneServiceForm.setIpList("");
        zoneServiceForm.setPortList("");
        AticDevice device = this.aticDeviceService.getDeviceByMoid(zoneDevice.getDeviceId().longValue());
        if (device.getDeviceType() == 8 || device.getDeviceType() == 9) {
            ZoneInfoForm zoneInfoFormTemp = this.zoneDefineService.getById(zoneServiceForm.getZoneId());
            if (zoneInfoFormTemp != null) {
                if (isSupportOutbound) {
                    zoneServiceForm.setServiceName("Basic_AntiDDoS1820-N_Outbound_" + device.getIpAddress().replace(".", "_"));
                } else {
                    zoneServiceForm.setServiceName("Basic_AntiDDoS1820-N_" + device.getIpAddress().replace(".", "_"));
                }
            }
        } else if (isSupportOutbound) {
            zoneServiceForm.setServiceName("Basic_Outbound_" + device.getIpAddress().replace(".", "_"));
        } else {
            zoneServiceForm.setServiceName("Basic_" + device.getIpAddress().replace(".", "_"));
        }
    }

    private IFoundDefaultIdService getFoundDefaultIdService() {
        for (int i = 0; null == this.foundDefaultIdService && i < 100; ++i) {
            try {
                this.foundDefaultIdService = ZoneReferUtil.getFoundDefaultIdService();
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)"get AticBis/foundDefaultIdService failed ");
            }
        }
        return this.foundDefaultIdService;
    }

    private ZoneServiceForm initZoneServiceForm(boolean isSupportOutbound) {
        ZoneServiceForm zoneServiceForm = new ZoneServiceForm();
        NfaPolicyEditForm nfaPolicyEditForm = new NfaPolicyEditForm();
        TcpDefendPolicyForm tcpDefendPolicyForm = new TcpDefendPolicyForm();
        UdpDefendPolicyForm udpDefendPolicyForm = new UdpDefendPolicyForm();
        IcmpDefendPolicyForm icmpDefendPolicyForm = new IcmpDefendPolicyForm();
        if (isSupportOutbound) {
            tcpDefendPolicyForm.setDirection(2);
            udpDefendPolicyForm.setDirection(2);
            icmpDefendPolicyForm.setDirection(2);
            nfaPolicyEditForm.setDirection(2);
        }
        HttpDefendPolicyForm httpDefendPolicyForm = new HttpDefendPolicyForm();
        HttpsDefendPolicyForm httpsDefendPolicyForm = new HttpsDefendPolicyForm();
        DnsDefendPolicyForm dnsDefendPolicyForm = new DnsDefendPolicyForm();
        SipDefendPolicyForm sipDefendPolicyForm = new SipDefendPolicyForm();
        OtherDefendPolicyForm otherDefendPolicyForm = new OtherDefendPolicyForm();
        zoneServiceForm.setTcpDefendPolicyForm(tcpDefendPolicyForm);
        zoneServiceForm.setUdpDefendPolicyForm(udpDefendPolicyForm);
        zoneServiceForm.setHttpDefendPolicyForm(httpDefendPolicyForm);
        zoneServiceForm.setHttpsDefendPolicyForm(httpsDefendPolicyForm);
        zoneServiceForm.setIcmpDefendPolicyForm(icmpDefendPolicyForm);
        zoneServiceForm.setDnsDefendPolicyForm(dnsDefendPolicyForm);
        zoneServiceForm.setSipDefendPolicyForm(sipDefendPolicyForm);
        zoneServiceForm.setOtherDefendPolicyForm(otherDefendPolicyForm);
        zoneServiceForm.setNfaPolicyEditForm(nfaPolicyEditForm);
        return zoneServiceForm;
    }

    private ZonePolicyApplyForm tranInfo2Form(Map<Long, String> deviceMap, ZonePolicyApplyInfo zonePolicyApplyInfo) {
        ZonePolicyApplyForm userPolicyApplyForm = new ZonePolicyApplyForm();
        ArrayList<ZoneDeviceForm> tmpDevList = new ArrayList<ZoneDeviceForm>();
        VsmUtil.getInstance().copyProperties(zonePolicyApplyInfo, userPolicyApplyForm);
        for (ZoneDeviceInfo info : zonePolicyApplyInfo.getZoneDeviceInfos()) {
            ZoneDeviceForm devForm = new ZoneDeviceForm();
            VsmUtil.getInstance().copyProperties(info, devForm);
            String addressIp = deviceMap.get(info.getDeviceId());
            if (null != addressIp) {
                devForm.setDeviceIp(addressIp);
            }
            tmpDevList.add(devForm);
        }
        userPolicyApplyForm.setZoneDeviceForms(tmpDevList);
        return userPolicyApplyForm;
    }

    private ZonePolicyApplyForm tranInfo2Form(List<AticDevice> deviceList, ZonePolicyApplyInfo zonePolicyApplyInfo) {
        ZonePolicyApplyForm userPolicyApplyForm = new ZonePolicyApplyForm();
        ArrayList<ZoneDeviceForm> tmpDevList = new ArrayList<ZoneDeviceForm>();
        VsmUtil.getInstance().copyProperties(zonePolicyApplyInfo, userPolicyApplyForm);
        for (ZoneDeviceInfo info : zonePolicyApplyInfo.getZoneDeviceInfos()) {
            ZoneDeviceForm devForm = new ZoneDeviceForm();
            VsmUtil.getInstance().copyProperties(info, devForm);
            for (AticDevice device : deviceList) {
                if (device.getMoId() != info.getDeviceId().longValue()) continue;
                String deviceIp = device.getIpAddress();
                devForm.setDeviceIp(deviceIp);
                break;
            }
            tmpDevList.add(devForm);
        }
        userPolicyApplyForm.setZoneDeviceForms(tmpDevList);
        return userPolicyApplyForm;
    }

    private ZonePolicyApplyInfo tranForm2Info(ZonePolicyApplyForm form) {
        ZonePolicyApplyInfo info = new ZonePolicyApplyInfo();
        VsmUtil.getInstance().copyProperties(form, info);
        List<ZoneDeviceForm> devList = form.getZoneDeviceForms();
        HashSet<ZoneDeviceInfo> deviceSet = new HashSet<ZoneDeviceInfo>();
        if (null != devList) {
            for (ZoneDeviceForm zoneDeviceForm : devList) {
                ZoneDeviceInfo zoneDeviceInfo = new ZoneDeviceInfo();
                VsmUtil.getInstance().copyProperties(zoneDeviceForm, zoneDeviceInfo);
                deviceSet.add(zoneDeviceInfo);
            }
        }
        info.setZoneDeviceInfos(deviceSet);
        return info;
    }

    private List<ZoneIpLocationForm> tranInfoList2FormList(List<ZoneIpLocationInfo> infoList) {
        ArrayList<ZoneIpLocationForm> formList = new ArrayList<ZoneIpLocationForm>();
        if (infoList != null && !infoList.isEmpty()) {
            for (ZoneIpLocationInfo info : infoList) {
                ZoneIpLocationForm form = new ZoneIpLocationForm();
                VsmUtil.getInstance().copyProperties(info, form);
                formList.add(form);
            }
        }
        return formList;
    }

    private List<ZoneIpLocationInfo> tranFormList2InfoList(List<ZoneIpLocationForm> formList) {
        ArrayList<ZoneIpLocationInfo> infoList = new ArrayList<ZoneIpLocationInfo>();
        if (formList != null && !formList.isEmpty()) {
            for (ZoneIpLocationForm form : formList) {
                ZoneIpLocationInfo info = new ZoneIpLocationInfo();
                VsmUtil.getInstance().copyProperties(form, info);
                infoList.add(info);
            }
        }
        return infoList;
    }

    public Long create(ZonePolicyApplyForm form) {
        Long pkid = null;
        if (null != form) {
            ZonePolicyApplyInfo info = this.tranForm2Info(form);
            this.userPolicyApplyDao.saveOrUpdate(info);
            pkid = info.getZoneId();
        }
        return pkid;
    }

    @Override
    public void deleteByZoneId(Long id) {
        this.getUserPolicyApplyDao().deleteByZoneId(id);
        this.getBlackWhiteListDao().deleteAllByZoneId(id);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", String.valueOf(id));
        Paging page = this.zoneService.queryByPage(queryMap, 0, Integer.MAX_VALUE);
        List formList = page.getData();
        ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
        for (ZoneServiceForm form : formList) {
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(form.getPkid().longValue());
            boList.add(bo);
        }
        this.zoneService.deleteInBatch(boList);
    }

    @Override
    public List<ZonePolicyApplyForm> queryRelationZoneByZoneId(Set<Long> zoneIdExistSet) {
        List<ZonePolicyApplyInfo> userList = this.userPolicyApplyDao.queryByZoneIds(new ArrayList<Long>(zoneIdExistSet));
        ArrayList<ZonePolicyApplyForm> userPolicyApplyFormList = null;
        List deviceList = this.aticDeviceService.getAllDevice();
        if (!userList.isEmpty()) {
            int size = userList.size();
            userPolicyApplyFormList = new ArrayList<ZonePolicyApplyForm>();
            for (int i = 0; i < size; ++i) {
                ZonePolicyApplyInfo zonePolicyApplyInfo = userList.get(i);
                ZonePolicyApplyForm userPolicyApplyForm = this.tranInfo2Form(deviceList, zonePolicyApplyInfo);
                userPolicyApplyFormList.add(userPolicyApplyForm);
            }
        } else {
            return new ArrayList<ZonePolicyApplyForm>();
        }
        return userPolicyApplyFormList;
    }

    public void delete(Long id) {
    }

    public void delete(ZonePolicyApplyForm form) {
        ZonePolicyApplyInfo info = this.tranForm2Info(form);
        this.userPolicyApplyDao.delete(info);
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        return null;
    }

    public ZonePolicyApplyForm query(Long id) {
        List<ZonePolicyApplyInfo> userList = this.userPolicyApplyDao.getListByZoneId(id);
        ZonePolicyApplyForm userPolicyApplyForm = null;
        List deviceList = this.aticDeviceService.getAllDevice();
        if (!userList.isEmpty()) {
            ZonePolicyApplyInfo zonePolicyApplyInfo = userList.get(0);
            userPolicyApplyForm = this.tranInfo2Form(deviceList, zonePolicyApplyInfo);
            List<ZoneIpLocationInfo> infoList = this.zoneIpLocationDao.getByZoneId(id);
            List<ZoneIpLocationForm> formList = this.tranInfoList2FormList(infoList);
            userPolicyApplyForm.setZoneIpLocationList(formList);
            List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.queryByZoneId(id);
            if (null != filterDeviceZoneInfoList) {
                ArrayList<Long> filterIdList = new ArrayList<Long>();
                ArrayList<Long> filterPreferenceList = new ArrayList<Long>();
                for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
                    if (filterIdList.contains(filterDeviceZoneInfo.getFilterId())) continue;
                    filterIdList.add(filterDeviceZoneInfo.getFilterId());
                    filterPreferenceList.add(filterDeviceZoneInfo.getPreference());
                }
                userPolicyApplyForm.setFilterIdList(filterIdList);
                userPolicyApplyForm.setFilterPreferenceList(filterPreferenceList);
            }
            List<BlackWhiteListInfo> blackListInfoList = this.blackWhiteListDao.queryPrefixBlackWhiteListByZoneId(id, 1);
            List<ZoneBlackWhiteForm> zoneBlackWhiteFormList = this.zoneBlackTranInfoList2FormList(blackListInfoList);
            Collections.sort(zoneBlackWhiteFormList);
            userPolicyApplyForm.setZoneBlackWhiteFormList(zoneBlackWhiteFormList);
            List<BlackWhiteListInfo> whiteListInfoList = this.blackWhiteListDao.queryPrefixBlackWhiteListByZoneId(id, 2);
            List<ZoneWhiteForm> zonewhiteFormList = this.zoneWhiteTranInfoList2FormList(whiteListInfoList);
            Collections.sort(zonewhiteFormList);
            userPolicyApplyForm.setZoneWhiteFormList(zonewhiteFormList);
        }
        return userPolicyApplyForm;
    }

    private List<ZoneWhiteForm> zoneWhiteTranInfoList2FormList(List<BlackWhiteListInfo> blackWhiteListInfoList) {
        ArrayList<ZoneWhiteForm> whiteFormList = new ArrayList<ZoneWhiteForm>();
        if (blackWhiteListInfoList != null && !blackWhiteListInfoList.isEmpty()) {
            for (BlackWhiteListInfo info : blackWhiteListInfoList) {
                ZoneWhiteForm form = new ZoneWhiteForm();
                VsmUtil.getInstance().copyProperties(info, form);
                whiteFormList.add(form);
            }
        }
        return whiteFormList;
    }

    private List<ZoneBlackWhiteForm> zoneBlackTranInfoList2FormList(List<BlackWhiteListInfo> blackWhiteListInfoList) {
        ArrayList<ZoneBlackWhiteForm> blackFormList = new ArrayList<ZoneBlackWhiteForm>();
        if (blackWhiteListInfoList != null && !blackWhiteListInfoList.isEmpty()) {
            for (BlackWhiteListInfo info : blackWhiteListInfoList) {
                ZoneBlackWhiteForm form = new ZoneBlackWhiteForm();
                VsmUtil.getInstance().copyProperties(info, form);
                blackFormList.add(form);
            }
        }
        return blackFormList;
    }

    @Override
    public ZonePolicyApplyForm queryForDeploy(Long id) {
        List<ZonePolicyApplyInfo> userList = this.userPolicyApplyDao.getListByZoneId(id);
        ZonePolicyApplyForm userPolicyApplyForm = null;
        List deviceList = this.aticDeviceService.getAllDevice();
        if (!userList.isEmpty()) {
            ZonePolicyApplyInfo zonePolicyApplyInfo = userList.get(0);
            userPolicyApplyForm = this.tranInfo2Form(deviceList, zonePolicyApplyInfo);
            List<ZoneIpLocationInfo> infoList = this.zoneIpLocationDao.getByZoneId(id);
            List<ZoneIpLocationForm> formList = this.tranInfoList2FormList(infoList);
            userPolicyApplyForm.setZoneIpLocationList(formList);
        }
        return userPolicyApplyForm;
    }

    @Override
    public ZonePolicyApplyForm queryOnlyZonePolicy(Long id) {
        List<ZonePolicyApplyInfo> userList = this.userPolicyApplyDao.getListByZoneId(id);
        ZonePolicyApplyForm userPolicyApplyForm = null;
        if (!userList.isEmpty()) {
            ZonePolicyApplyInfo zonePolicyApplyInfo = userList.get(0);
            userPolicyApplyForm = new ZonePolicyApplyForm();
            VsmUtil.getInstance().copyProperties(zonePolicyApplyInfo, userPolicyApplyForm);
        }
        return userPolicyApplyForm;
    }

    @Override
    public ZonePolicyApplyForm queryByZoneId(Long id, int direction) {
        List<ZonePolicyApplyInfo> userList = this.userPolicyApplyDao.getListByZoneId(id);
        ZonePolicyApplyForm userPolicyApplyForm = null;
        List deviceList = this.aticDeviceService.getAllDevice();
        if (!userList.isEmpty()) {
            ZonePolicyApplyInfo zonePolicyApplyInfo = userList.get(0);
            userPolicyApplyForm = this.tranInfo2Form(deviceList, zonePolicyApplyInfo);
            List<ZoneIpLocationInfo> infoList = this.zoneIpLocationDao.getByZoneId(id);
            List<ZoneIpLocationForm> formList = this.tranInfoList2FormList(infoList);
            userPolicyApplyForm.setZoneIpLocationList(formList);
            List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.queryByZoneId(id, direction);
            if (null != filterDeviceZoneInfoList) {
                ArrayList<Long> filterIdList = new ArrayList<Long>();
                ArrayList<Long> filterPreferenceList = new ArrayList<Long>();
                for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
                    if (filterIdList.contains(filterDeviceZoneInfo.getFilterId())) continue;
                    filterIdList.add(filterDeviceZoneInfo.getFilterId());
                    filterPreferenceList.add(filterDeviceZoneInfo.getPreference());
                }
                userPolicyApplyForm.setFilterIdList(filterIdList);
                userPolicyApplyForm.setFilterPreferenceList(filterPreferenceList);
            }
        }
        return userPolicyApplyForm;
    }

    @Override
    public void update(ZonePolicyApplyForm form) {
        if (null != form) {
            ZonePolicyApplyInfo zonePolicyApplyInfo = this.tranForm2Info(form);
            this.userPolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
        }
    }

    public IZoneServiceService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneServiceService zoneService) {
        this.zoneService = zoneService;
    }

    @Override
    public ZonePolicyApplyForm queryByZoneId(Long id) {
        return this.query(id);
    }

    public void createOrUpdate(ZonePolicyApplyForm form) {
        Long configCrcAfterDB;
        Long configCrcBeforeDB;
        ZonePolicyApplyForm formNew = null;
        ZonePolicyApplyInfo infoInDb = null;
        if (null == form) {
            this.logger.error((Object)"form is null");
            return;
        }
        ZonePolicyApplyInfo zonePolicyApplyInfo = this.tranForm2Info(form);
        infoInDb = this.userPolicyApplyDao.getByZoneId(form.getZoneId());
        formNew = this.query(form.getZoneId());
        if (null == formNew) {
            this.logger.error((Object)"formNew is null");
            return;
        }
        this.userPolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
        if (infoInDb != null) {
            Set<ZoneDeviceInfo> deleteDevice = this.getDeleteDevice(infoInDb, zonePolicyApplyInfo);
            this.zoneDeviceDao.deleteAll(new ArrayList<ZoneDeviceInfo>(deleteDevice));
        }
        if (!(configCrcBeforeDB = Long.valueOf(CrcUtil.getCrcValue(form.getCalcCrcString()))).equals(configCrcAfterDB = Long.valueOf(CrcUtil.getCrcValue(formNew.getCalcCrcString())))) {
            ZonePolicyApplyInfo info = this.userPolicyApplyDao.getByZoneId(form.getZoneId());
            if (infoInDb != null) {
                if (!"UNDEPLOY".equals(infoInDb.getDeployState())) {
                    info.setDeployState("UNDEPLOY");
                } else {
                    info.setDeployState("INCREAMENT_UNDEPLOY");
                }
            }
            this.userPolicyApplyDao.saveOrUpdate(info);
        }
    }

    @Override
    public void createDDOSPolicy(Long zoneId, Long adminId) {
        ZoneInfoForm zoneInfo = this.zoneDefineService.getById(zoneId);
        ZonePolicyApplyForm form = new ZonePolicyApplyForm();
        form.setZoneId(zoneId);
        form.setZoneDesc(zoneInfo.getZoneDesc());
        this.initZonePolicyApplyForm(form);
        this.create(form);
    }

    @Override
    public void deleteDDOSPolicy(Long zoneId, Long adminId, List<Long> unConnDevices) {
        ZonePolicyApplyForm zoneBasiPolicy = this.query(zoneId);
        this.logger.info((Object)("systemTimeBeforeUndeploy : " + System.currentTimeMillis()));
        if (zoneBasiPolicy != null && !zoneBasiPolicy.getZoneDeviceForms().isEmpty()) {
            this.zonePolicyMgrService.unDeploy(zoneId, adminId, unConnDevices);
        }
        this.logger.info((Object)("systemTimeAfterUndeploy : " + System.currentTimeMillis()));
    }

    private void initZonePolicyApplyForm(ZonePolicyApplyForm form) {
        ArrayList<ZoneDeviceForm> zoneDeviceInfos = new ArrayList<ZoneDeviceForm>();
        form.setZoneDeviceForms(zoneDeviceInfos);
        form.setDefendMode(Constant.DEFENDMODE_DEFEND_AUTO);
        form.setDivertMode(Constant.DIVERTMODE_DIVERT_AUTO);
        form.setDynamicBlackMode(Constant.DYNAMICBLACKMODE_DYNAMIC_BLACK_CLOSE);
        form.setIpLimitEnable(false);
        form.setZoneLimitRate(1000);
        form.setBtwEnable(false);
        form.setCncEnable(false);
        form.setWebEnable(false);
        form.setDosEnable(false);
        form.setAuditEnable(false);
        form.setIpReputationEnable(false);
        form.setAbnormalState("NORMAL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> savePolicy(ZonePolicyApplyForm form, boolean isImport) {
        Boolean isLockZoneOK = false;
        ArrayList<Long> zoneIds = new ArrayList<Long>();
        try {
            if (null == form) {
                Map<Long, String> map = null;
                return map;
            }
            ZoneInfoForm zoneInfo = this.zoneDefineService.getById(form.getZoneId());
            form.setZoneDesc(zoneInfo.getZoneDesc());
            form.setZoneType(zoneInfo.getZoneType());
            zoneIds.add(form.getZoneId());
            isLockZoneOK = VsmUtil.getInstance().lockZones(zoneIds, "editPolicy");
            ZonePolicyApplyForm formDB = null;
            Map<Long, String> resultMap = null;
            ZonePolicyApplyInfo infoAlreadyHave = this.userPolicyApplyDao.getBaseZonePolicyApplyInfoByZoneId(form.getZoneId());
            ZonePolicyApplyForm formtemp = new ZonePolicyApplyForm();
            VsmUtil.getInstance().copyProperties(infoAlreadyHave, formtemp);
            ZonePolicyApplyInfo zonePolicyApplyInfo = this.tranForm2Info(form);
            if (form.getDirection() == 1) {
                if (null != formtemp.getOutBoundFilterAction()) {
                    zonePolicyApplyInfo.setOutBoundFilterAction(formtemp.getOutBoundFilterAction());
                }
                if (null != formtemp.getOutBoundFilterDropThreshold()) {
                    zonePolicyApplyInfo.setOutBoundFilterDropThreshold(formtemp.getOutBoundFilterDropThreshold());
                }
                if (null != formtemp.getOutBoundNextHop()) {
                    zonePolicyApplyInfo.setOutBoundNextHop(formtemp.getOutBoundNextHop());
                }
                if (null != formtemp.getOutBoundFilterLimit()) {
                    zonePolicyApplyInfo.setOutBoundFilterLimit(formtemp.getOutBoundFilterLimit());
                }
            }
            ZonePolicyApplyInfo infoInDb = this.userPolicyApplyDao.getByZoneId(form.getZoneId());
            formDB = this.query(form.getZoneId());
            if (null == formDB) {
                formDB = new ZonePolicyApplyForm();
                this.logger.error((Object)"savePolicy method,formDB is null");
            }
            this.userPolicyApplyDao.saveOrUpdate(zonePolicyApplyInfo);
            List<ZoneIpLocationForm> formList = form.getZoneIpLocationList();
            List<ZoneIpLocationInfo> infoList = this.tranFormList2InfoList(formList);
            this.zoneIpLocationDao.deleteByZoneId(form.getZoneId());
            this.zoneIpLocationDao.save(infoList);
            Set<ZoneDeviceInfo> newRelDevice = this.getNewRelDevice(infoInDb, zonePolicyApplyInfo);
            Set<ZoneDeviceInfo> deleteDevice = this.getDeleteDevice(infoInDb, zonePolicyApplyInfo);
            this.checkEnableDivertExist(deleteDevice);
            this.deleteDisabledDivertTask(deleteDevice);
            if (!deleteDevice.isEmpty()) {
                resultMap = this.uneployeZoneDeviceData(deleteDevice, newRelDevice);
            }
            if (isImport) {
                this.updateFilterRelation4Import(form);
            } else {
                this.updateFilterRelation(form, newRelDevice);
            }
            ArrayList<Integer> deviceTypeList = new ArrayList<Integer>();
            Iterator<ZoneDeviceInfo> ite = newRelDevice.iterator();
            while (ite.hasNext()) {
                AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(ite.next().getDeviceId().longValue());
                int deviceType = aticDevice.getDeviceType();
                deviceTypeList.add(deviceType);
            }
            if (!newRelDevice.isEmpty() && !isImport && deviceTypeList.contains(1) || deviceTypeList.contains(8) || deviceTypeList.contains(9)) {
                this.createDefaultServiceByDevice(newRelDevice);
            }
            if ((!newRelDevice.isEmpty() || !deleteDevice.isEmpty()) && !isImport && deviceTypeList.contains(1) || deviceTypeList.contains(8) || deviceTypeList.contains(9)) {
                this.updateZoneIpState(form.getZoneId());
                this.updateZonePortMapState(form.getZoneId());
            }
            this.notifyDeployStateChange(formDB, form, resultMap, newRelDevice);
            Map<Long, String> map = resultMap;
            return map;
        }
        finally {
            if (isLockZoneOK.booleanValue()) {
                VsmUtil.getInstance().unlockZones(zoneIds);
            }
        }
    }

    private void updateFilterRelation4Import(ZonePolicyApplyForm form) {
        FilterDeviceZoneInfo info;
        String fdeviceType;
        Long filterId;
        int deviceType;
        AticDevice aticDevice;
        int i;
        List<Long> filterPreferenceList;
        List<Long> filterIdList;
        if (null != form.getFilterIdList() && !form.getFilterIdList().isEmpty() && form.getFilterIdList().get(0) != null) {
            filterIdList = form.getFilterIdList();
            filterPreferenceList = form.getFilterPreferenceList();
            for (i = 0; i < form.getFilterIdList().size(); ++i) {
                if (null == form.getZoneDeviceForms() || form.getZoneDeviceForms().isEmpty()) continue;
                for (ZoneDeviceForm zoneDevice : form.getZoneDeviceForms()) {
                    aticDevice = this.aticDeviceService.getDeviceByMoid(zoneDevice.getDeviceId().longValue());
                    deviceType = aticDevice.getDeviceType();
                    filterId = filterIdList.get(i);
                    fdeviceType = ((FilterForm)this.filterService.query(filterId)).getDeviceType();
                    info = null;
                    if (null != fdeviceType && "ALL".equals(fdeviceType)) {
                        info = new FilterDeviceZoneInfo();
                        info.setDeviceId(zoneDevice.getDeviceId());
                        info.setFilterId(filterIdList.get(i));
                        info.setZoneId(form.getZoneId());
                        info.setPreference(filterPreferenceList.get(i));
                        info.setDirection(1);
                    } else if (null != fdeviceType && "AntiDDoS".equals(fdeviceType) && 1 == deviceType) {
                        info = new FilterDeviceZoneInfo();
                        info.setDeviceId(zoneDevice.getDeviceId());
                        info.setFilterId(filterIdList.get(i));
                        info.setZoneId(form.getZoneId());
                        info.setPreference(filterPreferenceList.get(i));
                        info.setDirection(1);
                    }
                    if (null == info) continue;
                    this.filterDeviceZoneInfoDao.saveForZone(info);
                }
            }
        }
        if (null != form.getOutboundFilterIdList() && !form.getOutboundFilterIdList().isEmpty() && form.getOutboundFilterIdList().get(0) != null) {
            filterIdList = form.getOutboundFilterIdList();
            filterPreferenceList = form.getOutboundFilterPreferenceList();
            for (i = 0; i < form.getOutboundFilterIdList().size(); ++i) {
                if (null == form.getZoneDeviceForms() || form.getZoneDeviceForms().isEmpty()) continue;
                for (ZoneDeviceForm zoneDevice : form.getZoneDeviceForms()) {
                    aticDevice = this.aticDeviceService.getDeviceByMoid(zoneDevice.getDeviceId().longValue());
                    deviceType = aticDevice.getDeviceType();
                    filterId = filterIdList.get(i);
                    fdeviceType = ((FilterForm)this.filterService.query(filterId)).getDeviceType();
                    info = null;
                    if (null != fdeviceType && "ALL".equals(fdeviceType)) {
                        info = new FilterDeviceZoneInfo();
                        info.setDeviceId(zoneDevice.getDeviceId());
                        info.setFilterId(filterIdList.get(i));
                        info.setZoneId(form.getZoneId());
                        info.setPreference(filterPreferenceList.get(i));
                        info.setDirection(2);
                    } else if (null != fdeviceType && "AntiDDoS".equals(fdeviceType) && 1 == deviceType) {
                        info = new FilterDeviceZoneInfo();
                        info.setDeviceId(zoneDevice.getDeviceId());
                        info.setFilterId(filterIdList.get(i));
                        info.setZoneId(form.getZoneId());
                        info.setPreference(filterPreferenceList.get(i));
                        info.setDirection(2);
                    }
                    if (null == info) continue;
                    this.filterDeviceZoneInfoDao.saveForZone(info);
                }
            }
        }
        ArrayList<Long> deviceIdList = new ArrayList<Long>();
        if (null != form.getZoneDeviceForms() && !form.getZoneDeviceForms().isEmpty()) {
            for (ZoneDeviceForm zoneDevice : form.getZoneDeviceForms()) {
                deviceIdList.add(zoneDevice.getDeviceId());
            }
        }
        this.filterDeviceZoneInfoDao.deleteByZoneIdExceptionDeviceIdAndFilterId(form.getZoneId(), deviceIdList, form.getFilterIdList(), 1);
        this.filterDeviceZoneInfoDao.deleteByZoneIdExceptionDeviceIdAndFilterId(form.getZoneId(), deviceIdList, form.getOutboundFilterIdList(), 2);
    }

    private void updateFilterRelation(ZonePolicyApplyForm form, Set<ZoneDeviceInfo> newAddDevice) {
        if (null != newAddDevice) {
            List<FilterDeviceZoneInfo> filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.getByZoneId(form.getZoneId());
            for (ZoneDeviceInfo zoneDeviceInfo : newAddDevice) {
                Long deviceId = zoneDeviceInfo.getDeviceId();
                for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfos) {
                    Long filterId = filterDeviceZoneInfo.getFilterId();
                    Long preference = filterDeviceZoneInfo.getPreference();
                    int direction = filterDeviceZoneInfo.getDirection();
                    this.saveFilterRelation(form, filterId, preference, deviceId, direction);
                }
            }
        }
        if (null != form.getFilterIdList() && !form.getFilterIdList().isEmpty() && form.getFilterIdList().get(0) != null) {
            List<Long> filterIdList = form.getFilterIdList();
            List<Long> filterPreferenceList = form.getFilterPreferenceList();
            for (int i = 0; i < form.getFilterIdList().size(); ++i) {
                if (null == form.getZoneDeviceForms() || form.getZoneDeviceForms().isEmpty()) continue;
                for (ZoneDeviceForm zoneDevice : form.getZoneDeviceForms()) {
                    Long filterId = filterIdList.get(i);
                    Long preference = filterPreferenceList.get(i);
                    Long deviceId = zoneDevice.getDeviceId();
                    this.saveFilterRelation(form, filterId, preference, deviceId, form.getDirection());
                }
            }
        }
        ArrayList<Long> deviceIdList = new ArrayList<Long>();
        if (null != form.getZoneDeviceForms() && !form.getZoneDeviceForms().isEmpty()) {
            for (ZoneDeviceForm zoneDevice : form.getZoneDeviceForms()) {
                deviceIdList.add(zoneDevice.getDeviceId());
            }
        }
        this.filterDeviceZoneInfoDao.deleteByZoneIdExceptionDeviceIdAndFilterId(form.getZoneId(), deviceIdList, form.getFilterIdList(), form.getDirection());
    }

    private void saveFilterRelation(ZonePolicyApplyForm form, Long filterId, Long preference, Long deviceId, int direction) {
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
        int deviceType = aticDevice.getDeviceType();
        String fdeviceType = ((FilterForm)this.filterService.query(filterId)).getDeviceType();
        FilterDeviceZoneInfo info = null;
        if (null != fdeviceType && "ALL".equals(fdeviceType)) {
            info = new FilterDeviceZoneInfo();
            info.setDeviceId(deviceId);
            info.setFilterId(filterId);
            info.setZoneId(form.getZoneId());
            info.setPreference(preference);
            info.setDirection(direction);
        } else if (null != fdeviceType && "AntiDDoS".equals(fdeviceType) && 1 == deviceType) {
            info = new FilterDeviceZoneInfo();
            info.setDeviceId(deviceId);
            info.setFilterId(filterId);
            info.setZoneId(form.getZoneId());
            info.setPreference(preference);
            info.setDirection(direction);
        } else if (null != fdeviceType && "AntiDDoS1820-N".equals(fdeviceType) && (8 == deviceType || 9 == deviceType)) {
            info = new FilterDeviceZoneInfo();
            info.setDeviceId(deviceId);
            info.setFilterId(filterId);
            info.setZoneId(form.getZoneId());
            info.setPreference(preference);
            info.setDirection(direction);
        }
        if (null != info) {
            this.filterDeviceZoneInfoDao.saveForZone(info);
        }
    }

    private void notifyDeployStateChange(ZonePolicyApplyForm formDB, ZonePolicyApplyForm form, Map<Long, String> resultMap, Set<ZoneDeviceInfo> newRelDevice) {
        ZonePolicyApplyInfo info = this.userPolicyApplyDao.getByZoneId(form.getZoneId());
        if (info.getZoneDeviceInfos().size() == 0) {
            if (!"UNDEPLOY".equals(info.getDeployState())) {
                info.setDeployState("UNDEPLOY");
                this.userPolicyApplyDao.saveOrUpdate(info);
            }
        } else {
            this.dealIncreamentDeployStatus(formDB, form, info, resultMap, newRelDevice);
        }
    }

    private void dealIncreamentDeployStatus(ZonePolicyApplyForm formDB, ZonePolicyApplyForm form, ZonePolicyApplyInfo info, Map<Long, String> resultMap, Set<ZoneDeviceInfo> newRelDevice) {
        String crcStringWithoutDevicesBefore = this.calcCrcWithoutDevicesBefore(formDB);
        String crcStringWithoutDevicesCur = this.calcCrcWithoutDevicesCurrent(form);
        Long configCrcWithoutDevicesBeforeDB = CrcUtil.getCrcValue(crcStringWithoutDevicesCur);
        Long configCrcWithoutDevicesAfterDB = CrcUtil.getCrcValue(crcStringWithoutDevicesBefore);
        List<ZoneModifyDetailForm> modifyDetailForms = this.getZoneModifyDetail(form.getZoneId());
        if (null != modifyDetailForms && !modifyDetailForms.isEmpty()) {
            if (null != resultMap && newRelDevice.isEmpty()) {
                if (!configCrcWithoutDevicesBeforeDB.equals(configCrcWithoutDevicesAfterDB) || form.getFilterIdList() != null && !form.getFilterIdList().isEmpty()) {
                    this.saveDeployStatus(info, form);
                }
            } else if (!"UNDEPLOY".equals(info.getDeployState())) {
                info.setDeployState("INCREAMENT_UNDEPLOY");
                this.userPolicyApplyDao.saveOrUpdate(info);
            }
        }
    }

    private void deleteDisabledDivertTask(Set<ZoneDeviceInfo> deleteDevice) {
        if (null == deleteDevice || deleteDevice.isEmpty()) {
            return;
        }
        try {
            for (ZoneDeviceInfo zoneDeviceInfo : deleteDevice) {
                this.getDivertTacticsService().removeDivertForBackoutNe(zoneDeviceInfo.getZoneId(), zoneDeviceInfo.getDeviceId());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    private void checkEnableDivertExist(Set<ZoneDeviceInfo> deleteDevice) {
        if (null == deleteDevice || deleteDevice.isEmpty()) {
            return;
        }
        for (ZoneDeviceInfo zoneDeviceInfo : deleteDevice) {
            Boolean hasEnableDivertTask = this.getDivertTacticsService().isHaveStartDivertTask(zoneDeviceInfo.getZoneId(), zoneDeviceInfo.getDeviceId());
            if (!hasEnableDivertTask.booleanValue()) continue;
            AticDevice device = this.aticDeviceService.getDeviceByMoid(zoneDeviceInfo.getDeviceId().longValue());
            throw new LegoCheckedException(630157L, new String[]{device.getName()});
        }
    }

    private void saveDeployStatus(ZonePolicyApplyInfo info, ZonePolicyApplyForm form) {
        if (info.getZoneDeviceInfos().size() == 1) {
            for (ZoneDeviceInfo zoneDeviceInfo : info.getZoneDeviceInfos()) {
                if (!"UNDEPLOY".equals(info.getDeployState())) {
                    info.setDeployState("INCREAMENT_UNDEPLOY");
                }
                this.notifyZoneDeviceDeployStatusChanged(zoneDeviceInfo.getZoneId(), zoneDeviceInfo.getDeviceId());
            }
        } else {
            if (!"UNDEPLOY".equals(info.getDeployState())) {
                info.setDeployState("INCREAMENT_UNDEPLOY");
            }
            this.notifyZoneDeviceDeployStatusChanged(form.getZoneId(), null);
        }
        this.userPolicyApplyDao.saveOrUpdate(info);
    }

    private String calcCrcWithoutDevicesCurrent(ZonePolicyApplyForm form) {
        StringBuffer sb = new StringBuffer();
        sb.append(form.getCalcCrcWithoutDevicesString());
        if (null != form.getFilterIdList()) {
            sb.append(form.getFilterIdList().toString());
        }
        if (null != form.getZoneBlackWhiteFormList()) {
            sb.append(form.getZoneBlackWhiteFormList().toString());
        }
        if (null != form.getZoneWhiteFormList()) {
            sb.append(form.getZoneWhiteFormList().toString());
        }
        return sb.toString();
    }

    private String calcCrcWithoutDevicesBefore(ZonePolicyApplyForm formNew) {
        StringBuffer sb = new StringBuffer();
        sb.append(formNew.getCalcCrcWithoutDevicesString());
        if (null != formNew.getFilterIdList()) {
            sb.append(formNew.getFilterIdList().toString());
        }
        if (null != formNew.getZoneBlackWhiteFormList()) {
            sb.append(formNew.getZoneBlackWhiteFormList().toString());
        }
        if (null != formNew.getZoneWhiteFormList()) {
            sb.append(formNew.getZoneWhiteFormList().toString());
        }
        return sb.toString();
    }

    private void notifyZoneDeviceDeployStatusChanged(Long zoneId, Long deviceId) {
        List zoneDeviceDeployStatusInfos;
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hqlBuffer = new StringBuffer();
        hqlBuffer.append("from ZoneDeviceDeployStatusInfo where zoneId = ?0 ");
        condition.put(0, zoneId);
        if (null != deviceId) {
            hqlBuffer.append(" and deviceId = ?1 ");
            condition.put(1, deviceId);
        }
        if (null != (zoneDeviceDeployStatusInfos = this.zoneDeviceDeployStatusDao.queryByHql(hqlBuffer.toString(), condition)) && !zoneDeviceDeployStatusInfos.isEmpty()) {
            for (ZoneDeviceDeployStatusInfo deviceStatusInfo : zoneDeviceDeployStatusInfos) {
                deviceStatusInfo.setHasChange(true);
                this.zoneDeviceDeployStatusDao.update(deviceStatusInfo);
            }
        }
    }

    private Map<Long, String> uneployeZoneDeviceData(Set<ZoneDeviceInfo> deleteDevice, Set<ZoneDeviceInfo> newRelDevice) {
        IDivertForPolicy divertTacticsServices = ZoneReferUtil.getDivertForPolicyService();
        if (null == deleteDevice) {
            return null;
        }
        ArrayList<Long> deviceIds = new ArrayList<Long>();
        HashSet<Long> delDevIds = new HashSet<Long>();
        Long zoneId = 0L;
        for (ZoneDeviceInfo zoneDevice : deleteDevice) {
            deviceIds.add(zoneDevice.getDeviceId());
            delDevIds.add(zoneDevice.getDeviceId());
            zoneId = zoneDevice.getZoneId();
        }
        Boolean hasNewRelDevices = false;
        if (null != newRelDevice && !newRelDevice.isEmpty()) {
            hasNewRelDevices = true;
        }
        Map<Long, String> resultMap = this.zonePolicyMgrService.unDeploy(zoneId, deviceIds, hasNewRelDevices);
        boolean isDefaultZone = this.zoneDefineService.isDefaultZone(zoneId);
        for (int i = 0; i < deviceIds.size(); ++i) {
            this.zoneService.deleteByDeviceIdAndZoneId((Long)deviceIds.get(i), zoneId);
            this.zoneDeviceDao.deleteByDeviceIdAndZoneId((Long)deviceIds.get(i), zoneId);
            if (!isDefaultZone) continue;
            divertTacticsServices.resetZoneNameForDivert(zoneId, delDevIds);
        }
        return resultMap;
    }

    @Override
    public void updateAbnormalState(Long zoneId, String abnormalState) {
        this.userPolicyApplyDao.updateAbnormalState(zoneId, abnormalState);
    }

    private IPacketTaskService getPacketTaskService() {
        for (int i = 0; null == this.packetTaskService && i < 100; ++i) {
            try {
                this.packetTaskService = ZoneReferUtil.getPacketTaskService();
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
            }
        }
        return this.packetTaskService;
    }

    private IDivertForPolicy getDivertTacticsService() {
        for (int i = 0; null == this.divertTacticsService && i < 100; ++i) {
            try {
                this.divertTacticsService = ZoneReferUtil.getDivertForPolicyService();
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
            }
        }
        return this.divertTacticsService;
    }

    private IAttackDataService getAttackDateService() {
        for (int i = 0; null == this.attackDataService && i < 100; ++i) {
            try {
                this.attackDataService = ZoneReferUtil.getAttackDataService();
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("getAttackDateService error." + e.getMessage()));
            }
        }
        return this.attackDataService;
    }

    @Override
    public void updateBaseLineState(Long zoneId, int baseLineState) {
    }

    @Override
    public void updateServiceLearnState(Long zoneId, int serviceLearnState) {
    }

    @Override
    public List<ZonePolicyApplyForm> queryByZoneIds(List<Long> zoneIds) {
        ArrayList<ZonePolicyApplyForm> policyForms = new ArrayList<ZonePolicyApplyForm>();
        if (null == zoneIds || zoneIds.isEmpty()) {
            return policyForms;
        }
        List<ZonePolicyApplyInfo> policyApplyInfos = this.userPolicyApplyDao.queryByZoneIds(zoneIds);
        if (policyApplyInfos.isEmpty()) {
            return policyForms;
        }
        ZonePolicyApplyForm policyForm = null;
        List deviceList = this.aticDeviceService.getAllDevice();
        for (ZonePolicyApplyInfo policyInfo : policyApplyInfos) {
            policyForm = this.tranInfo2Form(deviceList, policyInfo);
            policyForms.add(policyForm);
        }
        return policyForms;
    }

    @Override
    public Long queryZoneIpCrcDeployed(Long zoneId) {
        Set<ZoneDeviceInfo> zoneDeviceInfos;
        Long initCrc = CrcUtil.getCrcValue(0L);
        ZonePolicyApplyInfo policyInfo = this.userPolicyApplyDao.getByZoneId(zoneId);
        Long deviceId = null;
        if (null != policyInfo && null != (zoneDeviceInfos = policyInfo.getZoneDeviceInfos()) && !zoneDeviceInfos.isEmpty()) {
            ZoneDeviceInfo zoneDeviceInfo = zoneDeviceInfos.iterator().next();
            deviceId = zoneDeviceInfo.getDeviceId();
        }
        if (deviceId == null) {
            return initCrc;
        }
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        String hql = "from ZoneFeatureStatusInfo where zoneId = ?0 and deviceId = ?1 and featureType = 'ZoneIpForm'";
        condition.put(0, zoneId);
        condition.put(1, deviceId);
        List list = this.zoneFeatureStatusDao.queryByHql(hql, condition);
        if (null == list || list.isEmpty()) {
            return initCrc;
        }
        ZoneFeatureStatusInfo info = (ZoneFeatureStatusInfo)list.get(0);
        return info.getDeployCrc();
    }

    @Override
    public Long calcZoneIpCrcToDeploy(Long zoneId) {
        Long initCrc = CrcUtil.getCrcValue(0L);
        ZoneInfoForm form = this.zoneDefineService.getById(zoneId);
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> ipList = new ArrayList<String>();
        if (form == null || form.getZoneIpFormList().isEmpty()) {
            return initCrc;
        }
        for (ZoneIpForm ip : form.getZoneIpFormList()) {
            ipList.add("ipitem[ip=" + ip.getZoneIp() + ",mask=" + ip.getMask() + ",startIp=" + ip.getStartIp() + ",endIp=" + ip.getEndIp() + "]");
        }
        Collections.sort(ipList);
        buffer.append(((Object)ipList).toString());
        return CrcUtil.getCrcValue(buffer.toString());
    }

    @Override
    public void updateDDosPolicyDeployedState(Long zoneId) {
        ZonePolicyApplyInfo policyInfo = this.userPolicyApplyDao.getByZoneId(zoneId);
        if (!"UNDEPLOY".equals(policyInfo.getDeployState())) {
            policyInfo.setDeployState("INCREAMENT_UNDEPLOY");
        }
        this.userPolicyApplyDao.update(policyInfo);
        this.updateZoneDeviceDeployStatus(policyInfo);
    }

    private void updateZoneDeviceDeployStatus(ZonePolicyApplyInfo policyInfo) {
        Set<ZoneDeviceInfo> zoneDeviceInfos = policyInfo.getZoneDeviceInfos();
        for (ZoneDeviceInfo zoneDeviceInfo : zoneDeviceInfos) {
            List<ZoneDeviceDeployStatusInfo> statusInfos = this.zoneDeviceDeployStatusDao.getByZoneIdAndDeviceId(policyInfo.getZoneId(), zoneDeviceInfo.getDeviceId());
            if (null == statusInfos || statusInfos.isEmpty()) continue;
            ZoneDeviceDeployStatusInfo tempStatusInfo = statusInfos.get(0);
            tempStatusInfo.setHasChange(true);
            this.zoneDeviceDeployStatusDao.update(tempStatusInfo);
        }
    }

    @Override
    public void updateDeployStateByZoneId(Long zoneId, String deployState) {
        this.userPolicyApplyDao.updateDeployStateByZoneId(zoneId, deployState);
    }

    @Override
    public void updateAllZoneDeployState() {
        this.userPolicyApplyDao.updateAllZoneDeployState();
    }

    @Override
    public Long getDefaultZoneIdByDeviceId(Long deviceId) {
        List<Long> zoneIdList = this.zoneDeviceDao.getByDevId(deviceId);
        List<ZoneInfoForm> zoneInfoFormList = this.zoneDefineService.getAllDefaultZones();
        HashSet<Long> defaultZoneIdSet = new HashSet<Long>();
        for (ZoneInfoForm form : zoneInfoFormList) {
            defaultZoneIdSet.add(form.getZoneId());
        }
        for (Long zoneId : zoneIdList) {
            if (!defaultZoneIdSet.contains(zoneId)) continue;
            return zoneId;
        }
        return null;
    }

    @Override
    public List<ZonePolicyApplyInfo> getZoneInfoByDeviceId(Long deviceId) {
        List<Long> zoneIdList = this.zoneDeviceDao.getByDevId(deviceId);
        List<ZonePolicyApplyInfo> zoneInfoFormList = this.userPolicyApplyDao.queryByZoneIds(zoneIdList);
        return zoneInfoFormList;
    }

    @Override
    public Map<Long, Boolean> hasEnabledDivertTask(List<ZoneDeviceForm> zoneDeviceForms) {
        HashMap<Long, Boolean> divertTaskMap = new HashMap<Long, Boolean>();
        if (null == zoneDeviceForms || zoneDeviceForms.isEmpty()) {
            return divertTaskMap;
        }
        for (ZoneDeviceForm zoneDeviceForm : zoneDeviceForms) {
            Boolean hasDivertTaskFlag = this.getDivertTacticsService().isHaveStartDivertTask(zoneDeviceForm.getZoneId(), zoneDeviceForm.getDeviceId());
            divertTaskMap.put(zoneDeviceForm.getDeviceId(), hasDivertTaskFlag);
        }
        return divertTaskMap;
    }

    @Override
    public List<ZoneModifyDetailForm> getZoneModifyDetail(Long zoneId) {
        ZoneConfigData zoneConfigData = this.getConfigDataTools().initZoneConfigData(zoneId);
        ArrayList<ZoneModifyDetailForm> zoneModifyDetailForms = new ArrayList();
        ZoneToDeployData zoneModifiedData = new ZoneToDeployData();
        try {
            zoneModifyDetailForms = zoneModifiedData.initModifiedData(zoneConfigData, zoneId);
        }
        catch (Exception e) {
            this.logger.error((Object)("getZoneModifyDetail zoneModifyDetailForms exception error," + e.getMessage()));
        }
        return zoneModifyDetailForms;
    }

    @Override
    public int queryZoneDivertMode(Long zoneId) {
        ZonePolicyApplyInfo policy = this.userPolicyApplyDao.getBaseZonePolicyApplyInfoByZoneId(zoneId);
        if (null != policy) {
            return policy.getDivertMode();
        }
        return 0;
    }

    @Override
    public ZonePolicyApplyForm queryByZoneIdForCreateZoneXml(Long zoneId, List<Long> deviceIds, Map<Long, String> deviceMap) {
        ZonePolicyApplyForm form = this.queryByZoneId4Xml(zoneId, deviceMap);
        if (null != form) {
            ZoneInfoForm zoneInfo = this.zoneDefineService.getById(zoneId);
            List<ZoneListIpInfo> zoneListIpInfoList = this.zoneListIpDao.getByZoneIdAndDeleteFlag(zoneId);
            ArrayList<ZoneListIpForm> zoneListIpFormList = new ArrayList<ZoneListIpForm>();
            for (ZoneListIpInfo zoneListIpInfo : zoneListIpInfoList) {
                ZoneListIpForm zoneListIpForm = new ZoneListIpForm();
                VsmUtil.getInstance().copyProperties(zoneListIpInfo, zoneListIpForm);
                zoneListIpFormList.add(zoneListIpForm);
            }
            zoneInfo.setZoneListIpFormList(zoneListIpFormList);
            String telephone = LegoDataProtectorWrapper.sdpDecryptLocal((String)zoneInfo.getTelephone());
            String mobile = LegoDataProtectorWrapper.sdpDecryptLocal((String)zoneInfo.getMobile());
            String address = LegoDataProtectorWrapper.sdpDecryptLocal((String)zoneInfo.getAddress());
            String post = LegoDataProtectorWrapper.sdpDecryptLocal((String)zoneInfo.getPost());
            String email = LegoDataProtectorWrapper.sdpDecryptLocal((String)zoneInfo.getEmail());
            zoneInfo.setTelephone(telephone);
            zoneInfo.setMobile(mobile);
            zoneInfo.setAddress(address);
            zoneInfo.setPost(post);
            zoneInfo.setEmail(email);
            form.setZoneInfoForm(zoneInfo);
            FaultSeverityRuleForm faultSeverityRuleForm = this.faultSeverityRuleService.getZoneSeverityRuleByZoneId(zoneId, Integer.valueOf(1));
            if (null == faultSeverityRuleForm) {
                faultSeverityRuleForm = this.faultSeverityRuleService.getZoneSeverityRuleByZoneId(Long.valueOf(0L), Integer.valueOf(1));
            }
            form.setFaultSeverityRuleForm(faultSeverityRuleForm);
            FaultSeverityRuleForm outboundFaultSeverityRuleForm = this.faultSeverityRuleService.getZoneSeverityRuleByZoneId(zoneId, Integer.valueOf(2));
            if (null == outboundFaultSeverityRuleForm) {
                outboundFaultSeverityRuleForm = this.faultSeverityRuleService.getZoneSeverityRuleByZoneId(Long.valueOf(0L), Integer.valueOf(2));
            }
            form.setOutboundFaultSeverityRuleForm(outboundFaultSeverityRuleForm);
            List<ZoneServiceForm> zoneServices = this.zoneService.queryZoneServicesByZoneId(zoneId, deviceIds);
            form.setZoneServices(zoneServices);
        } else {
            this.logger.error((Object)"form is null");
        }
        return form;
    }

    private ZonePolicyApplyForm queryByZoneId4Xml(Long id, Map<Long, String> deviceMap) {
        List<ZonePolicyApplyInfo> userList = this.userPolicyApplyDao.getListByZoneId(id);
        ZonePolicyApplyForm userPolicyApplyForm = null;
        if (!userList.isEmpty()) {
            ZonePolicyApplyInfo zonePolicyApplyInfo = userList.get(0);
            userPolicyApplyForm = this.tranInfo2Form(deviceMap, zonePolicyApplyInfo);
            List<ZoneIpLocationInfo> infoList = this.zoneIpLocationDao.getByZoneId(id);
            List<ZoneIpLocationForm> formList = this.tranInfoList2FormList(infoList);
            userPolicyApplyForm.setZoneIpLocationList(formList);
            List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.queryByZoneId(id);
            if (null != filterDeviceZoneInfoList) {
                ArrayList<Long> inboundFilterIdList = new ArrayList<Long>();
                ArrayList<Long> outboundFilterIdList = new ArrayList<Long>();
                for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
                    if (1 == filterDeviceZoneInfo.getDirection() && !inboundFilterIdList.contains(filterDeviceZoneInfo.getFilterId())) {
                        inboundFilterIdList.add(filterDeviceZoneInfo.getFilterId());
                    }
                    if (2 != filterDeviceZoneInfo.getDirection() || outboundFilterIdList.contains(filterDeviceZoneInfo.getFilterId())) continue;
                    outboundFilterIdList.add(filterDeviceZoneInfo.getFilterId());
                }
                userPolicyApplyForm.setFilterIdList(inboundFilterIdList);
                userPolicyApplyForm.setOutboundFilterIdList(outboundFilterIdList);
            }
            List<BlackWhiteListInfo> blackListInfoList = this.blackWhiteListDao.queryPrefixBlackWhiteListByZoneId(id, 1);
            List<ZoneBlackWhiteForm> zoneBlackWhiteFormList = this.zoneBlackTranInfoList2FormList(blackListInfoList);
            Collections.sort(zoneBlackWhiteFormList);
            userPolicyApplyForm.setZoneBlackWhiteFormList(zoneBlackWhiteFormList);
            List<BlackWhiteListInfo> whiteListInfoList = this.blackWhiteListDao.queryPrefixBlackWhiteListByZoneId(id, 2);
            List<ZoneWhiteForm> zonewhiteFormList = this.zoneWhiteTranInfoList2FormList(whiteListInfoList);
            Collections.sort(zonewhiteFormList);
            userPolicyApplyForm.setZoneWhiteFormList(zonewhiteFormList);
        }
        return userPolicyApplyForm;
    }

    @Override
    public List<Long> queryAllNeedDeployZoneId() {
        return this.userPolicyApplyDao.queryAllNeedDeployZoneId();
    }

    @Override
    public int getBlackholeType(Long zoneId) {
        ZonePolicyApplyInfo zonePolicyApplyInfo = this.userPolicyApplyDao.getByZoneId(zoneId);
        return zonePolicyApplyInfo.getBlackholeType();
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }

    public FaultSeverityRuleService getFaultSeverityRuleService() {
        return this.faultSeverityRuleService;
    }

    public void setFaultSeverityRuleService(FaultSeverityRuleService faultSeverityRuleService) {
        this.faultSeverityRuleService = faultSeverityRuleService;
    }

    public ILicenseOutboundService getLicenseOutboundService() {
        return this.licenseOutboundService;
    }

    public void setLicenseOutboundService(ILicenseOutboundService licenseOutboundService) {
        this.licenseOutboundService = licenseOutboundService;
    }

    public ZoneDao getZoneDao() {
        return this.zoneDao;
    }

    public void setZoneDao(ZoneDao zoneDao) {
        this.zoneDao = zoneDao;
    }

    public IOutboundDivertForPolicy getOutboundDivertTacticsService() {
        if (null == this.outboundDivertTacticsService) {
            this.outboundDivertTacticsService = ZoneReferUtil.getOutboundDivertForPolicyService();
        }
        return this.outboundDivertTacticsService;
    }

    public ZoneListPortMapDao getZoneListPortMapDao() {
        return this.zoneListPortMapDao;
    }

    public void setZoneListPortMapDao(ZoneListPortMapDao zoneListPortMapDao) {
        this.zoneListPortMapDao = zoneListPortMapDao;
    }

    private void updateZoneIpState(Long zoneId) {
        this.zoneListIpDao.updateDeployStateByZoneId(zoneId);
    }

    private void updateZonePortMapState(Long zoneId) {
        this.zoneListPortMapDao.updateDeployStateByZoneId(zoneId);
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public ZoneIpLocationDao getZoneIpLocationDao() {
        return this.zoneIpLocationDao;
    }

    public void setZoneIpLocationDao(ZoneIpLocationDao zoneIpLocationDao) {
        this.zoneIpLocationDao = zoneIpLocationDao;
    }

    public INfaPolicyEditService getNfaPolicyEditService() {
        return this.nfaPolicyEditService;
    }

    public void setNfaPolicyEditService(INfaPolicyEditService nfaPolicyEditService) {
        this.nfaPolicyEditService = nfaPolicyEditService;
    }

    public ConfigDataTools getConfigDataTools() {
        return this.configDataTools;
    }

    public void setConfigDataTools(ConfigDataTools configDataTools) {
        this.configDataTools = configDataTools;
    }

    public IZoneService getZoneDefineService() {
        return this.zoneDefineService;
    }

    public void setZoneDefineService(IZoneService zoneDefineService) {
        this.zoneDefineService = zoneDefineService;
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public IZonePolicyMgrService getZonePolicyMgrService() {
        return this.zonePolicyMgrService;
    }

    public void setZonePolicyMgrService(IZonePolicyMgrService zonePolicyMgrService) {
        this.zonePolicyMgrService = zonePolicyMgrService;
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public ZoneServiceStatusDao getZoneServiceStatusDao() {
        return this.zoneServiceStatusDao;
    }

    public void setZoneServiceStatusDao(ZoneServiceStatusDao zoneServiceStatusDao) {
        this.zoneServiceStatusDao = zoneServiceStatusDao;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public ZoneServiceDao getZoneServiceDao() {
        return this.zoneServiceDao;
    }

    public void setZoneServiceDao(ZoneServiceDao zoneServiceDao) {
        this.zoneServiceDao = zoneServiceDao;
    }

    public FilterDeviceZoneInfoDao getFilterDeviceZoneInfoDao() {
        return this.filterDeviceZoneInfoDao;
    }

    public void setFilterDeviceZoneInfoDao(FilterDeviceZoneInfoDao filterDeviceZoneInfoDao) {
        this.filterDeviceZoneInfoDao = filterDeviceZoneInfoDao;
    }

    public ZonePolicyApplyDao getUserPolicyApplyDao() {
        return this.userPolicyApplyDao;
    }

    public void setUserPolicyApplyDao(ZonePolicyApplyDao userPolicyApplyDao) {
        this.userPolicyApplyDao = userPolicyApplyDao;
    }

    public ZoneDeviceDao getZoneDeviceDao() {
        return this.zoneDeviceDao;
    }

    public void setZoneDeviceDao(ZoneDeviceDao zoneDeviceDao) {
        this.zoneDeviceDao = zoneDeviceDao;
    }

    public ZoneListIpDao getZoneListIpDao() {
        return this.zoneListIpDao;
    }

    public void setZoneListIpDao(ZoneListIpDao zoneListIpDao) {
        this.zoneListIpDao = zoneListIpDao;
    }

    public BlackWhiteListDao getBlackWhiteListDao() {
        return this.blackWhiteListDao;
    }

    public void setBlackWhiteListDao(BlackWhiteListDao blackWhiteListDao) {
        this.blackWhiteListDao = blackWhiteListDao;
    }

    public IBlackWhiteListService getBlackWhiteListService() {
        return this.blackWhiteListService;
    }

    public void setBlackWhiteListService(IBlackWhiteListService blackWhiteListService) {
        this.blackWhiteListService = blackWhiteListService;
    }
}

