/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.vsm.secservice.ddos.dao.ZonePolicyApplyDao;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyCustomService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZonePolicyCustomService
implements IZonePolicyCustomService {
    private static final int NORMAL = 1;
    private static final int ALERT = 2;
    private static final int ATTACK = 3;
    private ZonePolicyApplyDao zonePolicyApplyDao;
    private Map<Long, String> stateBuffer = new HashMap<Long, String>();

    public ZonePolicyApplyDao getZonePolicyApplyDao() {
        return this.zonePolicyApplyDao;
    }

    public void setZonePolicyApplyDao(ZonePolicyApplyDao zonePolicyApplyDao) {
        this.zonePolicyApplyDao = zonePolicyApplyDao;
    }

    @Override
    public void updateZonePolicyApplyOfAbnormalState(Long zoneId, int defendState) {
        String zoneState = "NORMAL";
        switch (defendState) {
            case 1: {
                zoneState = "NORMAL";
                break;
            }
            case 2: {
                zoneState = "ALERTED";
                break;
            }
            case 3: {
                zoneState = "ATTACKED";
                break;
            }
        }
        if (null != this.zonePolicyApplyDao) {
            this.zonePolicyApplyDao.updateAbnormalState(zoneId, zoneState);
        }
        if (defendState == 1) {
            this.stateBuffer.remove(zoneId);
        } else {
            this.stateBuffer.put(zoneId, zoneState);
        }
    }

    @Override
    public String getZoneStateByZoneID(Long zoneId) {
        if (null == this.stateBuffer.get(zoneId)) {
            return "NORMAL";
        }
        return this.stateBuffer.get(zoneId);
    }

    @Override
    public List<Long> queryAllDeployZones() {
        if (null != this.zonePolicyApplyDao) {
            return this.zonePolicyApplyDao.queryAllDeployZones();
        }
        return null;
    }

    @Override
    public void resetAllZoneState() {
        if (null != this.zonePolicyApplyDao) {
            this.zonePolicyApplyDao.resetAllZoneState();
        }
    }
}

