/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service;

import com.hs.atic.sdk.bis.form.BaselineMetaDataForm;
import com.hs.atic.sdk.bis.form.ZoneBaseLineStudyForm;
import com.hs.atic.sdk.bis.service.IBaseLineService;
import com.hs.atic.sdk.bis.service.IBaselineDataService;
import com.hs.atic.sdk.util.BaseLineGetSuggestionValueQueryBean;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.DeviceTypesSupportedAntiDdos;
import com.hs.vsm.secservice.ddos.common.ErrorMsg2ResKey;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.service.data.ZoneUdpBlockInfo;
import com.hs.vsm.secservice.ddos.service.function.deploy.ZoneDeployCtrl;
import com.hs.vsm.secservice.ddos.service.function.undeploy.ZoneUndeployCtrl;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.ProgressMgr;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneModifyDetailForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyServiceSimple;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyMgrService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import com.huawei.atic.secservice.sdk.module.ddos.service.IDdosDevCapabilityService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZonePolicyMgrServiceImpl
implements IZonePolicyMgrService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Map<String, String> requestMap = new HashMap<String, String>();
    private ZoneDeployCtrl zoneDeployCtrl;
    private ZoneUndeployCtrl zoneUndeployCtrl;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private IBaselineDataService baselineDataService;
    private IZoneDeviceService zoneDeviceService;
    private IAticDeviceService aticDeviceService;
    private ICommonUtilService commonUtilService;
    private IZoneServiceService zoneServiceService;
    private IBaseLineService baseLineService;
    private IDdosDevCapabilityService ddosDevCapabilityService;

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public IBaselineDataService getBaselineDataService() {
        return this.baselineDataService;
    }

    public void setBaselineDataService(IBaselineDataService baselineDataService) {
        this.baselineDataService = baselineDataService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public IZoneServiceService getZoneServiceService() {
        return this.zoneServiceService;
    }

    public void setZoneServiceService(IZoneServiceService zoneServiceService) {
        this.zoneServiceService = zoneServiceService;
    }

    public IBaseLineService getBaseLineService() {
        return this.baseLineService;
    }

    public void setBaseLineService(IBaseLineService baseLineService) {
        this.baseLineService = baseLineService;
    }

    public IDdosDevCapabilityService getDdosDevCapabilityService() {
        return this.ddosDevCapabilityService;
    }

    public void setDdosDevCapabilityService(IDdosDevCapabilityService ddosDevCapabilityService) {
        this.ddosDevCapabilityService = ddosDevCapabilityService;
    }

    @Override
    public void deploy(List<Long> zoneIdList, Long progressBarId) {
        ErrorMsg2ResKey.getInstance();
        this.zoneDeployCtrl.setRequestMap(this.getRequestMap());
        this.zoneDeployCtrl.doDeploy(zoneIdList, progressBarId, null, null);
    }

    @Override
    public Map<Long, List<ZoneDeviceDeployStatusInfo>> queryByZoneIds(List<Long> zoneIdList) {
        int num = zoneIdList.size();
        LinkedHashMap<Long, List<ZoneDeviceDeployStatusInfo>> map = new LinkedHashMap<Long, List<ZoneDeviceDeployStatusInfo>>(num);
        List<ZoneDeviceDeployStatusInfo> list = null;
        ArrayList<ZoneDeviceDeployStatusInfo> newList = null;
        ZoneDeviceDeployStatusInfo newZoneDeviceDeployStatusInfo = null;
        for (Long lo : zoneIdList) {
            list = this.getZoneDeviceDeployStatusDao().queryByZoneId2(lo);
            newList = new ArrayList<ZoneDeviceDeployStatusInfo>(list.size());
            for (ZoneDeviceDeployStatusInfo zoneDeviceDeployStatusInfo : list) {
                newZoneDeviceDeployStatusInfo = new ZoneDeviceDeployStatusInfo();
                VsmUtil.getInstance().copyProperties(zoneDeviceDeployStatusInfo, newZoneDeviceDeployStatusInfo);
                newList.add(newZoneDeviceDeployStatusInfo);
            }
            map.put(lo, newList);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployInRest(List<Long> zoneIdList, List<String> features, List<String> zoneIp) {
        ErrorMsg2ResKey.getInstance();
        long progressBarId = System.currentTimeMillis();
        IZonePolicyApplyServiceSimple zonePolicyService = (IZonePolicyApplyServiceSimple)ServiceContext.getInstance().getService("policyApplyServiceSimple", IZonePolicyApplyServiceSimple.class);
        List<ZonePolicyApplyForm> beforePolicyApply = zonePolicyService.queryByZoneIds(zoneIdList);
        Map<Long, List<ZoneDeviceDeployStatusInfo>> beforeMap = this.queryByZoneIds(zoneIdList);
        this.zoneDeployCtrl.setRequestMap(this.getRequestMap());
        try {
            this.zoneDeployCtrl.doDeploy(zoneIdList, progressBarId, features, zoneIp);
        }
        finally {
            List<ZonePolicyApplyForm> newPolicyApply = zonePolicyService.queryByZoneIds(zoneIdList);
            Map<Long, List<ZoneDeviceDeployStatusInfo>> newMap = this.queryByZoneIds(zoneIdList);
            this.saveCompareZoneDevice(beforePolicyApply, beforeMap, newPolicyApply, newMap, zonePolicyService, features);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployRestZone(List<Long> zoneIdList, List<String> features, List<ZonePolicyApplyForm> beforePolicyApply, Map<Long, List<ZoneDeviceDeployStatusInfo>> beforeMap) {
        ErrorMsg2ResKey.getInstance();
        long progressBarId = System.currentTimeMillis();
        IZonePolicyApplyServiceSimple zonePolicyService = (IZonePolicyApplyServiceSimple)ServiceContext.getInstance().getService("policyApplyServiceSimple", IZonePolicyApplyServiceSimple.class);
        this.zoneDeployCtrl.setRequestMap(this.getRequestMap());
        try {
            this.zoneDeployCtrl.doDeploy(zoneIdList, progressBarId, features, null);
        }
        finally {
            List<ZonePolicyApplyForm> newPolicyApply = zonePolicyService.queryByZoneIds(zoneIdList);
            Map<Long, List<ZoneDeviceDeployStatusInfo>> newMap = this.queryByZoneIds(zoneIdList);
            this.saveCompareZoneDevice(beforePolicyApply, beforeMap, newPolicyApply, newMap, zonePolicyService, features);
        }
    }

    private void saveCompareZoneDevice(List<ZonePolicyApplyForm> beforePolicyApply, Map<Long, List<ZoneDeviceDeployStatusInfo>> beforeMap, List<ZonePolicyApplyForm> newPolicyApply, Map<Long, List<ZoneDeviceDeployStatusInfo>> newMap, IZonePolicyApplyServiceSimple zonePolicyService, List<String> features) {
        List<ZoneModifyDetailForm> zoneModifyDetailForms = null;
        List<ZoneDeviceDeployStatusInfo> before = null;
        List<ZoneDeviceDeployStatusInfo> after = null;
        int num = beforePolicyApply.size();
        for (int i = 0; i < num; ++i) {
            ZonePolicyApplyForm zonePolicyApplyForm;
            boolean feature = false;
            zoneModifyDetailForms = ZoneReferUtil.getZonePolicyService().getZoneModifyDetail(beforePolicyApply.get(i).getZoneId());
            if (null != zoneModifyDetailForms) {
                for (ZoneModifyDetailForm zoneModifyDetailForm : zoneModifyDetailForms) {
                    if (null == zoneModifyDetailForm.getModifyDetail() || zoneModifyDetailForm.getModifyDetail().trim().isEmpty()) continue;
                    feature = true;
                    break;
                }
            }
            if (("INCREAMENT_UNDEPLOY".equals(beforePolicyApply.get(i).getDeployState()) || "INCREAMENT_UNDEPLOY".equals(beforePolicyApply.get(i).getFilterState())) && "SUCCESS".equals(newPolicyApply.get(i).getDeployState()) && feature) {
                beforePolicyApply.get(i).setDeployState("INCREAMENT_UNDEPLOY");
                zonePolicyService.update(beforePolicyApply.get(i));
                continue;
            }
            if (("PART_SUCCESS".equals(beforePolicyApply.get(i).getDeployState()) || "PART_SUCCESS".equals(beforePolicyApply.get(i).getFilterState())) && "SUCCESS".equals(newPolicyApply.get(i).getDeployState())) {
                beforePolicyApply.get(i).setDeployState("PART_SUCCESS");
                zonePolicyService.update(beforePolicyApply.get(i));
                zonePolicyApplyForm = beforePolicyApply.get(i);
                if (!beforeMap.containsKey(zonePolicyApplyForm.getZoneId()) || !newMap.containsKey(zonePolicyApplyForm.getZoneId())) continue;
                before = beforeMap.get(zonePolicyApplyForm.getZoneId());
                after = newMap.get(zonePolicyApplyForm.getZoneId());
                this.updateZoneDeviceDeploy(before, after);
                continue;
            }
            if (("UNDEPLOY".equals(beforePolicyApply.get(i).getDeployState()) || "UNDEPLOY".equals(beforePolicyApply.get(i).getFilterState())) && "SUCCESS".equals(newPolicyApply.get(i).getDeployState()) && feature) {
                beforePolicyApply.get(i).setDeployState("INCREAMENT_UNDEPLOY");
                zonePolicyService.update(beforePolicyApply.get(i));
                continue;
            }
            if (!"PART_SUCCESS".equals(beforePolicyApply.get(i).getDeployState()) && !"PART_SUCCESS".equals(beforePolicyApply.get(i).getFilterState()) || !"PART_SUCCESS".equals(newPolicyApply.get(i).getDeployState()) || !beforeMap.containsKey((zonePolicyApplyForm = beforePolicyApply.get(i)).getZoneId()) || !newMap.containsKey(zonePolicyApplyForm.getZoneId())) continue;
            before = beforeMap.get(zonePolicyApplyForm.getZoneId());
            after = newMap.get(zonePolicyApplyForm.getZoneId());
            this.updateZoneDeviceDeploy(before, after);
        }
    }

    private void updateZoneDeviceDeploy(List<ZoneDeviceDeployStatusInfo> before, List<ZoneDeviceDeployStatusInfo> after) {
        LinkedHashMap<Long, ZoneDeviceDeployStatusInfo> mapBefore = new LinkedHashMap<Long, ZoneDeviceDeployStatusInfo>(before.size());
        LinkedHashMap<Long, ZoneDeviceDeployStatusInfo> mapAfter = new LinkedHashMap<Long, ZoneDeviceDeployStatusInfo>(after.size());
        for (ZoneDeviceDeployStatusInfo zoneDeviceDeployStatusInfo : before) {
            mapBefore.put(zoneDeviceDeployStatusInfo.getId(), zoneDeviceDeployStatusInfo);
        }
        for (ZoneDeviceDeployStatusInfo zoneDeviceDeployStatusInfo : after) {
            mapAfter.put(zoneDeviceDeployStatusInfo.getId(), zoneDeviceDeployStatusInfo);
        }
        Set set = mapBefore.entrySet();
        ZoneDeviceDeployStatusInfo oldZoneDeviceDeployStatusInfo = null;
        ZoneDeviceDeployStatusInfo statusInfo = null;
        String oldErrorKey = null;
        String oldErrorParam = null;
        String errorKey = null;
        for (Map.Entry entry : set) {
            oldZoneDeviceDeployStatusInfo = (ZoneDeviceDeployStatusInfo)entry.getValue();
            statusInfo = (ZoneDeviceDeployStatusInfo)mapAfter.get(entry.getKey());
            if (null == oldZoneDeviceDeployStatusInfo || null == statusInfo) continue;
            oldErrorParam = oldZoneDeviceDeployStatusInfo.getErrorParam();
            oldErrorKey = oldZoneDeviceDeployStatusInfo.getErrorMsgKey();
            errorKey = statusInfo.getErrorMsgKey();
            if (null == oldErrorKey || oldErrorKey.trim().length() <= 2 || null != errorKey && errorKey.trim().length() > 2) continue;
            statusInfo.setErrorMsgKey(oldErrorKey);
            statusInfo.setErrorParam(oldErrorParam);
            this.zoneDeviceDeployStatusDao.createOrUpdate(statusInfo);
        }
    }

    @Override
    public Map<Long, String> unDeploy(Long zoneId, List<Long> devices, Boolean hasNewRelDevices) {
        ErrorMsg2ResKey.getInstance();
        return this.zoneUndeployCtrl.doUnDeploy(zoneId, devices, hasNewRelDevices);
    }

    public ZoneDeployCtrl getZoneDeployCtrl() {
        return this.zoneDeployCtrl;
    }

    public void setZoneDeployCtrl(ZoneDeployCtrl zoneDeployCtrl) {
        this.zoneDeployCtrl = zoneDeployCtrl;
    }

    @Override
    public List<ZoneDeviceDeployStatusForm> queryDeployResultByZoneId(Long zoneId) {
        ArrayList<ZoneDeviceDeployStatusForm> result = new ArrayList<ZoneDeviceDeployStatusForm>();
        List<ZoneDeviceDeployStatusInfo> infoList = this.getZoneDeviceDeployStatusDao().queryByZoneId2(zoneId);
        for (ZoneDeviceDeployStatusInfo info : infoList) {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(info.getDeviceId().longValue());
            ZoneDeviceDeployStatusForm form = new ZoneDeviceDeployStatusForm();
            VsmUtil.getInstance().copyProperties(info, form);
            if (form.getDeployState().booleanValue()) continue;
            form.setDeviceName(aticDevice.getName());
            if (null != form.getDeployTime()) {
                SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                form.setDeployTimeDesc(format2.format(form.getDeployTime()));
            }
            result.add(form);
        }
        return result;
    }

    @Override
    public List<ZoneDeviceDeployStatusForm> queryDeployAllResultByZoneId(Long zoneId) {
        ArrayList<ZoneDeviceDeployStatusForm> result = new ArrayList<ZoneDeviceDeployStatusForm>();
        List<ZoneDeviceDeployStatusInfo> infoList = this.getZoneDeviceDeployStatusDao().queryByZoneId2(zoneId);
        AticDevice aticDevice = null;
        ZoneDeviceDeployStatusForm form = null;
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (ZoneDeviceDeployStatusInfo info : infoList) {
            aticDevice = this.aticDeviceService.getDeviceByMoid(info.getDeviceId().longValue());
            if (null == aticDevice) {
                this.logger.error((Object)("Device is null, device id is " + info.getDeviceId()));
                continue;
            }
            form = new ZoneDeviceDeployStatusForm();
            VsmUtil.getInstance().copyProperties(info, form);
            form.setDeviceName(aticDevice.getName());
            if (null != form.getDeployTime()) {
                form.setDeployTimeDesc(format2.format(form.getDeployTime()));
            }
            result.add(form);
        }
        return result;
    }

    @Override
    public List<ZoneDeviceDeployStatusForm> queryAllDeployResultByZoneId(Long zoneId) {
        ArrayList<ZoneDeviceDeployStatusForm> result = new ArrayList<ZoneDeviceDeployStatusForm>();
        List<ZoneDeviceDeployStatusInfo> infoList = this.getZoneDeviceDeployStatusDao().queryByZoneId2(zoneId);
        for (ZoneDeviceDeployStatusInfo info : infoList) {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(info.getDeviceId().longValue());
            ZoneDeviceDeployStatusForm form = new ZoneDeviceDeployStatusForm();
            VsmUtil.getInstance().copyProperties(info, form);
            form.setDeviceName(aticDevice.getName());
            if (null != form.getDeployTime()) {
                SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                form.setDeployTimeDesc(format2.format(form.getDeployTime()));
            }
            result.add(form);
        }
        return result;
    }

    @Override
    public ProgressBar getProgressBar(Long id) {
        return ProgressMgr.getInstance().getProgressBar(id);
    }

    public ZoneUndeployCtrl getZoneUndeployCtrl() {
        return this.zoneUndeployCtrl;
    }

    public void setZoneUndeployCtrl(ZoneUndeployCtrl zoneUndeployCtrl) {
        this.zoneUndeployCtrl = zoneUndeployCtrl;
    }

    @Override
    public void cancleTask(Long progressBarId) {
        this.logger.info((Object)"enter cancleTask");
        this.logger.info((Object)("cancleTask progressBarId:" + progressBarId));
        ProgressBar progressBar = ProgressMgr.getInstance().getProgressBar(progressBarId);
        if (null != progressBar) {
            progressBar.setCancled(true);
        }
        this.logger.info((Object)"enter leave");
    }

    @Override
    public List<String> getDeviceTypes() {
        List<String> list = DeviceTypesSupportedAntiDdos.getInstance().getDeviceTypes();
        return list;
    }

    @Override
    public Map<String, String> getErrorMsgKeyMapping() {
        return ErrorMsg2ResKey.getInstance().getErrorMsgKeyMapping();
    }

    @Override
    public void unDeploy(List<Long> zoneIdList, Long progressBarId, Long adminId) {
        ErrorMsg2ResKey.getInstance();
        this.zoneUndeployCtrl.doUndeploy(zoneIdList, progressBarId, adminId);
    }

    @Override
    public void unDeploy(Long zoneId, Long adminId, List<Long> unConnDevices) {
        ErrorMsg2ResKey.getInstance();
        this.zoneUndeployCtrl.doUndeploy(zoneId, adminId, unConnDevices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean lockZones(List<Long> zoneIdsList, String type) {
        Boolean isLockOK = false;
        try {
            Boolean bl = isLockOK = VsmUtil.getInstance().lockZones(zoneIdsList, type);
            return bl;
        }
        finally {
            if (isLockOK.booleanValue()) {
                VsmUtil.getInstance().unlockZones(zoneIdsList);
            }
        }
    }

    @Override
    public void deployAllZone(Long progressBarId) {
        this.zoneUndeployCtrl.undeployAllZone();
        this.zoneDeployCtrl.setRequestMap(this.getRequestMap());
        this.zoneDeployCtrl.deployEachZone(progressBarId);
    }

    @Override
    public Map<Long, String> applyBaseline(List<Long> zoneIdList, int effectMode, int direction) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>();
        for (Long zoneId : zoneIdList) {
            List<String> deviceList = this.getDdosDeviceList(zoneId);
            List<BaselineMetaDataForm> list = this.getBaselineMetaData(zoneId, deviceList, direction);
            String result = this.updateZoneService(zoneId, list, effectMode);
            resultMap.put(zoneId, result);
        }
        return resultMap;
    }

    private List<String> getDdosDeviceList(Long zoneId) {
        ArrayList<String> deviceList = new ArrayList<String>();
        List forms = this.zoneDeviceService.getByZoneId(zoneId);
        for (ZoneDeviceForm form : forms) {
            AticDevice device = this.aticDeviceService.getDeviceByMoid(form.getDeviceId().longValue());
            if (device.getDeviceType() != 1 && device.getDeviceType() != 8) continue;
            deviceList.add(device.getIpAddress());
        }
        return deviceList;
    }

    private List<BaselineMetaDataForm> getBaselineMetaData(Long zoneId, List<String> deviceList, int direction) {
        ArrayList<BaselineMetaDataForm> dataList = new ArrayList<BaselineMetaDataForm>();
        for (String deviceIp : deviceList) {
            dataList.addAll(this.getBaselineMetaData(zoneId, deviceIp, direction));
        }
        return dataList;
    }

    private List<BaselineMetaDataForm> getBaselineMetaData(Long zoneId, String deviceIp, int direction) {
        ArrayList<BaselineMetaDataForm> dataList = new ArrayList<BaselineMetaDataForm>();
        HashMap<String, String> queryCondition = new HashMap<String, String>();
        queryCondition.put("zoneId", String.valueOf(zoneId));
        queryCondition.put("version", this.commonUtilService.getDDoSVersion(deviceIp));
        queryCondition.put("deviceIp", deviceIp);
        queryCondition.put("direction", direction + "");
        List<ZoneBaseLineStudyForm> queryBaselineTasks = this.baseLineService.queryBaselineTaskByZoneId(zoneId);
        if (null != queryBaselineTasks && !queryBaselineTasks.isEmpty()) {
            for (ZoneBaseLineStudyForm zoneBaseLineStudyForm : queryBaselineTasks) {
                queryCondition.put("studyId", String.valueOf(zoneBaseLineStudyForm.getStudyId()));
                dataList.addAll(this.baselineDataService.queryByPage(queryCondition));
            }
        }
        return dataList;
    }

    private String updateZoneService(Long zoneId, List<BaselineMetaDataForm> list, int effectMode) {
        StringBuffer result = new StringBuffer();
        for (BaselineMetaDataForm dataForm : list) {
            long serviceId = dataForm.getServiceId();
            ZoneServiceForm serviceForm = (ZoneServiceForm)this.zoneServiceService.query(serviceId);
            long deviceId = serviceForm.getDeviceId();
            ZoneBaseLineStudyForm studyForm = this.baseLineService.queryByZoneId(zoneId);
            String key = dataForm.getKey();
            long baselineValue = dataForm.getValue();
            AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId);
            long currentValue = 0L;
            if (device.getDeviceType() == 8) {
                currentValue = this.getNfaNowValue(key, serviceForm);
            } else {
                int interval;
                currentValue = serviceForm.getCurrentValue(key);
                if ("tcpNewSrctipRate".equals(key) && 0 != (interval = serviceForm.getCurrentValue("tcpNewSrctipInterval"))) {
                    currentValue = (int)Math.ceil(Double.valueOf(currentValue) / (double)interval);
                }
            }
            if (null != studyForm) {
                int interval;
                int currentValueWeight = studyForm.getHistoryHeft();
                BaseLineGetSuggestionValueQueryBean baseLineGetSuggestionValueQueryBean = new BaseLineGetSuggestionValueQueryBean();
                baseLineGetSuggestionValueQueryBean.setBaselineValue(baselineValue);
                baseLineGetSuggestionValueQueryBean.setCurrentValue(currentValue);
                baseLineGetSuggestionValueQueryBean.setCurrentValueWeight(currentValueWeight);
                baseLineGetSuggestionValueQueryBean.setPolicyItem(key);
                baseLineGetSuggestionValueQueryBean.setDevice(device);
                baseLineGetSuggestionValueQueryBean.setServiceType(dataForm.getServiceType());
                int suggestionValue = (int)this.baselineDataService.getSuggestionValue(baseLineGetSuggestionValueQueryBean);
                String policyItem = Constant.getPolicyItemMap().get(key);
                if ("httpDestQpsAlertRate".equals(key) || "httpQpsAlertRate".equals(key)) {
                    policyItem = "httpDestQpsAlertRate";
                } else if (null == policyItem) {
                    policyItem = key;
                }
                if ("tcpNewSrctipRate".equals(policyItem) && 0 != (interval = serviceForm.getCurrentValue("tcpNewSrctipInterval"))) {
                    suggestionValue *= interval;
                }
                if (effectMode == 0) {
                    serviceForm.setCurrentValue(policyItem, suggestionValue);
                    this.zoneServiceService.create(serviceForm);
                    result.append('[');
                    result.append(key);
                    result.append(',');
                    result.append(suggestionValue);
                    result.append(']');
                    continue;
                }
                if (effectMode != 1 || (long)suggestionValue <= currentValue) continue;
                serviceForm.setCurrentValue(policyItem, suggestionValue);
                this.zoneServiceService.create(serviceForm);
                result.append('[');
                result.append(key);
                result.append(',');
                result.append(suggestionValue);
                result.append(']');
                continue;
            }
            this.logger.error((Object)"studyForm is null");
        }
        return result.toString();
    }

    private long getNfaNowValue(String key, ZoneServiceForm serviceForm) {
        NfaPolicyEditForm nfaPolicyEditForm = serviceForm.getNfaPolicyEditForm();
        NfaPolicyForm nfaPolicyForm = null;
        long currentValue = 0L;
        if (nfaPolicyEditForm == null) {
            this.logger.error((Object)"nfaPolicyEditForm is null");
            throw new NullPointerException("nfaPolicyEditForm is null");
        }
        if (key.contains("sipFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getSipFlood();
        }
        if (key.contains("dnsQueryFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getDnsQueryFlood();
        }
        if (key.contains("dnsReplyFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getDnsReplyFlood();
        }
        if (key.contains("httpFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getHttpFlood();
        }
        if (key.contains("httpsFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getHttpsFlood();
        }
        if (key.contains("icmpFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getIcmpFlood();
        }
        if (key.contains("otherFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getOtherFlood();
        }
        if (key.contains("tcpAckFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpAckFlood();
        }
        if (key.contains("tcpFragment")) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpFragmentFlood();
        }
        if (key.contains("tcpRstFin")) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpRstFinFlood();
        }
        if (key.contains("tcpSynFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpSynFlood();
        }
        if (key.contains("udpFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getUdpFlood();
        }
        if (key.contains("udpFragment")) {
            nfaPolicyForm = nfaPolicyEditForm.getUdpFragmentFlood();
        }
        if (key.contains("hostTotal")) {
            nfaPolicyForm = nfaPolicyEditForm.getHostTotal();
        }
        if (null == nfaPolicyForm) {
            this.logger.error((Object)"nfaPolicyForm is null");
            throw new NullPointerException("nfaPolicyForm is null");
        }
        if (key.contains("PpsThreshold")) {
            nfaPolicyForm.setPpsUnit(nfaPolicyForm.getPpsUnit() == null ? "" : "pps");
            currentValue = nfaPolicyForm.getPpsThreshold() == null ? 100L : nfaPolicyForm.getPpsThreshold();
        } else if (key.contains("BpsThreshold")) {
            nfaPolicyForm.setBpsUnit(nfaPolicyForm.getBpsUnit() == null ? "" : "Kbps");
            currentValue = nfaPolicyForm.getBpsThreshold() == null ? 100L : nfaPolicyForm.getBpsThreshold();
        }
        return currentValue;
    }

    @Override
    public List<ZoneUdpBlockInfo> queryAllZonesUDPBlock(long userId, boolean isAdmin) {
        return this.getZoneDeviceDeployStatusDao().queryAllZonesUDPBlock(userId, isAdmin);
    }

    public Map<String, String> getRequestMap() {
        return this.requestMap;
    }

    public void setRequestMap(Map<String, String> requestMap) {
        this.requestMap = requestMap;
    }

    @Override
    public void setRequestUserMap(Map<String, String> requestUserMap) {
        this.setRequestMap(requestUserMap);
    }
}

