/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data;

import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.vsm.secservice.ddos.common.FilterDeviceZonePair;
import com.hs.vsm.secservice.ddos.dao.FilterDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneInfoDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneStatusDao;
import com.hs.vsm.secservice.ddos.dao.HttpFilterDao;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneStatusInfo;
import com.hs.vsm.secservice.ddos.service.data.FilterConfigData;
import com.hs.vsm.secservice.ddos.service.data.FilterInitDeployData;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneStatusService;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FilterConfigDataTool {
    private IZoneService zoneService;
    private IFilterDeviceZoneStatusService statusService;
    private IFilterDeviceZoneInfoService service;
    private HttpFilterDao httpFilterDao;
    private FilterDao filterDao;
    private FilterDeviceZoneStatusDao filterDeviceZoneStatusDao;
    private FilterDeviceZoneInfoDao filterDeviceZoneInfoDao;

    public FilterConfigData initDeployFilterConfigData(List<FilterDeviceZonePair> deployFilterDeviceZonePairList, List<FilterDeviceZonePair> undeployFilterDeviceZonePairList, Map<Long, Set<Long>> deviceUnDeployFiltersMap, Boolean isDeployWithFilter) {
        FilterConfigData filterConfigData = new FilterConfigData();
        FilterInitDeployData filterInitDeployData = new FilterInitDeployData();
        this.initDeployConfigDataMapByDeploy(deployFilterDeviceZonePairList, filterInitDeployData);
        this.initUnDeployConfigDataMapByDeploy(undeployFilterDeviceZonePairList, filterInitDeployData);
        this.initUnDeployConfigDataMapByDeploy(deviceUnDeployFiltersMap, filterInitDeployData);
        filterConfigData.setNeInfoMap(filterInitDeployData.getNeInfoMap());
        filterConfigData.setZoneInfoMap(filterInitDeployData.getZoneInfoMap());
        filterConfigData.setFilterInfoMap(filterInitDeployData.getFilterInfoMap());
        filterConfigData.setFilterPolicyMap(filterInitDeployData.getFilterPolicyMap());
        filterConfigData.setDeviceDeployFiltersMap(filterInitDeployData.getDeviceDeployFiltersMap());
        filterConfigData.setDeviceUnDeployFiltersMap(deviceUnDeployFiltersMap);
        filterConfigData.setDeviceFilterDeployZoneMap(filterInitDeployData.getDeviceFilterDeployZoneMap());
        filterConfigData.setDeviceFilterUnDeployZoneMap(filterInitDeployData.getDeviceFilterUnDeployZoneMap());
        return filterConfigData;
    }

    private void initUnDeployConfigDataMapByDeploy(Map<Long, Set<Long>> deviceUnDeployFiltersMap, FilterInitDeployData filterInitDeployData) {
        if (deviceUnDeployFiltersMap == null || deviceUnDeployFiltersMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, Set<Long>> deviceUnDeployFiltersMapEntry : deviceUnDeployFiltersMap.entrySet()) {
            Long deviceId = deviceUnDeployFiltersMapEntry.getKey();
            filterInitDeployData.addToNeInfoMap(deviceId);
            if (deviceUnDeployFiltersMapEntry.getValue() == null) continue;
            for (Long filterId : deviceUnDeployFiltersMapEntry.getValue()) {
                FilterDeviceZonePair filterDeviceZonePair = new FilterDeviceZonePair(null, filterId, deviceId);
                filterInitDeployData.addToFilterInfoMap(filterDeviceZonePair, this.filterDao, this.filterDeviceZoneInfoDao);
            }
        }
    }

    public FilterConfigData initUnDeployFilterConfigData(List<FilterDeviceZonePair> undeployFilterDeviceZonePairList, Map<Long, Set<Long>> deviceUnDeployFiltersMap, Boolean isDeployWithFilter) {
        FilterConfigData filterConfigData = new FilterConfigData();
        FilterInitDeployData filterInitDeployData = new FilterInitDeployData();
        this.initUnDeployConfigDataMapByUnDeploy(undeployFilterDeviceZonePairList, isDeployWithFilter, filterInitDeployData);
        this.initUnDeployConfigDataMapByDeploy(deviceUnDeployFiltersMap, filterInitDeployData);
        filterConfigData.setNeInfoMap(filterInitDeployData.getNeInfoMap());
        filterConfigData.setZoneInfoMap(filterInitDeployData.getZoneInfoMap());
        filterConfigData.setFilterInfoMap(filterInitDeployData.getFilterInfoMap());
        filterConfigData.setFilterPolicyMap(filterInitDeployData.getFilterPolicyMap());
        filterConfigData.setDeviceUnDeployFiltersMap(deviceUnDeployFiltersMap);
        filterConfigData.setDeviceFilterUnDeployZoneMap(filterInitDeployData.getDeviceFilterUnDeployZoneMap());
        return filterConfigData;
    }

    private void initUnDeployConfigDataMapByUnDeploy(List<FilterDeviceZonePair> undeployFilterDeviceZonePairList, Boolean isDeployWithFilter, FilterInitDeployData filterInitDeployData) {
        if (undeployFilterDeviceZonePairList == null || undeployFilterDeviceZonePairList.isEmpty()) {
            return;
        }
        for (FilterDeviceZonePair filterDeviceZonePair : undeployFilterDeviceZonePairList) {
            Long filterId = filterDeviceZonePair.getFilterId();
            Long deviceId = filterDeviceZonePair.getDeviceId();
            Long zoneId = filterDeviceZonePair.getZoneId();
            int direction = filterDeviceZonePair.getDirection();
            filterInitDeployData.addToNeInfoMap(deviceId);
            filterInitDeployData.addToFilterInfoMap(filterDeviceZonePair, this.filterDao, this.filterDeviceZoneInfoDao);
            if (zoneId == null) continue;
            if (isDeployWithFilter.booleanValue()) {
                filterInitDeployData.addToFilterUnDeployZoneMap(filterId, deviceId, zoneId, direction);
            }
            filterInitDeployData.addToZoneInfoMap(zoneId, this.zoneService);
        }
    }

    private void initDeployConfigDataMapByDeploy(List<FilterDeviceZonePair> filterDeviceZonePairList, FilterInitDeployData filterInitDeployData) {
        if (filterDeviceZonePairList == null || filterDeviceZonePairList.isEmpty()) {
            return;
        }
        for (FilterDeviceZonePair filterDeviceZonePair : filterDeviceZonePairList) {
            boolean isNeddApplyForGlo;
            Long filterId = filterDeviceZonePair.getFilterId();
            Long deviceId = filterDeviceZonePair.getDeviceId();
            Long zoneId = filterDeviceZonePair.getZoneId();
            int direction = filterDeviceZonePair.getDirection();
            List<FilterDeviceZoneStatusInfo> statusInfos = this.filterDeviceZoneStatusDao.getFilterDefineDeployedByFilterIdAndDeviceId(filterId, deviceId);
            List<FilterDeviceZoneInfo> infos = this.filterDeviceZoneInfoDao.getFilterDefineDeployedForGlo(filterId, deviceId);
            boolean filterDefineStatus = false;
            boolean gloFilterDefineStatus = false;
            if (null != statusInfos && !statusInfos.isEmpty()) {
                filterDefineStatus = true;
            }
            if (null != infos && !infos.isEmpty()) {
                FilterDeviceZoneInfo filterDeviceZoneInfo = infos.get(0);
                gloFilterDefineStatus = filterDeviceZoneInfo.getFilterDefineState();
            }
            boolean isGolFilter01 = zoneId == 0L;
            filterDefineStatus = !filterDefineStatus && !isGolFilter01;
            boolean bl = gloFilterDefineStatus = !gloFilterDefineStatus && isGolFilter01;
            if (filterDefineStatus || gloFilterDefineStatus) {
                filterInitDeployData.addToDeviceDeployFiltersMap(filterId, deviceId, this.httpFilterDao);
                filterInitDeployData.addToNeInfoMap(deviceId);
                filterInitDeployData.addToFilterInfoMap(filterDeviceZonePair, this.filterDao, this.filterDeviceZoneInfoDao);
                filterInitDeployData.addToZoneInfoMap(zoneId, this.zoneService);
            }
            Long deploydFilterPreference = null;
            Long filterPreference = null;
            boolean deployState = false;
            String gloDeployState = "";
            if (zoneId != 0L) {
                FilterDeviceZoneStatusInfo filterDeviceZoneStatusInfo = this.filterDeviceZoneStatusDao.getByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, zoneId, direction);
                filterPreference = this.getFilterPreference(filterId, deviceId, zoneId, direction);
                if (null != filterDeviceZoneStatusInfo) {
                    deploydFilterPreference = filterDeviceZoneStatusInfo.getFilterPreference();
                    deployState = filterDeviceZoneStatusInfo.getDeployState();
                }
            } else {
                FilterDeviceZoneInfo filterDeviceZoneInfo = this.filterDeviceZoneInfoDao.getByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, zoneId, direction);
                if (null == filterDeviceZoneInfo) continue;
                gloDeployState = filterDeviceZoneInfo.getDeployState();
            }
            boolean isGolFilter = zoneId == 0L;
            boolean isNeedApplyForZone = (null == filterPreference || null == deploydFilterPreference || filterPreference.intValue() != deploydFilterPreference.intValue() || !deployState) && !isGolFilter;
            boolean bl2 = isNeddApplyForGlo = !"SUCCESS".equals(gloDeployState) && isGolFilter;
            if (!isNeedApplyForZone && !isNeddApplyForGlo) continue;
            filterInitDeployData.addToFilterDeployZoneMap(filterId, deviceId, zoneId, direction);
            if (!filterDefineStatus && !gloFilterDefineStatus) {
                filterInitDeployData.addToNeInfoMap(deviceId);
                filterInitDeployData.addToFilterInfoMap(filterDeviceZonePair, this.filterDao, this.filterDeviceZoneInfoDao);
            }
            filterInitDeployData.addToZoneInfoMap(zoneId, this.zoneService);
        }
    }

    private Long getFilterPreference(Long filterId, Long deviceId, Long zoneId, int direction) {
        return this.service.queryFilterPreference(filterId, deviceId, zoneId, direction);
    }

    private Long deployedFilterPreference(Long filterId, Long deviceId, Long zoneId, int direction) {
        FilterDeviceZoneStatusForm filterDeviceZoneStatusForm = this.statusService.getFilterStatusByIdAndDeviceIdAndZoneId(filterId, deviceId, zoneId, direction);
        Long filterPerference = null;
        if (null != filterDeviceZoneStatusForm) {
            filterPerference = filterDeviceZoneStatusForm.getFilterPreference();
        }
        return filterPerference;
    }

    private void initUnDeployConfigDataMapByDeploy(List<FilterDeviceZonePair> undeployFilterDeviceZonePairList, FilterInitDeployData filterInitDeployData) {
        if (undeployFilterDeviceZonePairList == null || undeployFilterDeviceZonePairList.isEmpty()) {
            return;
        }
        for (FilterDeviceZonePair filterDeviceZonePair : undeployFilterDeviceZonePairList) {
            boolean isUndoGlobalApply;
            Long filterId = filterDeviceZonePair.getFilterId();
            Long deviceId = filterDeviceZonePair.getDeviceId();
            Long zoneId = filterDeviceZonePair.getZoneId();
            int direction = filterDeviceZonePair.getDirection();
            boolean filterDefineStatus = false;
            boolean gloFilterDefineStatus = false;
            FilterDeviceZoneStatusInfo filterDeviceZoneStatusInfo = null;
            FilterDeviceZoneInfo filterDeviceZoneInfo = null;
            String errorCode = "error.";
            if (zoneId != 0L) {
                filterDeviceZoneStatusInfo = this.filterDeviceZoneStatusDao.getByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, zoneId, direction);
                if (null != filterDeviceZoneStatusInfo) {
                    filterDefineStatus = filterDeviceZoneStatusInfo.getFilterDefineState();
                    errorCode = filterDeviceZoneStatusInfo.getErrorCode();
                }
            } else {
                FilterDeviceZoneStatusInfo globalFilterDeviceZoneStatusInfo = this.filterDeviceZoneStatusDao.getByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, zoneId, direction);
                if (null != globalFilterDeviceZoneStatusInfo) {
                    errorCode = globalFilterDeviceZoneStatusInfo.getErrorCode();
                }
                if (null != (filterDeviceZoneInfo = this.filterDeviceZoneInfoDao.queryFilterForGlo(deviceId, filterId).get(0))) {
                    gloFilterDefineStatus = filterDeviceZoneInfo.getFilterDefineState();
                }
            }
            if (filterDefineStatus || gloFilterDefineStatus || !"".equals(errorCode)) {
                filterInitDeployData.addToNeInfoMap(deviceId);
                filterInitDeployData.addToFilterInfoMap(filterDeviceZonePair, this.filterDao, this.filterDeviceZoneInfoDao);
            }
            Long filterPreference = null;
            Long deploydFilterPreference = null;
            boolean deployState = false;
            String gloDeployState = "";
            if (zoneId != 0L) {
                filterPreference = this.getFilterPreference(filterId, deviceId, zoneId, direction);
                deploydFilterPreference = this.deployedFilterPreference(filterId, deviceId, zoneId, direction);
                if (null != filterDeviceZoneStatusInfo) {
                    deployState = filterDeviceZoneStatusInfo.getDeployState();
                }
            } else if (null != filterDeviceZoneInfo) {
                gloDeployState = filterDeviceZoneInfo.getDeployState();
            }
            boolean isGlobalFilter = zoneId == 0L;
            boolean isUndoZoneApply = (filterPreference == null ? 0 : filterPreference.intValue()) != (deploydFilterPreference == null ? 1 : deploydFilterPreference.intValue()) && (deployState || !"".equals(errorCode)) && !isGlobalFilter;
            boolean bl = isUndoGlobalApply = "SUCCESS".equals(gloDeployState) && isGlobalFilter || !"".equals(errorCode);
            if (!isUndoZoneApply && !isUndoGlobalApply) continue;
            filterInitDeployData.addToFilterUnDeployZoneMap(filterId, deviceId, zoneId, direction);
            filterInitDeployData.addToZoneInfoMap(zoneId, this.zoneService);
        }
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IFilterDeviceZoneStatusService getStatusService() {
        return this.statusService;
    }

    public void setStatusService(IFilterDeviceZoneStatusService statusService) {
        this.statusService = statusService;
    }

    public IFilterDeviceZoneInfoService getService() {
        return this.service;
    }

    public void setService(IFilterDeviceZoneInfoService service) {
        this.service = service;
    }

    public HttpFilterDao getHttpFilterDao() {
        return this.httpFilterDao;
    }

    public void setHttpFilterDao(HttpFilterDao httpFilterDao) {
        this.httpFilterDao = httpFilterDao;
    }

    public FilterDao getFilterDao() {
        return this.filterDao;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.filterDao = filterDao;
    }

    public FilterDeviceZoneStatusDao getFilterDeviceZoneStatusDao() {
        return this.filterDeviceZoneStatusDao;
    }

    public void setFilterDeviceZoneStatusDao(FilterDeviceZoneStatusDao filterDeviceZoneStatusDao) {
        this.filterDeviceZoneStatusDao = filterDeviceZoneStatusDao;
    }

    public FilterDeviceZoneInfoDao getFilterDeviceZoneInfoDao() {
        return this.filterDeviceZoneInfoDao;
    }

    public void setFilterDeviceZoneInfoDao(FilterDeviceZoneInfoDao filterDeviceZoneInfoDao) {
        this.filterDeviceZoneInfoDao = filterDeviceZoneInfoDao;
    }
}

