/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.vsm.secservice.ddos.common.FilterZonePair;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import com.hs.vsm.secservice.ddos.model.HttpFilterInfo;
import com.hs.vsm.secservice.ddos.service.data.FilterConfigData;
import com.hs.vsm.secservice.ddos.service.data.FilterToDeployData;
import com.hs.vsm.secservice.ddos.service.data.FilterToUnDeployData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterZoneData;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FilterToDeployDataTool {
    public FilterToDeployData initFilterToDeployData(FilterConfigData filterConfigData) {
        FilterToDeployData filterToDeployData = new FilterToDeployData();
        Map<Long, List<IFeature>> filterInfoToDeployData = this.initFilterInfoDeployData(filterConfigData.getDeviceDeployFiltersMap(), filterConfigData.getFilterInfoMap(), filterConfigData.getFilterPolicyMap());
        Map<Long, List<IFeature>> filterInfoToUnDeployData = this.initFilterInfoDeployData(filterConfigData.getDeviceUnDeployFiltersMap(), filterConfigData.getFilterInfoMap(), filterConfigData.getFilterPolicyMap());
        Map<Long, List<IFeature>> filterZonesToDeployData = this.initFilterZoneDeployData(filterConfigData.getDeviceFilterDeployZoneMap(), filterConfigData.getFilterInfoMap(), filterConfigData.getZoneInfoMap());
        Map<Long, List<IFeature>> filterZonesToUnDeployData = this.initFilterZoneDeployData(filterConfigData.getDeviceFilterUnDeployZoneMap(), filterConfigData.getFilterInfoMap(), filterConfigData.getZoneInfoMap());
        filterToDeployData.setFilterInfoToDeployData(filterInfoToDeployData);
        filterToDeployData.setFilterInfoToUnDeployData(filterInfoToUnDeployData);
        filterToDeployData.setFilterZonesToDeployData(filterZonesToDeployData);
        filterToDeployData.setFilterZonesToUnDeployData(filterZonesToUnDeployData);
        return filterToDeployData;
    }

    public FilterToUnDeployData initFilterToUnDeployData(FilterConfigData filterConfigData) {
        FilterToUnDeployData filterToUnDeployData = new FilterToUnDeployData();
        Map<Long, List<IFeature>> filterInfoToUnDeployData = this.initFilterInfoDeployData(filterConfigData.getDeviceUnDeployFiltersMap(), filterConfigData.getFilterInfoMap(), filterConfigData.getFilterPolicyMap());
        Map<Long, List<IFeature>> filterZonesToUnDeployData = this.initFilterZoneDeployData(filterConfigData.getDeviceFilterUnDeployZoneMap(), filterConfigData.getFilterInfoMap(), filterConfigData.getZoneInfoMap());
        filterToUnDeployData.setFilterInfoToUnDeployData(filterInfoToUnDeployData);
        filterToUnDeployData.setFilterZonesToUnDeployData(filterZonesToUnDeployData);
        return filterToUnDeployData;
    }

    private Map<Long, List<IFeature>> initFilterZoneDeployData(Map<Long, Set<FilterZonePair>> deviceFilterDeployZoneMap, Map<Long, FilterInfo> filterInfoMap, Map<Long, ZoneInfoForm> zoneInfoMap) {
        HashMap<Long, List<IFeature>> filterZoneDeployData = new HashMap<Long, List<IFeature>>();
        for (Map.Entry<Long, Set<FilterZonePair>> deviceFilterDeployZoneMapEntry : deviceFilterDeployZoneMap.entrySet()) {
            Long deviceId = deviceFilterDeployZoneMapEntry.getKey();
            Set<FilterZonePair> filterZonePairSet = deviceFilterDeployZoneMapEntry.getValue();
            ArrayList<FilterZoneData> featureList = new ArrayList<FilterZoneData>();
            for (FilterZonePair filterZonePair : filterZonePairSet) {
                Long zoneId = filterZonePair.getZoneId();
                Long filterId = filterZonePair.getFilterId();
                int direction = filterZonePair.getDirection();
                ZoneInfoForm zoneInfoForm = zoneInfoMap.get(zoneId);
                if (null == zoneInfoForm) continue;
                FilterInfo filterInfo = filterInfoMap.get(filterId);
                FilterZoneData filterZoneData = new FilterZoneData(FilterDeviceZoneInfo.class.getSimpleName(), filterId, filterInfo, zoneInfoForm, direction);
                featureList.add(filterZoneData);
            }
            filterZoneDeployData.put(deviceId, featureList);
        }
        return filterZoneDeployData;
    }

    private Map<Long, List<IFeature>> initFilterInfoDeployData(Map<Long, Set<Long>> deviceDeployFiltersMap, Map<Long, FilterInfo> filterInfoMap, Map<Long, List<HttpFilterInfo>> filterPolicyMap) {
        HashMap<Long, List<IFeature>> filterInfoDeployData = new HashMap<Long, List<IFeature>>();
        for (Map.Entry<Long, Set<Long>> deviceDeployFiltersMapEntry : deviceDeployFiltersMap.entrySet()) {
            Long deviceId = deviceDeployFiltersMapEntry.getKey();
            Set<Long> filterIdSet = deviceDeployFiltersMapEntry.getValue();
            ArrayList<FilterData> filterFeatureList = new ArrayList<FilterData>();
            for (Long filterId : filterIdSet) {
                FilterInfo filterInfo = filterInfoMap.get(filterId);
                List<HttpFilterInfo> filterPolicyInfoList = filterPolicyMap.get(filterId);
                FilterData filterData = new FilterData(FilterInfo.class.getSimpleName(), filterId, filterInfo, filterPolicyInfoList);
                filterFeatureList.add(filterData);
            }
            filterInfoDeployData.put(deviceId, filterFeatureList);
        }
        return filterInfoDeployData;
    }
}

