/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.form.ZoneUndoIpForm;
import com.hs.atic.zone.dao.ZoneIpDao;
import com.hs.atic.zone.dao.ZoneIpStatusDao;
import com.hs.atic.zone.dao.ZoneListIpDao;
import com.hs.atic.zone.dao.ZoneListPortMapDao;
import com.hs.atic.zone.dao.ZoneListPortMapStateDao;
import com.hs.atic.zone.model.ZoneIpStatusInfo;
import com.hs.atic.zone.model.ZoneListIpInfo;
import com.hs.atic.zone.model.ZonePortMapInfo;
import com.hs.atic.zone.model.ZonePortMapStatusInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CommandPair;
import com.hs.vsm.secservice.ddos.common.FeaturePair;
import com.hs.vsm.secservice.ddos.common.ServicePair;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceStatusDao;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneServiceStatusInfo;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.ddos.service.function.deploy.ZoneDeployData;
import com.hs.vsm.secservice.sdk.common.util.CrcUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.common.ZonePair;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyServiceSimple;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyCustomService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdateDeployStatusTools {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private IZonePolicyApplyServiceSimple zonePolicyService;
    private IZoneServiceService zoneService;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private ZoneServiceStatusDao zoneServiceStatusDao;
    private IZonePolicyCustomService zonePolicyCustomService;
    private AticDeviceDao aticDeviceDao;
    private IAticDeviceService aticDeviceService;
    private ZoneListIpDao zoneListIpDao;
    private ZoneListPortMapDao zoneListPortMapDao;
    private ZoneListPortMapStateDao zoneListPortMapStateDao;
    private ZoneIpDao zoneIpDao;
    private ZoneIpStatusDao zoneIpStatusDao;

    public void updateDeployStatus(ZoneDeployData deployData) {
        this.logger.info((Object)"enter updateDeployStatus");
        for (Map.Entry<Long, List<Long>> entry : deployData.getZoneConfigData().getZoneID2DeviceIdsMapToDeploy().entrySet()) {
            Long zoneId = entry.getKey();
            int zoneDeployOkDevice = 0;
            for (Long deviceId : entry.getValue()) {
                ZonePolicyApplyForm zonePolicyApplyForm;
                ZonePair pair = new ZonePair(deviceId, zoneId);
                if (deployData.getResult().getZoneDeployResult().containsKey(pair) && deployData.getResult().getZoneDeployResult().get(pair).booleanValue()) {
                    ++zoneDeployOkDevice;
                    continue;
                }
                AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(deviceId.longValue());
                if (aticDevice.getDeviceType() != 8 || null == (zonePolicyApplyForm = this.zonePolicyService.queryByZoneId(zoneId)) || !zonePolicyApplyForm.getDeployState().equals("SUCCESS")) continue;
                ++zoneDeployOkDevice;
            }
            if (zoneDeployOkDevice == entry.getValue().size()) {
                deployData.getResult().getDeployResult().put(zoneId, "SUCCESS");
                continue;
            }
            deployData.getResult().getDeployResult().put(zoneId, "PART_SUCCESS");
        }
        for (Map.Entry<Object, List<Serializable>> entry : deployData.getZoneConfigData().getServicePair2FeaturePair().entrySet()) {
            int deployOkFeatures = 0;
            for (FeaturePair featurePair : entry.getValue()) {
                if (!deployData.getResult().getFeatureDeployResult().containsKey(featurePair) || !deployData.getResult().getFeatureDeployResult().get(featurePair).booleanValue()) continue;
                ++deployOkFeatures;
            }
            if (deployOkFeatures == entry.getValue().size()) {
                deployData.getResult().getZoneServiceDeployResult().put((ServicePair)entry.getKey(), true);
                continue;
            }
            deployData.getResult().getZoneServiceDeployResult().put((ServicePair)entry.getKey(), false);
        }
        this.saveDeployStatus(deployData);
        this.logger.info((Object)"leave updateDeployStatus");
    }

    private void saveDeployStatus(ZoneDeployData deployData) {
        this.logger.info((Object)"enter saveDeployStatus");
        this.saveZonePolicyStatus(deployData);
        Util.getInstance().processNext(deployData);
        this.saveServicePolicyStatus(deployData);
        Util.getInstance().processNext(deployData);
        this.saveServiceStatus(deployData);
        Util.getInstance().processNext(deployData);
        this.saveZoneDeviceStatus(deployData);
        Util.getInstance().processNext(deployData);
        this.saveZoneFeatureStatus(deployData);
        this.deleteServiceStatusInfoUndeployed(deployData);
        Util.getInstance().processNext(deployData);
        this.logger.info((Object)"leave saveDeployStatus");
    }

    private void saveZonePolicyStatus(ZoneDeployData deployData) {
        this.logger.info((Object)"enter saveZonePolicyStatus");
        Map<Long, String> deployResult = deployData.getResult().getDeployResult();
        HashMap<Long, ZonePolicyApplyForm> zonePolicyMap = new HashMap<Long, ZonePolicyApplyForm>();
        List<Long> zoneIds = deployData.getZoneIdList();
        List<ZonePolicyApplyForm> policyForms = this.zonePolicyService.queryByZoneIds(zoneIds);
        for (ZonePolicyApplyForm zonePolicyApplyForm : policyForms) {
            String state = this.zonePolicyCustomService.getZoneStateByZoneID(zonePolicyApplyForm.getZoneId());
            zonePolicyApplyForm.setAbnormalState(state);
            zonePolicyMap.put(zonePolicyApplyForm.getZoneId(), zonePolicyApplyForm);
        }
        deployData.getZoneConfigData().setZoneBasicInfoMap(zonePolicyMap);
        Map<Long, Long> zoneId2CrcMap = deployData.getZoneConfigData().getZoneId2CrcToDeployMap();
        for (Map.Entry<Long, String> result : deployResult.entrySet()) {
            if ("SUCCESS".equals(result.getValue())) {
                ((ZonePolicyApplyForm)zonePolicyMap.get(result.getKey())).setDefendState(Constant.ALL_DEVICE_DEFENDMODE_DEPLOY_SUCCESS);
            } else {
                ((ZonePolicyApplyForm)zonePolicyMap.get(result.getKey())).setDefendState(Constant.HAS_DEVICE_DEFENDMODE_DEPLOY_FAILED);
            }
            ((ZonePolicyApplyForm)zonePolicyMap.get(result.getKey())).setDeployedCrc(zoneId2CrcMap.get(result.getKey()));
            ((ZonePolicyApplyForm)zonePolicyMap.get(result.getKey())).setDeployState(result.getValue());
            this.zonePolicyService.update(zonePolicyMap.get(result.getKey()));
        }
        this.logger.info((Object)"leave saveZonePolicyStatus");
    }

    private void saveServicePolicyStatus(ZoneDeployData deployData) {
        this.logger.info((Object)"enter saveServicePolicyStatus");
        Map<Long, Long> serviceId2Crc = deployData.getZoneConfigData().getServiceId2CrcToDeployMap();
        for (Map.Entry<Long, ZoneServiceForm> serviceMap : deployData.getZoneConfigData().getZoneServiceMap().entrySet()) {
            Long deployedCrc;
            Long deviceId = serviceMap.getValue().getDeviceId();
            AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(deviceId.longValue());
            if (aticDevice.getDeviceType() == 8 && aticDevice.getDeviceType() == 9 || null == (deployedCrc = serviceId2Crc.get(serviceMap.getKey()))) continue;
            ZoneServiceForm form = serviceMap.getValue();
            form.setDeployedCrc(deployedCrc);
            ServicePair servicePair = new ServicePair(serviceMap.getValue().getZoneId(), serviceMap.getValue().getDeviceId(), serviceMap.getKey());
            Boolean deployState = deployData.getResult().getZoneServiceDeployResult().get(servicePair);
            if (null != deployState) {
                form.setDeployState(deployState);
            }
            this.zoneService.updateServiceBasicInfo(form);
        }
        this.logger.info((Object)"leave saveServicePolicyStatus");
    }

    private void saveServiceStatus(ZoneDeployData deployData) {
        this.logger.info((Object)"enter saveServiceStatus");
        Map<ServicePair, ZoneServiceStatusInfo> serviceStatus = deployData.getZoneConfigData().getZoneServiceStatusMap();
        Map<Long, Long> serviceId2CrcToDeployMap = deployData.getZoneConfigData().getServiceId2CrcToDeployMap();
        for (Map.Entry<ServicePair, Boolean> serviceResult : deployData.getResult().getZoneServiceDeployResult().entrySet()) {
            ZoneServiceStatusInfo info = null;
            ZoneServiceForm serviceForm = deployData.getZoneConfigData().getZoneServiceMap().get(serviceResult.getKey().getServiceId());
            if (serviceStatus.containsKey(serviceResult.getKey())) {
                info = serviceStatus.get(serviceResult.getKey());
                info.setServiceName(serviceForm.getServiceName());
            } else {
                info = new ZoneServiceStatusInfo();
                Long serviceId = serviceResult.getKey().getServiceId();
                info.setZoneId(serviceResult.getKey().getZoneId());
                info.setServiceId(serviceId);
                info.setDeviceId(serviceResult.getKey().getDeviceId());
                info.setServiceName(serviceForm.getServiceName());
                info.setServiceType(serviceForm.getServiceType());
                info.setProtocol(serviceForm.getProtocol());
            }
            info.setDeployCrc(serviceId2CrcToDeployMap.get(serviceResult.getKey().getServiceId()));
            info.setDeployState(serviceResult.getValue());
            info.setDeployTime(new Date());
            this.zoneServiceStatusDao.save(info);
        }
        this.logger.info((Object)"leave saveServiceStatus");
    }

    private void saveZoneDeviceStatus(ZoneDeployData deployData) {
        this.logger.info((Object)"enter saveZoneDeviceStatus");
        Map<ZonePair, String> errorDetail = deployData.getResult().getErrorDetail();
        Map<ZonePair, String> errorParams = deployData.getResult().getErrorParams();
        for (Map.Entry<ZonePair, Boolean> entry : deployData.getResult().getZoneDeployResult().entrySet()) {
            String errorMsgKey = errorDetail.get(entry.getKey());
            if (null == errorMsgKey) {
                errorMsgKey = "--";
            }
            ZoneDeviceDeployStatusInfo info = null;
            long zoneId = entry.getKey().getZoneId();
            long deviceId = entry.getKey().getDeviceId();
            List<ZoneDeviceDeployStatusInfo> statutList = this.zoneDeviceDeployStatusDao.queryByZoneId(zoneId);
            if (null != statutList && !statutList.isEmpty()) {
                for (ZoneDeviceDeployStatusInfo each : statutList) {
                    if (null == each || 1 != each.getDeployType() || deviceId != each.getDeviceId()) continue;
                    info = each;
                    break;
                }
            }
            if (null == info) {
                info = new ZoneDeviceDeployStatusInfo();
                info.setZoneId(entry.getKey().getZoneId());
                info.setDeviceId(entry.getKey().getDeviceId());
            }
            info.setDeployType(1);
            info.setDeployState(entry.getValue());
            info.setDeployTime(new Date());
            info.setErrorMsgKey(errorMsgKey);
            info.setHasChange(false);
            info.setErrorParam(errorParams.get(entry.getKey()));
            this.zoneDeviceDeployStatusDao.save(info);
        }
        for (Map.Entry<Object, Boolean> entry : deployData.getResult().getCommandDeployResult().entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            this.updateCommandResult(entry);
        }
        for (Map.Entry<Object, Boolean> entry : deployData.getResult().getCommandDeployResult().entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            this.updateCommandResult(entry);
        }
        List<Long> zoneIdList = deployData.getZoneIdList();
        for (Long zoneId : zoneIdList) {
            ZoneInfoForm zoneInfoForm = deployData.getZoneConfigData().getZoneInfoMap().get(zoneId);
            this.deleteDeployedIpList(zoneInfoForm);
            this.deletDeoloydPortMapList(zoneId);
        }
        this.logger.info((Object)"leave saveZoneDeviceStatus");
    }

    private void updateCommandResult(Map.Entry<CommandPair, Boolean> ipResult) {
        if (ZoneListIpInfo.class.getSimpleName().equals(ipResult.getKey().getCommandType())) {
            this.zoneListIpDao.updateDeployStateById(ipResult.getKey().getCommandId(), ipResult.getValue());
            this.updateZoneIpStatusInfo(ipResult);
        } else if (ZonePortMapInfo.class.getSimpleName().equals(ipResult.getKey().getCommandType())) {
            this.zoneListPortMapDao.updateDeployStateById(ipResult.getKey().getCommandId(), ipResult.getValue());
            this.saveZonePortMapStatusInfo(ipResult);
        }
    }

    private void updateZoneIpStatusInfo(Map.Entry<CommandPair, Boolean> ipResult) {
        CommandPair commandPair = ipResult.getKey();
        Long deviceId = commandPair.getDeviceId();
        Long pkId = commandPair.getCommandId();
        boolean deployState = ipResult.getValue();
        List<ZoneIpStatusInfo> zoneIpStatusInfoList = this.zoneIpStatusDao.findByIpIdAndDeviceId(pkId, deviceId);
        ZoneIpStatusInfo zoneIpStatusInfo = null;
        if (zoneIpStatusInfoList.isEmpty()) {
            zoneIpStatusInfo = new ZoneIpStatusInfo();
            zoneIpStatusInfo.setDeviceId(deviceId);
            zoneIpStatusInfo.setIpId(pkId);
            zoneIpStatusInfo.setDeployState(deployState);
        } else {
            zoneIpStatusInfo = zoneIpStatusInfoList.get(0);
            zoneIpStatusInfo.setDeployState(deployState);
        }
        this.zoneIpStatusDao.saveOrUpdate(zoneIpStatusInfo);
    }

    private void saveZonePortMapStatusInfo(Map.Entry<CommandPair, Boolean> ipResult) {
        CommandPair commandPair = ipResult.getKey();
        Long deviceId = commandPair.getDeviceId();
        Long portMapId = commandPair.getCommandId();
        boolean deployState = ipResult.getValue();
        List<ZonePortMapStatusInfo> zoneIpStatusInfoList = this.zoneListPortMapStateDao.findByIdAndDeviceId(portMapId, deviceId);
        ZonePortMapStatusInfo zonePortMapStatusInfo = null;
        if (zoneIpStatusInfoList.isEmpty()) {
            zonePortMapStatusInfo = new ZonePortMapStatusInfo();
            zonePortMapStatusInfo.setPortMapId(portMapId);
            zonePortMapStatusInfo.setDeviceId(deviceId);
            zonePortMapStatusInfo.setDeployState(deployState);
        } else {
            zonePortMapStatusInfo = zoneIpStatusInfoList.get(0);
            zonePortMapStatusInfo.setDeployState(deployState);
        }
        this.zoneListPortMapStateDao.saveOrUpdate(zonePortMapStatusInfo);
    }

    private boolean isZoneUndoByUndoIpFormList(ZoneInfoForm zoneInfoForm, ZoneIpForm zoneIpForm) {
        boolean isUndo = false;
        for (ZoneUndoIpForm zoneUndoIpForm : zoneInfoForm.getZoneUndoIpFromList()) {
            String[] subnetRange = IPUtil.getSubnetRange((String)zoneUndoIpForm.getZoneIp(), (int)zoneUndoIpForm.getMask());
            if (subnetRange[0].equals(zoneIpForm.getStartIp()) && subnetRange[1].equals(zoneIpForm.getEndIp())) {
                isUndo = true;
                break;
            }
            if (zoneIpForm.getZoneIp().equals(zoneUndoIpForm.getZoneIp()) && zoneIpForm.getMask().equals(zoneUndoIpForm.getMask())) {
                isUndo = true;
                break;
            }
            isUndo = false;
        }
        return isUndo;
    }

    private Set<Long> getDeletePkIdByUndoIpFormList(ZoneInfoForm zoneInfoForm, List<ZoneIpForm> zoneIpUndoFormList, List<ZoneIpForm> zoneIpDoFormList) {
        Long zoneId = zoneInfoForm.getZoneId();
        HashSet<Long> pkIdSet = new HashSet<Long>();
        for (ZoneIpForm zoneIpForm : zoneIpUndoFormList) {
            boolean isUndo = this.isZoneUndoByUndoIpFormList(zoneInfoForm, zoneIpForm);
            if (!isUndo || pkIdSet.contains(zoneIpForm.getPkIdList().get(0))) continue;
            boolean flag = false;
            for (ZoneIpForm zoneIpDoForm : zoneIpDoFormList) {
                if (!zoneIpDoForm.getZoneIp().equals(zoneIpForm.getZoneIp()) || !zoneIpDoForm.getMask().equals(zoneIpForm.getMask())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            this.zoneIpDao.deleteIpByIp(zoneId, zoneIpForm.getZoneIp(), zoneIpForm.getMask());
            pkIdSet.add(zoneIpForm.getPkIdList().get(0));
        }
        return pkIdSet;
    }

    private void deletezoneIpStatusInfoByUndoIpFormList(ZoneInfoForm zoneInfoForm, Set<Long> pkIdSet, List<ZoneListIpInfo> zoneListIpUndoInfo) {
        ArrayList<Long> ipIds = new ArrayList<Long>();
        for (ZoneListIpInfo zoneListIpInfo : zoneListIpUndoInfo) {
            if (pkIdSet.contains(zoneListIpInfo.getId())) {
                ipIds.add(zoneListIpInfo.getId());
                continue;
            }
            boolean isUndo = this.isUndoByUndoIpFromList(zoneInfoForm, zoneListIpInfo);
            if (!isUndo) continue;
            ipIds.add(zoneListIpInfo.getId());
        }
        if (!ipIds.isEmpty()) {
            this.zoneIpStatusDao.deleteIpByPkIds(ipIds);
        }
    }

    private boolean isUndoByUndoIpFromList(ZoneInfoForm zoneInfoForm, ZoneListIpInfo excludeIp) {
        boolean isUndo = false;
        for (ZoneUndoIpForm zoneUndoIpForm : zoneInfoForm.getZoneUndoIpFromList()) {
            String[] subnetRange = IPUtil.getSubnetRange((String)zoneUndoIpForm.getZoneIp(), (int)zoneUndoIpForm.getMask());
            if (subnetRange[0].equals(excludeIp.getStartIp()) && subnetRange[1].equals(excludeIp.getEndIp())) {
                isUndo = true;
                break;
            }
            if (zoneUndoIpForm.getZoneIp().equals(excludeIp.getZoneIp()) && zoneUndoIpForm.getMask().equals(excludeIp.getIntMask())) {
                isUndo = true;
                break;
            }
            isUndo = false;
        }
        return isUndo;
    }

    private void deleteZoneListIpByUndoIpFormList(Set<Long> pkIdSet, List<ZoneListIpInfo> excludeZoneIpList, List<ZoneListIpInfo> zoneListIpUndoInfo, List<ZoneListIpInfo> zoneListIpDeleteAndNotDeployInfo) {
        ArrayList<ZoneListIpInfo> deleteList = new ArrayList<ZoneListIpInfo>();
        if (null != excludeZoneIpList) {
            deleteList.addAll(excludeZoneIpList);
            deleteList.addAll(zoneListIpDeleteAndNotDeployInfo);
            for (ZoneListIpInfo zoneListIpInfo : zoneListIpUndoInfo) {
                if (!pkIdSet.contains(zoneListIpInfo.getId())) continue;
                deleteList.add(zoneListIpInfo);
            }
        }
        this.zoneListIpDao.deleteAll(deleteList);
    }

    private void deleteDeployedIpList(ZoneInfoForm zoneInfoForm) {
        Long zoneId = zoneInfoForm.getZoneId();
        List<ZoneListIpInfo> zoneListIpUndoInfo = this.zoneListIpDao.getIpInitUndoDataByZoneId(zoneId);
        List<ZoneListIpInfo> zoneListIpDoInfo = this.zoneListIpDao.getByZoneIdAndFlag(zoneId);
        List<ZoneListIpInfo> excludeZoneIpList = this.zoneListIpDao.getByExcludeIpAndDeleteFlag(zoneId);
        List<ZoneIpForm> zoneIpUndoFormList = this.splitZoneIp(zoneListIpUndoInfo);
        List<ZoneIpForm> zoneIpDoFormList = this.splitZoneIp(zoneListIpDoInfo);
        Set<Long> pkIdSet = this.getDeletePkIdByUndoIpFormList(zoneInfoForm, zoneIpUndoFormList, zoneIpDoFormList);
        this.deletezoneIpStatusInfoByUndoIpFormList(zoneInfoForm, pkIdSet, zoneListIpUndoInfo);
        List<ZoneListIpInfo> zoneListIpDeleteAndNotDeployInfo = this.zoneListIpDao.getDeletedAndUndeployedZoneIpList(zoneId);
        this.deleteZoneListIpByUndoIpFormList(pkIdSet, excludeZoneIpList, zoneListIpUndoInfo, zoneListIpDeleteAndNotDeployInfo);
    }

    private void deletDeoloydPortMapList(Long zoneId) {
        List<ZonePortMapInfo> zonePortMapInfos = this.zoneListPortMapDao.getByZoneIdAndFlag(zoneId);
        ArrayList<Long> ipIds = new ArrayList<Long>();
        for (ZonePortMapInfo zonePortMapInfo : zonePortMapInfos) {
            ipIds.add(zonePortMapInfo.getId());
        }
        if (!ipIds.isEmpty()) {
            this.zoneListPortMapStateDao.deleteIpByPortMapIds(ipIds);
        }
        this.zoneListPortMapDao.deleteAll(zonePortMapInfos);
    }

    private List<ZoneIpForm> splitZoneIp(List<ZoneListIpInfo> zoneListIpInfos) {
        ArrayList<ZoneIpForm> ipFormList = new ArrayList<ZoneIpForm>();
        for (ZoneListIpInfo zoneListIpInfo : zoneListIpInfos) {
            String[] networkSegment;
            ZoneIpForm zoneIpForm;
            int maskType = zoneListIpInfo.getMaskType();
            ArrayList<Long> pkIdList = new ArrayList<Long>();
            Long pkId = zoneListIpInfo.getId();
            pkIdList.add(pkId);
            if (maskType == 0) {
                zoneIpForm = new ZoneIpForm();
                String[] srcIpRange = IPUtil.getSubnetRange((String)zoneListIpInfo.getZoneIp(), (int)zoneListIpInfo.getIntMask());
                zoneIpForm.setZoneIp(srcIpRange[0]);
                zoneIpForm.setMask(zoneListIpInfo.getIntMask());
                zoneIpForm.setStartIp(zoneListIpInfo.getStartIp());
                zoneIpForm.setEndIp(zoneListIpInfo.getEndIp());
                zoneIpForm.setPkIdList(pkIdList);
                ipFormList.add(zoneIpForm);
                continue;
            }
            if (maskType != 1) continue;
            for (String ipAdress : networkSegment = IPUtil.getNetworkSegment((String)zoneListIpInfo.getStartIp(), (String)zoneListIpInfo.getEndIp())) {
                zoneIpForm = new ZoneIpForm();
                String[] ipStrings = ipAdress.split("/");
                zoneIpForm.setZoneIp(ipStrings[0]);
                zoneIpForm.setMask(Integer.valueOf(ipStrings[1]));
                zoneIpForm.setPkIdList(pkIdList);
                ipFormList.add(zoneIpForm);
            }
        }
        return ipFormList;
    }

    private void saveZoneFeatureStatus(ZoneDeployData deployData) {
        this.logger.info((Object)"enter saveZoneFeatureStatus");
        Map<FeaturePair, ZoneFeatureStatusInfo> zoneFeatureStatusMap = deployData.getZoneConfigData().getZoneFeatureStatusMap();
        for (Map.Entry<FeaturePair, Boolean> featureResult : deployData.getResult().getFeatureDeployResult().entrySet()) {
            Long deployCrc;
            ZoneFeatureStatusInfo info = null;
            if (zoneFeatureStatusMap.containsKey(featureResult.getKey())) {
                info = zoneFeatureStatusMap.get(featureResult.getKey());
            } else {
                info = new ZoneFeatureStatusInfo();
                info.setZoneId(featureResult.getKey().getZoneId());
                info.setDeviceId(featureResult.getKey().getDeviceId());
                info.setFeatureId(featureResult.getKey().getFeatureId());
                info.setFeatureType(featureResult.getKey().getFeatureType());
                if (!featureResult.getValue().booleanValue()) {
                    info.setDefendMode(Constant.DEFENDMODE_DEFEND_AUTO);
                }
            }
            info.setDeployState(featureResult.getValue());
            if (featureResult.getValue().booleanValue()) {
                ZonePolicyApplyForm form = deployData.getZoneConfigData().getZoneBasicInfoMap().get(featureResult.getKey().getZoneId());
                info.setDefendMode(form.getDefendMode());
            }
            if (null == (deployCrc = deployData.getZoneConfigData().getZoneFeature2CrcMap().get(featureResult.getKey()))) {
                deployCrc = CrcUtil.getCrcValue("0");
            }
            info.setDeployCrc(deployCrc);
            this.zoneFeatureStatusDao.save(info);
        }
        this.logger.info((Object)"leave saveZoneFeatureStatus");
    }

    private void deleteServiceStatusInfoUndeployed(ZoneDeployData deployData) {
        this.logger.info((Object)"enter deleteServiceStatusInfoUndeployed");
        Map<ServicePair, ZoneServiceForm> serviceToUndeploy = deployData.getZoneConfigData().getZoneServiceToUndeploy();
        for (Map.Entry<ServicePair, ZoneServiceForm> entry : serviceToUndeploy.entrySet()) {
            ServicePair servicePair = entry.getKey();
            FeaturePair featurePair = new FeaturePair(servicePair.getZoneId(), servicePair.getDeviceId(), "ZoneServiceToUndeploy", servicePair.getServiceId());
            if (!deployData.getResult().getFeatureDeployResult().containsKey(featurePair) || !deployData.getResult().getFeatureDeployResult().get(featurePair).booleanValue()) continue;
            HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
            condition.put(0, servicePair.getServiceId());
            List serviceStatusInfos = this.zoneServiceStatusDao.queryByHql("from ZoneServiceStatusInfo where serviceId = ?0 ", condition);
            if (null == serviceStatusInfos || serviceStatusInfos.isEmpty()) continue;
            ZoneServiceStatusInfo zoneServiceStatus = (ZoneServiceStatusInfo)serviceStatusInfos.get(0);
            this.zoneServiceStatusDao.deleteByDeviceIdAndZoneIdAndServiceId(zoneServiceStatus.getDeviceId(), zoneServiceStatus.getZoneId(), zoneServiceStatus.getServiceId());
            this.zoneFeatureStatusDao.deleteByDeviceIdAndZoneIdAndFeatureId(zoneServiceStatus.getDeviceId(), zoneServiceStatus.getZoneId(), zoneServiceStatus.getServiceId(), ZoneServiceForm.class.getSimpleName());
        }
        this.logger.info((Object)"leave deleteServiceStatusInfoUndeployed");
    }

    public AticDeviceDao getAticDeviceDao() {
        return this.aticDeviceDao;
    }

    public void setAticDeviceDao(AticDeviceDao aticDeviceDao) {
        this.aticDeviceDao = aticDeviceDao;
    }

    public IZonePolicyCustomService getZonePolicyCustomService() {
        return this.zonePolicyCustomService;
    }

    public void setZonePolicyCustomService(IZonePolicyCustomService zonePolicyCustomService) {
        this.zonePolicyCustomService = zonePolicyCustomService;
    }

    public IZonePolicyApplyServiceSimple getZonePolicyService() {
        return this.zonePolicyService;
    }

    public void setZonePolicyService(IZonePolicyApplyServiceSimple zonePolicyService) {
        this.zonePolicyService = zonePolicyService;
    }

    public IZoneServiceService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneServiceService zoneService) {
        this.zoneService = zoneService;
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public ZoneServiceStatusDao getZoneServiceStatusDao() {
        return this.zoneServiceStatusDao;
    }

    public void setZoneServiceStatusDao(ZoneServiceStatusDao zoneServiceStatusDao) {
        this.zoneServiceStatusDao = zoneServiceStatusDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public ZoneListIpDao getZoneListIpDao() {
        return this.zoneListIpDao;
    }

    public void setZoneListIpDao(ZoneListIpDao zoneListIpDao) {
        this.zoneListIpDao = zoneListIpDao;
    }

    public ZoneIpDao getZoneIpDao() {
        return this.zoneIpDao;
    }

    public void setZoneIpDao(ZoneIpDao zoneIpDao) {
        this.zoneIpDao = zoneIpDao;
    }

    public ZoneListPortMapDao getZoneListPortMapDao() {
        return this.zoneListPortMapDao;
    }

    public void setZoneListPortMapDao(ZoneListPortMapDao zoneListPortMapDao) {
        this.zoneListPortMapDao = zoneListPortMapDao;
    }

    public ZoneListPortMapStateDao getZoneListPortMapStateDao() {
        return this.zoneListPortMapStateDao;
    }

    public void setZoneListPortMapStateDao(ZoneListPortMapStateDao zoneListPortMapStateDao) {
        this.zoneListPortMapStateDao = zoneListPortMapStateDao;
    }

    public ZoneIpStatusDao getZoneIpStatusDao() {
        return this.zoneIpStatusDao;
    }

    public void setZoneIpStatusDao(ZoneIpStatusDao zoneIpStatusDao) {
        this.zoneIpStatusDao = zoneIpStatusDao;
    }
}

