/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.form.ZonePortMapForm;
import com.hs.atic.sdk.zone.form.ZoneUndoIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.common.FeaturePair;
import com.hs.vsm.secservice.ddos.common.ServicePair;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneServiceStatusInfo;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.service.data.ZoneConfigData;
import com.hs.vsm.secservice.ddos.service.data.feature.HelloFeature;
import com.hs.vsm.secservice.ddos.service.data.feature.ServiceDnsDefendData;
import com.hs.vsm.secservice.ddos.service.data.feature.ServiceHttpDefendData;
import com.hs.vsm.secservice.ddos.service.data.feature.ServiceHttpsDefendData;
import com.hs.vsm.secservice.ddos.service.data.feature.ServiceIcmpDefendData;
import com.hs.vsm.secservice.ddos.service.data.feature.ServiceIpInfo;
import com.hs.vsm.secservice.ddos.service.data.feature.ServiceNfaDefendData;
import com.hs.vsm.secservice.ddos.service.data.feature.ServiceOtherDefendData;
import com.hs.vsm.secservice.ddos.service.data.feature.ServiceSipDefendData;
import com.hs.vsm.secservice.ddos.service.data.feature.ServiceTcpDefendData;
import com.hs.vsm.secservice.ddos.service.data.feature.ServiceUdpDefendData;
import com.hs.vsm.secservice.ddos.service.data.feature.TopnStudyDefendData;
import com.hs.vsm.secservice.ddos.service.data.feature.UndeployServiceData;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneBasicPolicyInfo;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneBlackWhiteListData;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneDefendModeData;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneDefineInfo;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneIpInfo;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneIpLocationData;
import com.hs.vsm.secservice.ddos.service.data.feature.ZonePortMapData;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneServiceBasicInfo;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneServiceToUndeploy;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneWhiteListData;
import com.hs.vsm.secservice.nfa.util.NfaPolicyUtil;
import com.hs.vsm.secservice.sdk.common.util.CrcUtil;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.common.ZonePair;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.IcmpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.OtherDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SipDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TopNStudyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.UdpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneModifyDetailForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneWhiteForm;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZoneToDeployData {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Map<LogicDev, Map<Long, List<IFeature>>> toDeployData = new HashMap<LogicDev, Map<Long, List<IFeature>>>();
    private ZoneConfigData zoneConfigData;
    private Map<String, String> requestMap = new HashMap<String, String>();

    public void initToDeployData(ZoneConfigData zoneConfigDatas, List<String> features, List<String> zoneIp) {
        this.zoneConfigData = zoneConfigDatas;
        this.calcZoneConfigCrc(features, zoneIp);
        this.calcFeatureCrc(features, zoneIp);
        this.initData(features, zoneIp);
    }

    private void calcFeatureCrc(List<String> features, List<String> zoneIp) {
        this.calcFeatureCrcOfZoneInfo();
        this.calcFeatureCrcOfZoneBasicPolicy();
        this.calcFeatureCrcOfZoneDefendMode();
        if (null != features && features.contains(Constant.Feature.ZoneIpInfo.toString())) {
            this.incrementCalcFeatureCrcOfZoneIpInfo(zoneIp);
        } else {
            this.calcFeatureCrcOfZoneIpInfo();
            this.calcFeatureCrcOfZonePortMapInfo();
            this.calcFeatureCrcOfZoneBasicPolicyTab();
            this.calcFeatureCrcOfZoneFilter();
            this.calcFeatureCrcOfZoneService(features);
            if (this.isContainsFeature(features, Constant.Feature.ZoneIpLocationData.toString()).booleanValue()) {
                this.calcFeatureCrcOfZoneIpLocation();
            }
            this.calcFeatureCrcOfZoneBlackList();
            this.calcFeatureCrcOfZoneWhiteList();
        }
    }

    private void calcFeatureCrcOfZoneBlackList() {
        Map<Long, ZonePolicyApplyForm> zoneBasicInfoMap = this.zoneConfigData.getZoneBasicInfoMap();
        if (null == zoneBasicInfoMap) {
            return;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZonePolicyApplyForm> oneZonePolicy : zoneBasicInfoMap.entrySet()) {
            Long zoneId = oneZonePolicy.getKey();
            List<Long> devices = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
            if (null == oneZonePolicy.getValue()) {
                return;
            }
            Long crc = this.calcZoneBlackListCrc(oneZonePolicy.getValue());
            if (null == devices) continue;
            for (Long deviceId : devices) {
                AticDevice aticDevice = ZoneReferUtil.getFirewallService().getDeviceByMoid(deviceId.longValue());
                if (aticDevice.getDeviceType() == 8) continue;
                FeaturePair pair = new FeaturePair(zoneId, deviceId, ZoneBlackWhiteForm.class.getSimpleName(), zoneId);
                zoneFeature2CrcMap.put(pair, crc);
            }
        }
    }

    private void calcFeatureCrcOfZoneWhiteList() {
        Map<Long, ZonePolicyApplyForm> zoneBasicInfoMap = this.zoneConfigData.getZoneBasicInfoMap();
        if (null == zoneBasicInfoMap) {
            return;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZonePolicyApplyForm> oneZonePolicy : zoneBasicInfoMap.entrySet()) {
            Long zoneId = oneZonePolicy.getKey();
            List<Long> devices = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
            if (null == oneZonePolicy.getValue()) {
                return;
            }
            Long crc = this.calcZoneWhiteListCrc(oneZonePolicy.getValue());
            if (null == devices) continue;
            for (Long deviceId : devices) {
                AticDevice aticDevice = ZoneReferUtil.getFirewallService().getDeviceByMoid(deviceId.longValue());
                if (aticDevice.getDeviceType() == 8) continue;
                FeaturePair pair = new FeaturePair(zoneId, deviceId, ZoneWhiteForm.class.getSimpleName(), zoneId);
                zoneFeature2CrcMap.put(pair, crc);
            }
        }
    }

    private void calcFeatureCrcOfZoneIpLocation() {
        Map<Long, ZonePolicyApplyForm> zoneBasicInfoMap = this.zoneConfigData.getZoneBasicInfoMap();
        if (null == zoneBasicInfoMap) {
            return;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZonePolicyApplyForm> oneZonePolicy : zoneBasicInfoMap.entrySet()) {
            Long zoneId = oneZonePolicy.getKey();
            List<Long> devices = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
            if (null == oneZonePolicy.getValue()) {
                return;
            }
            Long crc = this.calcZoneIpLocationCrc(oneZonePolicy.getValue());
            if (null == devices) continue;
            for (Long deviceId : devices) {
                AticDevice aticDevice = ZoneReferUtil.getFirewallService().getDeviceByMoid(deviceId.longValue());
                if (aticDevice.getDeviceType() == 8) continue;
                FeaturePair pair = new FeaturePair(zoneId, deviceId, ZoneIpLocationForm.class.getSimpleName(), zoneId);
                zoneFeature2CrcMap.put(pair, crc);
            }
        }
    }

    private void calcFeatureCrcOfZoneFilter() {
        Map<Long, ZonePolicyApplyForm> zoneBasicInfoMap = this.zoneConfigData.getZoneBasicInfoMap();
        if (null == zoneBasicInfoMap) {
            return;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZonePolicyApplyForm> oneZonePolicy : zoneBasicInfoMap.entrySet()) {
            Long zoneId = oneZonePolicy.getKey();
            List<Long> devices = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
            if (null == oneZonePolicy.getValue()) {
                return;
            }
            Long crc = this.calcZoneFilterCrc(oneZonePolicy.getValue());
            if (null == devices) continue;
            for (Long deviceId : devices) {
                FeaturePair pair = new FeaturePair(zoneId, deviceId, FilterForm.class.getSimpleName(), zoneId);
                zoneFeature2CrcMap.put(pair, crc);
            }
        }
    }

    private void calcFeatureCrcOfZoneBasicPolicyTab() {
        Map<Long, ZonePolicyApplyForm> zoneBasicInfoMap = this.zoneConfigData.getZoneBasicInfoMap();
        if (null == zoneBasicInfoMap) {
            return;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZonePolicyApplyForm> policy : zoneBasicInfoMap.entrySet()) {
            Long zoneId = policy.getKey();
            List<Long> devices = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
            Long crc = CrcUtil.getCrcValue(policy.getValue().getCrcStringOfBasicPolicyTab());
            if (null == devices) continue;
            for (Long deviceId : devices) {
                FeaturePair pair = new FeaturePair(zoneId, deviceId, policy.getValue().getClass().getSimpleName(), zoneId);
                zoneFeature2CrcMap.put(pair, crc);
            }
        }
    }

    private void calcFeatureCrcOfZoneDefendMode() {
        Map<Long, ZonePolicyApplyForm> zoneBasicInfoMap = this.zoneConfigData.getZoneBasicInfoMap();
        if (null == zoneBasicInfoMap) {
            return;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZonePolicyApplyForm> policy : zoneBasicInfoMap.entrySet()) {
            Long zoneId = policy.getKey();
            List<Long> devices = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
            Long crc = CrcUtil.getCrcValue(policy.getValue().getZoneDefendModeCrcString());
            if (null == devices) continue;
            for (Long deviceId : devices) {
                AticDevice aticDevice = ZoneReferUtil.getFirewallService().getDeviceByMoid(deviceId.longValue());
                if (aticDevice.getDeviceType() == 8) continue;
                FeaturePair pair = new FeaturePair(zoneId, deviceId, "ZoneDefendModeFeature", zoneId);
                zoneFeature2CrcMap.put(pair, crc);
            }
        }
    }

    private void calcFeatureCrcOfServiceIpInfo(Long zoneId, Long deviceId, ZoneServiceForm serviceForm) {
        DeviceTypeInfo devTypeInfo;
        AticDevice aticDevice = ZoneReferUtil.getFirewallService().getDeviceByMoid(deviceId.longValue());
        if (aticDevice.getDeviceType() == 8) {
            return;
        }
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo = CmdUtil.getDevTypeInfo(deviceId));
        Boolean isSupportPortService = supportAttrs.contains("isSupportPortService");
        if (isSupportPortService.booleanValue() && !"DEFAULT".equals(serviceForm.getProtocol())) {
            FeaturePair ipAndPortPair = new FeaturePair(zoneId, deviceId, "ServiceIpForm", serviceForm.getPkid());
            Long ipAndPortcrc = CrcUtil.getCrcValue(serviceForm.getCrcStringOfServiceIpInfo());
            this.zoneConfigData.getZoneFeature2CrcMap().put(ipAndPortPair, ipAndPortcrc);
        }
    }

    private Long incrementCalcFeatureCrcOfZoneIpInfo(List<String> zoneIp) {
        Long crc = CrcUtil.getCrcValue(String.valueOf(0));
        Map<Long, ZoneInfoForm> zoneInfoMap = this.zoneConfigData.getZoneInfoMap();
        if (null == zoneInfoMap) {
            return crc;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZoneInfoForm> form : zoneInfoMap.entrySet()) {
            Long zoneId = form.getKey();
            List<ZoneListIpForm> zoneListIpFormList = this.getZoneListIpFormList(zoneId);
            List<ZoneIpForm> zoneIpFormList = this.getZoneIpFormList(zoneId);
            for (ZoneListIpForm zoneListIpForm : zoneListIpFormList) {
                boolean isDelete = true;
                Iterator<ZoneIpForm> iterator = zoneIpFormList.iterator();
                while (iterator.hasNext()) {
                    String[] subnetRange2;
                    ZoneIpForm next = iterator.next();
                    String[] subnetRange = IPUtil.getSubnetRange((String)next.getZoneIp(), (int)next.getMask());
                    if (subnetRange[0].equals((subnetRange2 = IPUtil.getSubnetRange((String)zoneListIpForm.getZoneIp(), (int)zoneListIpForm.getIntMask()))[0]) && subnetRange[1].equals(subnetRange2[1])) {
                        isDelete = false;
                    }
                    if (zoneListIpForm.isDeployState() || !subnetRange[0].equals(subnetRange2[0]) || !subnetRange[1].equals(subnetRange2[1]) || null == zoneIp || zoneIp.contains(next.getZoneIp() + "/" + next.getMask())) continue;
                    iterator.remove();
                    break;
                }
                if (!isDelete) continue;
                ZoneIpForm deleteForm = new ZoneIpForm();
                deleteForm.setZoneIp(zoneListIpForm.getZoneIp());
                deleteForm.setMask(zoneListIpForm.getIntMask());
                deleteForm.setStartIp(zoneListIpForm.getStartIp());
                deleteForm.setEndIp(zoneListIpForm.getEndIp());
                zoneIpFormList.remove(deleteForm);
            }
            String crcString = this.zoneConfigData.getZoneIpCalcCrcString(zoneIpFormList);
            crc = CrcUtil.getCrcValue(crcString);
            List<Long> devices = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
            if (null == devices) continue;
            for (Long deviceId : devices) {
                FeaturePair pair = new FeaturePair(zoneId, deviceId, ZoneIpForm.class.getSimpleName(), form.getValue().getZoneId());
                zoneFeature2CrcMap.put(pair, crc);
            }
        }
        return crc;
    }

    private void calcFeatureCrcOfZoneIpInfo() {
        Map<Long, ZoneInfoForm> zoneInfoMap = this.zoneConfigData.getZoneInfoMap();
        if (null == zoneInfoMap) {
            return;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZoneInfoForm> form : zoneInfoMap.entrySet()) {
            Long zoneId = form.getKey();
            List<ZoneIpForm> zoneIpFormList = this.getZoneIpFormList(zoneId);
            String crcString = this.zoneConfigData.getZoneIpCalcCrcString(zoneIpFormList);
            Long crc = CrcUtil.getCrcValue(crcString);
            List<Long> devices = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
            if (null == devices) continue;
            for (Long deviceId : devices) {
                FeaturePair pair = new FeaturePair(zoneId, deviceId, ZoneIpForm.class.getSimpleName(), form.getValue().getZoneId());
                zoneFeature2CrcMap.put(pair, crc);
            }
        }
    }

    private void calcFeatureCrcOfZonePortMapInfo() {
        Map<Long, ZoneInfoForm> zoneInfoMap = this.zoneConfigData.getZoneInfoMap();
        if (null == zoneInfoMap) {
            return;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZoneInfoForm> form : zoneInfoMap.entrySet()) {
            Long zoneId = form.getKey();
            List<ZonePortMapForm> zonePortMapFormList = this.getZonePortMapFormList(zoneId);
            String crcString = this.zoneConfigData.getZonePortMapCalcCrcString(zonePortMapFormList);
            Long crc = CrcUtil.getCrcValue(crcString);
            List<Long> devices = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
            if (null == devices) continue;
            for (Long deviceId : devices) {
                AticDevice aticDevice = ZoneReferUtil.getFirewallService().getDeviceByMoid(deviceId.longValue());
                if (aticDevice.getDeviceType() == 8) continue;
                FeaturePair pair = new FeaturePair(zoneId, deviceId, ZonePortMapForm.class.getSimpleName(), form.getValue().getZoneId());
                zoneFeature2CrcMap.put(pair, crc);
            }
        }
    }

    private List<ZoneListIpForm> getZoneListIpFormList(Long zoneId) {
        IZoneService zoneServices = ZoneReferUtil.getZoneService();
        List<ZoneListIpForm> zoneIpFormList = null;
        zoneIpFormList = zoneServices.getListIpByZoneId(zoneId);
        return zoneIpFormList;
    }

    private List<ZoneIpForm> getZoneIpFormList(Long zoneId) {
        IZoneService zoneServices = ZoneReferUtil.getZoneService();
        List<ZoneIpForm> zoneIpFormList = null;
        zoneIpFormList = zoneServices.findIpByZoneId(zoneId);
        return zoneIpFormList;
    }

    private List<ZonePortMapForm> getZonePortMapFormList(Long zoneId) {
        IZoneService zoneServices = ZoneReferUtil.getZoneService();
        List<ZonePortMapForm> zonePortMapFormList = null;
        zonePortMapFormList = zoneServices.findPortMapByZoneId(zoneId);
        return zonePortMapFormList;
    }

    private void calcFeatureCrcOfZoneInfo() {
        Map<Long, ZoneInfoForm> zoneInfoMap = this.zoneConfigData.getZoneInfoMap();
        if (null == zoneInfoMap) {
            return;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZoneInfoForm> form : zoneInfoMap.entrySet()) {
            Long zoneId = form.getKey();
            String crcString = this.zoneConfigData.getZoneInfoCalcCrcString(form.getValue());
            Long crc = CrcUtil.getCrcValue(crcString);
            List<Long> devices = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
            if (null == devices) continue;
            for (Long deviceId : devices) {
                AticDevice aticDevice = ZoneReferUtil.getFirewallService().getDeviceByMoid(deviceId.longValue());
                if (aticDevice.getDeviceType() == 8) continue;
                FeaturePair pair = new FeaturePair(zoneId, deviceId, form.getValue().getClass().getSimpleName(), form.getValue().getZoneId());
                zoneFeature2CrcMap.put(pair, crc);
            }
        }
    }

    private void calcFeatureCrcOfZoneBasicPolicy() {
        Map<Long, ZonePolicyApplyForm> zoneBasicInfoMap = this.zoneConfigData.getZoneBasicInfoMap();
        if (null == zoneBasicInfoMap) {
            return;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZonePolicyApplyForm> policy : zoneBasicInfoMap.entrySet()) {
            Long zoneId = policy.getKey();
            List<Long> devices = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
            Long crc = CrcUtil.getCrcValue(policy.getValue().getCalcCrcWithoutDevicesString());
            if (null == devices) continue;
            for (Long deviceId : devices) {
                FeaturePair pair = new FeaturePair(zoneId, deviceId, policy.getValue().getClass().getSimpleName(), policy.getValue().getZoneId());
                zoneFeature2CrcMap.put(pair, crc);
            }
        }
    }

    private void calcFeatureCrcOfZoneService(List<String> features) {
        Map<Long, ZoneServiceForm> zoneServiceMap = this.zoneConfigData.getZoneServiceMap();
        if (null == zoneServiceMap) {
            return;
        }
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        for (Map.Entry<Long, ZoneServiceForm> zoneService : zoneServiceMap.entrySet()) {
            Long zoneId = zoneService.getValue().getZoneId();
            String calcString = zoneService.getValue().getCalcCrcStringOfBasicInfo();
            Long crc = CrcUtil.getCrcValue(calcString);
            Long deviceId = zoneService.getValue().getDeviceId();
            FeaturePair pair = new FeaturePair(zoneId, deviceId, zoneService.getValue().getClass().getSimpleName(), zoneService.getValue().getPkid());
            zoneFeature2CrcMap.put(pair, crc);
            this.calcFeatureCrcOfServiceIpInfo(zoneId, deviceId, zoneService.getValue());
            this.calcFeatureCrcOfZoneServicePolicy(zoneId, deviceId, zoneService.getValue(), features);
        }
    }

    private void calcFeatureCrcOfZoneServicePolicy(Long zoneId, Long deviceId, ZoneServiceForm zoneService, List<String> features) {
        TopNStudyForm topnForm;
        OtherDefendPolicyForm other;
        SipDefendPolicyForm sip;
        DnsDefendPolicyForm dns;
        HttpsDefendPolicyForm https;
        HttpDefendPolicyForm http;
        IcmpDefendPolicyForm icmp;
        UdpDefendPolicyForm udp;
        TcpDefendPolicyForm tcp;
        Long crc;
        FeaturePair pair;
        NfaPolicyEditForm nfa;
        Map<FeaturePair, Long> zoneFeature2CrcMap = this.zoneConfigData.getZoneFeature2CrcMap();
        String serviceProtocol = zoneService.getProtocol();
        List<String> policys = ZoneServiceForm.getService2policy().get(serviceProtocol);
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
        if (this.hasNfaFeature(policys, zoneService).booleanValue() && devTypeInfo.getDevType().contains("AntiDDoS1820-N") && null != (nfa = zoneService.getNfaPolicyEditForm())) {
            pair = new FeaturePair(zoneService.getZoneId(), zoneService.getDeviceId(), nfa.getClass().getSimpleName(), zoneService.getPkid());
            crc = CrcUtil.getCrcValue(nfa.getCalcCrcString());
            zoneFeature2CrcMap.put(pair, crc);
        }
        if (this.hasTcpFeature(policys, zoneService).booleanValue() && this.isContainsFeature(features, Constant.Feature.ServiceTcpDefendData.toString()).booleanValue() && null != (tcp = zoneService.getTcpDefendPolicyForm())) {
            pair = new FeaturePair(zoneId, deviceId, tcp.getClass().getSimpleName(), tcp.getId());
            crc = CrcUtil.getCrcValue(tcp.getCalcCrcString());
            zoneFeature2CrcMap.put(pair, crc);
        }
        if (this.hasUdpFeature(policys, zoneService).booleanValue() && this.isContainsFeature(features, Constant.Feature.ServiceUdpDefendData.toString()).booleanValue() && null != (udp = zoneService.getUdpDefendPolicyForm())) {
            pair = new FeaturePair(zoneId, deviceId, udp.getClass().getSimpleName(), udp.getId());
            crc = CrcUtil.getCrcValue(udp.getCalcCrcString());
            zoneFeature2CrcMap.put(pair, crc);
        }
        if (policys.contains("ICMP") && this.isContainsFeature(features, Constant.Feature.ServiceIcmpDefendData.toString()).booleanValue() && null != (icmp = zoneService.getIcmpDefendPolicyForm())) {
            pair = new FeaturePair(zoneId, deviceId, icmp.getClass().getSimpleName(), icmp.getId());
            crc = CrcUtil.getCrcValue(icmp.getCalcCrcString());
            zoneFeature2CrcMap.put(pair, crc);
        }
        if (this.hasHttpFeature(policys, zoneService) && this.isContainsFeature(features, Constant.Feature.ServiceHttpDefendData.toString()).booleanValue() && null != (http = zoneService.getHttpDefendPolicyForm())) {
            pair = new FeaturePair(zoneId, deviceId, http.getClass().getSimpleName(), http.getId());
            crc = CrcUtil.getCrcValue(http.getCalcCrcString());
            zoneFeature2CrcMap.put(pair, crc);
        }
        if (this.hasHttpsFeature(policys, zoneService) && this.isContainsFeature(features, Constant.Feature.ServiceHttpsDefendData.toString()).booleanValue() && null != (https = zoneService.getHttpsDefendPolicyForm())) {
            pair = new FeaturePair(zoneId, deviceId, https.getClass().getSimpleName(), https.getId());
            crc = CrcUtil.getCrcValue(https.getCalcCrcString());
            zoneFeature2CrcMap.put(pair, crc);
        }
        if (this.hasDnsFeature(policys, zoneService) && this.isContainsFeature(features, Constant.Feature.ServiceDnsDefendData.toString()).booleanValue() && null != (dns = zoneService.getDnsDefendPolicyForm())) {
            pair = new FeaturePair(zoneId, deviceId, dns.getClass().getSimpleName(), dns.getId());
            crc = CrcUtil.getCrcValue(dns.getCalcCrcString());
            zoneFeature2CrcMap.put(pair, crc);
        }
        if (this.hasSipPolicyFeature(policys, zoneService).booleanValue() && this.isContainsFeature(features, Constant.Feature.ServiceSipDefendData.toString()).booleanValue() && null != (sip = zoneService.getSipDefendPolicyForm())) {
            pair = new FeaturePair(zoneId, deviceId, sip.getClass().getSimpleName(), sip.getId());
            crc = CrcUtil.getCrcValue(sip.getCalcCrcString());
            zoneFeature2CrcMap.put(pair, crc);
        }
        if (policys.contains("Other") && this.isContainsFeature(features, Constant.Feature.ServiceOtherDefendData.toString()).booleanValue() && null != (other = zoneService.getOtherDefendPolicyForm())) {
            pair = new FeaturePair(zoneId, deviceId, other.getClass().getSimpleName(), other.getId());
            crc = CrcUtil.getCrcValue(other.getCalcCrcString());
            zoneFeature2CrcMap.put(pair, crc);
        }
        if (policys.contains("TOPNSTUDY") && this.isContainsFeature(features, Constant.Feature.TopnStudyDefendData.toString()).booleanValue() && null != (topnForm = zoneService.getTopNStudyForm())) {
            pair = new FeaturePair(zoneId, deviceId, topnForm.getClass().getSimpleName(), topnForm.getId());
            crc = CrcUtil.getCrcValue(topnForm.getCalcCrcString());
            zoneFeature2CrcMap.put(pair, crc);
        }
    }

    private Boolean isContainsFeature(List<String> features, String featureType) {
        if (null == features) {
            return true;
        }
        if (features.contains(featureType)) {
            return true;
        }
        return false;
    }

    private Boolean hasUdpFeature(List<String> policys, ZoneServiceForm zoneService) {
        if (policys.contains("UDP") && null != zoneService.getUdpDefendPolicyForm()) {
            return true;
        }
        return false;
    }

    private Boolean hasNfaFeature(List<String> policys, ZoneServiceForm zoneService) {
        if (policys.contains("NFA") && null != zoneService.getNfaPolicyEditForm()) {
            return true;
        }
        return false;
    }

    private Boolean hasTcpFeature(List<String> policys, ZoneServiceForm zoneService) {
        if (policys.contains("TCP") && null != zoneService.getTcpDefendPolicyForm()) {
            return true;
        }
        return false;
    }

    private void calcZoneConfigCrc(List<String> features, List<String> zoneIp) {
        this.calcSerivceCrc();
        ZoneInfoForm infoForm = null;
        ZonePolicyApplyForm policyForm = null;
        for (Map.Entry<Long, ZoneInfoForm> zone : this.zoneConfigData.getZoneInfoMap().entrySet()) {
            infoForm = zone.getValue();
            policyForm = this.zoneConfigData.getZoneBasicInfoMap().get(zone.getKey());
            Long zoneConfigCrc = null;
            Long zoneInfoCrc = this.calcZoneInfoCrc(infoForm);
            Long zoneIpCrc = this.calcZoneIpInfoCrc(infoForm);
            Long protMapCrc = this.calcPortMapInfoCrc(infoForm);
            Long zoneBasicPolicyCrc = this.calcZoneBasicPolicyCrc(policyForm);
            Long zoneDefendModeCrc = CrcUtil.getCrcValue(policyForm.getZoneDefendModeCrcString());
            Long zoneFilterCrc = this.calcZoneFilterCrc(policyForm);
            Long zoneIplocationCrc = this.calcZoneIpLocationCrc(policyForm);
            Long zoneBlackListCrc = this.calcZoneBlackListCrc(policyForm);
            Long zoneWhiteListCrc = this.calcZoneWhiteListCrc(policyForm);
            Long zoneServicesCrc = this.calcAllServiceCrcUnderByZoneId(zone.getKey());
            StringBuffer buffer = new StringBuffer();
            buffer.append("[zoneInfoCrc=" + zoneInfoCrc + ",").append("zoneIpCrc" + zoneIpCrc + ",").append("protMapCrc" + protMapCrc + ",").append("zoneBasicPolicyCrc" + zoneBasicPolicyCrc + ",").append("zoneDefendModeCrc" + zoneDefendModeCrc + ",").append("zoneFilterCrc" + zoneFilterCrc + ",").append("zoneIpLocationCrc" + zoneIplocationCrc + ",").append("zoneServicesCrc" + zoneServicesCrc + ",").append("zoneBlackListCrc" + zoneBlackListCrc + "]").append("zoneWhiteListCrc" + zoneWhiteListCrc + "]");
            zoneConfigCrc = CrcUtil.getCrcValue(buffer.toString());
            this.zoneConfigData.getZoneId2CrcToDeployMap().put(zone.getKey(), zoneConfigCrc);
        }
    }

    private Long calcZoneBlackListCrc(ZonePolicyApplyForm policyForm) {
        List<ZoneBlackWhiteForm> list = policyForm.getZoneBlackWhiteFormList();
        if (list == null || list.isEmpty()) {
            return CrcUtil.getCrcValue("");
        }
        return CrcUtil.getCrcValue(list.toString());
    }

    private Long calcZoneWhiteListCrc(ZonePolicyApplyForm policyForm) {
        List<ZoneWhiteForm> list = policyForm.getZoneWhiteFormList();
        if (list == null || list.isEmpty()) {
            return CrcUtil.getCrcValue("");
        }
        return CrcUtil.getCrcValue(list.toString());
    }

    private Long calcZoneFilterCrc(ZonePolicyApplyForm policyForm) {
        List<Long> filterIds = policyForm.getFilterIdList();
        if (null == filterIds || filterIds.isEmpty()) {
            return CrcUtil.getCrcValue("");
        }
        return CrcUtil.getCrcValue(filterIds.toString());
    }

    private Long calcZoneIpLocationCrc(ZonePolicyApplyForm policyForm) {
        List<ZoneIpLocationForm> list = policyForm.getZoneIpLocationList();
        if (list == null || list.isEmpty()) {
            return CrcUtil.getCrcValue("");
        }
        return CrcUtil.getCrcValue(list.toString());
    }

    private Long calcZoneIpInfoCrc(ZoneInfoForm zoneInfoForm) {
        Long zoneIpInfoCrc = CrcUtil.getCrcValue(String.valueOf(0));
        try {
            if (null != zoneInfoForm) {
                String zoneIpInfoString = ZoneConfigData.getZoneIpCalcCrcString(zoneInfoForm);
                zoneIpInfoCrc = CrcUtil.getCrcValue(zoneIpInfoString);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("enter calcZoneIpInfoCrc error :" + zoneIpInfoCrc + ". " + e.getMessage()));
        }
        return zoneIpInfoCrc;
    }

    private Long calcPortMapInfoCrc(ZoneInfoForm zoneInfoForm) {
        Long zonePortMapInfoCrc = CrcUtil.getCrcValue(String.valueOf(0));
        try {
            if (null != zoneInfoForm) {
                String zonePortMapInfoString = ZoneConfigData.getZonePortMapCalcCrcString(zoneInfoForm);
                zonePortMapInfoCrc = CrcUtil.getCrcValue(zonePortMapInfoString);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("enter calcPortMapInfoCrc:" + e.getMessage()));
        }
        return zonePortMapInfoCrc;
    }

    private Long calcZoneInfoCrc(ZoneInfoForm zoneInfo) {
        Long zoneInfoCrc = CrcUtil.getCrcValue(String.valueOf(0));
        if (null != zoneInfo) {
            String zoneInfoString = this.zoneConfigData.getZoneInfoCalcCrcString(zoneInfo);
            zoneInfoCrc = CrcUtil.getCrcValue(zoneInfoString);
        }
        return zoneInfoCrc;
    }

    private Long calcZoneBasicPolicyCrc(ZonePolicyApplyForm form) {
        Long zoneBasicPolicyCrc = CrcUtil.getCrcValue(String.valueOf(0));
        if (null != form) {
            zoneBasicPolicyCrc = CrcUtil.getCrcValue(form.getCalcCrcString());
            this.logger.info((Object)("zoneBasicPolicyCrcString : " + form.getCalcCrcString()));
            this.logger.info((Object)("zoneBasicPolicyCrc : " + zoneBasicPolicyCrc));
        }
        return zoneBasicPolicyCrc;
    }

    private Long calcAllServiceCrcUnderByZoneId(Long zoneId) {
        Long crc = null;
        List<Long> services = this.zoneConfigData.getZoneId2ServiceIdsMap().get(zoneId);
        ArrayList<String> serviceCrcList = new ArrayList<String>();
        if (null != services) {
            for (Long serviceId : services) {
                Long serviceCrc = this.zoneConfigData.getServiceId2CrcToDeployMap().get(serviceId);
                if (null != serviceCrc) {
                    serviceCrcList.add(String.valueOf(serviceCrc));
                    continue;
                }
                this.logger.error((Object)(" init serviceId2CrcToDeployMap error ,can not find serviceCrc with id:" + serviceId));
            }
        }
        Collections.sort(serviceCrcList);
        crc = CrcUtil.getCrcValue(((Object)serviceCrcList).toString());
        return crc;
    }

    private void calcSerivceCrc() {
        Long crc = null;
        try {
            for (Map.Entry<Long, ZoneServiceForm> service : this.zoneConfigData.getZoneServiceMap().entrySet()) {
                crc = CrcUtil.getCrcValue(service.getValue().getCalcCrcString());
                this.zoneConfigData.getServiceId2CrcToDeployMap().put(service.getKey(), crc);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("ysjServiceTotalCrc:" + crc + " " + e.getMessage()));
        }
    }

    public Map<LogicDev, Map<Long, List<IFeature>>> getToDeployData() {
        return this.toDeployData;
    }

    public void setToDeployData(Map<LogicDev, Map<Long, List<IFeature>>> toDeployData) {
        this.toDeployData = toDeployData;
    }

    public ZoneConfigData getZoneConfigData() {
        return this.zoneConfigData;
    }

    public void setZoneConfigData(ZoneConfigData zoneConfigData) {
        this.zoneConfigData = zoneConfigData;
    }

    private void initData(List<String> features, List<String> zoneIp) {
        if (null == this.zoneConfigData.getDeviceId2ZoneIDsMap() || this.zoneConfigData.getDeviceId2ZoneIDsMap().isEmpty()) {
            return;
        }
        Map<Long, List<Long>> deviceId2ZoneIDsMap = this.zoneConfigData.getDeviceId2ZoneIDsMap();
        for (Map.Entry<Long, List<Long>> device : deviceId2ZoneIDsMap.entrySet()) {
            Long deviceId = device.getKey();
            LogicDev logicDev = new LogicDev(deviceId, 1, "--");
            Map<Long, List<IFeature>> zoneFeatures = this.initZoneFeatures(deviceId, device.getValue(), features, zoneIp);
            this.toDeployData.put(logicDev, zoneFeatures);
        }
    }

    private boolean isZoneAlreadyDeployed(Long zoneId) {
        Long initCrc = CrcUtil.getCrcValue(String.valueOf(0));
        boolean flag = false;
        Long zoneDeployedCrc = this.zoneConfigData.getZoneId2CrcDeployedMap().get(zoneId);
        Long zoneToDeployCrc = this.zoneConfigData.getZoneId2CrcToDeployMap().get(zoneId);
        String preDeployStatus = this.zoneConfigData.getZoneId2PreDeployStatusMap().get(zoneId);
        if (zoneDeployedCrc.equals(zoneToDeployCrc) && !zoneDeployedCrc.equals(initCrc) && "SUCCESS".equals(preDeployStatus)) {
            flag = true;
        }
        return flag;
    }

    private boolean isServiceAlreadyDeployed(Long zoneId, Long deviceId, Long featureId) {
        Long initCrc = CrcUtil.getCrcValue(String.valueOf(0));
        boolean flag = false;
        Long serviceDeployedCrc = this.zoneConfigData.getServiceId2CrcDeployedMap().get(featureId);
        Long serviceToDeployCrc = this.zoneConfigData.getServiceId2CrcToDeployMap().get(featureId);
        boolean preDeployedFlag = false;
        ServicePair pair = new ServicePair(zoneId, deviceId, featureId);
        ZoneServiceStatusInfo serviceStatusInfo = this.zoneConfigData.getZoneServiceStatusMap().get(pair);
        if (null != serviceStatusInfo) {
            preDeployedFlag = serviceStatusInfo.getDeployState();
        }
        if (serviceDeployedCrc.equals(serviceToDeployCrc) && !serviceDeployedCrc.equals(initCrc) && preDeployedFlag) {
            flag = true;
        }
        return flag;
    }

    private boolean isFeatureDeployed(Long zoneId, Long deviceId, String featureType, Long featureId) {
        boolean flag = false;
        Long initCrc = CrcUtil.getCrcValue(0L);
        FeaturePair pair = new FeaturePair(zoneId, deviceId, featureType, featureId);
        Long toDeployCrc = this.zoneConfigData.getZoneFeature2CrcMap().get(pair);
        ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(pair);
        Long deployedCrc = CrcUtil.getCrcValue(0L);
        this.logger.info((Object)("toDeployCrc of featurepair in isFeatureDeployed : " + toDeployCrc));
        if (null != featureStaus) {
            deployedCrc = featureStaus.getDeployCrc();
        }
        if (null == toDeployCrc) {
            toDeployCrc = deployedCrc;
        }
        boolean preDeployedFlag = false;
        if (this.zoneConfigData.getZoneFeatureStatusMap().containsKey(pair)) {
            preDeployedFlag = this.zoneConfigData.getZoneFeatureStatusMap().get(pair).getDeployState();
        }
        if (toDeployCrc.equals(deployedCrc) && !deployedCrc.equals(initCrc) && preDeployedFlag) {
            flag = true;
        }
        return flag;
    }

    private boolean isIpDeployed(Long zoneId, Long deviceId, String featureType, Long featureId) {
        boolean flag = true;
        ZoneInfoForm zoneInfoForm = this.zoneConfigData.getZoneInfoMap().get(zoneId);
        List<ZoneIpForm> zoneIpFormList = zoneInfoForm.getZoneIpFormList();
        List<ZoneUndoIpForm> zoneUndoIpFormList = zoneInfoForm.getZoneUndoIpFromList();
        if (null != zoneIpFormList && !zoneIpFormList.isEmpty() || null != zoneUndoIpFormList && !zoneUndoIpFormList.isEmpty()) {
            flag = false;
        }
        return flag;
    }

    private boolean isPortMapDeployed(Long zoneId, Long deviceId, String featureType, Long featureId) {
        boolean flag = true;
        ZoneInfoForm zoneInfoForm = this.zoneConfigData.getZoneInfoMap().get(zoneId);
        List<ZonePortMapForm> zoneDoPortMapFormList = zoneInfoForm.getZoneDoPortMapFormLis();
        List<ZonePortMapForm> zoneUndoPortMapFormList = zoneInfoForm.getZoneUndoPortMapFormList();
        if (null != zoneDoPortMapFormList && !zoneDoPortMapFormList.isEmpty() || null != zoneUndoPortMapFormList && !zoneUndoPortMapFormList.isEmpty()) {
            flag = false;
        }
        return flag;
    }

    public Boolean isFeatureChanged(Long zoneId, Long deviceId, String featureType, Long featureId) {
        boolean flag = false;
        FeaturePair pair = new FeaturePair(zoneId, deviceId, featureType, featureId);
        Long toDeployCrc = this.zoneConfigData.getZoneFeature2CrcMap().get(pair);
        ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(pair);
        Long deployedCrc = 0L;
        if (null != featureStaus) {
            deployedCrc = featureStaus.getDeployCrc();
        }
        if (null != toDeployCrc && !toDeployCrc.equals(deployedCrc)) {
            flag = true;
        }
        return flag;
    }

    private Map<Long, List<IFeature>> initZoneFeatures(Long deviceId, List<Long> zoneIdList, List<String> features, List<String> zoneIp) {
        if (null == zoneIdList || zoneIdList.isEmpty()) {
            return null;
        }
        HashMap<Long, List<IFeature>> zoneFeatures = new HashMap<Long, List<IFeature>>();
        for (Long zoneId : zoneIdList) {
            Boolean isServicesFully;
            ArrayList<IFeature> singleZoneFeatures = new ArrayList<IFeature>();
            ZoneInfoForm zoneInfoForm = this.zoneConfigData.getZoneInfoMap().get(zoneId);
            if (this.isZoneAlreadyDeployed(zoneId)) {
                HelloFeature helloFeature = new HelloFeature(zoneInfoForm, "helloFeature", zoneInfoForm.getZoneId());
                singleZoneFeatures.add(helloFeature);
                this.initZone2deviceTodeploy(deviceId, zoneId);
                zoneFeatures.put(zoneId, singleZoneFeatures);
                continue;
            }
            this.initZone2deviceTodeploy(deviceId, zoneId);
            this.initZoneBasicFeature(zoneInfoForm, deviceId, singleZoneFeatures, features, zoneIp);
            List<IFeature> zoneServiceToUndeploy = this.initZoneServiceToUndeploy(deviceId, zoneId);
            int serviceToUndeployNum = 0;
            if (!zoneServiceToUndeploy.isEmpty()) {
                serviceToUndeployNum = zoneServiceToUndeploy.size();
            }
            if (!(isServicesFully = this.isServicesFully(zoneId, deviceId, serviceToUndeployNum)).booleanValue()) {
                singleZoneFeatures.addAll(zoneServiceToUndeploy);
            } else {
                UndeployServiceData undeployServiceData = new UndeployServiceData(zoneInfoForm, "UndeployServiceAll", zoneId);
                undeployServiceData.setCmdViewList(this.buildView4Zone(zoneId));
                singleZoneFeatures.add(undeployServiceData);
            }
            List<IFeature> zoneServicefeatures = this.initZoneServiceFeautre(deviceId, zoneId, isServicesFully, features);
            singleZoneFeatures.addAll(zoneServicefeatures);
            zoneFeatures.put(zoneId, singleZoneFeatures);
        }
        return zoneFeatures;
    }

    private Boolean isServicesFully(Long zoneId, Long deviceId, int serviceToUndeployNum) {
        Map<Long, List<Long>> zoneId2ServiceIdsMap = this.zoneConfigData.getZoneId2ServiceIdsMap();
        List<Long> serviceIdList = zoneId2ServiceIdsMap.get(zoneId);
        int serviceToDeployNum = 0;
        if (null != serviceIdList) {
            for (Long serviceId : serviceIdList) {
                ZoneServiceForm zoneServieForm = this.zoneConfigData.getZoneServiceMap().get(serviceId);
                if (null == zoneServieForm || !deviceId.equals(zoneServieForm.getDeviceId()) || "DEFAULT".equals(zoneServieForm.getProtocol())) continue;
                ++serviceToDeployNum;
            }
        }
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
        Set supAttr = DdosDevCapabilityServiceImpl.getInstance().getAllSupportedAttr(devTypeInfo);
        Boolean isX = supAttr.contains("withServiceViewCustomService");
        if (isX.booleanValue() && serviceToUndeployNum + serviceToDeployNum > Constant.SERVICE_PER_ZONE_MAXIMUM_NEW_DEVICE) {
            return true;
        }
        return false;
    }

    private void initZoneBasicFeature(ZoneInfoForm zoneInfoForm, Long deviceId, List<IFeature> singleZoneFeatures, List<String> features, List<String> zoneIp) {
        ZonePolicyApplyForm zonePolicy;
        AticDevice aticDevice = ZoneReferUtil.getFirewallService().getDeviceByMoid(deviceId.longValue());
        Long zoneId = zoneInfoForm.getZoneId();
        if (!this.isFeatureDeployed(zoneId, deviceId, zoneInfoForm.getClass().getSimpleName(), zoneId)) {
            ZoneDefineInfo zoneDefineInfo = new ZoneDefineInfo(zoneInfoForm, zoneInfoForm.getClass().getSimpleName(), zoneInfoForm.getZoneId());
            zoneDefineInfo.setCmdViewList(this.buildView4System());
            singleZoneFeatures.add(zoneDefineInfo);
        }
        if ((null == features || features.contains(Constant.Feature.ZoneIpInfo.toString())) && !this.isIpDeployed(zoneId, deviceId, ZoneIpForm.class.getSimpleName(), zoneId)) {
            ZoneIpInfo zoneIpInfo = new ZoneIpInfo(zoneInfoForm, ZoneIpForm.class.getSimpleName(), zoneInfoForm.getZoneId(), zoneIp);
            zoneIpInfo.setCmdViewList(this.buildView4Zone(zoneId));
            singleZoneFeatures.add(zoneIpInfo);
        }
        if ((null == features || features.contains(Constant.Feature.ZonePortMapData.toString())) && !this.isPortMapDeployed(zoneId, deviceId, ZonePortMapForm.class.getSimpleName(), zoneId) && aticDevice.getDeviceType() != 8) {
            ZonePortMapData zonePortMapData = new ZonePortMapData(zoneInfoForm, ZonePortMapForm.class.getSimpleName(), zoneInfoForm.getZoneId(), zoneIp);
            zonePortMapData.setCmdViewList(this.buildView4Zone(zoneId));
            singleZoneFeatures.add(zonePortMapData);
        }
        if ((zonePolicy = this.zoneConfigData.getZoneBasicInfoMap().get(zoneId)) == null) {
            return;
        }
        if ((null == features || features.contains(Constant.Feature.ZoneBasicPolicyInfo.toString())) && !this.isFeatureDeployed(zoneId, deviceId, zonePolicy.getClass().getSimpleName(), zoneId)) {
            ZoneBasicPolicyInfo zoneBasicPolicyInfo = new ZoneBasicPolicyInfo(zonePolicy, zoneInfoForm, zonePolicy.getClass().getSimpleName(), zonePolicy.getZoneId());
            zoneBasicPolicyInfo.setCmdViewList(this.buildView4Zone(zoneId));
            singleZoneFeatures.add(zoneBasicPolicyInfo);
        }
        if ((null == features || features.contains(Constant.Feature.ZoneDefendModeData.toString())) && !this.isFeatureDeployed(zoneId, deviceId, "ZoneDefendModeFeature", zoneId) && aticDevice.getDeviceType() != 8) {
            this.organizeDefendMode(zonePolicy, zoneId, singleZoneFeatures);
        }
        if ((null == features || features.contains(Constant.Feature.ZoneIpLocationData.toString())) && !this.isFeatureDeployed(zoneId, deviceId, ZoneIpLocationForm.class.getSimpleName(), zoneId) && aticDevice.getDeviceType() != 8) {
            ZoneIpLocationData zoneIpLocationData = new ZoneIpLocationData(zonePolicy.getZoneIpLocationList(), ZoneIpLocationForm.class.getSimpleName(), zoneId);
            zoneIpLocationData.setCmdViewList(this.buildView4Zone(zoneId));
            singleZoneFeatures.add(zoneIpLocationData);
        }
        if ((null == features || features.contains(Constant.Feature.ZoneBlackListData.toString())) && !this.isFeatureDeployed(zoneId, deviceId, ZoneBlackWhiteForm.class.getSimpleName(), zoneId) && aticDevice.getDeviceType() != 8) {
            ZoneBlackWhiteListData zoneBlackWhiteListData = new ZoneBlackWhiteListData(zonePolicy.getZoneBlackWhiteFormList(), ZoneBlackWhiteForm.class.getSimpleName(), zoneId);
            zoneBlackWhiteListData.setCmdViewList(this.buildView4Zone(zoneId));
            zoneBlackWhiteListData.setRequestMap(this.getRequestMap());
            singleZoneFeatures.add(zoneBlackWhiteListData);
        }
        if ((null == features || features.contains(Constant.Feature.ZoneWhiteListData.toString())) && !this.isFeatureDeployed(zoneId, deviceId, ZoneWhiteForm.class.getSimpleName(), zoneId) && aticDevice.getDeviceType() != 8) {
            ZoneWhiteListData zoneWhiteListData = new ZoneWhiteListData(zonePolicy.getZoneWhiteFormList(), ZoneWhiteForm.class.getSimpleName(), zoneId);
            zoneWhiteListData.setCmdViewList(this.buildView4Zone(zoneId));
            zoneWhiteListData.setRequestMap(this.getRequestMap());
            singleZoneFeatures.add(zoneWhiteListData);
        }
    }

    private void organizeDefendMode(ZonePolicyApplyForm zonePolicy, Long zoneId, List<IFeature> singleZoneFeatures) {
        ZoneDefendModeData defendModeData = new ZoneDefendModeData(zonePolicy, "ZoneDefendModeFeature", zoneId);
        defendModeData.setCmdViewList(this.buildView4Zone(zoneId));
        singleZoneFeatures.add(defendModeData);
    }

    private void initZone2deviceTodeploy(Long deviceId, Long zoneId) {
        Map<Long, List<Long>> zone2deviceTodeploy = this.zoneConfigData.getZoneID2DeviceIdsMapToDeploy();
        if (!zone2deviceTodeploy.containsKey(zoneId)) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(deviceId);
            zone2deviceTodeploy.put(zoneId, list);
        } else {
            zone2deviceTodeploy.get(zoneId).add(deviceId);
        }
    }

    private List<IFeature> initZoneServiceToUndeploy(Long deviceId, Long zoneId) {
        ArrayList<IFeature> features = new ArrayList<IFeature>();
        ZonePair pair = new ZonePair(deviceId, zoneId);
        Map<ServicePair, ZoneServiceForm> zoneServiceToUndeploy = this.zoneConfigData.getZoneServiceToUndeploy();
        for (Map.Entry<ServicePair, ZoneServiceForm> servicePair : zoneServiceToUndeploy.entrySet()) {
            ZonePair temp = new ZonePair(servicePair.getKey().getDeviceId(), servicePair.getKey().getZoneId());
            if (!temp.equals(pair)) continue;
            ZoneServiceToUndeploy feature = new ZoneServiceToUndeploy(servicePair.getValue(), "ZoneServiceToUndeploy", servicePair.getValue().getPkid());
            feature.setCmdViewList(this.buildView4Zone(zoneId));
            features.add(feature);
        }
        return features;
    }

    private List<IFeature> initZoneServiceFeautre(Long deviceId, Long zoneId, Boolean isServicesFully, List<String> featureStrs) {
        ArrayList<IFeature> iFeatures = new ArrayList<IFeature>();
        Map<Long, List<Long>> zoneId2ServiceIdsMap = this.zoneConfigData.getZoneId2ServiceIdsMap();
        List<Long> serviceIdList = zoneId2ServiceIdsMap.get(zoneId);
        if (null == serviceIdList) {
            return iFeatures;
        }
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        for (Long serviceId : serviceIdList) {
            List<IFeature> serviceIpFeature;
            ArrayList<FeaturePair> featurePairList = new ArrayList<FeaturePair>();
            ZoneServiceForm zoneServieForm = this.zoneConfigData.getZoneServiceMap().get(serviceId);
            if (null == zoneServieForm) continue;
            AticDevice device = ZoneReferUtil.getFirewallService().getDeviceByMoid(zoneServieForm.getDeviceId().longValue());
            ArrayList<Long> bingDevice = new ArrayList<Long>();
            if (device.getDeviceType() == 9) {
                IClusterService clusterService = (IClusterService)ServiceContext.getInstance().getService("clusterService", IClusterService.class);
                List nfaClusters = clusterService.getBindNfaDevice(Long.valueOf(device.getMoId()));
                for (AticDeviceNfaCluster cluster : nfaClusters) {
                    bingDevice.add(cluster.getDeviceId());
                }
                if (!bingDevice.contains(deviceId)) {
                    continue;
                }
            } else if (!deviceId.equals(zoneServieForm.getDeviceId())) continue;
            if (this.isServiceAlreadyDeployed(zoneId, deviceId, zoneServieForm.getPkid()) && !isServicesFully.booleanValue() && this.isFeatureDeployed(zoneId, deviceId, ZoneIpForm.class.getSimpleName(), zoneId)) continue;
            ServicePair pair = new ServicePair(zoneId, deviceId, serviceId);
            servicePair2FeaturePair.put(pair, featurePairList);
            if (!this.isFeatureDeployed(zoneId, deviceId, zoneServieForm.getClass().getSimpleName(), zoneServieForm.getPkid()) || isServicesFully.booleanValue()) {
                ZoneServiceBasicInfo zoneServiceBasicInfo = new ZoneServiceBasicInfo(zoneServieForm, zoneServieForm.getClass().getSimpleName(), zoneServieForm.getPkid(), this.zoneConfigData.getZoneFeatureStatusMap());
                zoneServiceBasicInfo.setCmdViewList(this.buildView4Zone(zoneId));
                zoneServiceBasicInfo.setIsServicesFully(isServicesFully);
                iFeatures.add(zoneServiceBasicInfo);
                FeaturePair featurePair = new FeaturePair(zoneId, deviceId, zoneServieForm.getClass().getSimpleName(), serviceId);
                featurePairList.add(featurePair);
            }
            if (!(serviceIpFeature = this.initServiceIpFeature(deviceId, zoneId, zoneServieForm, isServicesFully)).isEmpty()) {
                iFeatures.addAll(serviceIpFeature);
            }
            List<IFeature> serviceFeatures = this.initServicePolicyFeatures(deviceId, zoneId, zoneServieForm, isServicesFully, featureStrs);
            iFeatures.addAll(serviceFeatures);
        }
        return iFeatures;
    }

    private List<IFeature> initServiceIpFeature(Long deviceId, Long zoneId, ZoneServiceForm zoneServieForm, Boolean isServicesFully) {
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
        Boolean isSupportPortService = supportAttrs.contains("isSupportPortService");
        Long serviceId = zoneServieForm.getPkid();
        ServicePair pair = new ServicePair(zoneId, deviceId, serviceId);
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        if (null == featurePairList) {
            featurePairList = new ArrayList<FeaturePair>();
            servicePair2FeaturePair.put(pair, featurePairList);
        }
        ArrayList<IFeature> features = new ArrayList<IFeature>();
        if (isSupportPortService.booleanValue() && !"DEFAULT".equals(zoneServieForm.getProtocol()) && (!this.isFeatureDeployed(zoneId, deviceId, "ServiceIpForm", serviceId) || isServicesFully.booleanValue())) {
            ServiceIpInfo serviceIpInfo = new ServiceIpInfo(zoneServieForm, "ServiceIpForm", serviceId);
            serviceIpInfo.setCmdViewList(this.buildView4Service(deviceId, zoneId, serviceId, zoneServieForm.getProtocol()));
            features.add(serviceIpInfo);
            FeaturePair featurePair = new FeaturePair(zoneId, deviceId, "ServiceIpForm", serviceId);
            featurePairList.add(featurePair);
        }
        return features;
    }

    private List<IFeature> initServicePolicyFeatures(Long deviceId, Long zoneId, ZoneServiceForm form, Boolean isServicesFully, List<String> featureStrs) {
        ArrayList<IFeature> features = new ArrayList<IFeature>();
        if (null == form) {
            return features;
        }
        Map<String, List<String>> serviceType2Policys = ZoneServiceForm.getService2policy();
        List<String> policys = serviceType2Policys.get(form.getProtocol());
        Long serviceId = form.getPkid();
        ServicePair pair = new ServicePair(zoneId, deviceId, serviceId);
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        if (null == featurePairList) {
            featurePairList = new ArrayList<FeaturePair>();
            servicePair2FeaturePair.put(pair, featurePairList);
        }
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
        Boolean isSupportPortService = supportAttrs.contains("isSupportPortService");
        if (null == featureStrs || featureStrs.contains(Constant.Feature.ServiceNfaDefendData.toString()) && this.hasNfaFeature(policys, form).booleanValue()) {
            this.addNfaPolicyFeature(form, pair, features, isServicesFully);
        }
        if ((null == featureStrs || featureStrs.contains(Constant.Feature.ServiceTcpDefendData.toString())) && this.hasTcpFeature(policys, form).booleanValue()) {
            this.addTcpPolicyFeature(form, pair, features, isServicesFully, isSupportPortService);
        }
        if ((null == featureStrs || featureStrs.contains(Constant.Feature.ServiceUdpDefendData.toString())) && this.hasUdpFeature(policys, form).booleanValue()) {
            this.addUdpPolicyFeature(form, pair, features, isServicesFully);
        }
        if ((null == featureStrs || featureStrs.contains(Constant.Feature.ServiceIcmpDefendData.toString())) && policys.contains("ICMP") && null != form.getIcmpDefendPolicyForm()) {
            this.addIcmpPolicyFeature(form, pair, features, isServicesFully);
        }
        if ((null == featureStrs || featureStrs.contains(Constant.Feature.ServiceHttpDefendData.toString())) && this.hasHttpFeature(policys, form)) {
            this.addHttpPolicyFeature(form, pair, features, isServicesFully);
        }
        if ((null == featureStrs || featureStrs.contains(Constant.Feature.ServiceHttpsDefendData.toString())) && this.hasHttpsFeature(policys, form)) {
            this.addHttpsPolicyFeature(form, pair, features, isServicesFully);
        }
        if ((null == featureStrs || featureStrs.contains(Constant.Feature.ServiceDnsDefendData.toString())) && this.hasDnsFeature(policys, form)) {
            this.addDnsPolicyFeature(form, pair, features, isServicesFully);
        }
        if ((null == featureStrs || featureStrs.contains(Constant.Feature.ServiceSipDefendData.toString())) && this.hasSipPolicyFeature(policys, form).booleanValue()) {
            this.addSipPolicyFeature(form, pair, features, isServicesFully);
        }
        if ((null == featureStrs || featureStrs.contains(Constant.Feature.ServiceOtherDefendData.toString())) && policys.contains("Other") && null != form.getOtherDefendPolicyForm()) {
            this.addOtherPolicyFeature(form, pair, features, isServicesFully);
        }
        if ((null == featureStrs || featureStrs.contains(Constant.Feature.TopnStudyDefendData.toString())) && policys.contains("TOPNSTUDY") && null != form.getTopNStudyForm()) {
            this.addTopnStudyFeature(form, pair, features, isServicesFully);
        }
        return features;
    }

    private void addTopnStudyFeature(ZoneServiceForm form, ServicePair pair, List<IFeature> features, Boolean isServicesFully) {
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        TopNStudyForm topnForm = form.getTopNStudyForm();
        Long zoneId = pair.getZoneId();
        Long deviceId = pair.getDeviceId();
        Long serviceId = pair.getServiceId();
        String serviceProtocol = form.getProtocol();
        if (!this.isFeatureDeployed(zoneId, deviceId, topnForm.getClass().getSimpleName(), topnForm.getId()) || isServicesFully.booleanValue()) {
            TopnStudyDefendData topnData = new TopnStudyDefendData(topnForm, topnForm.getClass().getSimpleName(), topnForm.getId());
            topnData.setCmdViewList(this.buildView4Service(deviceId, zoneId, serviceId, serviceProtocol));
            features.add(topnData);
            FeaturePair featurePair = new FeaturePair(zoneId, deviceId, topnData.getFeatureType(), topnData.getFeatureId());
            featurePairList.add(featurePair);
        }
    }

    private Boolean hasSipPolicyFeature(List<String> policys, ZoneServiceForm form) {
        if (policys.contains("SIP") && null != form.getSipDefendPolicyForm()) {
            return true;
        }
        return false;
    }

    private boolean hasDnsFeature(List<String> policys, ZoneServiceForm form) {
        return policys.contains("DNS") && null != form.getDnsDefendPolicyForm();
    }

    private boolean hasHttpsFeature(List<String> policys, ZoneServiceForm form) {
        return policys.contains("HTTPS") && null != form.getHttpsDefendPolicyForm();
    }

    private boolean hasHttpFeature(List<String> policys, ZoneServiceForm form) {
        return policys.contains("HTTP") && null != form.getHttpDefendPolicyForm();
    }

    private void addOtherPolicyFeature(ZoneServiceForm form, ServicePair pair, List<IFeature> features, Boolean isServicesFully) {
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        OtherDefendPolicyForm otherForm = form.getOtherDefendPolicyForm();
        Long zoneId = pair.getZoneId();
        Long deviceId = pair.getDeviceId();
        Long serviceId = pair.getServiceId();
        String serviceProtocol = form.getProtocol();
        if (!this.isFeatureDeployed(zoneId, deviceId, otherForm.getClass().getSimpleName(), otherForm.getId()) || isServicesFully.booleanValue()) {
            FeaturePair otherFeaturePair = new FeaturePair(zoneId, deviceId, otherForm.getClass().getSimpleName(), otherForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(otherFeaturePair);
            if (null == featureStaus && !this.hasOtherConfig(otherForm) && otherForm.getDirection() == 1) {
                return;
            }
            ServiceOtherDefendData other = new ServiceOtherDefendData(otherForm, otherForm.getClass().getSimpleName(), otherForm.getId());
            other.setCmdViewList(this.buildView4Service(deviceId, zoneId, serviceId, serviceProtocol));
            features.add(other);
            FeaturePair featurePair = new FeaturePair(zoneId, deviceId, other.getFeatureType(), other.getFeatureId());
            featurePairList.add(featurePair);
        }
    }

    private boolean hasOtherConfig(OtherDefendPolicyForm otherForm) {
        boolean carDefenceEnableAndOther;
        boolean otherBlockOrDefendEnable = !(null != otherForm.getOtherBlock() && otherForm.getOtherBlock() != false || null != otherForm.getOtherDefendEnable() && otherForm.getOtherDefendEnable() != false);
        boolean bl = carDefenceEnableAndOther = !(null != otherForm.getCarDefenceEnable() && otherForm.getCarDefenceEnable() != false || null != otherForm.getOtherDefenseEnable() && otherForm.getOtherDefenseEnable() != false);
        return !otherBlockOrDefendEnable || !carDefenceEnableAndOther;
    }

    private void addSipPolicyFeature(ZoneServiceForm form, ServicePair pair, List<IFeature> features, Boolean isServicesFully) {
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        SipDefendPolicyForm sipForm = form.getSipDefendPolicyForm();
        Long zoneId = pair.getZoneId();
        Long deviceId = pair.getDeviceId();
        Long serviceId = pair.getServiceId();
        String serviceProtocol = form.getProtocol();
        if (!this.isFeatureDeployed(zoneId, deviceId, sipForm.getClass().getSimpleName(), sipForm.getId()) || isServicesFully.booleanValue()) {
            FeaturePair sipFeaturePair = new FeaturePair(zoneId, deviceId, sipForm.getClass().getSimpleName(), sipForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(sipFeaturePair);
            if (null == featureStaus && !this.hasSipConfig(sipForm) && sipForm.getDirection() == 1) {
                return;
            }
            ServiceSipDefendData sip = new ServiceSipDefendData(sipForm, sipForm.getClass().getSimpleName(), sipForm.getId());
            sip.setCmdViewList(this.buildView4Service(deviceId, zoneId, serviceId, serviceProtocol));
            features.add(sip);
            FeaturePair featurePair = new FeaturePair(zoneId, deviceId, sip.getFeatureType(), sip.getFeatureId());
            featurePairList.add(featurePair);
        }
    }

    private boolean hasSipConfig(SipDefendPolicyForm sipForm) {
        return null != sipForm.getSipBlock() && sipForm.getSipBlock() != false || null != sipForm.getSipDefendEnable() && sipForm.getSipDefendEnable() != false || null != sipForm.getLimitEnable() && sipForm.getLimitEnable() != false;
    }

    private void addDnsPolicyFeature(ZoneServiceForm form, ServicePair pair, List<IFeature> features, Boolean isServicesFully) {
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        DnsDefendPolicyForm dnsForm = form.getDnsDefendPolicyForm();
        Long zoneId = pair.getZoneId();
        Long deviceId = pair.getDeviceId();
        Long serviceId = pair.getServiceId();
        String serviceProtocol = form.getProtocol();
        if (!this.isFeatureDeployed(zoneId, deviceId, dnsForm.getClass().getSimpleName(), dnsForm.getId()) || isServicesFully.booleanValue()) {
            FeaturePair dnsFeaturePair = new FeaturePair(zoneId, deviceId, dnsForm.getClass().getSimpleName(), dnsForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(dnsFeaturePair);
            if (null == featureStaus && !this.hasDnsConfig(dnsForm) && dnsForm.getDirection() == 1) {
                return;
            }
            ServiceDnsDefendData dns = new ServiceDnsDefendData(dnsForm, dnsForm.getClass().getSimpleName(), dnsForm.getId());
            dns.setCmdViewList(this.buildView4Service(deviceId, zoneId, serviceId, serviceProtocol));
            features.add(dns);
            FeaturePair featurePair = new FeaturePair(zoneId, deviceId, dns.getFeatureType(), dns.getFeatureId());
            featurePairList.add(featurePair);
        }
    }

    private boolean hasDnsConfig(DnsDefendPolicyForm dnsForm) {
        boolean dnsBlock2;
        boolean dnsBlock1 = !(null != dnsForm.getDnsBlock() && dnsForm.getDnsBlock() != false || null != dnsForm.getDnsDefendEnable() && dnsForm.getDnsDefendEnable() != false);
        boolean bl = dnsBlock2 = !(null != dnsForm.getLimitEnable() && dnsForm.getLimitEnable() != false || null != dnsForm.getDnsStatisticEnable() && dnsForm.getDnsStatisticEnable() != false || null != dnsForm.getTopnStatisticEnable() && dnsForm.getTopnStatisticEnable() != false);
        return !dnsBlock1 || !dnsBlock2;
    }

    private void addHttpsPolicyFeature(ZoneServiceForm form, ServicePair pair, List<IFeature> features, Boolean isServicesFully) {
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        HttpsDefendPolicyForm httpsForm = form.getHttpsDefendPolicyForm();
        Long zoneId = pair.getZoneId();
        Long deviceId = pair.getDeviceId();
        Long serviceId = pair.getServiceId();
        String serviceProtocol = form.getProtocol();
        if (!this.isFeatureDeployed(zoneId, deviceId, httpsForm.getClass().getSimpleName(), httpsForm.getId()) || isServicesFully.booleanValue()) {
            FeaturePair httpsFeaturePair = new FeaturePair(zoneId, deviceId, httpsForm.getClass().getSimpleName(), httpsForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(httpsFeaturePair);
            if (null == featureStaus && !this.hasHttpsConfig(httpsForm) && httpsForm.getDirection() == 1) {
                return;
            }
            ServiceHttpsDefendData https = new ServiceHttpsDefendData(httpsForm, httpsForm.getClass().getSimpleName(), httpsForm.getId());
            https.setCmdViewList(this.buildView4Service(deviceId, zoneId, serviceId, serviceProtocol));
            features.add(https);
            FeaturePair featurePair = new FeaturePair(zoneId, deviceId, https.getFeatureType(), https.getFeatureId());
            featurePairList.add(featurePair);
        }
    }

    private boolean hasHttpsConfig(HttpsDefendPolicyForm httpsForm) {
        return null != httpsForm.getHttpsBlock() && httpsForm.getHttpsBlock() != false || null != httpsForm.getHttpsDefendEnable() && httpsForm.getHttpsDefendEnable() != false || null != httpsForm.getLimitEnable() && httpsForm.getLimitEnable() != false;
    }

    private void addHttpPolicyFeature(ZoneServiceForm form, ServicePair pair, List<IFeature> features, Boolean isServicesFully) {
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        HttpDefendPolicyForm httpForm = form.getHttpDefendPolicyForm();
        Long zoneId = pair.getZoneId();
        Long deviceId = pair.getDeviceId();
        Long serviceId = pair.getServiceId();
        String serviceProtocol = form.getProtocol();
        if (!this.isFeatureDeployed(zoneId, deviceId, httpForm.getClass().getSimpleName(), httpForm.getId()) || isServicesFully.booleanValue()) {
            FeaturePair httpFeaturePair = new FeaturePair(zoneId, deviceId, httpForm.getClass().getSimpleName(), httpForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(httpFeaturePair);
            if (null == featureStaus && !this.hasHttpConfig(httpForm) && httpForm.getDirection() == 1) {
                return;
            }
            ServiceHttpDefendData http = new ServiceHttpDefendData(httpForm, httpForm.getClass().getSimpleName(), httpForm.getId(), form);
            http.setCmdViewList(this.buildView4Service(deviceId, zoneId, serviceId, serviceProtocol));
            features.add(http);
            FeaturePair featurePair = new FeaturePair(zoneId, deviceId, http.getFeatureType(), http.getFeatureId());
            featurePairList.add(featurePair);
        }
    }

    private boolean hasHttpConfig(HttpDefendPolicyForm httpForm) {
        return null != httpForm.getHttpBlock() && httpForm.getHttpBlock() != false || null != httpForm.getHttpDefendEnable() && httpForm.getHttpDefendEnable() != false || null != httpForm.getLimitEnable() && httpForm.getLimitEnable() != false;
    }

    private void addIcmpPolicyFeature(ZoneServiceForm form, ServicePair pair, List<IFeature> features, Boolean isServicesFully) {
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        IcmpDefendPolicyForm icmpForm = form.getIcmpDefendPolicyForm();
        Long zoneId = pair.getZoneId();
        Long deviceId = pair.getDeviceId();
        Long serviceId = pair.getServiceId();
        String serviceProtocol = form.getProtocol();
        if (!this.isFeatureDeployed(zoneId, deviceId, icmpForm.getClass().getSimpleName(), icmpForm.getId()) || isServicesFully.booleanValue()) {
            FeaturePair icmpFeaturePair = new FeaturePair(zoneId, deviceId, icmpForm.getClass().getSimpleName(), icmpForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(icmpFeaturePair);
            if (null == featureStaus && !this.hasIcmpConfig(icmpForm) && icmpForm.getDirection() == 1) {
                return;
            }
            ServiceIcmpDefendData icmp = new ServiceIcmpDefendData(icmpForm, icmpForm.getClass().getSimpleName(), icmpForm.getId());
            icmp.setCmdViewList(this.buildView4Service(deviceId, zoneId, serviceId, serviceProtocol));
            features.add(icmp);
            FeaturePair featurePair = new FeaturePair(zoneId, deviceId, icmp.getFeatureType(), icmp.getFeatureId());
            featurePairList.add(featurePair);
        }
    }

    private boolean hasIcmpConfig(IcmpDefendPolicyForm icmpForm) {
        if (!(1 != icmpForm.getDirection() || null != icmpForm.getIcmpBlockEnable() && icmpForm.getIcmpBlockEnable().booleanValue() || null != icmpForm.getIcmpDefendEnable() && icmpForm.getIcmpDefendEnable().booleanValue() || null != icmpForm.getIcmpMaxSpeedEnable() && icmpForm.getIcmpMaxSpeedEnable().booleanValue())) {
            return false;
        }
        return 2 != icmpForm.getDirection() || null != icmpForm.getIcmpLimitSubEnable() && icmpForm.getIcmpLimitSubEnable() != false;
    }

    private void addUdpPolicyFeature(ZoneServiceForm form, ServicePair pair, List<IFeature> features, Boolean isServicesFully) {
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        UdpDefendPolicyForm udpForm = form.getUdpDefendPolicyForm();
        Long zoneId = pair.getZoneId();
        Long deviceId = pair.getDeviceId();
        Long serviceId = pair.getServiceId();
        String serviceProtocol = form.getProtocol();
        if (!this.isFeatureDeployed(zoneId, deviceId, udpForm.getClass().getSimpleName(), udpForm.getId()) || isServicesFully.booleanValue()) {
            FeaturePair udpFeaturePair = new FeaturePair(zoneId, deviceId, udpForm.getClass().getSimpleName(), udpForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(udpFeaturePair);
            if (null == featureStaus && !this.hasUdpConfig(udpForm) && udpForm.getDirection() == 1) {
                return;
            }
            ServiceUdpDefendData udp = new ServiceUdpDefendData(udpForm, udpForm.getClass().getSimpleName(), udpForm.getId(), form);
            udp.setCmdViewList(this.buildView4Service(deviceId, zoneId, serviceId, serviceProtocol));
            features.add(udp);
            FeaturePair featurePair = new FeaturePair(zoneId, deviceId, udp.getFeatureType(), udp.getFeatureId());
            featurePairList.add(featurePair);
        }
    }

    private boolean hasUdpConfig(UdpDefendPolicyForm udpForm) {
        if (!(1 != udpForm.getDirection() || null != udpForm.getUdpBlock() && udpForm.getUdpBlock().booleanValue() || null != udpForm.getUdpDefendEnable() && udpForm.getUdpDefendEnable().booleanValue() || null != udpForm.getUdpLimitEnable() && udpForm.getUdpLimitEnable().booleanValue())) {
            return false;
        }
        return 2 != udpForm.getDirection() || null != udpForm.getUdpMaxSpeedEnable() && udpForm.getUdpMaxSpeedEnable() != false || null != udpForm.getUdpFragMaxSpeedEnable() && udpForm.getUdpFragMaxSpeedEnable() != false;
    }

    private void addNfaPolicyFeature(ZoneServiceForm form, ServicePair pair, List<IFeature> features, Boolean isServicesFully) {
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        NfaPolicyEditForm nfaForm = form.getNfaPolicyEditForm();
        Long zoneId = pair.getZoneId();
        Long deviceId = pair.getDeviceId();
        Long pkId = form.getPkid();
        if (!this.isFeatureDeployed(zoneId, deviceId, nfaForm.getClass().getSimpleName(), pkId) || isServicesFully.booleanValue()) {
            FeaturePair nfaFeaturePair = new FeaturePair(zoneId, deviceId, nfaForm.getClass().getSimpleName(), pkId);
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(nfaFeaturePair);
            if (null == featureStaus && !this.hasNfaConfig(nfaForm)) {
                return;
            }
            ServiceNfaDefendData nfa = new ServiceNfaDefendData(nfaForm, nfaForm.getClass().getSimpleName(), pkId, form);
            nfa.setCmdViewList(this.buildView4Service(deviceId, zoneId, form.getPkid(), form.getProtocol()));
            features.add(nfa);
            FeaturePair featurePair = new FeaturePair(zoneId, deviceId, nfa.getFeatureType(), nfa.getFeatureId());
            featurePairList.add(featurePair);
        }
    }

    private void addTcpPolicyFeature(ZoneServiceForm form, ServicePair pair, List<IFeature> features, Boolean isServicesFully, Boolean isSupportPortService) {
        Long deviceId;
        Map<ServicePair, List<FeaturePair>> servicePair2FeaturePair = this.zoneConfigData.getServicePair2FeaturePair();
        List<FeaturePair> featurePairList = servicePair2FeaturePair.get(pair);
        TcpDefendPolicyForm tcpForm = form.getTcpDefendPolicyForm();
        Long zoneId = pair.getZoneId();
        if (!this.isFeatureDeployed(zoneId, deviceId = pair.getDeviceId(), tcpForm.getClass().getSimpleName(), tcpForm.getId()) || isServicesFully.booleanValue()) {
            FeaturePair tcpFeaturePair = new FeaturePair(zoneId, deviceId, tcpForm.getClass().getSimpleName(), tcpForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(tcpFeaturePair);
            if (null == featureStaus && !this.hasTcpConfig(tcpForm) && !this.hasTcpConfigOnPortService(tcpForm, isSupportPortService) && tcpForm.getDirection() == 1) {
                return;
            }
            ServiceTcpDefendData tcp = new ServiceTcpDefendData(tcpForm, tcpForm.getClass().getSimpleName(), tcpForm.getId(), form);
            tcp.setCmdViewList(this.buildView4Service(deviceId, zoneId, form.getPkid(), form.getProtocol()));
            features.add(tcp);
            FeaturePair featurePair = new FeaturePair(zoneId, deviceId, tcp.getFeatureType(), tcp.getFeatureId());
            featurePairList.add(featurePair);
        }
    }

    private boolean hasNfaConfig(NfaPolicyEditForm nfaForm) {
        List<NfaPolicyForm> nfaPolicyForms = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(nfaForm);
        boolean hostTotalEnable = false;
        boolean tcpAckFloodEnable = false;
        boolean tcpSynFloodEnable = false;
        boolean tcpFragmentFloodEnable = false;
        boolean tcpRstFinFloodEnable = false;
        boolean tcpAbnormalFloodEnable = false;
        boolean udpFloodEnable = false;
        boolean udpFragmentFloodEnable = false;
        boolean dnsQueryFloodEnable = false;
        boolean dnsReplyFloodEnable = false;
        boolean httpFloodEnable = false;
        boolean httpsFloodEnable = false;
        boolean sipFloodEnable = false;
        boolean icmpFloodEnable = false;
        boolean otherFloodEnable = false;
        boolean darkIpEnable = false;
        for (NfaPolicyForm nfaPolicyForm : nfaPolicyForms) {
            String value;
            switch (value = nfaPolicyForm.getName()) {
                case "Host_Traffic_Overflow": {
                    hostTotalEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Tcp_Ack_Flood": {
                    tcpAckFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Tcp_Syn_Flood": {
                    tcpSynFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Tcp_Fragment_Flood": {
                    tcpFragmentFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Tcp_RstFin_Flood": {
                    tcpRstFinFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Tcp_Malformed_Flood": {
                    tcpAbnormalFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Udp_Flood": {
                    udpFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Udp_Fragment_Flood": {
                    udpFragmentFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Dns_Query_Flood": {
                    dnsQueryFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Dns_Reply_Flood": {
                    dnsReplyFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Http_Flood": {
                    httpFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Https_Flood": {
                    httpsFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Sip_Flood": {
                    sipFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Icmp_Flood": {
                    icmpFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Other_Flood": {
                    otherFloodEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
                case "Dark_Ip": {
                    darkIpEnable = nfaPolicyForm.getEnable() == null ? false : nfaPolicyForm.getEnable();
                    break;
                }
            }
        }
        return !(nfaForm.getDirection() == 1 ? this.flag(hostTotalEnable, tcpAckFloodEnable, tcpSynFloodEnable, tcpFragmentFloodEnable, tcpRstFinFloodEnable) && this.flag2(tcpAbnormalFloodEnable, udpFloodEnable, udpFragmentFloodEnable, dnsQueryFloodEnable, dnsReplyFloodEnable) && this.flag3(httpFloodEnable, httpsFloodEnable, sipFloodEnable, icmpFloodEnable, otherFloodEnable) && !darkIpEnable : nfaForm.getDirection() == 2 && !tcpSynFloodEnable && !tcpFragmentFloodEnable && !udpFloodEnable && !udpFragmentFloodEnable && !icmpFloodEnable);
    }

    private boolean flag(boolean hostTotalEnable, boolean tcpAckFloodEnable, boolean tcpSynFloodEnable, boolean tcpFragmentFloodEnable, boolean tcpRstFinFloodEnable) {
        return hostTotalEnable || tcpAckFloodEnable || tcpSynFloodEnable || tcpFragmentFloodEnable || tcpRstFinFloodEnable;
    }

    private boolean flag2(boolean tcpAbnormalFloodEnable, boolean udpFloodEnable, boolean udpFragmentFloodEnable, boolean dnsQueryFloodEnable, boolean dnsReplyFloodEnable) {
        return tcpAbnormalFloodEnable || udpFloodEnable || udpFragmentFloodEnable || dnsQueryFloodEnable || dnsReplyFloodEnable;
    }

    private boolean flag3(boolean httpFloodEnable, boolean httpsFloodEnable, boolean sipFloodEnable, boolean icmpFloodEnable, boolean otherFloodEnable) {
        return httpFloodEnable || httpsFloodEnable || sipFloodEnable || icmpFloodEnable || otherFloodEnable;
    }

    private boolean hasTcpConfig(TcpDefendPolicyForm tcpForm) {
        if (!(tcpForm.getDirection() != 1 || null != tcpForm.getTcpBlock() && tcpForm.getTcpBlock().booleanValue() || null != tcpForm.getTcpDefendEnable() && tcpForm.getTcpDefendEnable().booleanValue() || null != tcpForm.getTcpLimitEnable() && tcpForm.getTcpLimitEnable().booleanValue())) {
            return false;
        }
        return 2 != tcpForm.getDirection() || null != tcpForm.getSynfloodEnable() && tcpForm.getSynfloodEnable() != false || null != tcpForm.getTcpFragEnable() && tcpForm.getTcpFragEnable() != false;
    }

    private boolean hasTcpConfigOnPortService(TcpDefendPolicyForm tcpForm, Boolean isSupportPortService) {
        if (!isSupportPortService.booleanValue()) {
            return false;
        }
        return null != tcpForm.getSourceLimitEnable() && tcpForm.getSourceLimitEnable() != false || null != tcpForm.getSynratioEnable() && tcpForm.getSynratioEnable() != false || null != tcpForm.getTcpConnEnable() && tcpForm.getTcpConnEnable() != false;
    }

    private List<CmdViewBean> buildView4System() {
        ArrayList<CmdViewBean> list = new ArrayList<CmdViewBean>();
        CmdViewBean view = new CmdViewBean();
        HashMap<String, String> params = new HashMap<String, String>();
        view.setViewName("system");
        view.setViewParams(params);
        list.add(view);
        return list;
    }

    private List<CmdViewBean> buildView4Zone(Long zoneId) {
        List<CmdViewBean> list = this.buildView4System();
        ZoneInfoForm form = this.zoneConfigData.getZoneInfoMap().get(zoneId);
        if (null != form) {
            String zoneName = form.getZoneName();
            CmdViewBean view = new CmdViewBean();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("zoneName", zoneName);
            params.put("zoneType", String.valueOf(form.getZoneType()));
            view.setViewName("zone");
            view.setViewParams(params);
            list.add(view);
        } else {
            this.logger.error((Object)("can not find object in ZoneInfoMap with zoneId:" + zoneId));
        }
        return list;
    }

    private List<CmdViewBean> buildView4UserDefineService(Long zoneId, Long serviceId) {
        List<CmdViewBean> list = this.buildView4Zone(zoneId);
        ZoneServiceForm form = this.zoneConfigData.getZoneServiceMap().get(serviceId);
        if (null != form) {
            String serviceName = form.getServiceName();
            CmdViewBean view = new CmdViewBean();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("serviceName", serviceName);
            view.setViewName("portService");
            view.setViewParams(params);
            list.add(view);
        } else {
            this.logger.error((Object)("can not find object in ZoneServiceMap with serviceId:" + serviceId));
        }
        return list;
    }

    private List<CmdViewBean> buildView4Service(Long deviceId, Long zoneId, Long serviceId, String serviceProtocol) {
        List<CmdViewBean> list = null;
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
        Boolean isSupportWithServiceViewCustomService = supportAttrs.contains("withServiceViewCustomService");
        list = serviceProtocol.endsWith("DEFAULT") || isSupportWithServiceViewCustomService == false ? this.buildView4Zone(zoneId) : this.buildView4UserDefineService(zoneId, serviceId);
        return list;
    }

    public List<ZoneModifyDetailForm> initModifiedData(ZoneConfigData zoneConfigDatas, Long zoneId) {
        this.zoneConfigData = zoneConfigDatas;
        this.calcZoneConfigCrc(null, null);
        this.calcFeatureCrc(null, null);
        List<ZoneModifyDetailForm> zoneModifyDetailForms = this.getModifyDetail(zoneId);
        return zoneModifyDetailForms;
    }

    private List<ZoneModifyDetailForm> getModifyDetail(Long zoneId) {
        if (null == zoneId) {
            return null;
        }
        ArrayList<ZoneModifyDetailForm> zoneModifyDetailForms = new ArrayList<ZoneModifyDetailForm>();
        ZoneInfoForm zoneInfoForm = this.zoneConfigData.getZoneInfoMap().get(zoneId);
        List<Long> deviceIds = this.zoneConfigData.getZoneID2DeviceIdsMap().get(zoneId);
        if (null == deviceIds || deviceIds.isEmpty()) {
            return null;
        }
        for (Long deviceId : deviceIds) {
            ZoneModifyDetailForm modifyDetailForm;
            ZonePolicyApplyForm zonePolicy;
            ZoneModifyDetailForm modifyDetailForm2;
            IAticDeviceService aticDeviceService = ZoneReferUtil.getFirewallService();
            AticDevice device = aticDeviceService.getDeviceByMoid(deviceId.longValue());
            if (null == device) {
                ZoneModifyDetailForm modifyDetailForm3 = new ZoneModifyDetailForm();
                modifyDetailForm3.setModifyObjName("");
                modifyDetailForm3.setDeviceName("unknown");
                modifyDetailForm3.setDeviceIp("unknown");
                modifyDetailForm3.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zonepolicy.nfapolicy.changed");
                zoneModifyDetailForms.add(modifyDetailForm3);
                continue;
            }
            boolean isNfaDevice = false;
            if (device.getDeviceType() == 8 || device.getDeviceType() == 9) {
                isNfaDevice = true;
            }
            if (null != zoneInfoForm && this.isFeatureChanged(zoneId, deviceId, zoneInfoForm.getClass().getSimpleName(), zoneId).booleanValue() && !isNfaDevice) {
                modifyDetailForm2 = new ZoneModifyDetailForm();
                modifyDetailForm2.setModifyObjName("");
                modifyDetailForm2.setDeviceName(device.getName());
                modifyDetailForm2.setDeviceIp(device.getIpAddress());
                modifyDetailForm2.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.basic.info.changed");
                zoneModifyDetailForms.add(modifyDetailForm2);
            }
            if (null != zoneInfoForm && this.isFeatureChanged(zoneId, deviceId, ZoneIpForm.class.getSimpleName(), zoneId).booleanValue()) {
                modifyDetailForm2 = new ZoneModifyDetailForm();
                modifyDetailForm2.setModifyObjName("");
                modifyDetailForm2.setDeviceName(device.getName());
                modifyDetailForm2.setDeviceIp(device.getIpAddress());
                modifyDetailForm2.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.ip.changed");
                zoneModifyDetailForms.add(modifyDetailForm2);
            }
            if (null != zoneInfoForm && this.isFeatureChanged(zoneId, deviceId, ZonePortMapForm.class.getSimpleName(), zoneId).booleanValue() && !isNfaDevice) {
                modifyDetailForm2 = new ZoneModifyDetailForm();
                modifyDetailForm2.setModifyObjName("");
                modifyDetailForm2.setDeviceName(device.getName());
                modifyDetailForm2.setDeviceIp(device.getIpAddress());
                modifyDetailForm2.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.portMap.changed");
                zoneModifyDetailForms.add(modifyDetailForm2);
            }
            if (null != (zonePolicy = this.zoneConfigData.getZoneBasicInfoMap().get(zoneId)) && this.isFeatureChanged(zoneId, deviceId, zonePolicy.getClass().getSimpleName(), zoneId).booleanValue()) {
                modifyDetailForm = new ZoneModifyDetailForm();
                modifyDetailForm.setModifyObjName("");
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
                modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zonepolicy.basic.info.changed");
                zoneModifyDetailForms.add(modifyDetailForm);
            }
            if (this.isFeatureChanged(zoneId, deviceId, ZoneIpLocationForm.class.getSimpleName(), zoneId).booleanValue() && !isNfaDevice) {
                modifyDetailForm = new ZoneModifyDetailForm();
                modifyDetailForm.setModifyObjName("");
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
                modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zonepolicy.zoneiplocation.info.changed");
                zoneModifyDetailForms.add(modifyDetailForm);
            }
            if (this.isFeatureChanged(zoneId, deviceId, ZoneBlackWhiteForm.class.getSimpleName(), zoneId).booleanValue() && !isNfaDevice) {
                modifyDetailForm = new ZoneModifyDetailForm();
                modifyDetailForm.setModifyObjName("");
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
                modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zonepolicy.blacklist.info.changed");
                zoneModifyDetailForms.add(modifyDetailForm);
            }
            if (this.isFeatureChanged(zoneId, deviceId, ZoneWhiteForm.class.getSimpleName(), zoneId).booleanValue() && !isNfaDevice) {
                modifyDetailForm = new ZoneModifyDetailForm();
                modifyDetailForm.setModifyObjName("");
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
                modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zonepolicy.bypass.info.changed");
                zoneModifyDetailForms.add(modifyDetailForm);
            }
            DdosDevCapabilityServiceImpl ddosCapService = DdosDevCapabilityServiceImpl.getInstance();
            DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
            Set supportAttrs = ddosCapService.getAllSupportedAttr(devTypeInfo);
            Boolean withServiceViewCustomService = supportAttrs.contains("withServiceViewCustomService");
            if (null != devTypeInfo && (withServiceViewCustomService.booleanValue() || isNfaDevice) && this.isFeatureChanged(zoneId, deviceId, FilterForm.class.getSimpleName(), zoneId).booleanValue()) {
                this.getZoneFilterChanged(zoneModifyDetailForms, device);
            }
            this.getZoneServiceDeleted(deviceId, zoneId, zoneModifyDetailForms, device);
            this.getZoneServiceFeature(deviceId, zoneId, zoneModifyDetailForms, device);
        }
        return zoneModifyDetailForms;
    }

    private void getZoneFilterChanged(List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
        modifyDetailForm.setModifyObjName("");
        if (null == device) {
            modifyDetailForm.setDeviceName("unknown");
            modifyDetailForm.setDeviceIp("unknown");
        } else {
            modifyDetailForm.setDeviceName(device.getName());
            modifyDetailForm.setDeviceIp(device.getIpAddress());
        }
        modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zonepolicy.zonefilter.info.changed");
        zoneModifyDetailForms.add(modifyDetailForm);
    }

    private void getZoneServiceFeature(Long deviceId, Long zoneId, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Map<Long, List<Long>> zoneId2ServiceIdsMap = this.zoneConfigData.getZoneId2ServiceIdsMap();
        List<Long> serviceIdList = zoneId2ServiceIdsMap.get(zoneId);
        if (null == serviceIdList) {
            return;
        }
        for (Long serviceId : serviceIdList) {
            ZoneServiceForm zoneServieForm = this.zoneConfigData.getZoneServiceMap().get(serviceId);
            if (null == zoneServieForm) continue;
            AticDevice aticDevice = ZoneReferUtil.getFirewallService().getDeviceByMoid(zoneServieForm.getDeviceId().longValue());
            ArrayList<Long> bingDevice = new ArrayList<Long>();
            if (aticDevice.getDeviceType() == 9) {
                IClusterService clusterService = (IClusterService)ServiceContext.getInstance().getService("clusterService", IClusterService.class);
                List nfaClusters = clusterService.getBindNfaDevice(Long.valueOf(aticDevice.getMoId()));
                for (AticDeviceNfaCluster cluster : nfaClusters) {
                    bingDevice.add(cluster.getDeviceId());
                }
                if (!bingDevice.contains(deviceId)) {
                    continue;
                }
            } else if (!deviceId.equals(zoneServieForm.getDeviceId())) continue;
            if (!this.isServiceChanged(zoneServieForm.getPkid()).booleanValue()) continue;
            this.getServiceIpFeature(zoneServieForm, zoneModifyDetailForms, device);
            this.getServicePolicyChangedFeatures(zoneServieForm, zoneModifyDetailForms, device);
        }
    }

    private void getServicePolicyChangedFeatures(ZoneServiceForm form, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Long deviceId = form.getDeviceId();
        Map<String, List<String>> serviceType2Policys = ZoneServiceForm.getService2policy();
        List<String> policys = serviceType2Policys.get(form.getProtocol());
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
        Boolean isSupportPortService = supportAttrs.contains("isSupportPortService");
        if (this.hasNfaFeature(policys, form).booleanValue()) {
            this.getNfaPolicyChanged(form, zoneModifyDetailForms, device);
        }
        if (this.hasTcpFeature(policys, form).booleanValue()) {
            this.getTcpPolicyChanged(form, zoneModifyDetailForms, device, isSupportPortService);
        }
        if (this.hasUdpFeature(policys, form).booleanValue()) {
            this.getUdpPolicyChanged(form, zoneModifyDetailForms, device);
        }
        if (policys.contains("ICMP")) {
            this.getIcmpPolicyChanged(form, zoneModifyDetailForms, device);
        }
        if (this.hasHttpFeature(policys, form)) {
            this.getHttpPolicyChanged(form, zoneModifyDetailForms, device);
        }
        if (this.hasHttpsFeature(policys, form)) {
            this.getHttpsPolicyChanged(form, zoneModifyDetailForms, device);
        }
        if (this.hasDnsFeature(policys, form)) {
            this.getDnsPolicyChanged(form, zoneModifyDetailForms, device);
        }
        if (this.hasSipPolicyFeature(policys, form).booleanValue()) {
            this.getSipPolicyChanged(form, zoneModifyDetailForms, device);
        }
        if (policys.contains("Other")) {
            this.getOtherPolicyChanged(form, zoneModifyDetailForms, device);
        }
        if (policys.contains("TOPNSTUDY")) {
            this.getTopnStudyChanged(form, zoneModifyDetailForms, device);
        }
    }

    private void getTopnStudyChanged(ZoneServiceForm form, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Long deviceId;
        TopNStudyForm topnForm = form.getTopNStudyForm();
        if (null == topnForm) {
            return;
        }
        Long zoneId = form.getZoneId();
        if (this.isFeatureChanged(zoneId, deviceId = form.getDeviceId(), topnForm.getClass().getSimpleName(), topnForm.getId()).booleanValue()) {
            FeaturePair topnFeaturePair = new FeaturePair(zoneId, deviceId, topnForm.getClass().getSimpleName(), topnForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(topnFeaturePair);
            if (null == featureStaus && !this.hasTopnConfig(topnForm)) {
                return;
            }
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(form.getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.topnstudy.changed");
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    private boolean hasTopnConfig(TopNStudyForm topnForm) {
        return null != topnForm.getHttpHostEnable() || null != topnForm.getHttpUriEnable() || null != topnForm.getHttpSrcIpEnable() || null != topnForm.getDnsQueryDomainEnable() || null != topnForm.getTopnCacheEnable() || null != topnForm.getDnsQuerySrcIpEnable() || null != topnForm.getHttpsEnable() || null != topnForm.getSipSrcIpEnable() || null != topnForm.getSipCalleeEnable() || null != topnForm.getSipCallerEnable() || null != topnForm.getTcpNewConnEnable();
    }

    private void getOtherPolicyChanged(ZoneServiceForm form, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Long deviceId;
        OtherDefendPolicyForm otherForm = form.getOtherDefendPolicyForm();
        if (null == otherForm) {
            return;
        }
        Long zoneId = form.getZoneId();
        if (this.isFeatureChanged(zoneId, deviceId = form.getDeviceId(), otherForm.getClass().getSimpleName(), otherForm.getId()).booleanValue()) {
            FeaturePair otherFeaturePair = new FeaturePair(zoneId, deviceId, otherForm.getClass().getSimpleName(), otherForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(otherFeaturePair);
            if (null == featureStaus && !this.hasOtherConfig(otherForm)) {
                return;
            }
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(form.getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.other.changed");
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    private void getSipPolicyChanged(ZoneServiceForm form, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Long deviceId;
        SipDefendPolicyForm sipForm = form.getSipDefendPolicyForm();
        if (null == sipForm) {
            return;
        }
        Long zoneId = form.getZoneId();
        if (this.isFeatureChanged(zoneId, deviceId = form.getDeviceId(), sipForm.getClass().getSimpleName(), sipForm.getId()).booleanValue()) {
            FeaturePair sipFeaturePair = new FeaturePair(zoneId, deviceId, sipForm.getClass().getSimpleName(), sipForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(sipFeaturePair);
            if (null == featureStaus && !this.hasSipConfig(sipForm)) {
                return;
            }
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(form.getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.sip.changed");
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    private void getDnsPolicyChanged(ZoneServiceForm form, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Long deviceId;
        DnsDefendPolicyForm dnsForm = form.getDnsDefendPolicyForm();
        if (null == dnsForm) {
            return;
        }
        Long zoneId = form.getZoneId();
        if (this.isFeatureChanged(zoneId, deviceId = form.getDeviceId(), dnsForm.getClass().getSimpleName(), dnsForm.getId()).booleanValue()) {
            FeaturePair dnsFeaturePair = new FeaturePair(zoneId, deviceId, dnsForm.getClass().getSimpleName(), dnsForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(dnsFeaturePair);
            if (null == featureStaus && !this.hasDnsConfig(dnsForm)) {
                return;
            }
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(form.getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.dns.changed");
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    private void getHttpsPolicyChanged(ZoneServiceForm form, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Long deviceId;
        HttpsDefendPolicyForm httpsForm = form.getHttpsDefendPolicyForm();
        if (null == httpsForm) {
            return;
        }
        Long zoneId = form.getZoneId();
        if (this.isFeatureChanged(zoneId, deviceId = form.getDeviceId(), httpsForm.getClass().getSimpleName(), httpsForm.getId()).booleanValue()) {
            FeaturePair httpsFeaturePair = new FeaturePair(zoneId, deviceId, httpsForm.getClass().getSimpleName(), httpsForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(httpsFeaturePair);
            if (null == featureStaus && !this.hasHttpsConfig(httpsForm)) {
                return;
            }
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(form.getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.https.changed");
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    private void getHttpPolicyChanged(ZoneServiceForm form, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Long deviceId;
        HttpDefendPolicyForm httpForm = form.getHttpDefendPolicyForm();
        if (null == httpForm) {
            return;
        }
        Long zoneId = form.getZoneId();
        if (this.isFeatureChanged(zoneId, deviceId = form.getDeviceId(), httpForm.getClass().getSimpleName(), httpForm.getId()).booleanValue()) {
            FeaturePair httpFeaturePair = new FeaturePair(zoneId, deviceId, httpForm.getClass().getSimpleName(), httpForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(httpFeaturePair);
            if (null == featureStaus && !this.hasHttpConfig(httpForm)) {
                return;
            }
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(form.getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.http.changed");
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    private void getIcmpPolicyChanged(ZoneServiceForm form, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Long deviceId;
        IcmpDefendPolicyForm icmpForm = form.getIcmpDefendPolicyForm();
        if (null == icmpForm) {
            return;
        }
        Long zoneId = form.getZoneId();
        if (this.isFeatureChanged(zoneId, deviceId = form.getDeviceId(), icmpForm.getClass().getSimpleName(), icmpForm.getId()).booleanValue()) {
            FeaturePair icmpFeaturePair = new FeaturePair(zoneId, deviceId, icmpForm.getClass().getSimpleName(), icmpForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(icmpFeaturePair);
            if (null == featureStaus && !this.hasIcmpConfig(icmpForm)) {
                return;
            }
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(form.getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.icmp.changed");
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    private void getUdpPolicyChanged(ZoneServiceForm form, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Long deviceId;
        UdpDefendPolicyForm udpForm = form.getUdpDefendPolicyForm();
        if (null == udpForm) {
            return;
        }
        Long zoneId = form.getZoneId();
        if (this.isFeatureChanged(zoneId, deviceId = form.getDeviceId(), udpForm.getClass().getSimpleName(), udpForm.getId()).booleanValue()) {
            FeaturePair udpFeaturePair = new FeaturePair(zoneId, deviceId, udpForm.getClass().getSimpleName(), udpForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(udpFeaturePair);
            if (null == featureStaus && !this.hasUdpConfig(udpForm)) {
                return;
            }
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(form.getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.udp.changed");
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    private void getNfaPolicyChanged(ZoneServiceForm form, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Long deviceId;
        NfaPolicyEditForm nfaForm = form.getNfaPolicyEditForm();
        if (null == nfaForm) {
            return;
        }
        Long zoneId = form.getZoneId();
        if (this.isFeatureChanged(zoneId, deviceId = form.getDeviceId(), nfaForm.getClass().getSimpleName(), form.getPkid()).booleanValue()) {
            FeaturePair pair = new FeaturePair(zoneId, deviceId, nfaForm.getClass().getSimpleName(), form.getPkid());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(pair);
            if (null == featureStaus && !this.hasNfaConfig(nfaForm)) {
                return;
            }
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(form.getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.nfapolicy.changed");
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    private void getTcpPolicyChanged(ZoneServiceForm form, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device, Boolean isSupportPortService) {
        Long deviceId;
        TcpDefendPolicyForm tcpForm = form.getTcpDefendPolicyForm();
        if (null == tcpForm) {
            return;
        }
        Long zoneId = form.getZoneId();
        if (this.isFeatureChanged(zoneId, deviceId = form.getDeviceId(), tcpForm.getClass().getSimpleName(), tcpForm.getId()).booleanValue()) {
            FeaturePair tcpFeaturePair = new FeaturePair(zoneId, deviceId, tcpForm.getClass().getSimpleName(), tcpForm.getId());
            ZoneFeatureStatusInfo featureStaus = this.zoneConfigData.getZoneFeatureStatusMap().get(tcpFeaturePair);
            if (null == featureStaus && !this.hasTcpConfig(tcpForm) && !this.hasTcpConfigOnPortService(tcpForm, isSupportPortService)) {
                return;
            }
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(form.getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            if (null != form.getPortType() && isSupportPortService.booleanValue()) {
                modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.portService.defend.changed");
            } else {
                modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.tcp.changed");
            }
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    private void getServiceIpFeature(ZoneServiceForm zoneServieForm, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        Long zoneId = zoneServieForm.getZoneId();
        Long deviceId = zoneServieForm.getDeviceId();
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(deviceId);
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
        Boolean isSupportPortService = supportAttrs.contains("isSupportPortService");
        Long serviceId = zoneServieForm.getPkid();
        if (isSupportPortService.booleanValue() && !"DEFAULT".equals(zoneServieForm.getProtocol()) && this.isFeatureChanged(zoneId, deviceId, ZoneServiceForm.class.getSimpleName(), serviceId).booleanValue()) {
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(zoneServieForm.getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.basic.info.changed");
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    private Boolean isServiceChanged(Long featureId) {
        Long serviceToDeployCrc;
        Boolean flag = false;
        Long serviceDeployedCrc = this.zoneConfigData.getServiceId2CrcDeployedMap().get(featureId);
        if (!serviceDeployedCrc.equals(serviceToDeployCrc = this.zoneConfigData.getServiceId2CrcToDeployMap().get(featureId))) {
            flag = true;
        }
        return flag;
    }

    private void getZoneServiceDeleted(Long deviceId, Long zoneId, List<ZoneModifyDetailForm> zoneModifyDetailForms, AticDevice device) {
        ZonePair pair = new ZonePair(deviceId, zoneId);
        Map<ServicePair, ZoneServiceForm> zoneServiceToUndeploy = this.zoneConfigData.getZoneServiceToUndeploy();
        for (Map.Entry<ServicePair, ZoneServiceForm> servicePair : zoneServiceToUndeploy.entrySet()) {
            ZonePair temp = new ZonePair(servicePair.getKey().getDeviceId(), servicePair.getKey().getZoneId());
            if (!temp.equals(pair) || "DEFAULT".equals(servicePair.getValue().getProtocol())) continue;
            ZoneModifyDetailForm modifyDetailForm = new ZoneModifyDetailForm();
            modifyDetailForm.setModifyObjName(servicePair.getValue().getServiceName());
            if (null == device) {
                modifyDetailForm.setDeviceName("unknown");
                modifyDetailForm.setDeviceIp("unknown");
            } else {
                modifyDetailForm.setDeviceName(device.getName());
                modifyDetailForm.setDeviceIp(device.getIpAddress());
            }
            modifyDetailForm.setModifyDetail("com.hs.vsm.secservice.ddos.policy.zone.service.deleted");
            zoneModifyDetailForms.add(modifyDetailForm);
        }
    }

    public Map<String, String> getRequestMap() {
        return this.requestMap;
    }

    public void setRequestMap(Map<String, String> requestMap) {
        this.requestMap = requestMap;
    }
}

