/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import com.hs.vsm.secservice.ddos.model.HttpFilterInfo;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterDstIpData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = 8833480268946061732L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private FilterInfo filterInfo;
    private List<HttpFilterInfo> filterPolicyInfoList;

    public FilterDstIpData(String featureType, Long featureId, FilterInfo filterInfo, List<HttpFilterInfo> filterPolicyInfoList) {
        this.setFeatureId(featureId);
        this.setFeatureType(featureType);
        this.setFilterInfo(filterInfo);
        this.setFilterPolicyInfoList(filterPolicyInfoList);
    }

    private List<String> doDeployTranslate(LogicDev logicDev, boolean isDeploy) {
        Long deviceId = logicDev.getDeviceId();
        ArrayList<CmdParam> cmdParamList = new ArrayList<CmdParam>();
        this.systemViewParam(cmdParamList);
        if (isDeploy) {
            this.filterViewPram(cmdParamList);
            this.createFilterPolicy(cmdParamList);
        } else {
            this.filterViewPram(cmdParamList);
            this.createUndoFilterDstIpParam(cmdParamList);
        }
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(deviceId);
        List cmdList = tool.doTranslate(cmdFileDir, "filter", cmdParamList);
        return cmdList;
    }

    private void systemViewParam(List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("system");
        cmdParamList.add(cmdParam);
    }

    private void filterViewPram(List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("filter");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", this.filterInfo.getFilterName());
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createFilterPolicy(List<CmdParam> cmdParamList) {
        for (HttpFilterInfo info : this.filterPolicyInfoList) {
            String filterKey = info.getFilterKey();
            if (!filterKey.equals("destination-ip")) continue;
            this.createKeyDestinationIp(info, cmdParamList);
        }
    }

    private void createKeyDestinationIp(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("destination-ip");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("/");
        String ip = content[0];
        String mask = content[1];
        if (IPUtil.isIpv4((String)ip)) {
            paramMap.put("ip", ip);
            paramMap.put("mask", mask);
        } else if (IPUtil.isIpv6((String)ip)) {
            paramMap.put("ipv6", ip);
            paramMap.put("mask", mask);
        }
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createUndoFilterDstIpParam(List<CmdParam> cmdParamList) {
        for (HttpFilterInfo httpFilterInfo : this.filterPolicyInfoList) {
            this.createUndoKeyDestinationIp(httpFilterInfo, cmdParamList);
        }
    }

    private void createUndoKeyDestinationIp(HttpFilterInfo info, List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("destination-ip");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] content = info.getFilterContent().split("/");
        String ip = content[0];
        String mask = content[1];
        paramMap.put("undo", "undo");
        if (IPUtil.isIpv4((String)ip)) {
            paramMap.put("ip", ip);
            paramMap.put("mask", mask);
        } else if (IPUtil.isIpv6((String)ip)) {
            paramMap.put("ipv6", ip);
            paramMap.put("mask", mask);
        }
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmdList = this.doDeployTranslate(logicDev, true);
        logger.info((Object)("deploy filter, filter id : " + this.filterInfo.getPkid() + ", device id : " + logicDev.getDeviceId() + " cmd list :" + this.getcleanedMessage(cmdList.toString())));
        List<String> execCmds = CmdUtil.execCmds(logicDev.getDeviceId(), cmdList);
        return execCmds;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        List<String> cmdList = this.doDeployTranslate(logicDev, false);
        logger.info((Object)("deploy filter, filter id : " + this.filterInfo.getPkid() + ", device id : " + logicDev.getDeviceId() + " cmd list :" + this.getcleanedMessage(cmdList.toString())));
        List<String> execCmds = CmdUtil.execCmds(logicDev.getDeviceId(), cmdList);
        return execCmds;
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public List<HttpFilterInfo> getFilterPolicyInfoList() {
        return this.filterPolicyInfoList;
    }

    public void setFilterPolicyInfoList(List<HttpFilterInfo> filterPolicyInfoList) {
        this.filterPolicyInfoList = filterPolicyInfoList;
    }
}

