/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterZoneData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = 6902038552149604753L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private FilterInfo filterInfo;
    private ZoneInfoForm zoneInfoForm;
    private Long preference;
    private int direction;

    public FilterZoneData(String featureType, Long featureId, FilterInfo filterInfo, ZoneInfoForm zoneInfoForm, int direction) {
        this.setFeatureId(featureId);
        this.setFeatureType(featureType);
        this.setFilterInfo(filterInfo);
        this.setZoneInfoForm(zoneInfoForm);
        this.setDirection(direction);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmdList = this.doDeployTranslate(logicDev.getDeviceId());
        logger.info((Object)("deploy filtezone, filter id : " + this.filterInfo.getPkid() + ", device id : " + logicDev.getDeviceId() + ", zone id : " + this.zoneInfoForm.getZoneId() + " cmd list :" + this.getcleanedMessage(cmdList.toString())));
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmdList);
        logger.info((Object)("deploy filtezone, filter id : " + this.filterInfo.getPkid() + ", device id : " + logicDev.getDeviceId() + ", zone id : " + this.zoneInfoForm.getZoneId() + " result list :" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private List<String> doDeployTranslate(Long deviceId) {
        List<CmdParam> cmdParamList = this.createCmdParamList(true);
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(deviceId);
        List cmdList = tool.doTranslate(cmdFileDir, "filter", cmdParamList);
        return cmdList;
    }

    private List<CmdParam> createCmdParamList(boolean isDeploy) {
        ArrayList<CmdParam> cmdParamList = new ArrayList<CmdParam>();
        this.createSystemViewParam(cmdParamList);
        if (this.zoneInfoForm.getZoneId() == 0L) {
            this.createFilterDeviceParam(cmdParamList, isDeploy);
        } else {
            this.createZoneViewParam(cmdParamList);
            this.createFilterZoneParam(cmdParamList, isDeploy);
        }
        return cmdParamList;
    }

    private void createFilterDeviceParam(List<CmdParam> cmdParamList, boolean isDeploy) {
        if (this.filterInfo.getDirection() == 1) {
            CmdParam cmdParam = new CmdParam();
            cmdParam.setCmdID("apply");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("name", this.filterInfo.getFilterName());
            if (isDeploy) {
                paramMap.put("preference", this.filterInfo.getPreference().toString());
            } else {
                paramMap.put("undo", "undo");
            }
            cmdParam.setParams(paramMap);
            cmdParamList.add(cmdParam);
        }
    }

    private void createFilterZoneParam(List<CmdParam> cmdParamList, boolean isDeploy) {
        if (this.direction == 2) {
            CmdParam cmdParam = new CmdParam();
            cmdParam.setCmdID("applyOutbound");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("name", this.filterInfo.getFilterName());
            if (isDeploy) {
                paramMap.put("preference", this.preference.toString());
            } else {
                paramMap.put("undo", "undo");
            }
            cmdParam.setParams(paramMap);
            cmdParamList.add(cmdParam);
        } else {
            CmdParam cmdParam = new CmdParam();
            cmdParam.setCmdID("apply");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("name", this.filterInfo.getFilterName());
            if (isDeploy) {
                paramMap.put("preference", this.preference.toString());
            } else {
                paramMap.put("undo", "undo");
            }
            cmdParam.setParams(paramMap);
            cmdParamList.add(cmdParam);
        }
    }

    private void createZoneViewParam(List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("zone");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (Constant.ZONE_TYPE_OF_DEFAULT.equals(this.zoneInfoForm.getZoneType())) {
            paramMap.put("default", "default");
        } else {
            paramMap.put("zoneName", this.zoneInfoForm.getZoneName());
        }
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createSystemViewParam(List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("system");
        cmdParamList.add(cmdParam);
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        List<String> cmdList = this.doUnDeployTranslate(logicDev.getDeviceId());
        logger.info((Object)("undeploy filtezone, filter id : " + this.filterInfo.getPkid() + ", device id : " + logicDev.getDeviceId() + ", zone id : " + this.zoneInfoForm.getZoneId() + " result list :" + this.getcleanedMessage(cmdList.toString())));
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmdList);
        logger.info((Object)("undeploy filtezone, filter id : " + this.filterInfo.getPkid() + ", device id : " + logicDev.getDeviceId() + ", zone id : " + this.zoneInfoForm.getZoneId() + " result list :" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private List<String> doUnDeployTranslate(Long deviceId) {
        List<CmdParam> cmdParamList = this.createCmdParamList(false);
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(deviceId);
        List cmdList = tool.doTranslate(cmdFileDir, "filter", cmdParamList);
        return cmdList;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public ZoneInfoForm getZoneInfoForm() {
        return this.zoneInfoForm;
    }

    public void setZoneInfoForm(ZoneInfoForm zoneInfoForm) {
        this.zoneInfoForm = zoneInfoForm;
    }

    public Long getPreference() {
        return this.preference;
    }

    public void setPreference(Long preference) {
        this.preference = preference;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

