/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.model.NPFilterInfo;
import com.hs.vsm.secservice.ddos.model.NPFilterRuleInfo;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NPFilterData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = 6902038552149604753L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private NPFilterInfo npFilterInfo;
    private NPFilterRuleInfo npFilterRuleInfo;

    public NPFilterData(NPFilterInfo npFilterInfo, NPFilterRuleInfo npFilterRuleInfo) {
        this.setNpFilterInfo(npFilterInfo);
        this.setNpFilterRuleInfo(npFilterRuleInfo);
    }

    public NPFilterData(NPFilterInfo npFilterInfo) {
        this.setNpFilterInfo(npFilterInfo);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmdList = this.doDeployTranslate(logicDev, true);
        this.setCmds(cmdList);
        logger.info((Object)("NPFilter -> deploy NPFilter, filter id : " + this.npFilterInfo.getId() + ", device id : " + logicDev.getDeviceId() + " cmd list :" + this.getcleanedMessage(cmdList.toString())));
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmdList);
        logger.info((Object)("NPFilter -> deploy NPFilter, filter id : " + this.npFilterInfo.getId() + ", device id : " + logicDev.getDeviceId() + " result list :" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private List<String> doDeployTranslate(LogicDev logicDev, boolean isDeploy) {
        Long deviceId = logicDev.getDeviceId();
        ArrayList<CmdParam> cmdParamList = new ArrayList<CmdParam>();
        this.systemViewParam(cmdParamList);
        if (isDeploy) {
            this.createNPFilter(cmdParamList);
        } else {
            this.createUndoNPFilter(cmdParamList);
        }
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(deviceId);
        List cmdList = tool.doTranslate(cmdFileDir, "npfilter", cmdParamList);
        return cmdList;
    }

    private void systemViewParam(List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("system");
        cmdParamList.add(cmdParam);
    }

    private void createNPFilter(List<CmdParam> cmdParamList) {
        String sourcePort;
        String destinationPort;
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("npfilter");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("filterIndex", String.valueOf(this.npFilterInfo.getFilterIndex()));
        if ("IPV6".equals(this.npFilterInfo.getIpType())) {
            paramMap.put("ipType", this.npFilterInfo.getIpType().toLowerCase(Locale.US));
        }
        if ("NUMBER".equals(this.npFilterInfo.getProtocolType())) {
            paramMap.put("protocol", String.valueOf(this.npFilterInfo.getProtocolNumber()));
        } else {
            paramMap.put("protocol", this.npFilterInfo.getProtocolType().toLowerCase(Locale.US));
        }
        if (null == this.npFilterInfo.getFilterAlert() || 0 == this.npFilterInfo.getFilterAction()) {
            paramMap.put("filterAlert", "0");
        } else {
            paramMap.put("filterAlert", String.valueOf(this.npFilterInfo.getFilterAlert()));
        }
        if (null != this.npFilterRuleInfo.getDestinationIp()) {
            String[] ipAndMask = this.npFilterRuleInfo.getDestinationIp().split("/");
            paramMap.put("destinationIp", ipAndMask[0]);
            paramMap.put("destinationMask", ipAndMask[1]);
        }
        if (null != (destinationPort = this.npFilterRuleInfo.getDestinationPort())) {
            if (StringUtils.isNumeric((CharSequence)destinationPort)) {
                paramMap.put("destinationPort", destinationPort);
            } else {
                String[] startAndEndPort = destinationPort.split("-");
                paramMap.put("destinationStartPort", startAndEndPort[0]);
                paramMap.put("destinationEndPort", startAndEndPort[1]);
            }
        }
        if (null != this.npFilterRuleInfo.getSourceIp() && !"IPV6".equals(this.npFilterInfo.getIpType())) {
            String[] ipAndMask = this.npFilterRuleInfo.getSourceIp().split("/");
            paramMap.put("sourceIp", ipAndMask[0]);
            paramMap.put("sourceMask", ipAndMask[1]);
        }
        if (null != (sourcePort = this.npFilterRuleInfo.getSourcePort())) {
            if (StringUtils.isNumeric((CharSequence)sourcePort)) {
                paramMap.put("sourcePort", sourcePort);
            } else {
                String[] startAndEndPort = sourcePort.split("-");
                paramMap.put("sourceStartPort", startAndEndPort[0]);
                paramMap.put("sourceEndPort", startAndEndPort[1]);
            }
        }
        if (("TCP".equals(this.npFilterInfo.getProtocolType()) || "NUMBER".equals(this.npFilterInfo.getProtocolType()) && 6 == this.npFilterInfo.getProtocolNumber()) && null != this.npFilterRuleInfo.getTcpFlag()) {
            paramMap.put("tcpFlag", this.npFilterRuleInfo.getTcpFlag());
        }
        if (null != this.npFilterRuleInfo.getPacketStartLength() && null != this.npFilterRuleInfo.getPacketEndLength()) {
            paramMap.put("packetStartLength", String.valueOf(this.npFilterRuleInfo.getPacketStartLength()));
            paramMap.put("packetEndLength", String.valueOf(this.npFilterRuleInfo.getPacketEndLength()));
        }
        if (null != this.npFilterRuleInfo.getFragmentType()) {
            paramMap.put("fragmentType", this.npFilterRuleInfo.getFragmentType());
        }
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    private void createUndoNPFilter(List<CmdParam> cmdParamList) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("undoNPFilter");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("filterIndex", String.valueOf(this.npFilterInfo.getFilterIndex()));
        cmdParam.setParams(paramMap);
        cmdParamList.add(cmdParam);
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        List<String> cmdList = this.doUnDeployTranslate(logicDev, false);
        logger.info((Object)("NPFilter -> undeploy filter, filter id : " + this.npFilterInfo.getId() + ", device id : " + logicDev.getDeviceId() + " cmd list :" + this.getcleanedMessage(cmdList.toString())));
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmdList);
        logger.info((Object)("NPFilter -> undeploy filter, filter id : " + this.npFilterInfo.getId() + ", device id : " + logicDev.getDeviceId() + " result list :" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private List<String> doUnDeployTranslate(LogicDev logicDev, boolean isDeploy) {
        return this.doDeployTranslate(logicDev, false);
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }

    public NPFilterInfo getNpFilterInfo() {
        return this.npFilterInfo;
    }

    public void setNpFilterInfo(NPFilterInfo npFilterInfo) {
        this.npFilterInfo = npFilterInfo;
    }

    public NPFilterRuleInfo getNpFilterRuleInfo() {
        return this.npFilterRuleInfo;
    }

    public void setNpFilterRuleInfo(NPFilterRuleInfo npFilterRuleInfo) {
        this.npFilterRuleInfo = npFilterRuleInfo;
    }
}

