/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDomainCacheForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsStatisticItem;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsTtlCheckForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SourceIpRequestMessageForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SourceIpResponseMessageForm;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceDnsDefendData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = -1619411737151315661L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public ServiceDnsDefendData() {
    }

    public ServiceDnsDefendData(Object obj, String featureType, Long featureId) {
        this.setConfigData(obj);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmds = this.doTranslate(logicDev.getDeviceId());
        logger.info((Object)("device : " + logicDev.getDeviceId() + "to deploy cmds:" + this.getcleanedMessage(cmds.toString())));
        this.setCmds(cmds);
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmds);
        logger.info((Object)("deploy result:" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private List<String> doTranslate(Long moId) {
        List cmds = null;
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        DnsDefendPolicyForm dnsPolicyForm = (DnsDefendPolicyForm)this.getConfigData();
        Map<String, String> params = VsmUtil.getInstance().getObjectFieldAndValues(dnsPolicyForm);
        logger.info((Object)("params in doTranslateDNS : " + this.getcleanedMessage(params.toString())));
        DdosDevCapabilityServiceImpl ddosDevCapaService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(moId);
        Set supportAttrs = ddosDevCapaService.getAllSupportedAttr(devTypeInfo);
        List<DnsDomainCacheForm> dnsDomainCacheForms = dnsPolicyForm.getDnsDomainCacheForms();
        List<SourceIpRequestMessageForm> appointSourceIpRequestMessageForms = dnsPolicyForm.getAppointSourceIpRequestMessageFroms();
        List<SourceIpResponseMessageForm> appointSourceIpResponseMessageForms = dnsPolicyForm.getAppointSourceIpResponseMessageForms();
        List<DnsStatisticItem> dnsStatisticItems = dnsPolicyForm.getDnsStatisticItems();
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        Boolean isDnsView = viewList.size() == Constant.CUSTOM_SERVICE_WITH_SERVICE_VIEW_SIZE.intValue();
        this.dnsBlock(cmdParams, params, isDnsView);
        this.requestAlert(cmdParams, params, isDnsView, devTypeInfo);
        this.replyFloodAlert(cmdParams, params);
        this.noSuchNameCheck(supportAttrs, cmdParams, params);
        this.sourceIpReqLimit(supportAttrs, cmdParams, params, appointSourceIpRequestMessageForms);
        this.sourceIpRespLimit(supportAttrs, cmdParams, params, appointSourceIpResponseMessageForms);
        this.dnsRequestMessageLenLimit(supportAttrs, cmdParams, params, undoMap);
        this.dnsReponseMessageLenLimit(supportAttrs, cmdParams, params, undoMap);
        this.dnsDestoryDefence(supportAttrs, cmdParams, params);
        this.dnsFormatCheck(supportAttrs, cmdParams, params, undoMap);
        this.dnsReflectAttackDefencd(supportAttrs, cmdParams, params, undoMap);
        this.dnsDomainCache(supportAttrs, cmdParams, params, dnsDomainCacheForms);
        this.dnsStatistic(supportAttrs, cmdParams, params, dnsStatisticItems);
        this.dnsTtlCheck(supportAttrs, cmdParams, params, undoMap);
        this.bandWidthLimit(cmdParams, params, isDnsView);
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moId);
        cmds = tool.doTranslate(cmdFileDir, "dns_defend", cmdParams);
        return cmds;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void noSuchNameCheck(Set<String> supportAttrs, List<CmdParam> cmdParams, Map<String, String> params) {
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        if (supportAttrs.contains("withServiceViewCustomService")) {
            CmdParam cmdParam0 = new CmdParam();
            cmdParam0.setCmdID("noSuchNameCheck");
            cmdParam0.setParams(undoMap);
            cmdParams.add(cmdParam0);
            if (!"true".equals(params.get("dnsDefendEnable"))) {
                return;
            }
            if ("true".equals(params.get("noSuchNameCheckEnable"))) {
                CmdParam cmdParam1 = new CmdParam();
                cmdParam1.setCmdID("noSuchNameCheck");
                cmdParam1.setParams(params);
                cmdParams.add(cmdParam1);
            }
        }
    }

    private void bandWidthLimit(List<CmdParam> cmdParams, Map<String, String> params, Boolean isDnsView) {
        if (!isDnsView.booleanValue()) {
            return;
        }
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        CmdParam cmdParam0 = new CmdParam();
        cmdParam0.setCmdID("dnsLimit");
        cmdParam0.setParams(undoMap);
        cmdParams.add(cmdParam0);
        if ("true".equals(params.get("limitEnable"))) {
            CmdParam cmdParam1 = new CmdParam();
            cmdParam1.setCmdID("dnsLimit");
            cmdParam1.setParams(params);
            cmdParams.add(cmdParam1);
        }
    }

    private void dnsfirstPacketCheck(List<CmdParam> cmdParams, Map<String, String> params, boolean isDnsView, boolean hasThreshold) {
        if (!isDnsView) {
            if ("true".equals(params.get("dnsEnable")) && hasThreshold) {
                this.createDns(cmdParams, params);
            } else {
                this.createUndoDns(cmdParams);
            }
        }
    }

    private void createUndoDns(List<CmdParam> cmdParams) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("dnsFirstPacketCheck");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("undo", "undo");
        cmdParam.setParams(paramMap);
        cmdParams.add(cmdParam);
    }

    private void createDns(List<CmdParam> cmdParams, Map<String, String> params) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID("dnsFirstPacketCheck");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("dnsLowerLimit", params.get("dnsLowerLimit"));
        paramMap.put("dnsUpperLimit", params.get("dnsUpperLimit"));
        cmdParam.setParams(paramMap);
        cmdParams.add(cmdParam);
    }

    private void dnsBlock(List<CmdParam> cmdParams, Map<String, String> params, Boolean isDnsView) {
        if (!isDnsView.booleanValue()) {
            return;
        }
        HashMap<String, String> mapUndo = new HashMap<String, String>();
        mapUndo.put("undo", "undo");
        CmdParam cmdParam0 = new CmdParam();
        cmdParam0.setCmdID("drop");
        cmdParam0.setParams(mapUndo);
        cmdParams.add(cmdParam0);
        if ("true".equals(params.get("dnsBlock"))) {
            CmdParam cmdParam1 = new CmdParam();
            cmdParam1.setCmdID("drop");
            cmdParams.add(cmdParam1);
        }
    }

    private void replyFloodAlert(List<CmdParam> cmdParams, Map<String, String> params) {
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        CmdParam cmdParam1 = new CmdParam();
        cmdParam1.setCmdID("replyFloodAlertRate");
        cmdParam1.setParams(undoMap);
        cmdParams.add(cmdParam1);
        if (!"true".equals(params.get("dnsDefendEnable"))) {
            return;
        }
        if ("true".equals(params.get("replyFloodEnable"))) {
            if ("true".equals(params.get("replyFloodSrcDectectEnable"))) {
                CmdParam cmdParam3 = new CmdParam();
                cmdParam3.setCmdID("replyFloodAlertRate");
                cmdParam3.setParams(params);
                cmdParams.add(cmdParam3);
            }
            if ("true".equals(params.get("replyFloodSessCheckEnable"))) {
                CmdParam cmdParam4 = new CmdParam();
                cmdParam4.setCmdID("replyFloodSessionCheck");
                cmdParam4.setParams(params);
                cmdParams.add(cmdParam4);
            }
        }
    }

    private void requestAlert(List<CmdParam> cmdParams, Map<String, String> params, boolean isDnsView, DeviceTypeInfo devTypeInfo) {
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        CmdParam cmdParam0 = new CmdParam();
        cmdParam0.setCmdID("requestAlertRate");
        cmdParam0.setParams(undoMap);
        cmdParams.add(cmdParam0);
        if ("true".equals(params.get("dnsFloodEnable")) && "true".equals(params.get("dnsDefendEnable"))) {
            if (Constant.DNS_FLOOD_DEFENDMODE_BASIC.equals(Integer.valueOf(params.get("defendMode")))) {
                params.put("defendMode", "basic");
                this.dnsfirstPacketCheck(cmdParams, params, isDnsView, true);
            } else if (Constant.DNS_FLOOD_DEFENDMODE_STRENGTHEN.equals(Integer.valueOf(params.get("defendMode")))) {
                params.put("defendMode", "advanced");
            } else if (Constant.DNS_FLOOD_DEFENDMODE_SERVER.equals(Integer.valueOf(params.get("defendMode")))) {
                params.put("defendMode", "auth-ns");
                this.dnsfirstPacketCheck(cmdParams, params, isDnsView, true);
            } else if (Constant.DNS_FLOOD_DEFENDMODE_PASSIVE.equals(Integer.valueOf(params.get("defendMode")))) {
                params.put("defendMode", "passive");
                this.dnsfirstPacketCheck(cmdParams, params, isDnsView, true);
            }
            CmdParam cmdParam0d = new CmdParam();
            cmdParam0d.setCmdID("requestAlertRate");
            cmdParam0d.setParams(params);
            cmdParams.add(cmdParam0d);
        } else if (devTypeInfo.getDevType().startsWith("AntiDDoS12")) {
            this.dnsfirstPacketCheck(cmdParams, params, isDnsView, true);
        } else {
            this.dnsfirstPacketCheck(cmdParams, params, isDnsView, false);
        }
    }

    private void dnsStatistic(Set<String> supportAttrs, List<CmdParam> cmdParams, Map<String, String> params, List<DnsStatisticItem> dnsStatisticItems) {
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        if (supportAttrs.contains("dnsStatisticEnable")) {
            CmdParam cmdParam12 = new CmdParam();
            cmdParam12.setCmdID("detailStatistic");
            cmdParam12.setParams(undoMap);
            cmdParams.add(cmdParam12);
            CmdParam cmdParam13 = new CmdParam();
            cmdParam13.setCmdID("undoAllStatisticReqType");
            cmdParams.add(cmdParam13);
            if ("true".equals(params.get("dnsStatisticEnable"))) {
                CmdParam cmdParam10d = new CmdParam();
                cmdParam10d.setCmdID("detailStatistic");
                cmdParams.add(cmdParam10d);
                for (DnsStatisticItem dnsStatisticItem : dnsStatisticItems) {
                    Map<String, String> statisticReqTypeParams = VsmUtil.getInstance().getObjectFieldAndValues(dnsStatisticItem);
                    CmdParam cmdParam11d = new CmdParam();
                    cmdParam11d.setCmdID("detailStatisticReqType");
                    cmdParam11d.setParams(statisticReqTypeParams);
                    cmdParams.add(cmdParam11d);
                }
            }
        }
    }

    private void dnsDomainCache(Set<String> supportAttrs, List<CmdParam> cmdParams, Map<String, String> params, List<DnsDomainCacheForm> dnsDomainCacheForms) {
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        if (supportAttrs.contains("dnsDomainCacheEnable")) {
            CmdParam cmdParam10 = new CmdParam();
            cmdParam10.setCmdID("cacheEnable");
            cmdParam10.setParams(undoMap);
            cmdParams.add(cmdParam10);
            CmdParam cmdParam11 = new CmdParam();
            cmdParam11.setCmdID("undoAllCacheItem");
            cmdParams.add(cmdParam11);
            if (!"true".equals(params.get("dnsDefendEnable"))) {
                return;
            }
            if ("true".equalsIgnoreCase(params.get("dnsDomainCacheEnable"))) {
                CmdParam cmdParam71d = new CmdParam();
                cmdParam71d.setCmdID("cacheEnable");
                cmdParams.add(cmdParam71d);
                int index = 1;
                for (DnsDomainCacheForm domainCacheForm : dnsDomainCacheForms) {
                    Map<String, String> paramsMap = VsmUtil.getInstance().getObjectFieldAndValues(domainCacheForm);
                    paramsMap.put("index", String.valueOf(index));
                    CmdParam cmdParam72d = new CmdParam();
                    if (null != domainCacheForm.getIpAddress()) {
                        if (IPUtil.isIpv6((String)domainCacheForm.getIpAddress())) {
                            cmdParam72d.setCmdID("cacheItemV6");
                        } else {
                            cmdParam72d.setCmdID("cacheItem");
                        }
                    }
                    cmdParam72d.setParams(paramsMap);
                    cmdParams.add(cmdParam72d);
                    ++index;
                }
            }
        }
    }

    private void dnsReflectAttackDefencd(Set<String> supportAttrs, List<CmdParam> cmdParams, Map<String, String> params, Map<String, String> undoMap) {
        if (supportAttrs.contains("dnsReflectAttackDefencdEnable")) {
            CmdParam cmdParam9 = new CmdParam();
            cmdParam9.setCmdID("sessionCheck");
            cmdParam9.setParams(undoMap);
            cmdParams.add(cmdParam9);
            if (!"true".equals(params.get("dnsDefendEnable"))) {
                return;
            }
            if ("true".equalsIgnoreCase(params.get("dnsReflectAttackDefencdEnable"))) {
                CmdParam cmdParam7d = new CmdParam();
                cmdParam7d.setCmdID("sessionCheck");
                cmdParam7d.setParams(params);
                cmdParams.add(cmdParam7d);
            }
        }
    }

    private void dnsTtlCheck(Set<String> supportAttrs, List<CmdParam> cmdParams, Map<String, String> params, Map<String, String> undoMap) {
        if (!supportAttrs.contains("requestTtlCheckEnable") || !supportAttrs.contains("replyTtlCheckEnable")) {
            return;
        }
        CmdParam cmdParam0 = new CmdParam();
        cmdParam0.setCmdID("replyTtlCheck");
        cmdParam0.setParams(undoMap);
        cmdParams.add(cmdParam0);
        CmdParam cmdParam1 = new CmdParam();
        cmdParam1.setCmdID("requestTtlCheck");
        cmdParam1.setParams(undoMap);
        cmdParams.add(cmdParam1);
        if (!"true".equals(params.get("dnsDefendEnable"))) {
            return;
        }
        if ("true".equals(params.get("requestTtlCheckEnable"))) {
            if (Constant.DNS_TTL_PERMIT_ASSIGN_TYPE.equals(Integer.valueOf(params.get("requsetTtlCheckMode")))) {
                params.put("hopNumber", params.get("requestTtlAlertRate"));
            } else if (Constant.DNS_TTL_PERMIT_RANGLE_TYPE.equals(Integer.valueOf(params.get("requsetTtlCheckMode")))) {
                this.ttlScopeAdapter(params, "request");
            }
            CmdParam cmdParam2 = new CmdParam();
            cmdParam2.setCmdID("requestTtlCheck");
            cmdParam2.setParams(params);
            cmdParams.add(cmdParam2);
        }
        if ("true".equals(params.get("replyTtlCheckEnable"))) {
            if (Constant.DNS_TTL_PERMIT_ASSIGN_TYPE.equals(Integer.valueOf(params.get("replyTtlCheckMode")))) {
                params.put("hopReplyNumber", params.get("replyTtlAlertRate"));
            } else if (Constant.DNS_TTL_PERMIT_RANGLE_TYPE.equals(Integer.valueOf(params.get("replyTtlCheckMode")))) {
                this.ttlScopeAdapter(params, "reply");
            }
            CmdParam cmdParam3 = new CmdParam();
            cmdParam3.setCmdID("replyTtlCheck");
            cmdParam3.setParams(params);
            cmdParams.add(cmdParam3);
        }
    }

    private void ttlScopeAdapter(Map<String, String> params, String ttlType) {
        String requestTtlAlertRate = params.get("requestTtlAlertRate");
        String replyTtlAlertRate = params.get("replyTtlAlertRate");
        ArrayList<DnsTtlCheckForm> ttlCheckList = new ArrayList<DnsTtlCheckForm>();
        String[] ttlScopes = null;
        ttlScopes = ttlType.equals("request") ? requestTtlAlertRate.split(",") : replyTtlAlertRate.split(",");
        for (String ttlScope : ttlScopes) {
            DnsTtlCheckForm ttlForm = new DnsTtlCheckForm();
            ttlForm.setPermitListBegin(ttlScope.split("-")[0]);
            ttlForm.setPermitListEnd(ttlScope.split("-")[1]);
            ttlCheckList.add(ttlForm);
        }
        int index = 0;
        for (DnsTtlCheckForm ttlCheck : ttlCheckList) {
            ++index;
            if (ttlType.equals("request")) {
                params.put("begin" + index, ttlCheck.getPermitListBegin());
                params.put("end" + index, ttlCheck.getPermitListEnd());
                continue;
            }
            params.put("start" + index, ttlCheck.getPermitListBegin());
            params.put("terminal" + index, ttlCheck.getPermitListEnd());
        }
    }

    private void dnsFormatCheck(Set<String> supportAttrs, List<CmdParam> cmdParams, Map<String, String> params, Map<String, String> undoMap) {
        if (!supportAttrs.contains("formatCheckEnable")) {
            return;
        }
        CmdParam cmdParam0 = new CmdParam();
        cmdParam0.setCmdID("styleCheck");
        cmdParam0.setParams(undoMap);
        cmdParams.add(cmdParam0);
        if (!"true".equals(params.get("dnsDefendEnable"))) {
            return;
        }
        if ("true".equals(params.get("formatCheckEnable"))) {
            CmdParam cmdParam1 = new CmdParam();
            cmdParam1.setCmdID("styleCheck");
            cmdParam1.setParams(params);
            cmdParams.add(cmdParam1);
        }
    }

    private void dnsDestoryDefence(Set<String> supportAttrs, List<CmdParam> cmdParams, Map<String, String> params) {
        if (supportAttrs.contains("dnsDestoryDefenceEnable")) {
            if (!"true".equals(params.get("dnsDefendEnable"))) {
                return;
            }
            Boolean isWithCustomServiceView = supportAttrs.contains("withServiceViewCustomService");
            if (isWithCustomServiceView.booleanValue() && !"true".equals(params.get("dnsCacheServerEnable"))) {
                return;
            }
            if ("true".equals(params.get("cachePoisoningEnable"))) {
                CmdParam cmdParam6d = new CmdParam();
                cmdParam6d.setCmdID("cachePoison");
                cmdParam6d.setParams(params);
                cmdParams.add(cmdParam6d);
            }
        }
    }

    private void dnsReponseMessageLenLimit(Set<String> supportAttrs, List<CmdParam> cmdParams, Map<String, String> params, Map<String, String> undoMap) {
        if (supportAttrs.contains("dnsReponseMessageLenLimitEnable")) {
            CmdParam cmdParam7 = new CmdParam();
            cmdParam7.setCmdID("maxLengthResponseCheck");
            cmdParam7.setParams(undoMap);
            cmdParams.add(cmdParam7);
            if (!"true".equals(params.get("dnsDefendEnable"))) {
                return;
            }
            if ("true".equals(params.get("dnsReponseMessageLenLimitEnable"))) {
                CmdParam cmdParam5d = new CmdParam();
                cmdParam5d.setCmdID("maxLengthResponseCheck");
                cmdParam5d.setParams(params);
                cmdParams.add(cmdParam5d);
            }
        }
    }

    private void dnsRequestMessageLenLimit(Set<String> supportAttrs, List<CmdParam> cmdParams, Map<String, String> params, Map<String, String> undoMap) {
        if (supportAttrs.contains("dnsRequestMessageLenLimitEnable")) {
            CmdParam cmdParam6 = new CmdParam();
            cmdParam6.setCmdID("maxLengthRequestCheck");
            cmdParam6.setParams(undoMap);
            cmdParams.add(cmdParam6);
            if (!"true".equals(params.get("dnsDefendEnable"))) {
                return;
            }
            if ("true".equals(params.get("dnsRequestMessageLenLimitEnable"))) {
                CmdParam cmdParam4d = new CmdParam();
                cmdParam4d.setCmdID("maxLengthRequestCheck");
                cmdParam4d.setParams(params);
                cmdParams.add(cmdParam4d);
            }
        }
    }

    private void sourceIpRespLimit(Set<String> supportAttrs, List<CmdParam> cmdParams, Map<String, String> params, List<SourceIpResponseMessageForm> appointSourceIpResponseMessageForms) {
        if (supportAttrs.contains("srcipRespLimitEnable")) {
            CmdParam cmdParam3 = new CmdParam();
            cmdParam3.setCmdID("undoAllSourceIpResponseLimit");
            cmdParams.add(cmdParam3);
            if (!"true".equals(params.get("limitEnable"))) {
                return;
            }
            if ("true".equalsIgnoreCase(params.get("srcipRespLimitEnable"))) {
                if (String.valueOf(Constant.SOURCE_OTHER_LIMIT_MODE_ON).equals(params.get("srcipOtherRespMode"))) {
                    params.put("srcipOtherRespMode", "on");
                } else {
                    params.put("srcipOtherRespMode", "auto");
                }
                CmdParam cmdParam3d = new CmdParam();
                cmdParam3d.setCmdID("sourceIpOtherResponseLimit");
                cmdParam3d.setParams(params);
                cmdParams.add(cmdParam3d);
            }
            if ("true".equals(params.get("appointSourceIpResponseMessageEnable"))) {
                for (SourceIpResponseMessageForm appointSourceIpResponseMessageForm : appointSourceIpResponseMessageForms) {
                    Map<String, String> ipResponseParams = VsmUtil.getInstance().getObjectFieldAndValues(appointSourceIpResponseMessageForm);
                    CmdParam cmdParam9d = new CmdParam();
                    cmdParam9d.setCmdID("sourceIpResponseLimit");
                    cmdParam9d.setParams(ipResponseParams);
                    cmdParams.add(cmdParam9d);
                }
            }
        }
    }

    private void sourceIpReqLimit(Set<String> supportAttrs, List<CmdParam> cmdParams, Map<String, String> params, List<SourceIpRequestMessageForm> appointSourceIpRequestMessageForms) {
        if (supportAttrs.contains("srcipReqLimitEnable")) {
            CmdParam cmdParam2 = new CmdParam();
            cmdParam2.setCmdID("undoAllSourceIpRequestLimit");
            cmdParams.add(cmdParam2);
            if (!"true".equals(params.get("limitEnable"))) {
                return;
            }
            if ("true".equalsIgnoreCase(params.get("srcipReqLimitEnable"))) {
                if (String.valueOf(Constant.SOURCE_OTHER_LIMIT_MODE_ON).equals(params.get("srcipOtherReqMode"))) {
                    params.put("srcipOtherReqMode", "on");
                } else {
                    params.put("srcipOtherReqMode", "auto");
                }
                CmdParam cmdParam2d = new CmdParam();
                cmdParam2d.setCmdID("sourceIpOtherRequestLimit");
                cmdParam2d.setParams(params);
                cmdParams.add(cmdParam2d);
            }
            if ("true".equals(params.get("appointSourceIpRequestMessageEnable"))) {
                for (SourceIpRequestMessageForm appointSourceIpRequestMessageForm : appointSourceIpRequestMessageForms) {
                    Map<String, String> ipRequestParams = VsmUtil.getInstance().getObjectFieldAndValues(appointSourceIpRequestMessageForm);
                    CmdParam cmdParam8d = new CmdParam();
                    cmdParam8d.setCmdID("sourceIpRequestLimit");
                    cmdParam8d.setParams(ipRequestParams);
                    cmdParams.add(cmdParam8d);
                }
            }
        }
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }
}

