/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpKeyDetectUriForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceHttpDefendData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = -8537847642933766782L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Object basicServiceForm;

    public ServiceHttpDefendData() {
    }

    public ServiceHttpDefendData(Object obj, String featureType, Long featureId, Object basicServiceForm) {
        this.setBasicServiceForm(basicServiceForm);
        this.setConfigData(obj);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmds = this.doTranslate(logicDev.getDeviceId());
        logger.info((Object)("device : " + logicDev.getDeviceId() + "to deploy cmds:" + this.getcleanedMessage(cmds.toString())));
        this.setCmds(cmds);
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmds);
        logger.info((Object)("deploy result:" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<String> doTranslate(Long moId) {
        List cmds = null;
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        HttpDefendPolicyForm httpForm = (HttpDefendPolicyForm)this.getConfigData();
        Map<String, String> params = VsmUtil.getInstance().getObjectFieldAndValues(httpForm);
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        ZoneServiceForm basicServiceForms = (ZoneServiceForm)this.getBasicServiceForm();
        if (viewList.size() == Constant.CUSTOM_SERVICE_SIZE.intValue() && !"DEFAULT".equals(basicServiceForms.getProtocol())) {
            params.put("serviceName", basicServiceForms.getServiceName());
            undoMap.put("serviceName", basicServiceForms.getServiceName());
            this.customServiceCommand(cmdParams, params, undoMap);
            CommandAPI tool = new CommandAPI();
            String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moId);
            cmds = tool.doTranslate(cmdFileDir, "http_defend", cmdParams);
            return cmds;
        }
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(moId);
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
        this.defendModeAdapter(params);
        this.srcStaticModeAdapter(params);
        CmdParam cmdParam0 = new CmdParam();
        cmdParam0.setCmdID("maxTimes");
        cmdParam0.setParams(undoMap);
        cmdParams.add(cmdParam0);
        boolean isDefService = "DEFAULT".equals(basicServiceForms.getProtocol());
        this.removeHttpDefendPolicy(supportAttrs, cmdParams, isDefService);
        if (viewList.size() == Constant.CUSTOM_SERVICE_WITH_SERVICE_VIEW_SIZE.intValue()) {
            this.translateBlockCommand(params, cmdParams);
        }
        this.translateDefense(httpForm, params, cmdParams, supportAttrs, isDefService);
        if (viewList.size() == Constant.CUSTOM_SERVICE_WITH_SERVICE_VIEW_SIZE.intValue()) {
            this.translateLimitCommand(params, cmdParams);
        }
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moId);
        cmds = tool.doTranslate(cmdFileDir, "http_defend", cmdParams);
        return cmds;
    }

    private void translateDefense(HttpDefendPolicyForm httpForm, Map<String, String> params, List<CmdParam> cmdParams, Set<String> supportAttrs, boolean isDefService) {
        if ("true".equals(params.get("httpDefendEnable"))) {
            CmdParam cmdParam1D;
            if (("true".equals(params.get("httpSourceAuthEnable")) || "true".equals(params.get("httpFirstPacketEnable")) || "true".equals(params.get("fingerLearnEnable")) || "true".equals(params.get("highFreqDetectEnable")) || "true".equals(params.get("largeResDetectEnable")) || "true".equals(params.get("httpFixUriEnable"))) && supportAttrs.contains("httpDestQpsEnable")) {
                cmdParam1D = new CmdParam();
                cmdParam1D.setCmdID("httpAlertRequest");
                cmdParam1D.setParams(params);
                cmdParams.add(cmdParam1D);
            }
            if (supportAttrs.contains("httpProxyEnable") && "true".equals(params.get("httpProxyEnable"))) {
                CmdParam proxyCmdParam = new CmdParam();
                proxyCmdParam.setCmdID("proxyCheck");
                proxyCmdParam.setParams(params);
                cmdParams.add(proxyCmdParam);
                if (isDefService && "true".equals(params.get("httpProxyHeaderEnable"))) {
                    CmdParam proxyCmdParam2 = new CmdParam();
                    proxyCmdParam2.setCmdID("httpProxyHeader");
                    proxyCmdParam2.setParams(params);
                    cmdParams.add(proxyCmdParam2);
                }
            }
            this.sourceAuthCommand(supportAttrs, params, cmdParams);
            this.aftersourceAuth(supportAttrs, params, cmdParams);
            if (supportAttrs.contains("httpWebDetectEnable") && "true".equals(params.get("httpWebDetectEnable"))) {
                this.handleUnicode(params);
                CmdParam webTitle = new CmdParam();
                webTitle.setCmdID("httpWebDetectTitle");
                webTitle.setParams(params);
                cmdParams.add(webTitle);
            }
            this.keyUrisCommand(supportAttrs, httpForm, cmdParams);
            this.fingerLearnAndUriCommand(supportAttrs, params, cmdParams);
            this.slowAttackCommand(supportAttrs, params, cmdParams);
            this.highFreqDetectCommand(supportAttrs, params, cmdParams);
            this.httpFixUriCommand(supportAttrs, params, cmdParams);
            this.largeResDetectCommand(supportAttrs, params, cmdParams);
            this.illegalSessionCheckCommand(supportAttrs, params, cmdParams);
            if (("true".equals(params.get("httpSlowAttackEnable")) || "true".equals(params.get("httpIllegalSessionCheckEnable"))) && "true".equals(params.get("destIpConnNumEnable"))) {
                cmdParam1D = new CmdParam();
                cmdParam1D.setCmdID("destIpConnNumConfig");
                cmdParam1D.setParams(params);
                cmdParams.add(cmdParam1D);
            }
            if (isDefService) {
                this.httpFirstPacketCommand(params, cmdParams);
            }
        }
    }

    private void handleUnicode(Map<String, String> params) {
        if (params.containsKey("webTitle")) {
            try {
                char[] eachs;
                String value = URLEncoder.encode(params.get("webTitle"), "UTF-8");
                String temp = value.replaceAll("%", "\\\\x");
                String afterTrans = temp.replaceAll("\\\\x", "\\\\\\\\x");
                StringBuffer buffer = new StringBuffer();
                for (char each : eachs = afterTrans.toCharArray()) {
                    if (each == ' ' || each == '?') {
                        char bb = each;
                        String cc = Integer.toHexString(bb);
                        buffer.append("\\x");
                        buffer.append(cc);
                        continue;
                    }
                    buffer.append(each);
                }
                params.put("webTitle", temp.replaceAll("\\+", "\\\\x20"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)("handle http web title Unicode error. " + e.getMessage()));
            }
        }
    }

    private void slowAttackCommand(Set<String> supportAttrs, Map<String, String> params, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpSlowAttackEnable") && "true".equals(params.get("httpSlowAttackEnable"))) {
            String cmdId = "";
            cmdId = supportAttrs.contains("slowAttackDetectNoConn") ? "slowAttackDetectNoConn" : "slowAttackDetect";
            CmdParam slowAttackCmdParam = new CmdParam();
            slowAttackCmdParam.setCmdID(cmdId);
            slowAttackCmdParam.setParams(params);
            cmdParams.add(slowAttackCmdParam);
        }
    }

    private void highFreqDetectCommand(Set<String> supportAttrs, Map<String, String> params, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("highFreqDetectEnable") && "true".equals(params.get("highFreqDetectEnable"))) {
            CmdParam highFreqDetectCmdParam = new CmdParam();
            highFreqDetectCmdParam.setCmdID("httpHighFreqDetect");
            highFreqDetectCmdParam.setParams(params);
            cmdParams.add(highFreqDetectCmdParam);
        }
    }

    private void undoHighFreqDetectCommand(Set<String> supportAttrs, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("highFreqDetectEnable")) {
            HashMap<String, String> undoMap = new HashMap<String, String>();
            undoMap.put("undo", "undo");
            CmdParam undoCmd = new CmdParam();
            undoCmd.setCmdID("httpHighFreqDetect");
            undoCmd.setParams(undoMap);
            cmdParams.add(undoCmd);
        }
    }

    private void httpFixUriCommand(Set<String> supportAttrs, Map<String, String> params, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpFixUriEnable") && "true".equals(params.get("httpFixUriEnable"))) {
            CmdParam httpFixUriCmdParam = new CmdParam();
            httpFixUriCmdParam.setCmdID("httpFixUriDetect");
            httpFixUriCmdParam.setParams(params);
            cmdParams.add(httpFixUriCmdParam);
        }
    }

    private void undoHttpFixUriCommand(Set<String> supportAttrs, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpFixUriEnable")) {
            HashMap<String, String> undoMap = new HashMap<String, String>();
            undoMap.put("undo", "undo");
            CmdParam undoCmd = new CmdParam();
            undoCmd.setCmdID("httpFixUriDetect");
            undoCmd.setParams(undoMap);
            cmdParams.add(undoCmd);
        }
    }

    private void largeResDetectCommand(Set<String> supportAttrs, Map<String, String> params, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("largeResDetectEnable") && "true".equals(params.get("largeResDetectEnable"))) {
            CmdParam largeResDetectCmdParam = new CmdParam();
            largeResDetectCmdParam.setCmdID("httpLargeResDetect");
            largeResDetectCmdParam.setParams(params);
            cmdParams.add(largeResDetectCmdParam);
        }
    }

    private void undoLargeResDetectCommand(Set<String> supportAttrs, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("largeResDetectEnable")) {
            HashMap<String, String> undoMap = new HashMap<String, String>();
            undoMap.put("undo", "undo");
            CmdParam undoCmd = new CmdParam();
            undoCmd.setCmdID("httpLargeResDetect");
            undoCmd.setParams(undoMap);
            cmdParams.add(undoCmd);
        }
    }

    private void illegalSessionCheckCommand(Set<String> supportAttrs, Map<String, String> params, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpIllegalSessionCheckEnable") && "true".equals(params.get("httpIllegalSessionCheckEnable"))) {
            HashMap<String, String> mode;
            if ("true".equals(params.get("nullMethodCheck"))) {
                mode = new HashMap<String, String>();
                mode.put("checkMode", "null-method-check");
                CmdParam cmd1 = new CmdParam();
                cmd1.setCmdID("httpIllegalSessionCheckMode");
                cmd1.setParams(mode);
                cmdParams.add(cmd1);
            }
            if ("true".equals(params.get("rangeHeaderCheck"))) {
                mode = new HashMap();
                mode.put("checkMode", "range-header-check");
                CmdParam cmd2 = new CmdParam();
                cmd2.setCmdID("httpIllegalSessionCheckMode");
                cmd2.setParams(mode);
                cmdParams.add(cmd2);
            }
            if ("true".equals(params.get("multiGetCheck"))) {
                mode = new HashMap();
                mode.put("checkMode", "multi-method-check");
                CmdParam cmd3 = new CmdParam();
                cmd3.setCmdID("httpIllegalSessionCheckMode");
                cmd3.setParams(mode);
                cmdParams.add(cmd3);
            }
            CmdParam cmd4 = new CmdParam();
            cmd4.setCmdID("httpIllegalSessionCheck");
            cmd4.setParams(params);
            cmdParams.add(cmd4);
        }
    }

    private void undoIllegalSessionCheckCommand(Set<String> supportAttrs, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpIllegalSessionCheckEnable")) {
            HashMap<String, String> mode1 = new HashMap<String, String>();
            mode1.put("checkMode", "null-method-check");
            mode1.put("undo", "undo");
            CmdParam cmd1 = new CmdParam();
            cmd1.setCmdID("httpIllegalSessionCheckMode");
            cmd1.setParams(mode1);
            cmdParams.add(cmd1);
            HashMap<String, String> mode2 = new HashMap<String, String>();
            mode2.put("checkMode", "range-header-check");
            mode2.put("undo", "undo");
            CmdParam cmd2 = new CmdParam();
            cmd2.setCmdID("httpIllegalSessionCheckMode");
            cmd2.setParams(mode2);
            cmdParams.add(cmd2);
            HashMap<String, String> mode3 = new HashMap<String, String>();
            mode3.put("checkMode", "multi-method-check");
            mode3.put("undo", "undo");
            CmdParam cmd3 = new CmdParam();
            cmd3.setCmdID("httpIllegalSessionCheckMode");
            cmd3.setParams(mode3);
            cmdParams.add(cmd3);
            CmdParam cmd4 = new CmdParam();
            cmd4.setCmdID("httpIllegalSessionCheck");
            cmd4.setParams(mode1);
            cmdParams.add(cmd4);
        }
    }

    private void aftersourceAuth(Set<String> supportAttrs, Map<String, String> params, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpSourceAuthEnable")) {
            String value;
            if ("true".equals(params.get("httpAfterAuthSynEnable")) && params.containsKey("afterAuthSynAction")) {
                value = params.get("afterAuthSynAction");
                if (value.equals(Constant.HTTP_AUTH_ACTION_BLIST.toString())) {
                    params.put("afterAuthSynAction", "drop-mark-black");
                } else {
                    params.put("afterAuthSynAction", "limit");
                }
                CmdParam cmdParamSynAuth = new CmdParam();
                cmdParamSynAuth.setCmdID("afterBypassSynCheck");
                cmdParamSynAuth.setParams(params);
                cmdParams.add(cmdParamSynAuth);
            }
            if ("true".equals(params.get("httpAfterAuthAckEnable")) && params.containsKey("afterAuthAckAction")) {
                value = params.get("afterAuthAckAction");
                if (value.equals(Constant.HTTP_AUTH_ACTION_BLIST.toString())) {
                    params.put("afterAuthAckAction", "drop-mark-black");
                } else {
                    params.put("afterAuthAckAction", "limit");
                }
                CmdParam cmdParamAckAuth = new CmdParam();
                cmdParamAckAuth.setCmdID("afterBypassAckCheck");
                cmdParamAckAuth.setParams(params);
                cmdParams.add(cmdParamAckAuth);
            }
        }
    }

    private void translateLimitCommand(Map<String, String> params, List<CmdParam> cmdParams) {
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        if ("true".equals(params.get("limitEnable"))) {
            CmdParam cmdParam1D = new CmdParam();
            cmdParam1D.setCmdID("serviceLimit");
            cmdParam1D.setParams(params);
            cmdParams.add(cmdParam1D);
        } else {
            CmdParam cmdParam2D = new CmdParam();
            cmdParam2D.setCmdID("serviceLimit");
            cmdParam2D.setParams(undoMap);
            cmdParams.add(cmdParam2D);
        }
    }

    private void translateBlockCommand(Map<String, String> params, List<CmdParam> cmdParams) {
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        if ("true".equals(params.get("httpBlock"))) {
            CmdParam cmdParam1D = new CmdParam();
            cmdParam1D.setCmdID("httpServiceDrop");
            cmdParams.add(cmdParam1D);
        } else {
            CmdParam cmdParam2D = new CmdParam();
            cmdParam2D.setCmdID("httpServiceDrop");
            cmdParam2D.setParams(undoMap);
            cmdParams.add(cmdParam2D);
        }
    }

    private void httpFirstPacketCommand(Map<String, String> params, List<CmdParam> cmdParams) {
        if ("true".equals(params.get("httpFirstPacketEnable"))) {
            CmdParam cmdParam = new CmdParam();
            cmdParam.setCmdID("httpFirstPacket");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("lowerLimit", params.get("httpLowerLimit"));
            paramMap.put("upperLimit", params.get("httpUpperLimit"));
            cmdParam.setParams(paramMap);
            cmdParams.add(cmdParam);
        }
    }

    private void keyUrisCommand(Set<String> supportAttrs, HttpDefendPolicyForm httpForm, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpUriEnable") && "true".equals(String.valueOf(httpForm.getHttpUriEnable())) || supportAttrs.contains("httpFixUriEnable") && "true".equals(String.valueOf(httpForm.getHttpFixUriEnable()))) {
            int index = 1;
            for (HttpKeyDetectUriForm keyUriForm : httpForm.getKeyDetectUriForms()) {
                String uri = keyUriForm.getHttpUri();
                if (null != uri && !uri.equals("")) {
                    uri = this.unicodeToString(uri);
                    keyUriForm.setHttpUri(this.transQues2ASCII(uri));
                }
                Map<String, String> keyUriParams = VsmUtil.getInstance().getObjectFieldAndValues(keyUriForm);
                if (String.valueOf(0).equals(keyUriParams.get("matchMode"))) {
                    keyUriParams.put("matchMode", "full-matching");
                } else {
                    keyUriParams.remove("matchMode");
                }
                keyUriParams.put("index", String.valueOf(index));
                ++index;
                CmdParam cmdParam5D = new CmdParam();
                cmdParam5D.setCmdID("keyURLDetect");
                cmdParam5D.setParams(keyUriParams);
                cmdParams.add(cmdParam5D);
            }
        }
    }

    private String transQues2ASCII(String toTrans) {
        int lastIndex;
        char[] eachs;
        String afterTrans = toTrans.replaceAll("\\\\x", "\\\\\\\\x");
        StringBuffer buffer = new StringBuffer();
        for (char each : eachs = afterTrans.toCharArray()) {
            if (each == '?') {
                char bb = each;
                String cc = Integer.toHexString(bb);
                buffer.append("\\x");
                buffer.append(cc);
                continue;
            }
            buffer.append(each);
        }
        String result = buffer.toString().trim();
        if (result.length() > 255 && (lastIndex = (result = result.substring(0, 254)).lastIndexOf("\\x")) > 251) {
            result = result.substring(0, lastIndex);
        }
        return result;
    }

    private void fingerLearnAndUriCommand(Set<String> supportAttrs, Map<String, String> params, List<CmdParam> cmdParams) {
        if ("true".equals(params.get("fingerLearnEnable"))) {
            CmdParam cmdParam2D = new CmdParam();
            cmdParam2D.setCmdID("fingerprintLearn");
            cmdParam2D.setParams(params);
            cmdParams.add(cmdParam2D);
        }
        if ("true".equals(params.get("httpUriEnable")) && supportAttrs.contains("httpBehaviorDetectEnable")) {
            CmdParam cmdParam3D = new CmdParam();
            cmdParam3D.setCmdID("behaviorDetect");
            cmdParam3D.setParams(params);
            cmdParams.add(cmdParam3D);
        }
        if (supportAttrs.contains("httpUriEnable") && "true".equals(params.get("httpUriEnable"))) {
            CmdParam cmdParam4D = new CmdParam();
            cmdParam4D.setCmdID("uriDefendDetect");
            cmdParam4D.setParams(params);
            cmdParams.add(cmdParam4D);
        }
    }

    private void sourceAuthCommand(Set<String> supportAttrs, Map<String, String> params, List<CmdParam> cmdParams) {
        if ("true".equals(params.get("httpSourceAuthEnable"))) {
            CmdParam cmdParam1d;
            CmdParam cmdParam10d = new CmdParam();
            if (!supportAttrs.contains("httpFloodDefendMode")) {
                params.remove("defendMode");
            }
            if (!supportAttrs.contains("httpSrcModeEnable")) {
                params.remove("httpSrcMode");
            }
            cmdParam10d.setCmdID("sourceDetectMode");
            cmdParam10d.setParams(params);
            cmdParams.add(cmdParam10d);
            if (supportAttrs.contains("httpDetectUriEnable") && "true".equals(params.get("detectUriEnable"))) {
                params.put("detectUriEnable", "attempt-limit");
                cmdParam1d = new CmdParam();
                cmdParam1d.setCmdID("maxTimes");
                cmdParam1d.setParams(params);
                cmdParams.add(cmdParam1d);
            }
            if (supportAttrs.contains("httpSrcStaticEnable") && "true".equals(params.get("httpSrcStaticEnable"))) {
                CmdParam cmdParamSrcStatic = new CmdParam();
                cmdParamSrcStatic.setCmdID("httpSrcStatic");
                cmdParamSrcStatic.setParams(params);
                cmdParams.add(cmdParamSrcStatic);
                if (supportAttrs.contains("httpSrcModeEnable")) {
                    CmdParam srcStaticMode = new CmdParam();
                    srcStaticMode.setCmdID("httpSrcStaticMode");
                    srcStaticMode.setParams(params);
                    cmdParams.add(srcStaticMode);
                }
                if (supportAttrs.contains("httpSrcQpsEnable")) {
                    CmdParam srcStaticQps = new CmdParam();
                    srcStaticQps.setCmdID("httpSrcStaticQpsRate");
                    srcStaticQps.setParams(params);
                    cmdParams.add(srcStaticQps);
                }
            }
            if (supportAttrs.contains("httpPostRedirectEnable") && params.containsKey("defendMode") && "redirect".equals(params.get("defendMode"))) {
                cmdParam1d = new CmdParam();
                cmdParam1d.setCmdID("httpPostRedirect");
                cmdParams.add(cmdParam1d);
            }
        }
    }

    private void removeHttpDefendPolicy(Set<String> supportAttrs, List<CmdParam> cmdParams, boolean isDefService) {
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        HashMap<String, String> undoAttemptLimitMap = new HashMap<String, String>();
        undoAttemptLimitMap.put("undo", "undo");
        if (isDefService && supportAttrs.contains("httpProxyEnable")) {
            CmdParam proxyCmdParam = new CmdParam();
            proxyCmdParam.setCmdID("proxyCheck");
            proxyCmdParam.setParams(undoMap);
            cmdParams.add(proxyCmdParam);
            if (supportAttrs.contains("httpProxyHeaderEnable")) {
                CmdParam proxyCmdParam2 = new CmdParam();
                proxyCmdParam2.setCmdID("httpProxyHeader");
                proxyCmdParam2.setParams(undoMap);
                cmdParams.add(proxyCmdParam2);
            }
        }
        if (isDefService) {
            CmdParam cmdParam6 = new CmdParam();
            cmdParam6.setCmdID("httpFirstPacket");
            cmdParam6.setParams(undoMap);
            cmdParams.add(cmdParam6);
        }
        if (supportAttrs.contains("httpUriEnable")) {
            undoAttemptLimitMap.put("detectUriEnable", "attempt-limit");
            CmdParam cmdParam1 = new CmdParam();
            cmdParam1.setCmdID("maxTimes");
            cmdParam1.setParams(undoAttemptLimitMap);
            cmdParams.add(cmdParam1);
        }
        if (isDefService && supportAttrs.contains("httpSrcStaticEnable")) {
            CmdParam undoSrcStaticMode = new CmdParam();
            undoSrcStaticMode.setCmdID("httpSrcStaticMode");
            undoSrcStaticMode.setParams(undoMap);
            cmdParams.add(undoSrcStaticMode);
            CmdParam undoSrcStatic = new CmdParam();
            undoSrcStatic.setCmdID("httpSrcStatic");
            undoSrcStatic.setParams(undoMap);
            cmdParams.add(undoSrcStatic);
            CmdParam undoSrcQpsStatic = new CmdParam();
            undoSrcQpsStatic.setCmdID("httpSrcStaticQpsRate");
            undoSrcQpsStatic.setParams(undoMap);
            cmdParams.add(undoSrcQpsStatic);
        }
        if (supportAttrs.contains("httpAfterAuthEnable")) {
            CmdParam undoCmdParamSynAuth = new CmdParam();
            undoCmdParamSynAuth.setCmdID("afterBypassSynCheck");
            undoCmdParamSynAuth.setParams(undoMap);
            cmdParams.add(undoCmdParamSynAuth);
            CmdParam undoCmdParamAckAuth = new CmdParam();
            undoCmdParamAckAuth.setCmdID("afterBypassAckCheck");
            undoCmdParamAckAuth.setParams(undoMap);
            cmdParams.add(undoCmdParamAckAuth);
            if (supportAttrs.contains("httpPostRedirectEnable")) {
                CmdParam undoCmdParamPostRed = new CmdParam();
                undoCmdParamPostRed.setCmdID("httpPostRedirect");
                undoCmdParamPostRed.setParams(undoMap);
                cmdParams.add(undoCmdParamPostRed);
            }
        }
        if (isDefService && supportAttrs.contains("httpWebDetectEnable")) {
            CmdParam undoWebTitle = new CmdParam();
            undoWebTitle.setCmdID("httpWebDetectTitle");
            undoWebTitle.setParams(undoMap);
            cmdParams.add(undoWebTitle);
        }
        if (supportAttrs.contains("httpSlowAttackEnable")) {
            CmdParam slowAttackCmdParam = new CmdParam();
            slowAttackCmdParam.setCmdID("slowAttackDetect");
            slowAttackCmdParam.setParams(undoMap);
            cmdParams.add(slowAttackCmdParam);
        }
        CmdParam cmdParam2 = new CmdParam();
        cmdParam2.setCmdID("fingerprintLearn");
        cmdParam2.setParams(undoMap);
        cmdParams.add(cmdParam2);
        if (supportAttrs.contains("httpDestQpsEnable")) {
            CmdParam cmdParamQps = new CmdParam();
            cmdParamQps.setCmdID("httpAlertRequest");
            cmdParamQps.setParams(undoMap);
            cmdParams.add(cmdParamQps);
        }
        if (supportAttrs.contains("httpUriEnable")) {
            CmdParam cmdParam4 = new CmdParam();
            cmdParam4.setCmdID("uriDefendDetect");
            cmdParam4.setParams(undoMap);
            cmdParams.add(cmdParam4);
        }
        if (supportAttrs.contains("httpBehaviorDetectEnable")) {
            CmdParam cmdParam3 = new CmdParam();
            cmdParam3.setCmdID("behaviorDetect");
            cmdParam3.setParams(undoMap);
            cmdParams.add(cmdParam3);
        }
        if (supportAttrs.contains("httpUriEnable")) {
            CmdParam cmdParam5 = new CmdParam();
            cmdParam5.setCmdID("undoKeyURLDetect");
            cmdParams.add(cmdParam5);
        }
        if (supportAttrs.contains("destIpConnNumEnable")) {
            CmdParam cmdParam1D = new CmdParam();
            cmdParam1D.setCmdID("destIpConnNumConfig");
            cmdParam1D.setParams(undoMap);
            cmdParams.add(cmdParam1D);
        }
        this.undoHighFreqDetectCommand(supportAttrs, cmdParams);
        this.undoHttpFixUriCommand(supportAttrs, cmdParams);
        this.undoLargeResDetectCommand(supportAttrs, cmdParams);
        this.undoIllegalSessionCheckCommand(supportAttrs, cmdParams);
    }

    private void defendModeAdapter(Map<String, String> params) {
        if (params.get("defendMode") != null) {
            if (Constant.HTTP_FLOOD_DEFENDMODE_BASIC.equals(Integer.valueOf(params.get("defendMode")))) {
                params.put("defendMode", "basic");
                params.put("maxTimeDefendMode", "basic");
            } else if (Constant.HTTP_FLOOD_DEFENDMODE_STRENGTHEN.equals(Integer.valueOf(params.get("defendMode")))) {
                params.put("defendMode", "advanced");
                params.put("maxTimeDefendMode", "advanced");
            } else if (Constant.HTTP_FLOOD_DEFENDMODE_REDIRECT.equals(Integer.valueOf(params.get("defendMode")))) {
                params.put("defendMode", "redirect");
            } else if (Constant.HTTP_FLOOD_DEFENDMODE_COOKIE.equals(Integer.valueOf(params.get("defendMode")))) {
                params.put("defendMode", "cookie");
            } else if (Constant.HTTP_FLOOD_DEFENDMODE_JAVASCRIPT.equals(Integer.valueOf(params.get("defendMode")))) {
                params.put("defendMode", "js");
            }
        }
    }

    private void srcStaticModeAdapter(Map<String, String> params) {
        if (params.get("httpSrcMode") != null) {
            if (Constant.HTTP_FLOOD_DEFENDMODE_BASIC.equals(Integer.valueOf(params.get("httpSrcMode")))) {
                params.put("httpSrcMode", "basic");
            } else if (Constant.HTTP_FLOOD_DEFENDMODE_STRENGTHEN.equals(Integer.valueOf(params.get("httpSrcMode")))) {
                params.put("httpSrcMode", "advanced");
            }
        }
    }

    private void customServiceCommand(List<CmdParam> cmdParams, Map<String, String> params, Map<String, String> undoMap) {
        if ("true".equals(params.get("limitEnable"))) {
            CmdParam cmdParamS0 = new CmdParam();
            cmdParamS0.setCmdID("customServiceLimit");
            cmdParamS0.setParams(undoMap);
            cmdParams.add(cmdParamS0);
            CmdParam cmdParamS0d = new CmdParam();
            cmdParamS0d.setCmdID("customServiceLimit");
            cmdParamS0d.setParams(params);
            cmdParams.add(cmdParamS0d);
        } else {
            CmdParam cmdParamS0 = new CmdParam();
            cmdParamS0.setCmdID("customServiceLimit");
            cmdParamS0.setParams(undoMap);
            cmdParams.add(cmdParamS0);
        }
    }

    private String unicodeToString(String unicode) {
        StringBuffer string = new StringBuffer();
        String[] hex = unicode.split("\\\\u");
        try {
            for (int i = 1; i < hex.length; ++i) {
                int data = Integer.parseInt(hex[i], 16);
                string.append((char)data);
            }
            if (0 != string.length()) {
                return string.toString();
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)("NumberFormat error. " + e.getMessage()));
        }
        return unicode;
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }

    public Object getBasicServiceForm() {
        return this.basicServiceForm;
    }

    public void setBasicServiceForm(Object basicServiceForm) {
        this.basicServiceForm = basicServiceForm;
    }
}

