/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceHttpsDefendData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = -3274107996287508313L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public ServiceHttpsDefendData() {
    }

    public ServiceHttpsDefendData(Object obj, String featureType, Long featureId) {
        this.setConfigData(obj);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmds = this.doTranslate(logicDev.getDeviceId());
        logger.info((Object)("device : " + logicDev.getDeviceId() + "to deploy cmds:" + this.getcleanedMessage(cmds.toString())));
        this.setCmds(cmds);
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmds);
        logger.info((Object)("deploy result:" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private boolean isDefaultService(int viewSize) {
        return viewSize == 2;
    }

    private List<String> doTranslate(Long moId) {
        List cmds = null;
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        boolean isDefaultService = this.isDefaultService(viewList.size());
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(moId);
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
        Map<String, String> params = VsmUtil.getInstance().getObjectFieldAndValues(this.getConfigData());
        if (viewList.size() == Constant.CUSTOM_SERVICE_WITH_SERVICE_VIEW_SIZE.intValue()) {
            this.translateBlockCommand(params, undoMap, cmdParams);
            this.translateLimitCommand(params, undoMap, cmdParams);
        }
        this.undoHttpsDefend(undoMap, cmdParams, isDefaultService, supportAttrs);
        this.translateHttpsDefend(params, cmdParams, supportAttrs);
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moId);
        cmds = tool.doTranslate(cmdFileDir, "https_defend", cmdParams);
        return cmds;
    }

    private void translateLimitCommand(Map<String, String> params, Map<String, String> undoMap, List<CmdParam> cmdParams) {
        if ("true".equals(params.get("limitEnable"))) {
            CmdParam cmdParam1d = new CmdParam();
            cmdParam1d.setCmdID("httpsLimit");
            cmdParam1d.setParams(params);
            cmdParams.add(cmdParam1d);
        } else {
            CmdParam cmdParam2d = new CmdParam();
            cmdParam2d.setCmdID("httpsLimit");
            cmdParam2d.setParams(undoMap);
            cmdParams.add(cmdParam2d);
        }
    }

    private void translateBlockCommand(Map<String, String> params, Map<String, String> undoMap, List<CmdParam> cmdParams) {
        if ("true".equals(params.get("httpsBlock"))) {
            CmdParam cmdParam1d = new CmdParam();
            cmdParam1d.setCmdID("serviceDrop");
            cmdParams.add(cmdParam1d);
        } else {
            CmdParam cmdParam2d = new CmdParam();
            cmdParam2d.setCmdID("serviceDrop");
            cmdParam2d.setParams(undoMap);
            cmdParams.add(cmdParam2d);
        }
    }

    private void translateHttpsDefend(Map<String, String> params, List<CmdParam> cmdParams, Set<String> supportAttrs) {
        if ("true".equals(params.get("httpsDefendEnable"))) {
            CmdParam cmdParamSession;
            CmdParam cmdParamIll;
            CmdParam cmdParamNego;
            if ("true".equals(params.get("httpsSrcEnable"))) {
                if (supportAttrs.contains("tlsDesIpAlert")) {
                    CmdParam cmdParam0 = new CmdParam();
                    cmdParam0.setCmdID("tlsDesIpAlert");
                    cmdParam0.setParams(params);
                    cmdParams.add(cmdParam0);
                } else {
                    CmdParam cmdParam0d = new CmdParam();
                    cmdParam0d.setCmdID("httpsAlertRate");
                    cmdParam0d.setParams(params);
                    cmdParams.add(cmdParam0d);
                }
                if ("true".equals(params.get("httpsSslEnable"))) {
                    if ("true".equals(params.get("httpsNegoCheckEnable"))) {
                        cmdParamNego = new CmdParam();
                        cmdParamNego.setCmdID("httpsNego");
                        cmdParamNego.setParams(params);
                        cmdParams.add(cmdParamNego);
                    }
                    if ("true".equals(params.get("httpsNegoCheckEnable")) || "true".equals(params.get("httpsSessionCheckEnable"))) {
                        cmdParamIll = new CmdParam();
                        cmdParamIll.setCmdID("httpsIll");
                        cmdParamIll.setParams(params);
                        cmdParams.add(cmdParamIll);
                    }
                    if ("true".equals(params.get("httpsSessionCheckEnable"))) {
                        cmdParamSession = new CmdParam();
                        cmdParamSession.setCmdID("httpsSessionCheckEnable");
                        cmdParamSession.setParams(params);
                        cmdParams.add(cmdParamSession);
                    }
                }
                if ("true".equals(params.get("httpsSrcStaticEnable"))) {
                    CmdParam cmdParamSrcStatic = new CmdParam();
                    cmdParamSrcStatic.setCmdID("httpsSrcStatic");
                    cmdParamSrcStatic.setParams(params);
                    cmdParams.add(cmdParamSrcStatic);
                    if (supportAttrs.contains("httpsSrcStaticModeEnable")) {
                        this.defendModeAdapter(params);
                        CmdParam httpsSrcStaticMode = new CmdParam();
                        httpsSrcStaticMode.setCmdID("httpsSrcStaticMode");
                        httpsSrcStaticMode.setParams(params);
                        cmdParams.add(httpsSrcStaticMode);
                    }
                }
                if ("true".equals(params.get("httpsSrcAdvanceEnable"))) {
                    CmdParam httpsSrcStaticMode = new CmdParam();
                    httpsSrcStaticMode.setCmdID("httpsSourceDetect");
                    httpsSrcStaticMode.setParams(params);
                    cmdParams.add(httpsSrcStaticMode);
                }
            }
            if (supportAttrs.contains("httpsSSLNewEnable") && "true".equals(params.get("httpsSslEnable"))) {
                if ("true".equals(params.get("httpsNegoCheckEnable"))) {
                    cmdParamNego = new CmdParam();
                    cmdParamNego.setCmdID("httpsNego");
                    cmdParamNego.setParams(params);
                    cmdParams.add(cmdParamNego);
                }
                if ("true".equals(params.get("httpsNegoCheckEnable")) || "true".equals(params.get("httpsSessionCheckEnable"))) {
                    cmdParamIll = new CmdParam();
                    cmdParamIll.setCmdID("httpsIll");
                    cmdParamIll.setParams(params);
                    cmdParams.add(cmdParamIll);
                    if ("true".equals(params.get("httpsDestIpConnNumEnable"))) {
                        CmdParam cmdParam1D = new CmdParam();
                        cmdParam1D.setCmdID("httpsDestIpConnNumConfig");
                        cmdParam1D.setParams(params);
                        cmdParams.add(cmdParam1D);
                    }
                }
                if ("true".equals(params.get("httpsSessionCheckEnable"))) {
                    cmdParamSession = new CmdParam();
                    cmdParamSession.setCmdID("httpsSessionCheckEnable");
                    cmdParamSession.setParams(params);
                    cmdParams.add(cmdParamSession);
                }
            }
            this.highFreqDetectCommand(supportAttrs, params, cmdParams);
            this.httpFixResCommand(supportAttrs, params, cmdParams);
            this.largeResDetectCommand(supportAttrs, params, cmdParams);
        }
    }

    private void defendModeAdapter(Map<String, String> params) {
        if (params.get("httpsSrcMode") != null) {
            if (Constant.HTTP_FLOOD_DEFENDMODE_BASIC.equals(Integer.valueOf(params.get("httpsSrcMode")))) {
                params.put("httpsSrcMode", "basic");
            } else if (Constant.HTTP_FLOOD_DEFENDMODE_STRENGTHEN.equals(Integer.valueOf(params.get("httpsSrcMode")))) {
                params.put("httpsSrcMode", "advanced");
            }
        }
    }

    private void undoHttpsDefend(Map<String, String> undoMap, List<CmdParam> cmdParams, boolean isDefaultService, Set<String> supportAttrs) {
        if (supportAttrs.contains("tlsDesIpAlert")) {
            this.generateUndoCmd("tlsDesIpAlert", undoMap, cmdParams);
        } else {
            this.generateUndoCmd("httpsAlertRate", undoMap, cmdParams);
        }
        this.generateUndoCmd("httpsNego", undoMap, cmdParams);
        this.generateUndoCmd("httpsIll", undoMap, cmdParams);
        this.generateUndoCmd("httpsSessionCheckEnable", undoMap, cmdParams);
        if (isDefaultService) {
            this.generateUndoCmd("httpsSrcStatic", undoMap, cmdParams);
            if (supportAttrs.contains("httpsSrcStaticModeEnable")) {
                this.generateUndoCmd("httpsSrcStaticMode", undoMap, cmdParams);
            }
            if (supportAttrs.contains("httpsSrcAdvanceEnable")) {
                this.generateUndoCmd("httpsSourceDetect", undoMap, cmdParams);
            }
        }
        this.undoHighFreqDetectCommand(supportAttrs, cmdParams);
        this.undoHttpFixResCommand(supportAttrs, cmdParams);
        this.undoLargeResDetectCommand(supportAttrs, cmdParams);
        if (supportAttrs.contains("httpsDestIpConnNumEnable")) {
            this.generateUndoCmd("httpsDestIpConnNumConfig", undoMap, cmdParams);
        }
    }

    private void generateUndoCmd(String cmdId, Map<String, String> undoMap, List<CmdParam> cmdParams) {
        CmdParam cmdParam = new CmdParam();
        cmdParam.setCmdID(cmdId);
        cmdParam.setParams(undoMap);
        cmdParams.add(cmdParam);
    }

    private void highFreqDetectCommand(Set<String> supportAttrs, Map<String, String> params, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpsHighFreqDetectEnable") && "true".equals(params.get("httpsHighFreqDetectEnable"))) {
            CmdParam highFreqDetectCmdParam = new CmdParam();
            highFreqDetectCmdParam.setCmdID("httpsHighFreqDetect");
            highFreqDetectCmdParam.setParams(params);
            cmdParams.add(highFreqDetectCmdParam);
        }
    }

    private void undoHighFreqDetectCommand(Set<String> supportAttrs, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpsHighFreqDetectEnable")) {
            HashMap<String, String> undoMap = new HashMap<String, String>();
            undoMap.put("undo", "undo");
            CmdParam undoCmd = new CmdParam();
            undoCmd.setCmdID("httpsHighFreqDetect");
            undoCmd.setParams(undoMap);
            cmdParams.add(undoCmd);
        }
    }

    private void httpFixResCommand(Set<String> supportAttrs, Map<String, String> params, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpsFixResEnable") && "true".equals(params.get("httpsFixResEnable"))) {
            CmdParam httpFixUriCmdParam = new CmdParam();
            httpFixUriCmdParam.setCmdID("httpsFixResDetect");
            httpFixUriCmdParam.setParams(params);
            cmdParams.add(httpFixUriCmdParam);
        }
    }

    private void undoHttpFixResCommand(Set<String> supportAttrs, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpsFixResEnable")) {
            HashMap<String, String> undoMap = new HashMap<String, String>();
            undoMap.put("undo", "undo");
            CmdParam undoCmd = new CmdParam();
            undoCmd.setCmdID("httpsFixResDetect");
            undoCmd.setParams(undoMap);
            cmdParams.add(undoCmd);
        }
    }

    private void largeResDetectCommand(Set<String> supportAttrs, Map<String, String> params, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpsLargeResDetectEnable") && "true".equals(params.get("httpsLargeResDetectEnable"))) {
            CmdParam largeResDetectCmdParam = new CmdParam();
            largeResDetectCmdParam.setCmdID("httpsLargeResDetect");
            largeResDetectCmdParam.setParams(params);
            cmdParams.add(largeResDetectCmdParam);
        }
    }

    private void undoLargeResDetectCommand(Set<String> supportAttrs, List<CmdParam> cmdParams) {
        if (supportAttrs.contains("httpsLargeResDetectEnable")) {
            HashMap<String, String> undoMap = new HashMap<String, String>();
            undoMap.put("undo", "undo");
            CmdParam undoCmd = new CmdParam();
            undoCmd.setCmdID("httpsLargeResDetect");
            undoCmd.setParams(undoMap);
            cmdParams.add(undoCmd);
        }
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }
}

