/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.form.IcmpDefendPolicyForm;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceIcmpDefendData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = 1738645873921064895L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public ServiceIcmpDefendData() {
    }

    public ServiceIcmpDefendData(Object obj, String featureType, Long featureId) {
        this.setConfigData(obj);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmds = this.doTranslate(logicDev.getDeviceId());
        logger.info((Object)("device : " + logicDev.getDeviceId() + "to deploy cmds:" + this.getcleanedMessage(cmds.toString())));
        this.setCmds(cmds);
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmds);
        logger.info((Object)("deploy result:" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<String> doTranslate(Long moId) {
        Map<String, String> params = VsmUtil.getInstance().getObjectFieldAndValues(this.getConfigData());
        IcmpDefendPolicyForm icmpDefendPolicyForm = (IcmpDefendPolicyForm)this.getConfigData();
        int direction = icmpDefendPolicyForm.getDirection();
        List cmds = null;
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        DdosDevCapabilityServiceImpl devCapabilityService = DdosDevCapabilityServiceImpl.getInstance();
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(moId);
        Set supportAttrs = devCapabilityService.getAllSupportedAttr(devTypeInfo);
        Boolean withServiceViewCustomService = supportAttrs.contains("withServiceViewCustomService");
        boolean icmpNewDestSessionLimitEnable = supportAttrs.contains("icmpNewDestSessionLimitEnable");
        boolean icmpLimitSubEnable = supportAttrs.contains("icmpLimitSubEnable");
        if (direction == 2) {
            CmdParam cmdParam0d = new CmdParam();
            cmdParam0d.setCmdID("icmpMaxSpeedOutbound");
            cmdParam0d.setParams(undoMap);
            cmdParams.add(cmdParam0d);
            if ("true".equals(params.get("icmpLimitSubEnable"))) {
                CmdParam cmdParam4d = new CmdParam();
                cmdParam4d.setCmdID("icmpMaxSpeedOutbound");
                cmdParam4d.setParams(params);
                cmdParams.add(cmdParam4d);
            }
        } else {
            if (withServiceViewCustomService.booleanValue()) {
                this.translateBlockCommand(params, undoMap, cmdParams);
            }
            if (icmpLimitSubEnable) {
                this.translateIcmpLimit(cmdParams, params, undoMap);
            }
            if (icmpNewDestSessionLimitEnable) {
                this.translateDestSessionLimit(cmdParams, params, undoMap);
            }
        }
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moId);
        cmds = tool.doTranslate(cmdFileDir, "icmp_defend", cmdParams);
        return cmds;
    }

    private void translateBlockCommand(Map<String, String> params, Map<String, String> undoMap, List<CmdParam> cmdParams) {
        if ("true".equals(params.get("icmpBlockEnable"))) {
            CmdParam cmdParam1d = new CmdParam();
            cmdParam1d.setCmdID("icmpDrop");
            cmdParams.add(cmdParam1d);
        } else {
            CmdParam cmdParam2d = new CmdParam();
            cmdParam2d.setCmdID("icmpDrop");
            cmdParam2d.setParams(undoMap);
            cmdParams.add(cmdParam2d);
        }
    }

    private void translateIcmpLimit(List<CmdParam> cmdParams, Map<String, String> params, Map<String, String> undoMap) {
        if ("true".equals(params.get("icmpLimitSubEnable"))) {
            CmdParam cmdParam = new CmdParam();
            cmdParam.setCmdID("icmpMaxSpeed");
            cmdParam.setParams(params);
            cmdParams.add(cmdParam);
        } else {
            CmdParam cmdParam0 = new CmdParam();
            cmdParam0.setCmdID("icmpMaxSpeed");
            cmdParam0.setParams(undoMap);
            cmdParams.add(cmdParam0);
        }
    }

    private void translateDestSessionLimit(List<CmdParam> cmdParams, Map<String, String> params, Map<String, String> undoMap) {
        if ("true".equals(params.get("icmpNewDestSessionLimitEnable"))) {
            CmdParam newDestSessionParam = new CmdParam();
            newDestSessionParam.setCmdID("icmpNewDestSessionLimit");
            if (AticUtil.isNull((String)params.get("icmpNewDestSessionLimit"))) {
                params.put("icmpNewDestSessionLimit", "10000");
            }
            newDestSessionParam.setParams(params);
            cmdParams.add(newDestSessionParam);
        } else {
            CmdParam undoNewDestParam = new CmdParam();
            undoNewDestParam.setCmdID("icmpNewDestSessionLimit");
            undoNewDestParam.setParams(undoMap);
            cmdParams.add(undoNewDestParam);
        }
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }
}

