/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.model.ServiceLearningInfo;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ServiceLearningData
implements Serializable {
    public static final int START_COMMAND = 0;
    public static final int STOP_COMMAND = 1;
    private static final String DEFAULT_ZONE_NAME = "default";
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Object configData;
    private Object deviceData;

    public ServiceLearningData() {
    }

    public ServiceLearningData(Object obj) {
        this.setConfigData(obj);
    }

    public boolean excuteStopCommandSingle(ServiceLearningInfo info) {
        if (info != null) {
            List cmds = null;
            ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
            CmdParam cmdParam0sys = new CmdParam();
            cmdParam0sys.setCmdID("system");
            cmdParams.add(cmdParam0sys);
            CmdParam cmdParamDdosZone = new CmdParam();
            cmdParamDdosZone.setCmdID("zone");
            if (info.getZoneType() != Constant.ZONE_TYPE_OF_DEFAULT.intValue()) {
                cmdParamDdosZone.getParams().put("zoneName", info.getZoneAccount());
            } else {
                cmdParamDdosZone.getParams().put(DEFAULT_ZONE_NAME, DEFAULT_ZONE_NAME);
            }
            cmdParams.add(cmdParamDdosZone);
            CmdParam cmdParam0serviceStop = new CmdParam();
            cmdParam0serviceStop.setCmdID("stop_serviceLearning");
            cmdParams.add(cmdParam0serviceStop);
            CommandAPI tool = new CommandAPI();
            String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(Long.valueOf(info.getDeviceId()));
            try {
                cmds = tool.doTranslate(cmdFileDir, "service_learning", cmdParams);
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("service start cmds:" + this.getcleanedMessage(cmds.toString())));
                }
                return this.execCmds(info.getDeviceId(), cmds);
            }
            catch (RuntimeException e) {
                logger.error((Object)("cmd excute error:" + this.getcleanedMessage(((Object)cmdParams).toString())));
                return false;
            }
        }
        return false;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private boolean execCmds(long deviceId, List<String> cmds) {
        try {
            List<String> result = CmdUtil.execCmds(deviceId, cmds);
            if (!result.isEmpty()) {
                for (String errorStr : result) {
                    if (errorStr == null || !errorStr.contains("Error") && !AticUtil.judgmentEcho((String)errorStr)) continue;
                    return false;
                }
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"service learning cmd excute error!!");
            return false;
        }
        return true;
    }

    public boolean excuteStartCommandSingle(ServiceLearningInfo info) {
        if (info != null) {
            List cmds = null;
            ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
            CmdParam cmdParam0sys = new CmdParam();
            cmdParam0sys.setCmdID("system");
            cmdParams.add(cmdParam0sys);
            CmdParam cmdParamDdosZone = new CmdParam();
            cmdParamDdosZone.setCmdID("zone");
            if (info.getZoneType() != Constant.ZONE_TYPE_OF_DEFAULT.intValue()) {
                cmdParamDdosZone.getParams().put("zoneName", info.getZoneAccount());
            } else {
                cmdParamDdosZone.getParams().put(DEFAULT_ZONE_NAME, DEFAULT_ZONE_NAME);
            }
            cmdParams.add(cmdParamDdosZone);
            CmdParam servicePeriod = new CmdParam();
            servicePeriod.setCmdID("serviceLearning_period");
            servicePeriod.getParams().put("period", String.valueOf(info.calculatePeriod()));
            cmdParams.add(servicePeriod);
            CmdParam serviceCmdThreshold = new CmdParam();
            serviceCmdThreshold.setCmdID("serviceLearning_threshold");
            serviceCmdThreshold.getParams().put("flowAlertRate", String.valueOf(info.getRate()));
            cmdParams.add(serviceCmdThreshold);
            CmdParam startupServiceCmd = new CmdParam();
            startupServiceCmd.setCmdID("startup_serviceLearning");
            cmdParams.add(startupServiceCmd);
            CommandAPI tool = new CommandAPI();
            String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(Long.valueOf(info.getDeviceId()));
            try {
                cmds = tool.doTranslate(cmdFileDir, "service_learning", cmdParams);
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("service start cmds:" + this.getcleanedMessage(cmds.toString())));
                }
                return this.execCmds(info.getDeviceId(), cmds);
            }
            catch (RuntimeException e) {
                logger.error((Object)("cmd excute error:" + this.getcleanedMessage(((Object)cmdParams).toString())));
                return false;
            }
        }
        return false;
    }

    public Object getConfigData() {
        return this.configData;
    }

    public void setConfigData(Object configData) {
        this.configData = configData;
    }

    public Object getDeviceData() {
        return this.deviceData;
    }

    public void setDeviceData(Object deviceData) {
        this.deviceData = deviceData;
    }
}

