/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.nfa.util.NfaPolicyUtil;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceNfaDefendData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = -1110764819301054161L;
    private static final Long NUM_1 = 0xFFFFFFFFL;
    private static final long THREHOLD_PER_KPS = 1000L;
    private static final long THREHOLD_PER_MPS = 1000000L;
    private static final long THREHOLD_PER_GPS = 1000000000L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Object basicServiceForm;

    public ServiceNfaDefendData() {
    }

    public ServiceNfaDefendData(Object obj, String featureType, Long featureId, Object basicServiceForm) {
        this.setBasicServiceForm(basicServiceForm);
        this.setConfigData(obj);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    public ServiceNfaDefendData(Object obj, String featureType, Long featureId) {
        this.setConfigData(obj);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmds = this.doTranslate(logicDev.getDeviceId());
        logger.info((Object)("device : " + logicDev.getDeviceId() + "to deploy cmds:" + this.getcleanedMessage(cmds.toString())));
        this.setCmds(cmds);
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmds);
        logger.info((Object)("deploy result:" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<String> doTranslate(Long moId) {
        List cmds = null;
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        NfaPolicyEditForm nfaPolicyEditForm = (NfaPolicyEditForm)this.getConfigData();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        this.getTranslateCmd(nfaPolicyEditForm, cmdParams);
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moId);
        cmds = tool.doTranslate(cmdFileDir, "nfa_defend", cmdParams);
        return cmds;
    }

    private void getTranslateCmd(NfaPolicyEditForm nfaPolicyEditForm, List<CmdParam> cmdParams) {
        int direction = nfaPolicyEditForm.getDirection();
        HashMap<String, Map<String, String>> nfaPolicyParams = new HashMap<String, Map<String, String>>();
        List<NfaPolicyForm> nfaPolicyForms = NfaPolicyUtil.nfaPolicyEditFormConvNfaPolicyFrom(nfaPolicyEditForm);
        for (NfaPolicyForm nfaPolicyForm : nfaPolicyForms) {
            if (nfaPolicyForm.getPpsThreshold() == null || nfaPolicyForm.getBpsThreshold() == null) continue;
            String name = nfaPolicyForm.getName();
            Map<String, String> nfaPolicyMap = VsmUtil.getInstance().getObjectFieldAndValues(nfaPolicyForm);
            nfaPolicyParams.put(name, nfaPolicyMap);
        }
        String name = "";
        if (!nfaPolicyParams.isEmpty()) {
            if (direction == 2) {
                name = "tcpSynFloodOutbound";
                Map tcpSynFloodParams = (Map)nfaPolicyParams.get("Tcp_Syn_Flood");
                this.translateCmd(name, tcpSynFloodParams, cmdParams);
                name = "tcpFragmentFloodOutbound";
                Map tcpFragmentFloodParams = (Map)nfaPolicyParams.get("Tcp_Fragment_Flood");
                this.translateCmd(name, tcpFragmentFloodParams, cmdParams);
                name = "udpFloodOutbound";
                Map udpFloodParams = (Map)nfaPolicyParams.get("Udp_Flood");
                this.translateCmd(name, udpFloodParams, cmdParams);
                name = "udpFragmentFloodOutbound";
                Map udpFragmentFloodParams = (Map)nfaPolicyParams.get("Udp_Fragment_Flood");
                this.translateCmd(name, udpFragmentFloodParams, cmdParams);
                name = "icmpFloodOutbound";
                Map icmpFloodParams = (Map)nfaPolicyParams.get("Icmp_Flood");
                this.translateCmd(name, icmpFloodParams, cmdParams);
            } else {
                name = "hostTotal";
                Map hostTotalParams = (Map)nfaPolicyParams.get("Host_Traffic_Overflow");
                this.translateCmd(name, hostTotalParams, cmdParams);
                name = "tcpAckFlood";
                Map tcpAckFloodParams = (Map)nfaPolicyParams.get("Tcp_Ack_Flood");
                this.translateCmd(name, tcpAckFloodParams, cmdParams);
                name = "tcpSynFlood";
                Map tcpSynFloodParams = (Map)nfaPolicyParams.get("Tcp_Syn_Flood");
                this.translateCmd(name, tcpSynFloodParams, cmdParams);
                name = "tcpRstFinFlood";
                Map tcpRstFinFloodParams = (Map)nfaPolicyParams.get("Tcp_RstFin_Flood");
                this.translateCmd(name, tcpRstFinFloodParams, cmdParams);
                name = "tcpFragmentFlood";
                Map tcpFragmentFloodParams = (Map)nfaPolicyParams.get("Tcp_Fragment_Flood");
                this.translateCmd(name, tcpFragmentFloodParams, cmdParams);
                name = "tcpAbnormalFlood";
                Map tcpAbnormalFloodParams = (Map)nfaPolicyParams.get("Tcp_Malformed_Flood");
                this.translateCmd(name, tcpAbnormalFloodParams, cmdParams);
                name = "udpFlood";
                Map udpFloodParams = (Map)nfaPolicyParams.get("Udp_Flood");
                this.translateCmd(name, udpFloodParams, cmdParams);
                name = "udpFragmentFlood";
                Map udpFragmentFloodParams = (Map)nfaPolicyParams.get("Udp_Fragment_Flood");
                this.translateCmd(name, udpFragmentFloodParams, cmdParams);
                name = "dnsQueryFlood";
                Map dnsQueryFloodParams = (Map)nfaPolicyParams.get("Dns_Query_Flood");
                this.translateCmd(name, dnsQueryFloodParams, cmdParams);
                name = "dnsReplyFlood";
                Map dnsReplyFloodParams = (Map)nfaPolicyParams.get("Dns_Reply_Flood");
                this.translateCmd(name, dnsReplyFloodParams, cmdParams);
                name = "httpFlood";
                Map httpFloodParams = (Map)nfaPolicyParams.get("Http_Flood");
                this.translateCmd(name, httpFloodParams, cmdParams);
                name = "httpsFlood";
                Map httpsFloodParams = (Map)nfaPolicyParams.get("Https_Flood");
                this.translateCmd(name, httpsFloodParams, cmdParams);
                name = "sipFlood";
                Map sipFloodParams = (Map)nfaPolicyParams.get("Sip_Flood");
                this.translateCmd(name, sipFloodParams, cmdParams);
                name = "icmpFlood";
                Map icmpFloodParams = (Map)nfaPolicyParams.get("Icmp_Flood");
                this.translateCmd(name, icmpFloodParams, cmdParams);
                name = "otherFlood";
                Map otherFloodParams = (Map)nfaPolicyParams.get("Other_Flood");
                this.translateCmd(name, otherFloodParams, cmdParams);
                name = "darkIp";
                Map darkIpParams = (Map)nfaPolicyParams.get("Dark_Ip");
                this.translateCmd(name, darkIpParams, cmdParams);
            }
        }
    }

    private void translateCmd(String name, Map<String, String> params, List<CmdParam> cmdParams) {
        if (null == params) {
            return;
        }
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        if (params.get("ppsUnit").contains("pps")) {
            CmdParam cmdParam03 = new CmdParam();
            cmdParam03.setCmdID(name + "pps");
            cmdParam03.setParams(undoMap);
            cmdParams.add(cmdParam03);
        }
        if (params.get("bpsUnit").contains("bps")) {
            CmdParam cmdParam04 = new CmdParam();
            cmdParam04.setCmdID(name + "Kbps");
            cmdParam04.setParams(undoMap);
            cmdParams.add(cmdParam04);
        }
        if ("true".equals(params.get("enable")) && !name.equals("")) {
            if ("true".equals(params.get("ppsEnable"))) {
                Long ppsThreshold;
                CmdParam cmdParam = new CmdParam();
                cmdParam.setCmdID(name + "pps");
                if (params.get("ppsUnit").equals("pps")) {
                    cmdParam.setParams(params);
                } else if (params.get("ppsUnit").equals("Kpps")) {
                    ppsThreshold = Long.valueOf(params.get("ppsThreshold"));
                    ppsThreshold = ppsThreshold * 1000L;
                    params.put("ppsThreshold", ppsThreshold.toString());
                    cmdParam.setParams(params);
                } else if (params.get("ppsUnit").equals("Mpps")) {
                    ppsThreshold = Long.valueOf(params.get("ppsThreshold"));
                    ppsThreshold = ppsThreshold * 1000000L;
                    params.put("ppsThreshold", ppsThreshold.toString());
                    cmdParam.setParams(params);
                } else {
                    ppsThreshold = Long.valueOf(params.get("ppsThreshold"));
                    ppsThreshold = ppsThreshold * 1000000000L;
                    params.put("ppsThreshold", ppsThreshold.toString());
                    cmdParam.setParams(params);
                }
                cmdParams.add(cmdParam);
            }
            if ("true".equals(params.get("bpsEnable"))) {
                Long bpsThreshold;
                CmdParam cmdParam02 = new CmdParam();
                cmdParam02.setCmdID(name + "Kbps");
                if (params.get("bpsUnit").equals("Kbps")) {
                    cmdParam02.setParams(params);
                } else if (params.get("bpsUnit").equals("Mbps")) {
                    bpsThreshold = Long.valueOf(params.get("bpsThreshold"));
                    bpsThreshold = bpsThreshold * 1000L;
                    params.put("bpsThreshold", bpsThreshold.toString());
                    cmdParam02.setParams(params);
                } else {
                    bpsThreshold = Long.valueOf(params.get("bpsThreshold"));
                    bpsThreshold = bpsThreshold * 1000000L;
                    params.put("bpsThreshold", bpsThreshold.toString());
                    cmdParam02.setParams(params);
                }
                cmdParams.add(cmdParam02);
            }
        }
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    public Object getBasicServiceForm() {
        return this.basicServiceForm;
    }

    public void setBasicServiceForm(Object basicServiceForm) {
        this.basicServiceForm = basicServiceForm;
    }
}

