/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.UdpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceUdpDefendData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = 6417596947980148825L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Object basicServiceForm;

    public ServiceUdpDefendData() {
    }

    public ServiceUdpDefendData(Object obj, String featureType, Long featureId, Object basicServiceForm) {
        this.setBasicServiceForm(basicServiceForm);
        this.setConfigData(obj);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    public Object getBasicServiceForm() {
        return this.basicServiceForm;
    }

    public void setBasicServiceForm(Object basicServiceForm) {
        this.basicServiceForm = basicServiceForm;
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        List<String> cmds = this.doTranslate(logicDev.getDeviceId());
        logger.info((Object)("device : " + logicDev.getDeviceId() + "to deploy cmds:" + this.getcleanedMessage(cmds.toString())));
        this.setCmds(cmds);
        List<String> result = CmdUtil.execCmds(logicDev.getDeviceId(), cmds);
        logger.info((Object)("deploy result:" + this.getcleanedMessage(result.toString())));
        return result;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<String> doTranslate(Long moId) {
        List cmds = null;
        HashMap<String, String> undoMap = new HashMap<String, String>();
        undoMap.put("undo", "undo");
        UdpDefendPolicyForm udpForm = (UdpDefendPolicyForm)this.getConfigData();
        int direction = udpForm.getDirection();
        Map<String, String> params = VsmUtil.getInstance().getObjectFieldAndValues(udpForm);
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        ZoneServiceForm basicServiceForms = (ZoneServiceForm)this.getBasicServiceForm();
        if (viewList.size() == Constant.CUSTOM_SERVICE_SIZE.intValue() && !"DEFAULT".equals(basicServiceForms.getProtocol()) && direction == 1) {
            CmdParam cmdParamS0;
            if ("true".equals(params.get("udpLimitEnable"))) {
                params.put("serviceName", basicServiceForms.getServiceName());
                undoMap.put("serviceName", basicServiceForms.getServiceName());
                cmdParamS0 = new CmdParam();
                cmdParamS0.setCmdID("customServiceLimit");
                cmdParamS0.setParams(undoMap);
                cmdParams.add(cmdParamS0);
                CmdParam cmdParamS0d = new CmdParam();
                cmdParamS0d.setCmdID("customServiceLimit");
                cmdParamS0d.setParams(params);
                cmdParams.add(cmdParamS0d);
            } else {
                undoMap.put("serviceName", basicServiceForms.getServiceName());
                cmdParamS0 = new CmdParam();
                cmdParamS0.setCmdID("customServiceLimit");
                cmdParamS0.setParams(undoMap);
                cmdParams.add(cmdParamS0);
            }
            CommandAPI tool = new CommandAPI();
            String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moId);
            cmds = tool.doTranslate(cmdFileDir, "udp_defend", cmdParams);
            return cmds;
        }
        if (direction == 2) {
            CmdParam cmdParam4d;
            CmdParam cmdParam0d = new CmdParam();
            cmdParam0d.setCmdID("udpMaxSpeedOutbound");
            cmdParam0d.setParams(undoMap);
            cmdParams.add(cmdParam0d);
            CmdParam cmdParam = new CmdParam();
            cmdParam.setCmdID("udpFragMaxSpeedOutbound");
            cmdParam.setParams(undoMap);
            cmdParams.add(cmdParam);
            if ("true".equals(params.get("udpMaxSpeedEnable"))) {
                cmdParam4d = new CmdParam();
                cmdParam4d.setCmdID("udpMaxSpeedOutbound");
                cmdParam4d.setParams(params);
                cmdParams.add(cmdParam4d);
            }
            if ("true".equals(params.get("udpFragMaxSpeedEnable"))) {
                cmdParam4d = new CmdParam();
                cmdParam4d.setCmdID("udpFragMaxSpeedOutbound");
                cmdParam4d.setParams(params);
                cmdParams.add(cmdParam4d);
            }
        } else {
            this.undoUdpDefend(undoMap, cmdParams);
            this.deployBlock(params, cmdParams);
            this.deployDefendConf(params, cmdParams);
            this.deployLimit(params, cmdParams);
        }
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moId);
        cmds = tool.doTranslate(cmdFileDir, "udp_defend", cmdParams);
        return cmds;
    }

    private void deployLimit(Map<String, String> params, List<CmdParam> cmdParams) {
        CmdParam cmdParam1;
        if (!"true".equals(params.get("udpLimitEnable"))) {
            return;
        }
        ZoneServiceForm basicServiceForms = (ZoneServiceForm)this.getBasicServiceForm();
        boolean isDefaultService = "DEFAULT".equals(basicServiceForms.getProtocol());
        boolean isUdpService = "UDP".equals(basicServiceForms.getProtocol());
        if (isDefaultService) {
            if ("true".equals(params.get("udpMaxSpeedEnable"))) {
                cmdParam1 = new CmdParam();
                cmdParam1.setCmdID("defaultUdpLimit");
                cmdParam1.setParams(params);
                cmdParams.add(cmdParam1);
            }
            if ("true".equals(params.get("udpFragMaxSpeedEnable"))) {
                CmdParam cmdParam2 = new CmdParam();
                cmdParam2.setCmdID("udpFragLimit");
                cmdParam2.setParams(params);
                cmdParams.add(cmdParam2);
            }
        }
        if (isUdpService) {
            cmdParam1 = new CmdParam();
            cmdParam1.setCmdID("udpLimit");
            cmdParam1.setParams(params);
            cmdParams.add(cmdParam1);
        }
        if (isDefaultService && this.isUdpNewDestSessionLimitEnable(basicServiceForms.getDeviceId()) && "true".equals(params.get("udpNewDestSessionLimitEnable"))) {
            CmdParam newDestSessionParam = new CmdParam();
            newDestSessionParam.setCmdID("udpNewDestSessionLimit");
            if (AticUtil.isNull((String)params.get("udpNewDestSessionLimit"))) {
                params.put("udpNewDestSessionLimit", "10000");
            }
            newDestSessionParam.setParams(params);
            cmdParams.add(newDestSessionParam);
        }
    }

    private void deployDefendConf(Map<String, String> params, List<CmdParam> cmdParams) {
        if (!"true".equals(params.get("udpDefendEnable"))) {
            return;
        }
        ZoneServiceForm basicServiceForms = (ZoneServiceForm)this.getBasicServiceForm();
        boolean isDefaultService = "DEFAULT".equals(basicServiceForms.getProtocol());
        if ("true".equals(params.get("alertSpeedEnable")) && "true".equals(params.get("udpContentCheckEnable"))) {
            CmdParam checkParam = new CmdParam();
            checkParam.setCmdID("contentCheck");
            checkParam.setParams(params);
            cmdParams.add(checkParam);
        }
        if (isDefaultService && "true".equals(params.get("fragAlertSpeedEnable")) && "true".equals(params.get("udpFragContentCheckEnable"))) {
            CmdParam cmdParam1 = new CmdParam();
            cmdParam1.setCmdID("fragContentCheck");
            cmdParam1.setParams(params);
            cmdParams.add(cmdParam1);
        }
        if ("true".equals(params.get("udpFirstPacketCheckEnable"))) {
            CmdParam cmdParam = new CmdParam();
            cmdParam.setCmdID("udpFirstPacketCheck");
            cmdParam.setParams(params);
            cmdParams.add(cmdParam);
        }
        if ("true".equals(params.get("udpAbnormalEnable"))) {
            CmdParam cmdParam5 = new CmdParam();
            cmdParam5.setCmdID("udpAbnormalFlood");
            cmdParam5.setParams(params);
            cmdParams.add(cmdParam5);
        }
        if ("true".equals(params.get("udpRelTcpDefendEnable"))) {
            String udpRelTcpDefendName = params.get("udpRelTcpDefendName");
            if (null != udpRelTcpDefendName) {
                int i = udpRelTcpDefendName.indexOf("[");
                params.remove("udpRelTcpDefendName");
                params.put("udpRelTcpDefendName", udpRelTcpDefendName.substring(0, i).trim());
            } else {
                params.remove("udpRelTcpDefendName");
            }
            CmdParam cmdParam4 = new CmdParam();
            cmdParam4.setCmdID("relationDefend");
            cmdParam4.setParams(params);
            cmdParams.add(cmdParam4);
        }
    }

    private void deployBlock(Map<String, String> params, List<CmdParam> cmdParams) {
        if (!"true".equals(params.get("udpBlock"))) {
            return;
        }
        ZoneServiceForm basicServiceForms = (ZoneServiceForm)this.getBasicServiceForm();
        boolean isDefaultService = "DEFAULT".equals(basicServiceForms.getProtocol());
        boolean isUdpService = "UDP".equals(basicServiceForms.getProtocol());
        if (isDefaultService) {
            CmdParam cmdParam0 = new CmdParam();
            cmdParam0.setCmdID("defaultUdpServiceDrop");
            cmdParams.add(cmdParam0);
        }
        if (isUdpService) {
            CmdParam cmdParam1 = new CmdParam();
            cmdParam1.setCmdID("udpServiceDrop");
            cmdParams.add(cmdParam1);
        }
    }

    private void undoUdpDefend(Map<String, String> undoMap, List<CmdParam> cmdParams) {
        CmdParam checkParam;
        ZoneServiceForm basicServiceForms = (ZoneServiceForm)this.getBasicServiceForm();
        boolean isDefaultService = "DEFAULT".equals(basicServiceForms.getProtocol());
        boolean isUdpService = "UDP".equals(basicServiceForms.getProtocol());
        Boolean isSipService = "SIP".equals(basicServiceForms.getProtocol());
        if (isDefaultService) {
            CmdParam cmdParam0 = new CmdParam();
            cmdParam0.setCmdID("defaultUdpServiceDrop");
            cmdParam0.setParams(undoMap);
            cmdParams.add(cmdParam0);
            CmdParam cmdParam11 = new CmdParam();
            cmdParam11.setCmdID("udpAbnormalFlood");
            cmdParam11.setParams(undoMap);
            cmdParams.add(cmdParam11);
        }
        if (isUdpService) {
            CmdParam cmdParam1 = new CmdParam();
            cmdParam1.setCmdID("udpServiceDrop");
            cmdParam1.setParams(undoMap);
            cmdParams.add(cmdParam1);
        }
        if (!isSipService.booleanValue()) {
            checkParam = new CmdParam();
            checkParam.setCmdID("contentCheck");
            checkParam.setParams(undoMap);
            cmdParams.add(checkParam);
        }
        if (isDefaultService) {
            checkParam = new CmdParam();
            checkParam.setCmdID("fragContentCheck");
            checkParam.setParams(undoMap);
            cmdParams.add(checkParam);
        }
        if (isDefaultService) {
            CmdParam cmdParam7 = new CmdParam();
            cmdParam7.setCmdID("defaultUdpLimit");
            cmdParam7.setParams(undoMap);
            cmdParams.add(cmdParam7);
            CmdParam cmdParam8 = new CmdParam();
            cmdParam8.setCmdID("udpFragLimit");
            cmdParam8.setParams(undoMap);
            cmdParams.add(cmdParam8);
        }
        if (isUdpService) {
            CmdParam cmdParam9 = new CmdParam();
            cmdParam9.setCmdID("udpLimit");
            cmdParam9.setParams(undoMap);
            cmdParams.add(cmdParam9);
        }
        if (isDefaultService && this.isUdpNewDestSessionLimitEnable(basicServiceForms.getDeviceId())) {
            CmdParam cmdParam10 = new CmdParam();
            cmdParam10.setCmdID("udpNewDestSessionLimit");
            cmdParam10.setParams(undoMap);
            cmdParams.add(cmdParam10);
        }
        if (this.isUdpFirstPacketCheckEnable(basicServiceForms.getDeviceId())) {
            CmdParam cmdParam11 = new CmdParam();
            cmdParam11.setCmdID("udpFirstPacketCheck");
            cmdParam11.setParams(undoMap);
            cmdParams.add(cmdParam11);
        }
    }

    private boolean isUdpNewDestSessionLimitEnable(Long moId) {
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(moId);
        Set supportAttr = DdosDevCapabilityServiceImpl.getInstance().getAllSupportedAttr(devTypeInfo);
        return supportAttr.contains("udpNewDestSessionLimitEnable");
    }

    private boolean isUdpFirstPacketCheckEnable(Long moId) {
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(moId);
        Set supportAttr = DdosDevCapabilityServiceImpl.getInstance().getAllSupportedAttr(devTypeInfo);
        return supportAttr.contains("udpFirstPacketCheckEnable");
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }
}

