/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZonePortMapForm;
import com.hs.atic.zone.model.ZonePortMapInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.common.CommandPair;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.service.data.ZoneDeployResult;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectionPool;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.huawei.atic.south.model.TelnetPara;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZonePortMapData
extends AbstractFeature
implements Serializable {
    private static final long serialVersionUID = 7048602248309187283L;
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private List<String> zoneIp;
    private String cmdFileDir;
    private String commandType = ZonePortMapInfo.class.getSimpleName();

    public ZonePortMapData() {
    }

    public ZonePortMapData(Object configData, String featureType, Long featureId, List<String> zoneIp) {
        this.setConfigData(configData);
        this.setFeatureId(featureId);
        this.setFeatureType(featureType);
        this.setZoneIp(zoneIp);
    }

    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        ArrayList<String> totalResult = new ArrayList<String>();
        Long moid = logicDev.getDeviceId();
        ExcmdConnectUtil excmdConnectUtil = null;
        IAticDeviceService aticDeviceService = ZoneReferUtil.getFirewallService();
        TelnetPara telnetPara = aticDeviceService.getDeviceTelnetPara(moid.longValue());
        this.cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(moid);
        ZoneDeployResult zoneDeployResult = (ZoneDeployResult)object;
        ZoneInfoForm infoForm = (ZoneInfoForm)this.getConfigData();
        this.clearPortMapCommandPair(moid, infoForm.getZoneId(), zoneDeployResult.getCommandDeployResult());
        boolean cmdResultFlag = false;
        boolean isAllFail = true;
        List<String> cmd = null;
        try {
            if (null != telnetPara) {
                excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                cmdResultFlag = this.execCmds(excmdConnectUtil, totalResult, cmd = this.doZoneViewCmds(), true);
                if (!cmdResultFlag) {
                    this.deployResultAllFail(moid, zoneDeployResult);
                    ArrayList<String> arrayList = totalResult;
                    return arrayList;
                }
                if (infoForm.isUndoAll()) {
                    cmd = this.undoAllPortMapCmd();
                    cmdResultFlag = this.execCmds(excmdConnectUtil, totalResult, cmd, false);
                    if (!cmdResultFlag) {
                        this.deployResultAllFail(moid, zoneDeployResult);
                        ArrayList<String> arrayList = totalResult;
                        return arrayList;
                    }
                    isAllFail = false;
                    List<ZonePortMapForm> zonePortMapFormList = infoForm.getZoneDoPortMapFormLis();
                    if (null != zonePortMapFormList && !zonePortMapFormList.isEmpty()) {
                        int size = zonePortMapFormList.size();
                        for (int i = 0; i < size; ++i) {
                            ZonePortMapForm zonePortMapForm = zonePortMapFormList.get(i);
                            ArrayList<ZonePortMapForm> zonePortMapForms = new ArrayList<ZonePortMapForm>();
                            zonePortMapForms.add(zonePortMapForm);
                            try {
                                cmd = this.doPortMapCmd(zonePortMapForm);
                                cmdResultFlag = this.execCmds(excmdConnectUtil, totalResult, cmd, false);
                                if (!cmdResultFlag) {
                                    this.deployPortMapResult(moid, zoneDeployResult, zonePortMapForms, false);
                                    continue;
                                }
                                this.deployPortMapResult(moid, zoneDeployResult, zonePortMapForms, true);
                                continue;
                            }
                            catch (LegoCheckedException e) {
                                zonePortMapForms.clear();
                                zonePortMapForms.addAll(zonePortMapFormList.subList(i, size));
                                this.deployPortMapResult(moid, zoneDeployResult, zonePortMapForms, false);
                                logger.error((Object)("@doDeploy, deploy zoneIp, EXE CLI ERROR : " + e.getMessage()));
                                throw e;
                            }
                            catch (Exception e) {
                                zonePortMapForms.clear();
                                zonePortMapForms.addAll(zonePortMapFormList.subList(i, size));
                                this.deployPortMapResult(moid, zoneDeployResult, zonePortMapForms, false);
                                logger.error((Object)("Exception : " + e.getMessage()));
                                throw new LegoCheckedException(630005L, (Throwable)e);
                            }
                        }
                    }
                } else {
                    isAllFail = false;
                    List<ZonePortMapForm> zoneUndoPortMapFormList = infoForm.getZoneUndoPortMapFormList();
                    if (null != zoneUndoPortMapFormList && !zoneUndoPortMapFormList.isEmpty()) {
                        int size = zoneUndoPortMapFormList.size();
                        for (int i = 0; i < size; ++i) {
                            ZonePortMapForm zoneUndoPortMapForm = zoneUndoPortMapFormList.get(i);
                            ArrayList<ZonePortMapForm> zoneUndoPortMapForms = new ArrayList<ZonePortMapForm>();
                            zoneUndoPortMapForms.add(zoneUndoPortMapForm);
                            try {
                                cmd = this.undoPortMapCmd(zoneUndoPortMapForm);
                                cmdResultFlag = this.execCmds(excmdConnectUtil, totalResult, cmd, false);
                                if (!cmdResultFlag) {
                                    this.undoPortMapResult(moid, zoneDeployResult, zoneUndoPortMapForms, false);
                                    continue;
                                }
                                this.undoPortMapResult(moid, zoneDeployResult, zoneUndoPortMapForms, true);
                                continue;
                            }
                            catch (LegoCheckedException e) {
                                zoneUndoPortMapForms.clear();
                                zoneUndoPortMapForms.addAll(zoneUndoPortMapFormList.subList(i, size));
                                this.undoPortMapResult(moid, zoneDeployResult, zoneUndoPortMapForms, false);
                                this.deployPortMapResult(moid, zoneDeployResult, infoForm.getZoneDoPortMapFormLis(), false);
                                logger.error((Object)("@doDeploy, deploy zoneIp, EXE CLI ERROR : " + e.getMessage()));
                                throw e;
                            }
                            catch (Exception e) {
                                zoneUndoPortMapForms.clear();
                                zoneUndoPortMapForms.addAll(zoneUndoPortMapFormList.subList(i, size));
                                this.undoPortMapResult(moid, zoneDeployResult, zoneUndoPortMapForms, false);
                                this.deployPortMapResult(moid, zoneDeployResult, infoForm.getZoneDoPortMapFormLis(), false);
                                logger.error((Object)e.getMessage());
                                throw new LegoCheckedException(630005L, (Throwable)e);
                            }
                        }
                    }
                    isAllFail = false;
                    List<ZonePortMapForm> zonePortMapFormList = infoForm.getZoneDoPortMapFormLis();
                    if (null != zonePortMapFormList && !zonePortMapFormList.isEmpty()) {
                        int size = zonePortMapFormList.size();
                        for (int i = 0; i < size; ++i) {
                            ZonePortMapForm zonePortMapForm = zonePortMapFormList.get(i);
                            ArrayList<ZonePortMapForm> zonePortMapForms = new ArrayList<ZonePortMapForm>();
                            zonePortMapForms.add(zonePortMapForm);
                            try {
                                cmd = this.doPortMapCmd(zonePortMapForm);
                                cmdResultFlag = this.execCmds(excmdConnectUtil, totalResult, cmd, false);
                                if (!cmdResultFlag) {
                                    this.deployPortMapResult(moid, zoneDeployResult, zonePortMapForms, false);
                                    continue;
                                }
                                this.deployPortMapResult(moid, zoneDeployResult, zonePortMapForms, true);
                                continue;
                            }
                            catch (LegoCheckedException e) {
                                zonePortMapForms.clear();
                                zonePortMapForms.addAll(zonePortMapFormList.subList(i, size));
                                this.deployPortMapResult(moid, zoneDeployResult, zonePortMapForms, false);
                                logger.error((Object)("@doDeploy, deploy zoneIp, EXE CLI ERROR : " + e.getMessage()));
                                throw e;
                            }
                            catch (Exception e) {
                                zonePortMapForms.clear();
                                zonePortMapForms.addAll(zonePortMapFormList.subList(i, size));
                                this.deployPortMapResult(moid, zoneDeployResult, zonePortMapForms, false);
                                logger.error((Object)e.getMessage());
                                throw new LegoCheckedException(630005L, (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
        catch (LegoCheckedException e) {
            if (isAllFail) {
                this.deployResultAllFail(moid, zoneDeployResult);
            }
            logger.error((Object)("@doDeploy, EXE CLI ERROR : " + e.getMessage()));
            throw e;
        }
        finally {
            if (null != telnetPara) {
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(moid.longValue(), excmdConnectUtil);
            }
        }
        return totalResult;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void clearPortMapCommandPair(Long deviceId, Long zoneId, Map<CommandPair, Boolean> commandDeployResult) {
        Iterator<Map.Entry<CommandPair, Boolean>> commandPairEntrys = commandDeployResult.entrySet().iterator();
        while (commandPairEntrys.hasNext()) {
            CommandPair commandPair = commandPairEntrys.next().getKey();
            if (!deviceId.equals(commandPair.getDeviceId()) || !zoneId.equals(commandPair.getZoneId()) || !this.commandType.equals(commandPair.getCommandType())) continue;
            commandPairEntrys.remove();
        }
    }

    private List<String> doZoneViewCmds() {
        ArrayList<CmdParam> cmdParamList = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParamList);
        List<String> reCmds = this.doTranslate(cmdParamList);
        logger.info((Object)("into zoneView cmd : " + this.getcleanedMessage(reCmds.toString())));
        return reCmds;
    }

    private List<String> undoAllPortMapCmd() {
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        CmdParam cmdParamUndo = new CmdParam();
        cmdParamUndo.setCmdID("undoServiceHttp");
        cmdParams.add(cmdParamUndo);
        List<String> reCmds = this.doTranslate(cmdParams);
        logger.info((Object)("undo all cmd : " + this.getcleanedMessage(reCmds.toString())));
        return reCmds;
    }

    private List<String> doPortMapCmd(ZonePortMapForm zonePortMapForm) {
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        logger.info((Object)("deploy cmd data is" + zonePortMapForm.toString()));
        Map<String, String> paramsMap = VsmUtil.getInstance().getObjectFieldAndValues(zonePortMapForm);
        HashMap<String, String> undoParamsMap = new HashMap<String, String>();
        undoParamsMap.putAll(paramsMap);
        undoParamsMap.put("undo", "undo");
        CmdParam undoCmdParam = new CmdParam();
        if (IPUtil.isIpv6((String)zonePortMapForm.getIpAddress())) {
            undoCmdParam.setCmdID("zonePortMapIpV6");
        } else {
            undoCmdParam.setCmdID("zonePortMap");
        }
        undoCmdParam.setParams(undoParamsMap);
        cmdParams.add(undoCmdParam);
        paramsMap.remove("undo");
        CmdParam cmdParam = new CmdParam();
        if (IPUtil.isIpv6((String)zonePortMapForm.getIpAddress())) {
            cmdParam.setCmdID("zonePortMapIpV6");
        } else {
            cmdParam.setCmdID("zonePortMap");
        }
        cmdParam.setParams(paramsMap);
        cmdParams.add(cmdParam);
        List<String> reCmds = this.doTranslate(cmdParams);
        logger.info((Object)("do ip cmd : " + this.getcleanedMessage(reCmds.toString())));
        return reCmds;
    }

    private List<String> undoPortMapCmd(ZonePortMapForm zoneUndoportMapForm) {
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        Map<String, String> paramsMap = VsmUtil.getInstance().getObjectFieldAndValues(zoneUndoportMapForm);
        paramsMap.put("undo", "undo");
        CmdParam cmdParam = new CmdParam();
        if (IPUtil.isIpv6((String)zoneUndoportMapForm.getIpAddress())) {
            cmdParam.setCmdID("zonePortMapIpV6");
        } else {
            cmdParam.setCmdID("zonePortMap");
        }
        cmdParam.setParams(paramsMap);
        cmdParams.add(cmdParam);
        List<String> reCmds = this.doTranslate(cmdParams);
        logger.info((Object)("undo ip cmd : " + this.getcleanedMessage(reCmds.toString())));
        return reCmds;
    }

    private List<String> doTranslate(List<CmdParam> cmdParamList) {
        CommandAPI tool = new CommandAPI();
        String separator = System.getProperty("line.separator");
        ArrayList<String> reCmds = new ArrayList<String>();
        List cmds = tool.doTranslate(this.cmdFileDir, "firwall_ddos", cmdParamList);
        Iterator iterator = cmds.iterator();
        while (iterator.hasNext()) {
            String cmdStrTemp;
            String cmdStr = cmdStrTemp = (String)iterator.next();
            cmdStr = cmdStr.replaceAll("lineseparatortmp", separator);
            reCmds.add(cmdStr);
        }
        return reCmds;
    }

    private Boolean execCmds(ExcmdConnectUtil excmdConnectUtil, List<String> totalResult, List<String> cmd, boolean isExeReturn) {
        this.addCmd(cmd);
        List<String> result = CmdUtil.execCmds(excmdConnectUtil, cmd, isExeReturn);
        logger.info((Object)("deploy result : " + this.getcleanedMessage(result.toString())));
        totalResult.addAll(result);
        Boolean flag = VsmUtil.getInstance().checkCmdResult(result);
        logger.info((Object)("deploy flag : " + flag));
        return flag;
    }

    private void deployResultAllFail(Long deviceId, ZoneDeployResult zoneDeployResult) {
        block6: {
            List<ZonePortMapForm> zoneDoPortMapForms;
            Long zoneId;
            ZoneInfoForm infoForm;
            Set<CommandPair> commandPairSet;
            Map<CommandPair, Boolean> commandDeployResult;
            block5: {
                commandDeployResult = zoneDeployResult.getCommandDeployResult();
                commandPairSet = commandDeployResult.keySet();
                infoForm = (ZoneInfoForm)this.getConfigData();
                zoneId = infoForm.getZoneId();
                if (!infoForm.isUndoAll()) break block5;
                List<ZonePortMapForm> zonePortMapForms = infoForm.getZoneDoPortMapFormLis();
                if (null == zonePortMapForms || zonePortMapForms.isEmpty()) break block6;
                int size = zonePortMapForms.size();
                for (int i = 0; i < size; ++i) {
                    ZonePortMapForm zoneIpForm = zonePortMapForms.get(i);
                    Long id = zoneIpForm.getId();
                    CommandPair curCommand = new CommandPair(zoneId, deviceId, this.commandType, id);
                    if (commandPairSet.contains(curCommand) && !commandDeployResult.get(curCommand).booleanValue()) continue;
                    commandDeployResult.put(curCommand, false);
                }
                break block6;
            }
            List<ZonePortMapForm> zoneUndoPortMapForms = infoForm.getZoneUndoPortMapFormList();
            if (null != zoneUndoPortMapForms && !zoneUndoPortMapForms.isEmpty()) {
                int size = zoneUndoPortMapForms.size();
                for (int i = 0; i < size; ++i) {
                    ZonePortMapForm zoneUndoPortMapForm = zoneUndoPortMapForms.get(i);
                    Long id = zoneUndoPortMapForm.getId();
                    CommandPair curCommand = new CommandPair(zoneId, deviceId, this.commandType, id);
                    if (commandPairSet.contains(curCommand) && !commandDeployResult.get(curCommand).booleanValue()) continue;
                    commandDeployResult.put(curCommand, false);
                }
            }
            if (null != (zoneDoPortMapForms = infoForm.getZoneDoPortMapFormLis()) && !zoneDoPortMapForms.isEmpty()) {
                int size = zoneDoPortMapForms.size();
                for (int i = 0; i < size; ++i) {
                    ZonePortMapForm zoneUndoIpForm = zoneDoPortMapForms.get(i);
                    Long id = zoneUndoIpForm.getId();
                    CommandPair curCommand = new CommandPair(zoneId, deviceId, this.commandType, id);
                    if (commandPairSet.contains(curCommand) && !commandDeployResult.get(curCommand).booleanValue()) continue;
                    commandDeployResult.put(curCommand, false);
                }
            }
        }
    }

    private void deployPortMapResult(Long deviceId, ZoneDeployResult zoneDeployResult, List<ZonePortMapForm> zoneDoPortMapForms, boolean flag) {
        Map<CommandPair, Boolean> commandDeployResult = zoneDeployResult.getCommandDeployResult();
        Set<CommandPair> commandPairSet = commandDeployResult.keySet();
        ZoneInfoForm infoForm = (ZoneInfoForm)this.getConfigData();
        Long zoneId = infoForm.getZoneId();
        if (null != zoneDoPortMapForms && !zoneDoPortMapForms.isEmpty()) {
            int size = zoneDoPortMapForms.size();
            for (int i = 0; i < size; ++i) {
                ZonePortMapForm zoneIpForm = zoneDoPortMapForms.get(i);
                Long id = zoneIpForm.getId();
                CommandPair curCommand = new CommandPair(zoneId, deviceId, this.commandType, id);
                if (flag) {
                    if (commandPairSet.contains(curCommand)) continue;
                    commandDeployResult.put(curCommand, true);
                    continue;
                }
                if (commandPairSet.contains(curCommand) && !commandDeployResult.get(curCommand).booleanValue()) continue;
                commandDeployResult.put(curCommand, false);
            }
        }
    }

    private void undoPortMapResult(Long deviceId, ZoneDeployResult zoneDeployResult, List<ZonePortMapForm> zoneUndoPortMapForms, boolean flag) {
        Map<CommandPair, Boolean> commandDeployResult = zoneDeployResult.getCommandDeployResult();
        Set<CommandPair> commandPairSet = commandDeployResult.keySet();
        ZoneInfoForm infoForm = (ZoneInfoForm)this.getConfigData();
        Long zoneId = infoForm.getZoneId();
        if (null != zoneUndoPortMapForms && !zoneUndoPortMapForms.isEmpty()) {
            int size = zoneUndoPortMapForms.size();
            for (int i = 0; i < size; ++i) {
                ZonePortMapForm zoneIpForm = zoneUndoPortMapForms.get(i);
                Long id = zoneIpForm.getId();
                CommandPair curCommand = new CommandPair(zoneId, deviceId, this.commandType, id);
                if (flag) {
                    if (commandPairSet.contains(curCommand)) continue;
                    commandDeployResult.put(curCommand, true);
                    continue;
                }
                if (commandPairSet.contains(curCommand) && !commandDeployResult.get(curCommand).booleanValue()) continue;
                commandDeployResult.put(curCommand, false);
            }
        }
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    public List<String> getZoneIp() {
        return this.zoneIp;
    }

    public void setZoneIp(List<String> zoneIp) {
        this.zoneIp = zoneIp;
    }
}

