/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.data.feature;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IBlackWhiteListService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.adapter.frame.service.CmdDevCapManager;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.huawei.atic.util.CapaUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class ZoneWhiteListData
extends AbstractFeature
implements Serializable {
    private static final int BATCH_SIZE = 1000;
    private static final int REPEATED_TIMES = 3;
    private static final int LOG_BLACK_CMD_SUCCESS = 1;
    private static final int LOG_BLACK_CMD_FAILED = 0;
    private static final long serialVersionUID = -8918274995893353825L;
    private static final String DDOS_POLICY_BLACK_OPERATION = "com.hs.vsm.secservice.ddos.policy.white.operation";
    private static final String DDOS_POLICY_MODULE = "com.hs.vsm.secservice.ddos.policy.module";
    private static final String DDOS_POLICY_BLACK_LOG_DETAILS = "com.hs.vsm.secservice.ddos.policy.white.log.details";
    private static final String ERROR_CONFIGURATION = "error:";
    private static ReentrantLock lock = new ReentrantLock();
    private static final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private List<ZoneWhiteForm> list;
    private List<ZoneWhiteForm> zoneWhiteFormList = new ArrayList<ZoneWhiteForm>();
    private List<ZoneWhiteForm> undoZoneWhiteFormList = new ArrayList<ZoneWhiteForm>();
    private List<ZoneWhiteForm> resultZoneWhiteFormList = new ArrayList<ZoneWhiteForm>(1000);
    private List<ZoneWhiteForm> resultUndoZoneWhiteFormList = new ArrayList<ZoneWhiteForm>(1000);
    private Set<String> doCmdSuccessList = new HashSet<String>();
    private Set<String> doCmdFailedList = new HashSet<String>();
    private Set<String> undoCmdSuccessList = new HashSet<String>();
    private Set<String> undoCmdFailedList = new HashSet<String>();
    private Map<String, String> requestMap = new HashMap<String, String>();

    public ZoneWhiteListData(List<ZoneWhiteForm> list, String featureType, Long featureId) {
        this.setList(list);
        this.setFeatureType(featureType);
        this.setFeatureId(featureId);
    }

    @Override
    public Object doAudit(LogicDev logicDev, Object object) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doDeploy(LogicDev logicDev, Object object) {
        ArrayList<String> result = new ArrayList<String>();
        lock.lock();
        try {
            Long deviceId = logicDev.getDeviceId();
            this.getDozoneBlackWhiteFormList(deviceId);
            this.getUndozoneBlackWhiteFormList(deviceId);
            this.undoWhiteFormListCmd(deviceId, result);
            this.doWhiteFormListCmd(deviceId, result);
            this.recordSystemLog(deviceId);
            logger.info((Object)("deploy ZoneWhiteListData result:" + this.getcleanedMessage(((Object)result).toString())));
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    private void doWhiteFormListCmd(Long deviceId, List<String> result) {
        while (this.zoneWhiteFormList.size() > 0) {
            if (this.zoneWhiteFormList.size() > 1000) {
                this.resultZoneWhiteFormList.addAll(this.zoneWhiteFormList.subList(0, 1000));
                this.zoneWhiteFormList.subList(0, 1000).clear();
            } else {
                this.resultZoneWhiteFormList.addAll(this.zoneWhiteFormList);
                this.zoneWhiteFormList.clear();
            }
            boolean saveResult = false;
            List<Object> cmdsResult = new ArrayList();
            int zoneBlackWhiteListSize = this.resultZoneWhiteFormList.size();
            for (int i = 0; i < zoneBlackWhiteListSize; ++i) {
                ZoneWhiteForm zoneWhiteForm = this.resultZoneWhiteFormList.get(i);
                zoneWhiteForm.setDeviceId(deviceId);
                saveResult = false;
                for (int j = 0; j < 3 && !saveResult; ++j) {
                    List<String> cmds = this.doWhiteTranslate(zoneWhiteForm);
                    logger.info((Object)("resultZoneWhiteFormList cmds: " + cmds.toString()));
                    this.setCmds(cmds);
                    cmdsResult = CmdUtil.execCmds(deviceId, cmds);
                    logger.info((Object)("resultZoneWhiteFormList cmdsResult: " + cmdsResult.toString()));
                    saveResult = this.saveZoneWhiteStatus(zoneWhiteForm, cmdsResult);
                    try {
                        if (saveResult) continue;
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error((Object)("Deploy zone whitelist (do... ),failed to deploy and need retry, Failed times = " + (i + 1)));
                    }
                }
                if (saveResult) {
                    this.doCmdSuccessList.add(zoneWhiteForm.getIpAddressAndMask());
                } else {
                    StringBuilder errorMsgKey = new StringBuilder("");
                    errorMsgKey.append(zoneWhiteForm.getIpAddressAndMask()).append(" ");
                    for (String string : cmdsResult) {
                        String returnInfo = string.toLowerCase(Locale.ENGLISH);
                        if (!returnInfo.contains(ERROR_CONFIGURATION)) continue;
                        String cmdRest = returnInfo.split("\\r\\n")[1];
                        errorMsgKey.append(cmdRest.substring(cmdRest.indexOf(":") + 1)).append(" ");
                    }
                    logger.info((Object)("resultZoneWhiteFormList errorMsgKey: " + errorMsgKey.toString()));
                    this.doCmdFailedList.add(errorMsgKey.toString());
                }
                result.addAll(cmdsResult);
            }
            this.resultZoneWhiteFormList.clear();
        }
    }

    private void undoWhiteFormListCmd(Long deviceId, List<String> result) {
        while (this.undoZoneWhiteFormList.size() > 0) {
            if (this.undoZoneWhiteFormList.size() > 1000) {
                this.resultUndoZoneWhiteFormList.addAll(this.undoZoneWhiteFormList.subList(0, 1000));
                this.undoZoneWhiteFormList.subList(0, 1000).clear();
            } else {
                this.resultUndoZoneWhiteFormList.addAll(this.undoZoneWhiteFormList);
                this.undoZoneWhiteFormList.clear();
            }
            boolean saveResult = false;
            List<Object> cmdsResult = new ArrayList();
            int undoZoneBlackWhiteFormListSize = this.resultUndoZoneWhiteFormList.size();
            for (int i = 0; i < undoZoneBlackWhiteFormListSize; ++i) {
                ZoneWhiteForm undoZoneWhiteForm = this.resultUndoZoneWhiteFormList.get(i);
                undoZoneWhiteForm.setDeviceId(deviceId);
                saveResult = false;
                for (int j = 0; j < 3 && !saveResult; ++j) {
                    List<String> cmds = this.undoTranslate(undoZoneWhiteForm);
                    this.setCmds(cmds);
                    logger.info((Object)("resultUndoZoneWhiteFormList cmd: " + cmds.toString()));
                    cmdsResult = CmdUtil.execCmds(deviceId, cmds);
                    logger.info((Object)("resultUndoZoneWhiteFormList cmdsResult: " + cmdsResult.toString()));
                    saveResult = this.deleteZoneWhiteInfo(undoZoneWhiteForm, cmdsResult);
                    try {
                        if (saveResult) continue;
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error((Object)("Deploy zone whitelist (undo... ),failed to deploy and need retry, Failed times = " + (j + 1)));
                    }
                }
                if (saveResult) {
                    this.undoCmdSuccessList.add(undoZoneWhiteForm.getIpAddressAndMask());
                } else {
                    StringBuilder errorMsgKey = new StringBuilder("");
                    errorMsgKey.append(undoZoneWhiteForm.getIpAddressAndMask()).append(" ");
                    for (String string : cmdsResult) {
                        String returnInfo = string.toLowerCase(Locale.ENGLISH);
                        if (!returnInfo.contains(ERROR_CONFIGURATION)) continue;
                        String cmdRest = returnInfo.split("\\r\\n")[1];
                        errorMsgKey.append(cmdRest.substring(cmdRest.indexOf(":") + 1)).append(" ");
                    }
                    logger.info((Object)("resultUndoZoneWhiteFormList errorMsgKey: " + errorMsgKey.toString()));
                    this.undoCmdFailedList.add(errorMsgKey.toString());
                }
                result.addAll(cmdsResult);
            }
            this.resultUndoZoneWhiteFormList.clear();
        }
    }

    private void recordSystemLog(Long deviceId) {
        AticDevice device = CapaUtil.getAticDeviceService().getDeviceByMoid(deviceId.longValue());
        Long zoneId = this.getFeatureId();
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getById(zoneId);
        String zoneName = "com.hs.vsm.secservice.ddos.policy.zone";
        if (zoneInfoForm != null && !AticUtil.isNull((String)zoneInfoForm.getZoneName())) {
            zoneName = zoneInfoForm.getZoneName();
        }
        String doCmdSuccess = "--";
        StringBuilder doCmdFailedBuilder = new StringBuilder("");
        String undoCmdSuccess = "--";
        StringBuilder undoCmdFailedBuilder = new StringBuilder("");
        if (this.doCmdSuccessList.size() > 0) {
            doCmdSuccess = this.doCmdSuccessList.toString();
        }
        if (this.doCmdFailedList.size() <= 0) {
            doCmdFailedBuilder.append("-- ");
        } else {
            doCmdFailedBuilder.append("[ ");
            for (String doCmdFailed : this.doCmdFailedList) {
                doCmdFailedBuilder.append(" ").append(doCmdFailed);
            }
            doCmdFailedBuilder.append(" ]");
        }
        if (this.undoCmdSuccessList.size() > 0) {
            undoCmdSuccess = this.undoCmdSuccessList.toString();
        }
        if (this.undoCmdFailedList.size() > 0) {
            undoCmdFailedBuilder.append("[ ");
            for (String undoCmdFailed : this.undoCmdFailedList) {
                undoCmdFailedBuilder.append(" ").append(undoCmdFailed);
            }
            undoCmdFailedBuilder.append(" ]");
        } else {
            undoCmdFailedBuilder.append("-- ");
        }
        if (this.doCmdSuccessList.size() == 0 && this.doCmdFailedList.size() == 0 && this.undoCmdSuccessList.size() == 0 && this.undoCmdFailedList.size() == 0) {
            return;
        }
        String[] detailPara = new String[]{zoneName, device.getName(), doCmdSuccess, doCmdFailedBuilder.toString(), undoCmdSuccess, undoCmdFailedBuilder.toString()};
        this.batchRsult(true, DDOS_POLICY_MODULE, zoneName, DDOS_POLICY_BLACK_LOG_DETAILS, DDOS_POLICY_BLACK_OPERATION, detailPara);
    }

    private boolean deleteZoneWhiteInfo(ZoneWhiteForm undoZoneWhiteForm, List<String> result) {
        int errorCode = AticUtil.cmdResult(result);
        if (errorCode == 1 || errorCode == 572219) {
            IBlackWhiteListService blackWhiteListService = ZoneReferUtil.getBlackWhiteListService();
            ZoneBlackWhiteForm zoneBlackWhiteForm = this.zoneWhiteFormToZoneBlackWhiteForm(undoZoneWhiteForm);
            blackWhiteListService.singleDeleteUnDeployStatus(zoneBlackWhiteForm);
            int cmdSize = result.size();
            for (int i = 0; i < cmdSize && errorCode == 572219; ++i) {
                String cmdResultLowcase = result.get(i).toLowerCase(Locale.ENGLISH);
                if (!cmdResultLowcase.contains("Error: This specified item does not exist".toLowerCase(Locale.ENGLISH))) continue;
                logger.info((Object)("undo deploy cmdResultLowcase result:" + this.getcleanedMessage(cmdResultLowcase)));
                result.set(i, "Info: This specified item does not exist.");
            }
        } else {
            return false;
        }
        return true;
    }

    private void batchRsult(boolean isSuccess, String module, String target, String detail, String operation, String[] detailPara) {
        String terminalIp;
        SysOptLog syncSysLog = new SysOptLog();
        syncSysLog.setOperation(operation);
        syncSysLog.setModule(module);
        syncSysLog.setLevel(SysoplogLevel.info.getValue());
        String userName = this.getRequestMap().get("requestUserName");
        if (AticUtil.isNull((String)userName)) {
            userName = "system";
        }
        if (AticUtil.isNull((String)(terminalIp = this.getRequestMap().get("requestTerminalIp")))) {
            userName = "127.0.0.1";
        }
        syncSysLog.setOperator(userName);
        syncSysLog.setTerminalIp(terminalIp);
        syncSysLog.setTargetLocal(Boolean.valueOf(true));
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        if (isSuccess) {
            syncSysLog.setResult(1);
            syncSysLog.setTarget(target);
            syncSysLog.setDetail(detail);
            syncSysLog.setDetailPara(detailPara);
            sysOptLog.writeOptLog(syncSysLog);
        } else {
            syncSysLog.setResult(0);
            syncSysLog.setTarget(target);
            syncSysLog.setDetail(detail);
            syncSysLog.setDetailPara(detailPara);
            sysOptLog.writeOptLog(syncSysLog);
        }
    }

    private boolean saveZoneWhiteStatus(ZoneWhiteForm zoneWhiteForm, List<String> result) {
        int errorCode = AticUtil.cmdResult(result);
        if (errorCode == 1 || errorCode == 572220) {
            IBlackWhiteListService blackWhiteListService = ZoneReferUtil.getBlackWhiteListService();
            ZoneBlackWhiteForm zoneBlackWhiteForm = this.zoneWhiteFormToZoneBlackWhiteForm(zoneWhiteForm);
            blackWhiteListService.singleSaveDoDeployStatus(zoneBlackWhiteForm, "SUCCESS");
            int cmdSize = result.size();
            for (int i = 0; i < cmdSize && errorCode == 572220; ++i) {
                String cmdResultLowcase = result.get(i).toLowerCase(Locale.ENGLISH);
                if (!cmdResultLowcase.contains("Error: The specified item has already existed.".toLowerCase(Locale.ENGLISH))) continue;
                logger.info((Object)("do deploy cmdResultLowcase result:" + this.getcleanedMessage(cmdResultLowcase)));
                result.set(i, "Info: The specified item has already existed.");
            }
        } else {
            return false;
        }
        return true;
    }

    private ZoneBlackWhiteForm zoneWhiteFormToZoneBlackWhiteForm(ZoneWhiteForm zoneWhiteForm) {
        ZoneBlackWhiteForm zoneBlackWhiteForm = new ZoneBlackWhiteForm();
        VsmUtil.getInstance().copyProperties(zoneWhiteForm, zoneBlackWhiteForm);
        return zoneBlackWhiteForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<String> undoTranslate(ZoneWhiteForm undoform) {
        List cmds = null;
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        CmdParam cmdParam = new CmdParam();
        HashMap<String, String> params = new HashMap<String, String>();
        if (undoform.getBlackWhiteType() == 1) {
            if (IPUtil.isIpv4((String)undoform.getIpAddress())) {
                cmdParam.setCmdID("zoneBlackListIpv4");
                params.put("undo", "undo");
                params.put("ipAddress", undoform.getIpAddress());
                params.put("mask", String.valueOf(undoform.getMask()));
            }
            if (IPUtil.isIpv6((String)undoform.getIpAddress())) {
                cmdParam.setCmdID("zoneBlackListIpv6");
                params.put("undo", "undo");
                params.put("ipAddress", undoform.getIpAddress());
                params.put("mask", String.valueOf(undoform.getMask()));
            }
        } else if (undoform.getBlackWhiteType() == 2) {
            if (IPUtil.isIpv4((String)undoform.getIpAddress())) {
                cmdParam.setCmdID("zoneWhiteListIpv4");
                params.put("undo", "undo");
                params.put("ipAddress", undoform.getIpAddress());
                params.put("mask", String.valueOf(undoform.getMask()));
            }
            if (IPUtil.isIpv6((String)undoform.getIpAddress())) {
                cmdParam.setCmdID("zoneWhiteListIpv6");
                params.put("undo", "undo");
                params.put("ipAddress", undoform.getIpAddress());
                params.put("mask", String.valueOf(undoform.getMask()));
            }
        }
        cmdParam.setParams(params);
        cmdParams.add(cmdParam);
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(undoform.getDeviceId());
        cmds = tool.doTranslate(cmdFileDir, "firwall_ddos", cmdParams);
        return cmds;
    }

    private List<String> doWhiteTranslate(ZoneWhiteForm zoneWhiteForm) {
        List cmds = null;
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        List<CmdViewBean> viewList = this.getCmdViewList();
        Util.getInstance().addView(viewList, cmdParams);
        CmdParam cmdParam = new CmdParam();
        HashMap<String, String> params = new HashMap<String, String>();
        if (zoneWhiteForm.getBlackWhiteType() == 1) {
            if (IPUtil.isIpv4((String)zoneWhiteForm.getIpAddress())) {
                cmdParam.setCmdID("zoneBlackListIpv4");
                params.put("ipAddress", zoneWhiteForm.getIpAddress());
                params.put("mask", String.valueOf(zoneWhiteForm.getMask()));
            }
            if (IPUtil.isIpv6((String)zoneWhiteForm.getIpAddress())) {
                cmdParam.setCmdID("zoneBlackListIpv6");
                params.put("ipAddress", zoneWhiteForm.getIpAddress());
                params.put("mask", String.valueOf(zoneWhiteForm.getMask()));
            }
        } else if (zoneWhiteForm.getBlackWhiteType() == 2) {
            if (IPUtil.isIpv4((String)zoneWhiteForm.getIpAddress())) {
                cmdParam.setCmdID("zoneWhiteListIpv4");
                params.put("ipAddress", zoneWhiteForm.getIpAddress());
                params.put("mask", String.valueOf(zoneWhiteForm.getMask()));
            }
            if (IPUtil.isIpv6((String)zoneWhiteForm.getIpAddress())) {
                cmdParam.setCmdID("zoneWhiteListIpv6");
                params.put("ipAddress", zoneWhiteForm.getIpAddress());
                params.put("mask", String.valueOf(zoneWhiteForm.getMask()));
            }
        }
        cmdParam.setParams(params);
        cmdParams.add(cmdParam);
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(zoneWhiteForm.getDeviceId());
        cmds = tool.doTranslate(cmdFileDir, "firwall_ddos", cmdParams);
        return cmds;
    }

    private void getDozoneBlackWhiteFormList(Long deviceId) {
        IBlackWhiteListService blackWhiteListService = ZoneReferUtil.getBlackWhiteListService();
        if (this.list != null && !this.list.isEmpty()) {
            ArrayList<ZoneWhiteForm> cloneList = new ArrayList<ZoneWhiteForm>();
            for (ZoneWhiteForm zoneWhiteForm : this.list) {
                ZoneWhiteForm zoneForm = new ZoneWhiteForm();
                VsmUtil.getInstance().copyProperties(zoneWhiteForm, zoneForm);
                cloneList.add(zoneForm);
            }
            Long zoneId = this.getFeatureId();
            List<ZoneWhiteForm> depolyZoneWhiteFormList = blackWhiteListService.queryDoWhiteListByZoneIdAndDeviceId(zoneId, deviceId);
            HashMap<String, ZoneWhiteForm> zoneBlackWhiteFormMap = new HashMap<String, ZoneWhiteForm>();
            for (ZoneWhiteForm zoneBlackWhiteForm : depolyZoneWhiteFormList) {
                zoneBlackWhiteFormMap.put(zoneBlackWhiteForm.getIpAddressAndMask(), zoneBlackWhiteForm);
            }
            for (ZoneWhiteForm form : cloneList) {
                ZoneWhiteForm zoneWhiteFormTemp = (ZoneWhiteForm)zoneBlackWhiteFormMap.get(form.getIpAddressAndMask());
                if (zoneWhiteFormTemp != null && "SUCCESS".equals(zoneWhiteFormTemp.getDeployState()) || form.getDeleteFlag() == 1) continue;
                this.zoneWhiteFormList.add(form);
            }
        }
    }

    private void getUndozoneBlackWhiteFormList(Long deviceId) {
        IBlackWhiteListService blackWhiteListService = ZoneReferUtil.getBlackWhiteListService();
        Long zoneId = this.getFeatureId();
        List<ZoneWhiteForm> depolyZoneWhiteFormList = blackWhiteListService.queryDoWhiteListByZoneIdAndDeviceId(zoneId, deviceId);
        HashMap<String, ZoneWhiteForm> zoneBlackWhiteFormMap = new HashMap<String, ZoneWhiteForm>();
        if (this.list != null && !this.list.isEmpty()) {
            ArrayList<ZoneWhiteForm> cloneList = new ArrayList<ZoneWhiteForm>();
            for (ZoneWhiteForm zoneWhiteForm : this.list) {
                ZoneWhiteForm zoneForm = new ZoneWhiteForm();
                VsmUtil.getInstance().copyProperties(zoneWhiteForm, zoneForm);
                cloneList.add(zoneForm);
            }
            for (ZoneWhiteForm zoneWhiteForm : cloneList) {
                zoneBlackWhiteFormMap.put(zoneWhiteForm.getIpAddressAndMask(), zoneWhiteForm);
            }
        }
        for (ZoneWhiteForm form : depolyZoneWhiteFormList) {
            ZoneWhiteForm zoneWhiteFormTemp = (ZoneWhiteForm)zoneBlackWhiteFormMap.get(form.getIpAddressAndMask());
            if (zoneWhiteFormTemp != null || !"SUCCESS".equals(form.getDeployState())) continue;
            this.undoZoneWhiteFormList.add(form);
        }
    }

    @Override
    public Object doDiscover(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doUndeploy(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Object doVerify(LogicDev logicDev, Object object) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(List<IFeature> featureDataList) {
        return null;
    }

    @Override
    public Map<String, List<Long>> getDependFeatureID(Long featureID) {
        return null;
    }

    @Override
    public IFeature getFeature(Long featureID) {
        return null;
    }

    @Override
    public List<IFeature> getFeature(List<Long> featureIDList) {
        return null;
    }

    @Override
    public IFeature getTopFeatureData() {
        return null;
    }

    public List<ZoneWhiteForm> getList() {
        return this.list;
    }

    public void setList(List<ZoneWhiteForm> list) {
        this.list = list;
    }

    public List<ZoneWhiteForm> getZoneWhiteFormList() {
        return this.zoneWhiteFormList;
    }

    public void setZoneWhiteFormList(List<ZoneWhiteForm> zoneWhiteFormList) {
        this.zoneWhiteFormList = zoneWhiteFormList;
    }

    public List<ZoneWhiteForm> getUndoZoneWhiteFormList() {
        return this.undoZoneWhiteFormList;
    }

    public void setUndoZoneWhiteFormList(List<ZoneWhiteForm> undoZoneWhiteFormList) {
        this.undoZoneWhiteFormList = undoZoneWhiteFormList;
    }

    public List<ZoneWhiteForm> getResultZoneWhiteFormList() {
        return this.resultZoneWhiteFormList;
    }

    public void setResultZoneWhiteFormList(List<ZoneWhiteForm> resultZoneWhiteFormList) {
        this.resultZoneWhiteFormList = resultZoneWhiteFormList;
    }

    public List<ZoneWhiteForm> getResultUndoZoneWhiteFormList() {
        return this.resultUndoZoneWhiteFormList;
    }

    public void setResultUndoZoneWhiteFormList(List<ZoneWhiteForm> resultUndoZoneWhiteFormList) {
        this.resultUndoZoneWhiteFormList = resultUndoZoneWhiteFormList;
    }

    public Map<String, String> getRequestMap() {
        return this.requestMap;
    }

    public void setRequestMap(Map<String, String> requestMap) {
        this.requestMap = requestMap;
    }
}

