/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.function.deploy;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.FilterDevicePair;
import com.hs.vsm.secservice.ddos.common.FilterDeviceZonePair;
import com.hs.vsm.secservice.ddos.common.FilterDstIpPair;
import com.hs.vsm.secservice.ddos.dao.FilterDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneInfoDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneStatusDao;
import com.hs.vsm.secservice.ddos.dao.HttpFilterDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZonePolicyApplyDao;
import com.hs.vsm.secservice.ddos.model.FilterDeviceInfo;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneInfo;
import com.hs.vsm.secservice.ddos.model.FilterDeviceZoneStatusInfo;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import com.hs.vsm.secservice.ddos.model.HttpFilterInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZonePolicyApplyInfo;
import com.hs.vsm.secservice.ddos.service.data.FilterConfigData;
import com.hs.vsm.secservice.ddos.service.data.FilterConfigDataTool;
import com.hs.vsm.secservice.ddos.service.data.FilterToDeployData;
import com.hs.vsm.secservice.ddos.service.data.FilterToDeployDataTool;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterDstIpData;
import com.hs.vsm.secservice.ddos.service.function.deploy.FilterDeployInfo;
import com.hs.vsm.secservice.ddos.service.function.deploy.FilterDeployThread;
import com.hs.vsm.secservice.ddos.service.function.deploy.FilterDstIpDeployInfo;
import com.hs.vsm.secservice.ddos.service.function.deploy.FilterDstIpDeployThread;
import com.hs.vsm.secservice.policyengine.commandutil.CrcUtil;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneModifyDetailForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyMgrService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.resource.dao.AticDeviceNfaClusterDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class FilterDeployCtrl {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private FilterConfigDataTool filterConfigDataTool;
    private FilterToDeployDataTool filterToDeployDataTool = new FilterToDeployDataTool();
    private FilterDeviceZoneInfoDao filterDeviceZoneInfoDao;
    private FilterDeviceZoneStatusDao filterDeviceZoneStatusDao;
    private FilterDeviceDao filterDeviceDao;
    private FilterDao filterDao;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private ZonePolicyApplyDao zonePolicyApplyDao;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IZonePolicyMgrService zonePolicyMgrService;
    private IClusterService clusterService;
    private IAticDeviceService aticDeviceService;
    private HttpFilterDao httpFilterDao;

    public FilterDeployInfo doDeployWithZone(List<Long> zoneIdList, Long progressBarId, ProgressBar progressBar, Long adminId) {
        ArrayList<FilterDeviceZonePair> deployTempList = new ArrayList<FilterDeviceZonePair>();
        ArrayList<FilterDeviceZonePair> deployedTempList = new ArrayList<FilterDeviceZonePair>();
        ArrayList<FilterDeviceZonePair> failedTempList = new ArrayList<FilterDeviceZonePair>();
        for (Long zoneId : zoneIdList) {
            FilterDeviceZonePair filterDeviceZonePair;
            List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.transTonfaId(zoneId);
            List<FilterDeviceZoneStatusInfo> filterDeviceZoneStatusInfoList = this.filterDeviceZoneStatusDao.getDeployedByZoneId(zoneId);
            List<FilterDeviceZoneStatusInfo> failedInfoList = this.filterDeviceZoneStatusDao.getFailedByZoneId(zoneId);
            for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
                filterDeviceZonePair = new FilterDeviceZonePair(filterDeviceZoneInfo.getZoneId(), filterDeviceZoneInfo.getFilterId(), filterDeviceZoneInfo.getDeviceId(), filterDeviceZoneInfo.getDirection());
                deployTempList.add(filterDeviceZonePair);
                this.logger.info((Object)("pre deploy filter with zone by deploy: " + filterDeviceZonePair.toString()));
            }
            for (FilterDeviceZoneStatusInfo filterDeviceZoneStatusInfo : filterDeviceZoneStatusInfoList) {
                filterDeviceZonePair = new FilterDeviceZonePair(filterDeviceZoneStatusInfo.getZoneId(), filterDeviceZoneStatusInfo.getFilterId(), filterDeviceZoneStatusInfo.getDeviceId(), filterDeviceZoneStatusInfo.getDirection());
                deployedTempList.add(filterDeviceZonePair);
                this.logger.info((Object)("pre undeploy filter with zone by deploy: " + filterDeviceZonePair.toString()));
            }
            for (FilterDeviceZoneStatusInfo info : failedInfoList) {
                filterDeviceZonePair = new FilterDeviceZonePair(info.getZoneId(), info.getFilterId(), info.getDeviceId(), info.getDirection());
                failedTempList.add(filterDeviceZonePair);
                this.logger.info((Object)("pre failed filter with zone by deploy: " + filterDeviceZonePair.toString()));
            }
            if (!deployTempList.isEmpty() || !deployedTempList.isEmpty()) continue;
            ZonePolicyApplyInfo zonePolicyApplyInfo = this.zonePolicyApplyDao.getByZoneId(zoneId);
            zonePolicyApplyInfo.setFilterState("SUCCESS");
            this.zonePolicyApplyDao.update(zonePolicyApplyInfo);
        }
        ArrayList<FilterDeviceZonePair> deployFilterDeviceZonePairTempList = new ArrayList<FilterDeviceZonePair>(deployTempList);
        ArrayList<FilterDeviceZonePair> undeployFilterDeviceZonePairTempList = new ArrayList<FilterDeviceZonePair>(deployedTempList);
        ArrayList failedFilterDeviceZonePairTempList = new ArrayList(failedTempList);
        failedFilterDeviceZonePairTempList.removeAll(deployFilterDeviceZonePairTempList);
        undeployFilterDeviceZonePairTempList.addAll(failedFilterDeviceZonePairTempList);
        FilterDeployInfo filterDeployInfo = new FilterDeployInfo();
        filterDeployInfo.setProgressBar(progressBar);
        filterDeployInfo.setProgressBarId(progressBarId);
        return this.doDeploy(deployFilterDeviceZonePairTempList, undeployFilterDeviceZonePairTempList, filterDeployInfo, adminId, false, null);
    }

    private List<FilterDeviceZoneInfo> transTonfaId(Long zoneId) {
        ArrayList<FilterDeviceZoneInfo> filterDeviceZoneInfoList = new ArrayList<FilterDeviceZoneInfo>();
        List<FilterDeviceZoneInfo> tempFilterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.getByZoneId(zoneId);
        for (FilterDeviceZoneInfo tempFilterDeviceZoneInfo : tempFilterDeviceZoneInfoList) {
            Long deviceId = tempFilterDeviceZoneInfo.getDeviceId();
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
            if (aticDevice.getDeviceType() == 9) {
                List aticDeviceNfaClusters = this.clusterService.getBindNfaDevice(Long.valueOf(aticDevice.getMoId()));
                for (AticDeviceNfaCluster nfaCluster : aticDeviceNfaClusters) {
                    FilterDeviceZoneInfo filterDeviceZoneInfo = new FilterDeviceZoneInfo();
                    AticUtil.copyProperties((Object)tempFilterDeviceZoneInfo, (Object)filterDeviceZoneInfo);
                    filterDeviceZoneInfo.setDeviceId(nfaCluster.getDeviceId());
                    filterDeviceZoneInfoList.add(filterDeviceZoneInfo);
                }
                continue;
            }
            filterDeviceZoneInfoList.add(tempFilterDeviceZoneInfo);
        }
        return filterDeviceZoneInfoList;
    }

    public Map<Long, Set<Long>> doDeployWithFilter(Long filterId, Long progressBarId, ProgressBar progressBar, Long adminId, List<Long> deleteDeviceIds, Boolean isGlobalApplyFilter) {
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        ArrayList<Long> deployZoneIdList = new ArrayList<Long>();
        ArrayList<FilterDeviceZonePair> deployTempList = new ArrayList<FilterDeviceZonePair>();
        ArrayList<FilterDeviceZonePair> undeployTempList = new ArrayList<FilterDeviceZonePair>();
        List<FilterDeviceZoneInfo> filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.getByFilterId(filterId);
        List<FilterDeviceZoneStatusInfo> filterDeviceZoneStatusInfoList = this.filterDeviceZoneStatusDao.getInitFilterDefineByFilterId(filterId);
        List<FilterDeviceZoneStatusInfo> filterDeviceDeployZoneInfoList = this.filterDeviceZoneStatusDao.getDeployZonesByFilterId(filterId);
        for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfoList) {
            FilterDeviceZonePair filterDeviceZonePair = new FilterDeviceZonePair(filterDeviceZoneInfo.getZoneId(), filterDeviceZoneInfo.getFilterId(), filterDeviceZoneInfo.getDeviceId(), filterDeviceZoneInfo.getDirection(), filterDeviceZoneInfo.getGloApplyFlag());
            if (filterDeviceZoneInfo.getZoneId() == 0L && null != deleteDeviceIds && deleteDeviceIds.contains(filterDeviceZoneInfo.getDeviceId())) {
                undeployTempList.add(filterDeviceZonePair);
            } else if (isGlobalApplyFilter.booleanValue() && filterDeviceZoneInfo.getGloApplyFlag() == 1) {
                deployTempList.add(filterDeviceZonePair);
            } else if (!isGlobalApplyFilter.booleanValue() && filterDeviceZoneInfo.getGloApplyFlag() == 0) {
                deployTempList.add(filterDeviceZonePair);
            }
            this.logger.info((Object)("pre deploy filter with filter by deploy: " + filterDeviceZonePair.toString()));
            if (deployZoneIdList.contains(filterDeviceZoneInfo.getZoneId())) continue;
            deployZoneIdList.add(filterDeviceZoneInfo.getZoneId());
        }
        for (FilterDeviceZoneStatusInfo filterDeviceZoneStatusInfo : filterDeviceDeployZoneInfoList) {
            if (zoneIdList.contains(filterDeviceZoneStatusInfo.getZoneId())) continue;
            zoneIdList.add(filterDeviceZoneStatusInfo.getZoneId());
        }
        if (!deployZoneIdList.isEmpty()) {
            zoneIdList.removeAll(deployZoneIdList);
        }
        if (filterDeviceZoneStatusInfoList != null) {
            for (FilterDeviceZoneStatusInfo filterDeviceZoneStatusInfo : filterDeviceZoneStatusInfoList) {
                Long zoneId = filterDeviceZoneStatusInfo.getZoneId();
                if (zoneId == 0L) continue;
                FilterDeviceZonePair filterDeviceZonePair = new FilterDeviceZonePair(zoneId, filterDeviceZoneStatusInfo.getFilterId(), filterDeviceZoneStatusInfo.getDeviceId(), filterDeviceZoneStatusInfo.getDirection());
                undeployTempList.add(filterDeviceZonePair);
                this.logger.info((Object)("pre undeploy filter with filter by deploy: " + filterDeviceZonePair.toString()));
            }
        }
        ArrayList<FilterDeviceZonePair> deployFilterDeviceZonePairTempList = new ArrayList<FilterDeviceZonePair>(deployTempList);
        ArrayList<FilterDeviceZonePair> arrayList = new ArrayList<FilterDeviceZonePair>(undeployTempList);
        arrayList.removeAll(deployTempList);
        arrayList.addAll(this.getUndeployList(zoneIdList));
        FilterDeployInfo filterDeployInfo = new FilterDeployInfo();
        filterDeployInfo.setProgressBar(progressBar);
        filterDeployInfo.setProgressBarId(progressBarId);
        filterDeployInfo = this.doDeploy(deployFilterDeviceZonePairTempList, arrayList, filterDeployInfo, adminId, true, deleteDeviceIds);
        Map<Long, Set<Long>> resultMap = this.getReturnResultMap(filterDeployInfo);
        this.logger.info((Object)("deploy filter, filter id : " + filterId + ", result : " + resultMap));
        return resultMap;
    }

    private List<FilterDeviceZonePair> getUndeployList(List<Long> zoneIdList) {
        FilterDeviceZonePair pair;
        ArrayList<FilterDeviceZoneInfo> infoList = new ArrayList<FilterDeviceZoneInfo>();
        ArrayList<FilterDeviceZoneStatusInfo> statusList = new ArrayList<FilterDeviceZoneStatusInfo>();
        ArrayList<FilterDeviceZonePair> deployList = new ArrayList<FilterDeviceZonePair>();
        ArrayList<FilterDeviceZonePair> undeployList = new ArrayList<FilterDeviceZonePair>();
        for (Long zoneId : zoneIdList) {
            infoList.addAll(this.filterDeviceZoneInfoDao.getByZoneId(zoneId));
            statusList.addAll(this.filterDeviceZoneStatusDao.getDeployedByZoneId(zoneId));
        }
        for (FilterDeviceZoneInfo info : infoList) {
            pair = new FilterDeviceZonePair(info.getZoneId(), info.getFilterId(), info.getDeviceId(), info.getDirection(), info.getGloApplyFlag());
            deployList.add(pair);
        }
        for (FilterDeviceZoneStatusInfo status : statusList) {
            pair = new FilterDeviceZonePair(status.getZoneId(), status.getFilterId(), status.getDeviceId(), status.getDirection());
            undeployList.add(pair);
        }
        undeployList.removeAll(deployList);
        return undeployList;
    }

    public FilterDeployInfo doDeploy(List<FilterDeviceZonePair> deployFilterDeviceZonePairList, List<FilterDeviceZonePair> undeployFilterDeviceZonePairList, FilterDeployInfo filterDeployInfo, Long adminId, Boolean isDeployWithFilter, List<Long> deleteDeviceIds) {
        try {
            Map<Long, Set<Long>> deviceUnDeployFilterMap = this.initDeviceUnDeployFilterMap(undeployFilterDeviceZonePairList, deleteDeviceIds);
            filterDeployInfo = this.initFilterDeployInfo(deployFilterDeviceZonePairList, undeployFilterDeviceZonePairList, deviceUnDeployFilterMap, filterDeployInfo, isDeployWithFilter);
            this.startFilterDeployThreads(filterDeployInfo);
            this.dealDeployResult(filterDeployInfo);
            this.saveZoneStatus(filterDeployInfo, isDeployWithFilter);
            return filterDeployInfo;
        }
        catch (Exception e) {
            this.logger.error((Object)("deploy filter error : " + e.getMessage()));
            return null;
        }
    }

    private Map<Long, Set<Long>> getReturnResultMap(FilterDeployInfo filterDeployInfo) {
        HashMap<Long, Set<Long>> returnResultMap = new HashMap<Long, Set<Long>>();
        if (null != filterDeployInfo) {
            Map<Long, Set<Long>> filterDeployResultMap = this.getResultMapWithFilterDeploy(filterDeployInfo.getFilterDeployResult());
            Map<Long, Set<Long>> filterUnDeployResultMap = this.getResultMapWithFilterDeploy(filterDeployInfo.getFilterUnDeployResult());
            Map<Long, Set<Long>> filterZoneDeployResultMap = this.getResultMapWithFilterZoneDeploy(filterDeployInfo.getFilterZoneDeployResult());
            Map<Long, Set<Long>> filterZoneUnDeployResultMap = this.getResultMapWithFilterZoneDeploy(filterDeployInfo.getFilterZoneUnDeployResult());
            returnResultMap.putAll(filterZoneUnDeployResultMap);
            returnResultMap.putAll(filterZoneDeployResultMap);
            returnResultMap.putAll(filterUnDeployResultMap);
            returnResultMap.putAll(filterDeployResultMap);
        }
        return returnResultMap;
    }

    private Map<Long, Set<Long>> getResultMapWithFilterZoneDeploy(Map<FilterDeviceZonePair, String> filterZoneDeployResult) {
        HashMap<Long, Set<Long>> filterZoneDeployResultMap = new HashMap<Long, Set<Long>>();
        for (Map.Entry<FilterDeviceZonePair, String> resultMapEntry : filterZoneDeployResult.entrySet()) {
            Long deviceId = resultMapEntry.getKey().getDeviceId();
            Long zoneId = resultMapEntry.getKey().getZoneId();
            String errorCode = resultMapEntry.getValue();
            if (errorCode == null || "".equals(errorCode)) continue;
            if (filterZoneDeployResultMap.get(deviceId) == null) {
                filterZoneDeployResultMap.put(deviceId, new HashSet());
            }
            ((Set)filterZoneDeployResultMap.get(deviceId)).add(zoneId);
        }
        return filterZoneDeployResultMap;
    }

    private Map<Long, Set<Long>> getResultMapWithFilterDeploy(Map<FilterDevicePair, String> filterDeployResult) {
        HashMap<Long, Set<Long>> filterDeployResultMap = new HashMap<Long, Set<Long>>();
        for (Map.Entry<FilterDevicePair, String> resultMapEntry : filterDeployResult.entrySet()) {
            Long deviceId = resultMapEntry.getKey().getDeviceId();
            String errorCode = resultMapEntry.getValue();
            if (errorCode == null || "".equals(errorCode) || filterDeployResultMap.get(deviceId) != null) continue;
            filterDeployResultMap.put(deviceId, new HashSet());
        }
        return filterDeployResultMap;
    }

    private Map<Long, Set<Long>> initDeviceUnDeployFilterMap(List<FilterDeviceZonePair> undeployFilterDeviceZonePairList, List<Long> deleteDeviceIds) {
        HashMap<Long, Set<Long>> deviceUnDeployFilterMap = new HashMap<Long, Set<Long>>();
        if (undeployFilterDeviceZonePairList != null && !undeployFilterDeviceZonePairList.isEmpty()) {
            HashMap<FilterDevicePair, Boolean> filterDeviceDeployMap = new HashMap<FilterDevicePair, Boolean>();
            HashSet<Long> filteIdSet = new HashSet<Long>();
            for (FilterDeviceZonePair filterDeviceZonePair : undeployFilterDeviceZonePairList) {
                FilterDeviceZoneInfo filterDeviceZoneInfo;
                FilterDevicePair filterDevicePair = new FilterDevicePair(filterDeviceZonePair.getFilterId(), filterDeviceZonePair.getDeviceId());
                if (filterDeviceDeployMap.get(filterDevicePair) == null) {
                    List<FilterDeviceZoneInfo> filterDeviceZoneInfoList;
                    Long deviceId = filterDeviceZonePair.getDeviceId();
                    if (this.clusterService.isBelongCluster(deviceId)) {
                        AticDeviceNfaCluster aticDeviceNfaCluster = this.clusterService.getClusterByNfaId(deviceId);
                        deviceId = aticDeviceNfaCluster.getClusterId();
                    }
                    if ((filterDeviceZoneInfoList = this.filterDeviceZoneInfoDao.getByDeviceIdAndFilterIdAndZoneId(deviceId, filterDeviceZonePair.getFilterId(), filterDeviceZonePair.getZoneId())) != null && !filterDeviceZoneInfoList.isEmpty()) {
                        filterDeviceDeployMap.put(filterDevicePair, false);
                    } else {
                        filterDeviceDeployMap.put(filterDevicePair, true);
                    }
                }
                if (((Boolean)filterDeviceDeployMap.get(filterDevicePair)).booleanValue()) {
                    filteIdSet.add(filterDeviceZonePair.getFilterId());
                    deviceUnDeployFilterMap.put(filterDeviceZonePair.getDeviceId(), filteIdSet);
                }
                if (null == deleteDeviceIds || !deleteDeviceIds.contains(filterDeviceZonePair.getDeviceId()) || null != (filterDeviceZoneInfo = this.filterDeviceZoneInfoDao.getByFilterIdAndDeviceIdAndZoneId(filterDeviceZonePair.getFilterId(), filterDeviceZonePair.getDeviceId(), 0L, 1))) continue;
                filteIdSet.add(filterDeviceZonePair.getFilterId());
                deviceUnDeployFilterMap.put(filterDeviceZonePair.getDeviceId(), filteIdSet);
            }
        }
        return deviceUnDeployFilterMap;
    }

    private void dealDeployResult(FilterDeployInfo filterDeployInfo) {
        this.dealFilterZoneDeployResult(filterDeployInfo.getFilterZoneDeployResult());
        this.dealFilterZoneUnDeployResult(filterDeployInfo.getFilterZoneUnDeployResult());
        this.dealFilterDeployResult(filterDeployInfo.getFilterDeployResult());
        this.dealFilterUnDeployResult(filterDeployInfo.getFilterUnDeployResult());
    }

    private void saveZoneStatus(FilterDeployInfo filterDeployInfo, Boolean isDeployWithFilter) {
        Map<FilterDeviceZonePair, String> filterZoneDeployResult = filterDeployInfo.getFilterZoneDeployResult();
        Map<FilterDeviceZonePair, String> filterZoneUnDeployResult = filterDeployInfo.getFilterZoneUnDeployResult();
        Map<FilterDeviceZonePair, String> zoneDeviceDeployMap = this.getZoneDeviceDeployMap(filterZoneDeployResult, filterZoneUnDeployResult);
        HashMap<Long, String> zoneDeployMap = new HashMap<Long, String>();
        HashMap<Long, Long> zoneDeployCrcMap = new HashMap<Long, Long>();
        for (Map.Entry<FilterDeviceZonePair, String> entry : zoneDeviceDeployMap.entrySet()) {
            List<FilterDeviceZoneStatusInfo> list;
            FilterDeviceZonePair filterDeviceZonePair = entry.getKey();
            String errorCode = entry.getValue();
            Long crc = this.getZoneFilterDeployCrc(filterDeviceZonePair.getZoneId());
            Long deviceId = filterDeviceZonePair.getDeviceId();
            Long zoneId = filterDeviceZonePair.getZoneId();
            Long filterId = filterDeviceZonePair.getFilterId();
            if (zoneId == 0L) continue;
            if (isDeployWithFilter.booleanValue() && errorCode.equals("") && (list = this.filterDeviceZoneStatusDao.getFailedByDeviceIdAndZoneId(deviceId, zoneId)) != null && !list.isEmpty()) {
                errorCode = list.get(0).getErrorCode();
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)zoneDeployMap.get(zoneId)))) {
                zoneDeployMap.put(zoneId, errorCode);
            }
            if (zoneDeployCrcMap.get(zoneId) == null || String.valueOf(zoneDeployCrcMap.get(zoneId)).equals("")) {
                zoneDeployCrcMap.put(zoneId, crc);
            }
            this.saveZoneFeatureStatus(zoneId, deviceId, crc, errorCode);
            this.saveZoneDeviceDeployStatus(zoneId, deviceId, filterId, errorCode);
        }
        for (Map.Entry<FilterDeviceZonePair, String> entry : zoneDeployMap.entrySet()) {
            Long crc = (Long)zoneDeployCrcMap.get(entry.getKey());
            this.saveZonePolicyApply((Long)((Object)entry.getKey()), crc, entry.getValue(), isDeployWithFilter);
        }
    }

    private Long getZoneFilterDeployCrc(Long zoneId) {
        Long crc = null;
        List<FilterDeviceZoneStatusInfo> filterDeviceZoneStatusInfoList = this.filterDeviceZoneStatusDao.getByZoneId(zoneId);
        if (filterDeviceZoneStatusInfoList != null && !filterDeviceZoneStatusInfoList.isEmpty()) {
            HashSet<Long> set = new HashSet<Long>();
            int j = filterDeviceZoneStatusInfoList.size();
            for (int i = 0; i < j; ++i) {
                set.add(filterDeviceZoneStatusInfoList.get(i).getFilterId());
            }
            List<Long> filterIdList = this.sortByPreferenceAsc(zoneId, set);
            crc = CrcUtil.getCrcValue(filterIdList.toString());
        } else {
            crc = CrcUtil.getCrcValue(0);
        }
        return crc;
    }

    private List<Long> sortByPreferenceAsc(Long zoneId, Set<Long> filterIdSet) {
        ArrayList<Long> filterIdList = new ArrayList<Long>();
        List<FilterDeviceZoneInfo> list = this.filterDeviceZoneInfoDao.queryByZoneId(zoneId);
        if (list != null) {
            for (FilterDeviceZoneInfo info : list) {
                Long filterId = info.getFilterId();
                if (!filterIdSet.contains(filterId) || filterIdList.contains(filterId)) continue;
                filterIdList.add(filterId);
            }
        }
        return filterIdList;
    }

    public Map<FilterDeviceZonePair, String> getZoneDeviceDeployMap(Map<FilterDeviceZonePair, String> filterZoneDeployResult, Map<FilterDeviceZonePair, String> filterZoneUndeployResult) {
        FilterDeviceZonePair filterDeviceZonePair1;
        String existErrorCode;
        FilterDeviceZonePair filterDeviceZonePair;
        String errorCode;
        Long filterId;
        Long zoneId;
        Long deviceId;
        HashMap<FilterDeviceZonePair, String> zoneResult = new HashMap<FilterDeviceZonePair, String>();
        HashMap<FilterDeviceZonePair, String> result = new HashMap<FilterDeviceZonePair, String>();
        ArrayList<FilterDeviceZonePair> filterList = new ArrayList<FilterDeviceZonePair>();
        for (Map.Entry<FilterDeviceZonePair, String> entry : filterZoneUndeployResult.entrySet()) {
            deviceId = entry.getKey().getDeviceId();
            zoneId = entry.getKey().getZoneId();
            filterId = entry.getKey().getFilterId();
            errorCode = entry.getValue();
            errorCode = errorCode != null ? errorCode : "";
            filterDeviceZonePair = new FilterDeviceZonePair(zoneId, deviceId);
            existErrorCode = (String)zoneResult.get(filterDeviceZonePair);
            if (existErrorCode != null && !existErrorCode.equals("")) continue;
            filterDeviceZonePair1 = new FilterDeviceZonePair(zoneId, filterId, deviceId);
            filterList.add(filterDeviceZonePair1);
            zoneResult.put(filterDeviceZonePair, errorCode);
        }
        for (Map.Entry<FilterDeviceZonePair, String> entry : filterZoneDeployResult.entrySet()) {
            deviceId = entry.getKey().getDeviceId();
            zoneId = entry.getKey().getZoneId();
            filterId = entry.getKey().getFilterId();
            errorCode = entry.getValue();
            errorCode = errorCode != null ? errorCode : "";
            filterDeviceZonePair = new FilterDeviceZonePair(zoneId, deviceId);
            existErrorCode = (String)zoneResult.get(filterDeviceZonePair);
            if (existErrorCode == null) {
                filterDeviceZonePair1 = new FilterDeviceZonePair(zoneId, filterId, deviceId);
                filterList.add(filterDeviceZonePair1);
                zoneResult.put(filterDeviceZonePair, errorCode);
                continue;
            }
            if ("".equals(errorCode)) continue;
            filterDeviceZonePair1 = new FilterDeviceZonePair(zoneId, filterId, deviceId);
            filterList.add(filterDeviceZonePair1);
            zoneResult.put(filterDeviceZonePair, errorCode);
        }
        for (Map.Entry<FilterDeviceZonePair, String> entry : zoneResult.entrySet()) {
            for (FilterDeviceZonePair filter : filterList) {
                if (!entry.getKey().getDeviceId().equals(filter.getDeviceId()) || !entry.getKey().getZoneId().equals(filter.getZoneId())) continue;
                result.put(filter, entry.getValue());
            }
        }
        return result;
    }

    private void saveZonePolicyApply(Long zoneId, Long crc, String errorCode, Boolean isDeployWithFilter) {
        boolean isZoneModify = false;
        boolean isNoneDeployFailed = true;
        if (zoneId == 0L) {
            return;
        }
        if (isDeployWithFilter.booleanValue()) {
            isZoneModify = this.isZoneModify(zoneId);
            isNoneDeployFailed = this.checkZoneIsNodeDeployFailed(zoneId);
        }
        boolean isUpdate = true;
        ZonePolicyApplyInfo zonePolicyApplyInfo = this.zonePolicyApplyDao.getByZoneId(zoneId);
        if (zonePolicyApplyInfo == null) {
            isUpdate = false;
            zonePolicyApplyInfo = new ZonePolicyApplyInfo();
        }
        if (isNoneDeployFailed && !isZoneModify) {
            if (errorCode == null || "".equals(errorCode)) {
                zonePolicyApplyInfo.setFilterState("SUCCESS");
                zonePolicyApplyInfo.setDeployState("SUCCESS");
            } else {
                zonePolicyApplyInfo.setFilterState("PART_SUCCESS");
                zonePolicyApplyInfo.setDeployState("PART_SUCCESS");
            }
        } else if (isNoneDeployFailed && isZoneModify) {
            if (errorCode == null || "".equals(errorCode)) {
                zonePolicyApplyInfo.setFilterState("INCREAMENT_UNDEPLOY");
                zonePolicyApplyInfo.setDeployState("INCREAMENT_UNDEPLOY");
            } else {
                zonePolicyApplyInfo.setFilterState("PART_SUCCESS");
                zonePolicyApplyInfo.setDeployState("PART_SUCCESS");
            }
        } else {
            zonePolicyApplyInfo.setFilterState("SUCCESS");
            zonePolicyApplyInfo.setDeployState("SUCCESS");
            return;
        }
        zonePolicyApplyInfo.setDeployedCrc(crc);
        if (isUpdate) {
            this.zonePolicyApplyDao.update(zonePolicyApplyInfo);
        } else {
            this.zonePolicyApplyDao.save(zonePolicyApplyInfo);
        }
    }

    private boolean checkZoneIsNodeDeployFailed(Long zoneId) {
        List<ZoneDeviceDeployStatusForm> zoneDeviceDeployStatusFormList = this.zonePolicyMgrService.queryDeployResultByZoneId(zoneId);
        if (zoneDeviceDeployStatusFormList != null && !zoneDeviceDeployStatusFormList.isEmpty()) {
            int j = zoneDeviceDeployStatusFormList.size();
            for (int i = 0; i < j; ++i) {
                ZoneDeviceDeployStatusForm zoneDeviceDeployStatusInfo = zoneDeviceDeployStatusFormList.get(i);
                if (null == zoneDeviceDeployStatusInfo.getErrorMsgKey() || "".equals(zoneDeviceDeployStatusInfo.getErrorMsgKey())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isZoneModify(Long zoneId) {
        List<ZoneModifyDetailForm> zoneModifyDetailFormList = this.zonePolicyApplyService.getZoneModifyDetail(zoneId);
        return zoneModifyDetailFormList != null && !zoneModifyDetailFormList.isEmpty();
    }

    private void saveZoneDeviceDeployStatus(Long zoneId, Long deviceId, Long filterId, String errorCode) {
        ZoneDeviceDeployStatusInfo zoneDeviceDeployStatusInfo = this.zoneDeviceDeployStatusDao.getOneByZoneIdAndDeviceId(zoneId, deviceId, 2);
        FilterInfo filterInfo = this.filterDao.get(filterId);
        String errorParam = "";
        if (null != filterInfo && !"".equals(errorCode)) {
            errorParam = "filter name:" + filterInfo.getFilterName() + " filter_Id:" + filterInfo.getFilterId();
        }
        if (null != zoneDeviceDeployStatusInfo) {
            zoneDeviceDeployStatusInfo.setZoneId(zoneId);
            zoneDeviceDeployStatusInfo.setDeviceId(deviceId);
            zoneDeviceDeployStatusInfo.setDeployState("".equals(errorCode));
            zoneDeviceDeployStatusInfo.setDeployType(2);
            zoneDeviceDeployStatusInfo.setErrorMsgKey(errorCode);
            zoneDeviceDeployStatusInfo.setDeployTime(new Date());
            zoneDeviceDeployStatusInfo.setErrorParam(errorParam);
            this.zoneDeviceDeployStatusDao.update(zoneDeviceDeployStatusInfo);
        } else {
            zoneDeviceDeployStatusInfo = new ZoneDeviceDeployStatusInfo();
            zoneDeviceDeployStatusInfo.setZoneId(zoneId);
            zoneDeviceDeployStatusInfo.setDeviceId(deviceId);
            zoneDeviceDeployStatusInfo.setDeployState("".equals(errorCode));
            zoneDeviceDeployStatusInfo.setDeployType(2);
            zoneDeviceDeployStatusInfo.setErrorMsgKey(errorCode);
            zoneDeviceDeployStatusInfo.setDeployTime(new Date());
            zoneDeviceDeployStatusInfo.setErrorParam(errorParam);
            this.zoneDeviceDeployStatusDao.save(zoneDeviceDeployStatusInfo);
        }
    }

    private void saveZoneFeatureStatus(Long zoneId, Long deviceId, Long crc, String errorCode) {
        ZoneFeatureStatusInfo zoneFeatureStatusInfo = this.zoneFeatureStatusDao.getByZoneIdAndDeviceIdAndTypeAndFeatureId(zoneId, deviceId, FilterForm.class.getSimpleName(), zoneId);
        if (zoneFeatureStatusInfo == null) {
            zoneFeatureStatusInfo = new ZoneFeatureStatusInfo();
            zoneFeatureStatusInfo.setZoneId(zoneId);
            zoneFeatureStatusInfo.setDeviceId(deviceId);
            zoneFeatureStatusInfo.setDeployState(errorCode == null || "".equals(errorCode));
            zoneFeatureStatusInfo.setDeployCrc(crc);
            zoneFeatureStatusInfo.setFeatureId(zoneId);
            zoneFeatureStatusInfo.setFeatureType(FilterForm.class.getSimpleName());
            this.zoneFeatureStatusDao.save(zoneFeatureStatusInfo);
        } else {
            zoneFeatureStatusInfo.setZoneId(zoneId);
            zoneFeatureStatusInfo.setDeviceId(deviceId);
            zoneFeatureStatusInfo.setDeployState(errorCode == null || "".equals(errorCode));
            zoneFeatureStatusInfo.setDeployCrc(crc);
            zoneFeatureStatusInfo.setFeatureId(zoneId);
            zoneFeatureStatusInfo.setFeatureType(FilterForm.class.getSimpleName());
            this.zoneFeatureStatusDao.update(zoneFeatureStatusInfo);
        }
    }

    private void dealFilterZoneUnDeployResult(Map<FilterDeviceZonePair, String> filterZoneUnDeployResult) {
        for (Map.Entry<FilterDeviceZonePair, String> filterZoneUnDeployResultEntry : filterZoneUnDeployResult.entrySet()) {
            Long deviceId = filterZoneUnDeployResultEntry.getKey().getDeviceId();
            Long filterId = filterZoneUnDeployResultEntry.getKey().getFilterId();
            Long zoneId = filterZoneUnDeployResultEntry.getKey().getZoneId();
            int direction = filterZoneUnDeployResultEntry.getKey().getDirection();
            String errorCode = filterZoneUnDeployResultEntry.getValue();
            int gloApplyFlag = filterZoneUnDeployResultEntry.getKey().getGloApplyFlag();
            Long filter2DeviceId = deviceId;
            AticDeviceNfaClusterDao aticDeviceNfaClusterDao = (AticDeviceNfaClusterDao)ServiceContext.getInstance().getService("aticDeviceNfaClusterDao", AticDeviceNfaClusterDao.class);
            List findClusterByDeviceId = aticDeviceNfaClusterDao.findClusterByDeviceId(deviceId);
            if (null != findClusterByDeviceId && !findClusterByDeviceId.isEmpty()) {
                filter2DeviceId = ((AticDeviceNfaCluster)findClusterByDeviceId.get(0)).getClusterId();
            }
            List<FilterDeviceZoneInfo> list = this.filterDeviceZoneInfoDao.getByDeviceIdAndFilterIdAndZoneId(filter2DeviceId, filterId, zoneId, direction);
            boolean notExist = false;
            if (list == null || list.isEmpty()) {
                notExist = true;
            }
            if ("".equals(errorCode) && notExist) {
                this.filterDeviceZoneStatusDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, zoneId, direction);
            }
            if (zoneId != 0L || gloApplyFlag != 1 || !"".equals(errorCode)) continue;
            this.filterDeviceZoneInfoDao.updateFilterDeployStateForGlo(filterId, deviceId, "UNDEPLOY");
            this.filterDeviceZoneInfoDao.updateGlobalApplyFlag(filterId, deviceId);
            this.filterDeviceZoneStatusDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, 0L);
        }
    }

    private void dealFilterZoneDeployResult(Map<FilterDeviceZonePair, String> filterZoneDeployResult) {
        for (Map.Entry<FilterDeviceZonePair, String> filterZoneDeployResultEntry : filterZoneDeployResult.entrySet()) {
            FilterDeviceZoneStatusInfo filterDeviceZoneStatusInfo;
            Long deviceId = filterZoneDeployResultEntry.getKey().getDeviceId();
            Long filterId = filterZoneDeployResultEntry.getKey().getFilterId();
            Long zoneId = filterZoneDeployResultEntry.getKey().getZoneId();
            int direction = filterZoneDeployResultEntry.getKey().getDirection();
            String errorCode = filterZoneDeployResultEntry.getValue();
            int gloApplyFlag = filterZoneDeployResultEntry.getKey().getGloApplyFlag();
            Boolean deployState = false;
            if ("".equals(errorCode)) {
                deployState = true;
            }
            if ((filterDeviceZoneStatusInfo = this.filterDeviceZoneStatusDao.getByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, zoneId, direction)) == null) {
                filterDeviceZoneStatusInfo = new FilterDeviceZoneStatusInfo();
                filterDeviceZoneStatusInfo.setFilterId(filterId);
                filterDeviceZoneStatusInfo.setDeviceId(deviceId);
                filterDeviceZoneStatusInfo.setZoneId(zoneId);
                filterDeviceZoneStatusInfo.setDirection(direction);
            }
            filterDeviceZoneStatusInfo.setDeployState(deployState);
            filterDeviceZoneStatusInfo.setFilterDefineState(deployState);
            Long preference = this.getPreference(filterId, zoneId, direction);
            filterDeviceZoneStatusInfo.setFilterPreference(preference);
            filterDeviceZoneStatusInfo.setErrorCode(errorCode);
            if (zoneId == 0L && gloApplyFlag == 1) {
                if (deployState.booleanValue()) {
                    this.filterDeviceZoneInfoDao.updateFilterDeployStateForGlo(filterId, deviceId, "SUCCESS");
                } else {
                    this.filterDeviceZoneInfoDao.updateFilterDeployStateForGlo(filterId, deviceId, "UNDEPLOY");
                }
            }
            if (deployState.booleanValue() && zoneId == 0L) continue;
            this.filterDeviceZoneStatusDao.save(filterDeviceZoneStatusInfo);
        }
    }

    private Long getPreference(Long filterId, Long zoneId, int direction) {
        IFilterDeviceZoneInfoService service = (IFilterDeviceZoneInfoService)ServiceContext.getInstance().getService("filterDeviceZoneInfoService", IFilterDeviceZoneInfoService.class);
        return service.queryPreferenceByFilterIdAndZoneId(filterId, zoneId, direction);
    }

    private void dealFilterUnDeployResult(Map<FilterDevicePair, String> filterUnDeployResult) {
        for (Map.Entry<FilterDevicePair, String> filterUnDeployResultEntry : filterUnDeployResult.entrySet()) {
            List bindNfaDevices;
            AticDevice device;
            Long filterId = filterUnDeployResultEntry.getKey().getFilterId();
            Long deviceId = filterUnDeployResultEntry.getKey().getDeviceId();
            if ("".equals(filterUnDeployResultEntry.getValue())) {
                device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
                if (null != device && device.getDeviceType() == 9) {
                    bindNfaDevices = this.clusterService.getBindNfaDevice(Long.valueOf(device.getMoId()));
                    for (AticDeviceNfaCluster aticDeviceNfaCluster : bindNfaDevices) {
                        this.filterDeviceDao.deleteByFilterIdAndDeviceId(filterId, aticDeviceNfaCluster.getDeviceId());
                        this.filterDeviceZoneStatusDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, aticDeviceNfaCluster.getDeviceId(), 0L);
                    }
                } else {
                    this.filterDeviceDao.deleteByFilterIdAndDeviceId(filterId, deviceId);
                    this.filterDeviceZoneStatusDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, 0L);
                }
                this.filterDeviceZoneInfoDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, 0L);
                continue;
            }
            this.filterDeviceZoneInfoDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, 0L);
            device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
            if (null != device && device.getDeviceType() == 9) {
                bindNfaDevices = this.clusterService.getBindNfaDevice(Long.valueOf(device.getMoId()));
                for (AticDeviceNfaCluster aticDeviceNfaCluster : bindNfaDevices) {
                    this.filterDeviceZoneStatusDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, aticDeviceNfaCluster.getDeviceId(), 0L);
                }
                continue;
            }
            this.filterDeviceZoneStatusDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, 0L);
        }
    }

    private void dealFilterDeployResult(Map<FilterDevicePair, String> filterDeployResult) {
        for (Map.Entry<FilterDevicePair, String> filterDeployResultEntry : filterDeployResult.entrySet()) {
            Long filterId = filterDeployResultEntry.getKey().getFilterId();
            Long deviceId = filterDeployResultEntry.getKey().getDeviceId();
            String errCode = filterDeployResultEntry.getValue();
            if ("".equals(filterDeployResultEntry.getValue())) {
                List<FilterDeviceInfo> filterDeviceInfoList = this.filterDeviceDao.getByFilterIdAndDeviceId(filterId, deviceId);
                if (filterDeviceInfoList == null || filterDeviceInfoList.isEmpty()) {
                    FilterDeviceInfo filterDeviceInfo = new FilterDeviceInfo();
                    filterDeviceInfo.setDeviceId(deviceId);
                    filterDeviceInfo.setFilterId(filterId);
                    this.filterDeviceDao.save(filterDeviceInfo);
                }
            } else {
                this.filterDeviceDao.deleteByFilterIdAndDeviceId(filterId, deviceId);
            }
            List<FilterDeviceZoneInfo> filterDeviceZoneInfos = this.filterDeviceZoneInfoDao.queryFilterForGlo(deviceId, filterId);
            for (FilterDeviceZoneInfo filterDeviceZoneInfo : filterDeviceZoneInfos) {
                Long zoneId = filterDeviceZoneInfo.getZoneId();
                if ("".equals(errCode)) {
                    this.filterDeviceZoneInfoDao.updateFilterDefineStateForGlo(filterId, deviceId, zoneId);
                    continue;
                }
                FilterDeviceZoneStatusInfo info = this.filterDeviceZoneStatusDao.getByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, 0L, 1);
                if (null == info) {
                    info = new FilterDeviceZoneStatusInfo();
                    info.setZoneId(zoneId);
                    info.setFilterId(filterId);
                    info.setDeviceId(deviceId);
                    info.setFilterDefineState(false);
                    info.setDeployState(false);
                    info.setDirection(filterDeviceZoneInfo.getDirection());
                    info.setFilterPreference(filterDeviceZoneInfo.getPreference());
                    info.setErrorCode(errCode);
                } else {
                    info.setFilterDefineState(false);
                    info.setDeployState(false);
                    info.setDirection(filterDeviceZoneInfo.getDirection());
                    info.setFilterPreference(filterDeviceZoneInfo.getPreference());
                    info.setErrorCode(errCode);
                }
                this.filterDeviceZoneStatusDao.createOrUpdate(info);
            }
            List<FilterDeviceZoneStatusInfo> filterDeviceZoneStatusInfos = this.filterDeviceZoneStatusDao.getByFilterIdAndDeviceId(filterId, deviceId);
            for (FilterDeviceZoneStatusInfo fInfo : filterDeviceZoneStatusInfos) {
                Long zoneId = fInfo.getZoneId();
                if (!"".equals(errCode)) continue;
                if (0L == zoneId) {
                    FilterDeviceZoneStatusInfo statusInfo = this.filterDeviceZoneStatusDao.getByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, zoneId);
                    if (null == statusInfo) continue;
                    this.filterDeviceZoneStatusDao.deleteByFilterIdAndDeviceIdAndZoneId(filterId, deviceId, zoneId);
                    continue;
                }
                this.filterDeviceZoneStatusDao.updateDeploydFilterDefineState(filterId, deviceId, zoneId);
            }
        }
    }

    private void startFilterDeployThreads(FilterDeployInfo filterDeployInfo) {
        Set<Long> deviceIdSet = filterDeployInfo.getFilterConfigData().getNeInfoMap().keySet();
        for (Long deviceId : deviceIdSet) {
            LogicDev logicDev = new LogicDev(deviceId, 1, "--");
            FilterDeployThread filterDeployThread = new FilterDeployThread(logicDev, filterDeployInfo);
            filterDeployInfo.getFilterDeployThreadPool().submit(filterDeployThread);
            this.logger.info((Object)("start filter deploy thread , deviceId : " + deviceId));
        }
        filterDeployInfo.getFilterDeployThreadPool().shutdown();
        try {
            if (filterDeployInfo.getFilterDeployThreadPool().awaitTermination(10L, TimeUnit.MINUTES)) {
                this.logger.info((Object)"filter deploy thread execute finished.");
            }
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)("filter deploy thread execute timeout." + e1.getMessage()));
        }
    }

    private FilterDeployInfo initFilterDeployInfo(List<FilterDeviceZonePair> deployFilterDeviceZonePairList, List<FilterDeviceZonePair> undeployFilterDeviceZonePairList, Map<Long, Set<Long>> deviceUnDeployFilterMap, FilterDeployInfo filterDeployInfo, Boolean isDeployWithFilter) {
        this.logger.info((Object)"init filter deploy info");
        FilterConfigData filterConfigData = this.initFilterConfigData(deployFilterDeviceZonePairList, undeployFilterDeviceZonePairList, deviceUnDeployFilterMap, isDeployWithFilter);
        filterDeployInfo.setFilterConfigData(filterConfigData);
        FilterToDeployData filterToDeployData = this.initFilterToDepolyData(filterConfigData);
        filterDeployInfo.setFilterToDeployData(filterToDeployData);
        ThreadPoolExecutor filterDeployThreadPool = this.initFilterDeployThreadPool();
        filterDeployInfo.setFilterDeployThreadPool(filterDeployThreadPool);
        return filterDeployInfo;
    }

    private FilterToDeployData initFilterToDepolyData(FilterConfigData filterConfigData) {
        this.logger.info((Object)"init filter to deploy data");
        FilterToDeployData filterToDeployData = this.filterToDeployDataTool.initFilterToDeployData(filterConfigData);
        return filterToDeployData;
    }

    private ThreadPoolExecutor initFilterDeployThreadPool() {
        this.logger.info((Object)"init filter deploy thread pool");
        ThreadPoolExecutor filterDeployThreadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        return filterDeployThreadPool;
    }

    private FilterConfigData initFilterConfigData(List<FilterDeviceZonePair> deployFilterDeviceZonePairList, List<FilterDeviceZonePair> undeployFilterDeviceZonePairList, Map<Long, Set<Long>> deviceUnDeployFilterMap, Boolean isDeployWithFilter) {
        this.logger.info((Object)"init filter config data");
        FilterConfigData filterConfigData = this.filterConfigDataTool.initDeployFilterConfigData(deployFilterDeviceZonePairList, undeployFilterDeviceZonePairList, deviceUnDeployFilterMap, isDeployWithFilter);
        return filterConfigData;
    }

    public void doDeployWithFilterDstIp(FilterForm filter) {
        FilterDstIpDeployInfo filterDstIpDeployInfo = new FilterDstIpDeployInfo();
        ArrayList<LogicDev> deviceList = new ArrayList<LogicDev>();
        try {
            this.logger.info((Object)("doDeployWithFilterDstIp : " + filter));
            this.initData4DeployWithFilterDstIp(filter, filterDstIpDeployInfo, deviceList);
            List<Future<String>> futures = this.startThread4DeployWithFilterDstIp(filterDstIpDeployInfo, deviceList, true);
            this.dealFilterDstIpDeployThreadResult(futures);
            this.backupFilterDstIpDeploy(filterDstIpDeployInfo);
        }
        catch (LegoCheckedException e) {
            this.backupFilterDstIpDeploy(filterDstIpDeployInfo);
            this.logger.error((Object)("Deploy filter dst-ip failed. " + e.getMessage()));
            throw e;
        }
    }

    public void doUnDeployWithFilterDstIp(FilterForm filter) {
        FilterDstIpDeployInfo filterDstIpDeployInfo = new FilterDstIpDeployInfo();
        ArrayList<LogicDev> deviceList = new ArrayList<LogicDev>();
        try {
            this.logger.info((Object)("doDeployWithFilterDstIp : " + filter));
            this.initData4DeployWithFilterDstIp(filter, filterDstIpDeployInfo, deviceList);
            List<Future<String>> futures = this.startThread4DeployWithFilterDstIp(filterDstIpDeployInfo, deviceList, false);
            this.dealFilterDstIpDeployThreadResult(futures);
            this.dealFilterDstIpUnDeployResult(filterDstIpDeployInfo);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("unDeploy filter dst-ip failed. " + e.getMessage()));
            throw e;
        }
    }

    private void initData4DeployWithFilterDstIp(FilterForm filter, FilterDstIpDeployInfo filterDstIpDeployInfo, List<LogicDev> deviceList) {
        this.logger.info((Object)"init deploy filter dst-ip data.");
        FilterInfo filterInfo = new FilterInfo();
        AticUtil.copyProperties((Object)filter, (Object)filterInfo);
        List<HttpFilterForm> httpFilterFormList = filter.getHttpFilterFormList();
        ArrayList<HttpFilterInfo> httpFilterInfos = new ArrayList<HttpFilterInfo>();
        if (null != httpFilterFormList && !httpFilterFormList.isEmpty()) {
            for (HttpFilterForm httpFilterForm : httpFilterFormList) {
                HttpFilterInfo httpFilterInfo = new HttpFilterInfo();
                AticUtil.copyProperties((Object)httpFilterForm, (Object)httpFilterInfo);
                httpFilterInfos.add(httpFilterInfo);
            }
        }
        HashMap<Long, FilterInfo> filterInfoMap = new HashMap<Long, FilterInfo>();
        filterInfoMap.put(filter.getPkid(), filterInfo);
        FilterConfigData filterConfigData = new FilterConfigData();
        filterConfigData.setFilterInfoMap(filterInfoMap);
        FilterToDeployData filterToDeployData = new FilterToDeployData();
        HashMap<Long, List<IFeature>> filterInfoToDeployData = new HashMap<Long, List<IFeature>>();
        ArrayList<FilterDstIpData> featureList = new ArrayList<FilterDstIpData>();
        FilterDstIpData filterDstIpData = new FilterDstIpData(FilterInfo.class.getSimpleName(), filterInfo.getPkid(), filterInfo, httpFilterInfos);
        featureList.add(filterDstIpData);
        List<FilterDeviceInfo> filterDeviceInfos = this.filterDeviceDao.getByFilterId(filter.getPkid());
        if (null != filterDeviceInfos && !filterDeviceInfos.isEmpty()) {
            for (FilterDeviceInfo filterDeviceInfo : filterDeviceInfos) {
                long deviceId = filterDeviceInfo.getDeviceId();
                filterInfoToDeployData.put(deviceId, featureList);
                LogicDev logicDev = new LogicDev(deviceId, 1, "--");
                deviceList.add(logicDev);
            }
        }
        filterToDeployData.setFilterInfoToDeployData(filterInfoToDeployData);
        filterDstIpDeployInfo.setFilterConfigData(filterConfigData);
        filterDstIpDeployInfo.setFilterToDeployData(filterToDeployData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Future<String>> startThread4DeployWithFilterDstIp(FilterDstIpDeployInfo filterDstIpDeployInfo, List<LogicDev> deviceList, boolean idDeploy) {
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        try {
            ThreadPoolExecutor filterDstIpDeployThreadPoll = this.initFilterDeployThreadPool(5);
            filterDstIpDeployInfo.setFilterDstIpDeployThreadPool(filterDstIpDeployThreadPoll);
            for (LogicDev logicDev : deviceList) {
                FilterDstIpDeployThread thread = new FilterDstIpDeployThread(logicDev, filterDstIpDeployInfo, idDeploy);
                futures.add(filterDstIpDeployInfo.getFilterDstIpDeployThreadPool().submit(thread));
            }
        }
        finally {
            filterDstIpDeployInfo.getFilterDstIpDeployThreadPool().shutdown();
        }
        return futures;
    }

    private ThreadPoolExecutor initFilterDeployThreadPool(int threadPoolSize) {
        this.logger.info((Object)"init filter deploy thread pool");
        ThreadPoolExecutor filterDeployThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadPoolSize);
        return filterDeployThreadPool;
    }

    private void dealFilterDstIpDeployThreadResult(List<Future<String>> futures) {
        for (int i = 0; i < futures.size(); ++i) {
            try {
                futures.get(i).get();
                continue;
            }
            catch (Exception e) {
                this.logger.info((Object)("deploy filter dst-ip error. " + e.getMessage()));
                futures.get(i).cancel(true);
                if (e instanceof LegoCheckedException) {
                    LegoCheckedException ex = (LegoCheckedException)((Object)e);
                    throw ex;
                }
                LegoCheckedException ex = new LegoCheckedException("");
                throw ex;
            }
        }
    }

    private void backupFilterDstIpDeploy(FilterDstIpDeployInfo filterDstIpDeployInfo) {
        Map<Long, FilterDstIpDeployInfo> backupMap = this.dealFilterDstIpDeployResult(filterDstIpDeployInfo);
        if (null != backupMap && backupMap.size() > 0) {
            this.logger.info((Object)("backupMap.size() = " + backupMap.size()));
            for (Map.Entry<Long, FilterDstIpDeployInfo> entry : backupMap.entrySet()) {
                Long key = entry.getKey();
                LogicDev logicDev = new LogicDev(key, 1, "--");
                ArrayList<LogicDev> logicDevs = new ArrayList<LogicDev>();
                logicDevs.add(logicDev);
                this.startThread4DeployWithFilterDstIp(filterDstIpDeployInfo, logicDevs, false);
            }
            throw new LegoCheckedException("deploy filter dst-ip failed.");
        }
    }

    private Map<Long, FilterDstIpDeployInfo> dealFilterDstIpDeployResult(FilterDstIpDeployInfo filterDstIpDeployInfo) {
        this.logger.info((Object)"deal filter dst-ip deploy result.");
        Map<FilterDstIpPair, List<String>> map = filterDstIpDeployInfo.getFilterDstIpDeployResult();
        if (map.isEmpty()) {
            throw new LegoCheckedException(571507L);
        }
        String isExisted = "lego.err.631038";
        HashMap<Long, FilterDstIpDeployInfo> backupMap = new HashMap<Long, FilterDstIpDeployInfo>();
        boolean isFailed = false;
        for (Map.Entry<FilterDstIpPair, List<String>> filterDeployResultEntry : map.entrySet()) {
            FilterDstIpPair filterDstIpPair = filterDeployResultEntry.getKey();
            List<String> errorCodes = filterDeployResultEntry.getValue();
            ArrayList<HttpFilterInfo> httpFilterInfos = new ArrayList<HttpFilterInfo>();
            for (int i = 2; i < errorCodes.size(); ++i) {
                String errorCode = errorCodes.get(i);
                if ("".equals(errorCode)) {
                    HttpFilterInfo httpFilterInfo = filterDstIpPair.getHttpFilterInfos().get(i - 2);
                    httpFilterInfos.add(httpFilterInfo);
                    continue;
                }
                if (isExisted.equals(errorCode)) continue;
                isFailed = true;
            }
            List<IFeature> list = filterDstIpDeployInfo.getFilterToDeployData().getFilterInfoToDeployData().get(filterDstIpPair.getDeviceId());
            FilterDstIpData filterDstIpData = (FilterDstIpData)list.get(0);
            FilterInfo filterInfo = filterDstIpData.getFilterInfo();
            ArrayList<FilterDstIpData> newList = new ArrayList<FilterDstIpData>();
            FilterDstIpData newFilterDstIpData = new FilterDstIpData(FilterInfo.class.getSimpleName(), filterDstIpPair.getDeviceId(), filterInfo, httpFilterInfos);
            newList.add(newFilterDstIpData);
            filterDstIpDeployInfo.getFilterToDeployData().getFilterInfoToDeployData().put(filterDstIpPair.getDeviceId(), newList);
            backupMap.put(filterDstIpPair.getDeviceId(), filterDstIpDeployInfo);
        }
        if (!isFailed) {
            this.saveFilterDstIp2db(map);
            return null;
        }
        return backupMap;
    }

    private void saveFilterDstIp2db(Map<FilterDstIpPair, List<String>> map) {
        this.logger.info((Object)("deploy filter dst-ip success. save to db." + map.size()));
        List allHttpFilterInfos = this.httpFilterDao.queryAll();
        for (Map.Entry<FilterDstIpPair, List<String>> filterDstIpDeployResultEntry : map.entrySet()) {
            long filterId = filterDstIpDeployResultEntry.getKey().getFilterId();
            List<HttpFilterInfo> httpFilterInfos = filterDstIpDeployResultEntry.getKey().getHttpFilterInfos();
            for (HttpFilterInfo httpFilterInfo : httpFilterInfos) {
                httpFilterInfo.setFilterId(filterId);
                if (allHttpFilterInfos.contains(httpFilterInfo)) continue;
                this.httpFilterDao.save(httpFilterInfo);
                allHttpFilterInfos.add(httpFilterInfo);
            }
        }
    }

    private void dealFilterDstIpUnDeployResult(FilterDstIpDeployInfo filterDstIpDeployInfo) {
        Map<FilterDstIpPair, List<String>> map = filterDstIpDeployInfo.getFilterDstIpUnDeployResult();
        for (Map.Entry<FilterDstIpPair, List<String>> filterUnDeployResultEntry : map.entrySet()) {
            List<HttpFilterInfo> httpFilterInfos = filterUnDeployResultEntry.getKey().getHttpFilterInfos();
            List<String> errorCodes = filterUnDeployResultEntry.getValue();
            for (int i = 2; i < errorCodes.size(); ++i) {
                HttpFilterInfo httpFilterInfo;
                List<HttpFilterInfo> queryDstIp;
                String errorCode = errorCodes.get(i);
                if (!"".equals(errorCode) || null == (queryDstIp = this.httpFilterDao.queryDstIp(httpFilterInfo = httpFilterInfos.get(i - 2))) || queryDstIp.isEmpty()) continue;
                this.httpFilterDao.delete(queryDstIp.get(0).getPkid());
            }
        }
    }

    public FilterConfigDataTool getFilterConfigDataTool() {
        return this.filterConfigDataTool;
    }

    public void setFilterConfigDataTool(FilterConfigDataTool filterConfigDataTool) {
        this.filterConfigDataTool = filterConfigDataTool;
    }

    public FilterToDeployDataTool getFilterToDeployDataTool() {
        return this.filterToDeployDataTool;
    }

    public void setFilterToDeployDataTool(FilterToDeployDataTool filterToDeployDataTool) {
        this.filterToDeployDataTool = filterToDeployDataTool;
    }

    public FilterDeviceZoneInfoDao getFilterDeviceZoneInfoDao() {
        return this.filterDeviceZoneInfoDao;
    }

    public void setFilterDeviceZoneInfoDao(FilterDeviceZoneInfoDao filterDeviceZoneInfoDao) {
        this.filterDeviceZoneInfoDao = filterDeviceZoneInfoDao;
    }

    public FilterDeviceZoneStatusDao getFilterDeviceZoneStatusDao() {
        return this.filterDeviceZoneStatusDao;
    }

    public void setFilterDeviceZoneStatusDao(FilterDeviceZoneStatusDao filterDeviceZoneStatusDao) {
        this.filterDeviceZoneStatusDao = filterDeviceZoneStatusDao;
    }

    public FilterDeviceDao getFilterDeviceDao() {
        return this.filterDeviceDao;
    }

    public void setFilterDeviceDao(FilterDeviceDao filterDeviceDao) {
        this.filterDeviceDao = filterDeviceDao;
    }

    public FilterDao getFilterDao() {
        return this.filterDao;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.filterDao = filterDao;
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public ZonePolicyApplyDao getZonePolicyApplyDao() {
        return this.zonePolicyApplyDao;
    }

    public void setZonePolicyApplyDao(ZonePolicyApplyDao zonePolicyApplyDao) {
        this.zonePolicyApplyDao = zonePolicyApplyDao;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public IZonePolicyMgrService getZonePolicyMgrService() {
        return this.zonePolicyMgrService;
    }

    public void setZonePolicyMgrService(IZonePolicyMgrService zonePolicyMgrService) {
        this.zonePolicyMgrService = zonePolicyMgrService;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public HttpFilterDao getHttpFilterDao() {
        return this.httpFilterDao;
    }

    public void setHttpFilterDao(HttpFilterDao httpFilterDao) {
        this.httpFilterDao = httpFilterDao;
    }
}

