/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.function.deploy;

import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.ErrorMsg2ResKey;
import com.hs.vsm.secservice.ddos.common.FilterDevicePair;
import com.hs.vsm.secservice.ddos.common.FilterDeviceZonePair;
import com.hs.vsm.secservice.ddos.service.data.FilterToDeployData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterZoneData;
import com.hs.vsm.secservice.ddos.service.function.deploy.FilterDeployInfo;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneFeatureStatusService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterDeployThread
extends Thread {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private LogicDev logicDev;
    private FilterToDeployData filterToDeployData;
    private Map<FilterDevicePair, String> filterDeployResult;
    private Map<FilterDevicePair, String> filterUnDeployResult;
    private Map<FilterDeviceZonePair, String> filterZoneDeployResult;
    private Map<FilterDeviceZonePair, String> filterZoneUnDeployResult;
    private Boolean isDeviceConnectedOK = true;
    private Map<String, String> errorMapping = ErrorMsg2ResKey.getInstance().getErrorMsgKeyMapping();
    private IAticDeviceService aticDeviceService;
    private IZoneFeatureStatusService zoneFeatureStatusService;
    private ILicenseOutboundService licenseOutboundService;
    private LogicDev logicDev1;

    public FilterDeployThread(LogicDev logicDev, FilterDeployInfo filterDeployInfo) {
        this.logicDev = logicDev;
        this.filterToDeployData = filterDeployInfo.getFilterToDeployData();
        this.filterDeployResult = filterDeployInfo.getFilterDeployResult();
        this.filterUnDeployResult = filterDeployInfo.getFilterUnDeployResult();
        this.filterZoneDeployResult = filterDeployInfo.getFilterZoneDeployResult();
        this.filterZoneUnDeployResult = filterDeployInfo.getFilterZoneUnDeployResult();
    }

    @Override
    public void run() {
        this.aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        this.zoneFeatureStatusService = (IZoneFeatureStatusService)ServiceContext.getInstance().getService("zoneFeatureStatusService", IZoneFeatureStatusService.class);
        try {
            AticDevice device = this.aticDeviceService.getDeviceByMoid(this.logicDev.getDeviceId().longValue());
            if (null == device) {
                this.logger.error((Object)("device is null, device id : " + this.logicDev.getDeviceId()));
                return;
            }
            if (device.getDeviceType() == 9) {
                IClusterService clusterService = (IClusterService)ServiceContext.getInstance().getService("clusterService", IClusterService.class);
                List bindNfaDevice = clusterService.getBindNfaDevice(Long.valueOf(device.getMoId()));
                for (AticDeviceNfaCluster aticDeviceNfaCluster : bindNfaDevice) {
                    this.logicDev1 = new LogicDev(aticDeviceNfaCluster.getDeviceId(), 1, "--");
                    this.logicDev1.setType(8);
                    this.logicDev1.setClusterId(aticDeviceNfaCluster.getClusterId());
                    this.unDeployFilterZoneFromDevice();
                    this.unDeployFilterFromDevice();
                    this.deployFilterToDevice();
                    this.deployFilterZoneToDevice();
                }
            } else {
                this.logicDev1 = this.logicDev;
                this.logicDev1.setType(device.getDeviceType());
                this.unDeployFilterZoneFromDevice();
                this.unDeployFilterFromDevice();
                this.deployFilterToDevice();
                this.deployFilterZoneToDevice();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("deploy filter thread error, device id : " + this.logicDev.getDeviceId() + ". " + e.getMessage()));
        }
    }

    private void deployFilterToDevice() {
        List<IFeature> deployFilterData = this.filterToDeployData.getFilterInfoToDeployData().get(this.logicDev.getDeviceId());
        if (deployFilterData != null && !deployFilterData.isEmpty()) {
            for (int i = 0; i < deployFilterData.size(); ++i) {
                IFeature feature = deployFilterData.get(i);
                FilterData filterData = (FilterData)feature;
                this.logger.info((Object)("pre deploy filter by deploy,  deviceId : " + this.logicDev1.getDeviceId() + ", filterId : " + filterData.getFilterInfo().getPkid()));
                String errorCode = "lego.err.631039";
                try {
                    if (this.isDeviceConnectedOK.booleanValue() || i == 0) {
                        List cmdResultList = (List)filterData.doDeploy(this.logicDev1, null);
                        errorCode = this.checkCmdResultList(cmdResultList);
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                    if (e.getErrorCode() != 630005L) {
                        this.isDeviceConnectedOK = false;
                    }
                    errorCode = "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                    errorCode = "lego.err.631039";
                }
                this.checkFilterResult(filterData.getFeatureId(), errorCode, true);
            }
        }
    }

    private void deployFilterZoneToDevice() {
        List<IFeature> deployFilterDataZonesData = this.filterToDeployData.getFilterZonesToDeployData().get(this.logicDev.getDeviceId());
        if (deployFilterDataZonesData != null && !deployFilterDataZonesData.isEmpty()) {
            for (IFeature feature : deployFilterDataZonesData) {
                String errorCode = "";
                FilterZoneData filterZoneData = (FilterZoneData)feature;
                Long zoneId = filterZoneData.getZoneInfoForm().getZoneId();
                if (zoneId != 0L) {
                    Long preference = this.getPreference(filterZoneData.getFilterInfo().getPkid(), zoneId, filterZoneData.getDirection());
                    filterZoneData.setPreference(preference);
                }
                this.logger.info((Object)("pre deploy filterZone by deploy,  deviceId : " + this.logicDev1.getDeviceId() + ", zoneId : " + zoneId + ", filterId : " + filterZoneData.getFilterInfo().getPkid()));
                FilterDevicePair filterDevicePair = new FilterDevicePair(filterZoneData.getFilterInfo().getPkid(), this.logicDev1.getDeviceId());
                if (this.filterDeployResult.get(filterDevicePair) != null && !AticUtil.isNull((String)(errorCode = this.filterDeployResult.get(filterDevicePair)))) {
                    this.logger.info((Object)("filterDeployResult errorCode is :" + this.getcleanedMessage(errorCode)));
                    this.checkFilterZoneResult(filterZoneData.getFilterInfo().getPkid(), zoneId, errorCode, true, filterZoneData.getDirection());
                    continue;
                }
                List cmdResultList = null;
                try {
                    if ("".equals(errorCode) && this.isDeviceConnectedOK.booleanValue()) {
                        cmdResultList = (List)filterZoneData.doDeploy(this.logicDev1, null);
                        errorCode = this.checkCmdResultList(cmdResultList);
                    } else {
                        errorCode = "lego.err.631039";
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                    if (e.getErrorCode() != 630005L) {
                        this.isDeviceConnectedOK = false;
                    }
                    errorCode = "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                    errorCode = "lego.err.631039";
                }
                this.checkFilterZoneResult(filterZoneData.getFilterInfo().getPkid(), zoneId, errorCode, true, filterZoneData.getDirection());
            }
        }
    }

    private void unDeployFilterFromDevice() {
        List<IFeature> unDeployFilterData = this.filterToDeployData.getFilterInfoToUnDeployData().get(this.logicDev.getDeviceId());
        if (unDeployFilterData != null && !unDeployFilterData.isEmpty()) {
            for (IFeature feature : unDeployFilterData) {
                FilterData filterData;
                String errorCode;
                block7: {
                    errorCode = "";
                    filterData = (FilterData)feature;
                    this.logger.info((Object)("pre undeploy filter by deploy,  deviceId : " + this.logicDev1.getDeviceId() + ", filterId : " + filterData.getFilterInfo().getPkid()));
                    try {
                        if (this.isDeviceConnectedOK.booleanValue()) {
                            filterData.doUndeploy(this.logicDev1, null);
                            break block7;
                        }
                        this.logger.info((Object)("deploy filter isDeviceConnectedOK is" + this.isDeviceConnectedOK));
                        break;
                    }
                    catch (LegoCheckedException e) {
                        this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                        if (e.getErrorCode() != 630005L) {
                            this.isDeviceConnectedOK = false;
                        }
                        errorCode = "lego.err." + e.getErrorCode();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                        errorCode = "lego.err.631039";
                    }
                }
                this.checkFilterResult(filterData.getFeatureId(), errorCode, false);
            }
        }
    }

    private void unDeployFilterZoneFromDevice() {
        List<IFeature> unDeployFilterDataZonesData = this.filterToDeployData.getFilterZonesToUnDeployData().get(this.logicDev.getDeviceId());
        if (unDeployFilterDataZonesData != null && !unDeployFilterDataZonesData.isEmpty()) {
            for (IFeature feature : unDeployFilterDataZonesData) {
                Long zoneId;
                FilterZoneData filterZoneData;
                String errorCode;
                block7: {
                    errorCode = "";
                    filterZoneData = (FilterZoneData)feature;
                    zoneId = filterZoneData.getZoneInfoForm().getZoneId();
                    this.logger.info((Object)("pre undeploy filterZone by deploy,  deviceId : " + this.logicDev1.getDeviceId() + "zoneId : " + zoneId + ", filterId : " + filterZoneData.getFilterInfo().getPkid()));
                    try {
                        if (this.isDeviceConnectedOK.booleanValue()) {
                            List cmdResultList = (List)filterZoneData.doUndeploy(this.logicDev1, null);
                            errorCode = this.checkCmdResultList(cmdResultList);
                            break block7;
                        }
                        this.logger.info((Object)("deploy filter isDeviceConnectedOK is" + this.isDeviceConnectedOK));
                        break;
                    }
                    catch (LegoCheckedException e) {
                        this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                        if (e.getErrorCode() != 630005L) {
                            this.isDeviceConnectedOK = false;
                        }
                        errorCode = "lego.err." + e.getErrorCode();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                        errorCode = "lego.err.631039";
                    }
                }
                this.checkFilterZoneResult(filterZoneData.getFilterInfo().getPkid(), zoneId, errorCode, false, filterZoneData.getDirection());
            }
        }
    }

    private String checkCmdResultList(List<String> cmdResultList) {
        if (null == cmdResultList) {
            return "";
        }
        int count = 0;
        Iterator<String> iterator = cmdResultList.iterator();
        while (iterator.hasNext()) {
            String resultStringTemp;
            String resultString = resultStringTemp = iterator.next();
            resultString = resultString.toLowerCase(Locale.ENGLISH);
            ++count;
            if ("".equals(resultString)) continue;
            for (Map.Entry<String, String> entry : this.errorMapping.entrySet()) {
                String key = entry.getKey().toLowerCase(Locale.ENGLISH);
                Pattern p = Pattern.compile(key);
                Matcher matcher = p.matcher(resultString);
                if (!matcher.find()) continue;
                if ("lego.err.631003".equals(entry.getValue()) && count == 3) {
                    Pattern p1 = Pattern.compile("-filter-");
                    Matcher matcher1 = p1.matcher(resultString);
                    if (matcher1.find()) continue;
                    return entry.getValue();
                }
                return entry.getValue();
            }
        }
        return "";
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void checkFilterResult(Long filterId, String errorCode, boolean isDeploy) {
        FilterDevicePair filterDevicePair = new FilterDevicePair(filterId, this.logicDev1.getDeviceId());
        if (isDeploy) {
            this.logger.info((Object)("deploy filter by deploy,  deviceId : " + this.logicDev1.getDeviceId() + ", filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode)));
            this.filterDeployResult.put(filterDevicePair, errorCode);
        } else {
            this.logger.info((Object)("undeploy filter by deploy,  deviceId : " + this.logicDev1.getDeviceId() + ", filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode)));
            if (this.logicDev1.getType() == 8 && 0L != this.logicDev1.getClusterId()) {
                filterDevicePair.setDeviceId(this.logicDev1.getClusterId());
            }
            this.filterUnDeployResult.put(filterDevicePair, errorCode);
        }
    }

    private void checkFilterZoneResult(Long filterId, Long zoneId, String errorCode, boolean isDeploy, int direction) {
        int gloApplyFlag;
        int n = gloApplyFlag = zoneId == 0L ? 1 : 0;
        if ("lego.err.631042".equals(errorCode) && gloApplyFlag == 1) {
            errorCode = "lego.err.631071";
        }
        FilterDeviceZonePair filterDeviceZonePair = new FilterDeviceZonePair(zoneId, filterId, this.logicDev1.getDeviceId(), direction, gloApplyFlag);
        if (isDeploy) {
            this.logger.info((Object)("deploy filterZone result by deploy,  zoneId : " + zoneId + ", deviceId : " + this.logicDev1.getDeviceId() + " filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode) + ", direction :" + direction));
            this.filterZoneDeployResult.put(filterDeviceZonePair, errorCode);
        } else {
            this.logger.info((Object)("undeploy filterZone result by deploy,  zoneId : " + zoneId + ", deviceId : " + this.logicDev1.getDeviceId() + " filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode)));
            this.filterZoneUnDeployResult.put(filterDeviceZonePair, errorCode);
        }
    }

    private Long getPreference(Long filterId, Long zoneId, int direction) {
        IFilterDeviceZoneInfoService service = (IFilterDeviceZoneInfoService)ServiceContext.getInstance().getService("filterDeviceZoneInfoService", IFilterDeviceZoneInfoService.class);
        return service.queryPreferenceByFilterIdAndZoneId(filterId, zoneId, direction);
    }

    public IZoneFeatureStatusService getZoneFeatureStatusService() {
        return this.zoneFeatureStatusService;
    }

    public void setZoneFeatureStatusService(IZoneFeatureStatusService zoneFeatureStatusService) {
        this.zoneFeatureStatusService = zoneFeatureStatusService;
    }

    public ILicenseOutboundService getLicenseOutboundService() {
        return this.licenseOutboundService;
    }

    public void setLicenseOutboundService(ILicenseOutboundService licenseOutboundService) {
        this.licenseOutboundService = licenseOutboundService;
    }
}

