/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.function.deploy;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.ErrorMsg2ResKey;
import com.hs.vsm.secservice.ddos.common.FilterDstIpPair;
import com.hs.vsm.secservice.ddos.model.HttpFilterInfo;
import com.hs.vsm.secservice.ddos.service.data.FilterToDeployData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterDstIpData;
import com.hs.vsm.secservice.ddos.service.function.deploy.FilterDstIpDeployInfo;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterDstIpDeployThread
implements Callable<String> {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private FilterDstIpDeployInfo filterDstIpDeployInfo;
    private LogicDev logicDev;
    private boolean isLock;
    private boolean isDeploy;
    private Map<String, String> errorMapping = ErrorMsg2ResKey.getInstance().getErrorMsgKeyMapping();

    public FilterDstIpDeployThread(LogicDev logicDev, FilterDstIpDeployInfo filterDstIpDeployInfo, boolean isDeploy) {
        this.logicDev = logicDev;
        this.filterDstIpDeployInfo = filterDstIpDeployInfo;
        this.isDeploy = isDeploy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() throws Exception {
        this.isLock = VsmUtil.getInstance().lock(this.logicDev.getDeviceId());
        try {
            this.logger.info((Object)("deploy filter dst-ip thread run." + this.filterDstIpDeployInfo.toString()));
            if (!this.isLock) {
                throw new LegoCheckedException(630007L);
            }
            FilterToDeployData filterToDeployData = this.filterDstIpDeployInfo.getFilterToDeployData();
            Map<Long, List<IFeature>> filterInfoToDeployData = filterToDeployData.getFilterInfoToDeployData();
            if (null != filterInfoToDeployData && !filterInfoToDeployData.isEmpty()) {
                List<IFeature> list = filterInfoToDeployData.get(this.logicDev.getDeviceId());
                for (IFeature iFeature : list) {
                    FilterDstIpData filterDstIpData = (FilterDstIpData)iFeature;
                    List cmdResultList = null;
                    cmdResultList = this.isDeploy ? (List)filterDstIpData.doDeploy(this.logicDev, null) : (List)filterDstIpData.doUndeploy(this.logicDev, null);
                    List<String> errorCode = this.checkCmdResultList(cmdResultList);
                    this.logger.info((Object)("errorCode : " + errorCode));
                    this.checkFilterResult(filterDstIpData, errorCode);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("wooo..." + e.getMessage()));
        }
        finally {
            if (this.isLock) {
                Locker.getInstance().unlock(this.logicDev.getDeviceId(), 1);
            }
        }
        return "success";
    }

    private void checkFilterResult(FilterDstIpData filterDstIpData, List<String> errorCode) {
        List<HttpFilterInfo> httpFilterInfos = filterDstIpData.getFilterPolicyInfoList();
        Long filterId = filterDstIpData.getFeatureId();
        FilterDstIpPair filterDstIpPair = new FilterDstIpPair(filterId, this.logicDev.getDeviceId(), httpFilterInfos);
        if (this.isDeploy) {
            this.filterDstIpDeployInfo.getFilterDstIpDeployResult().put(filterDstIpPair, errorCode);
        } else {
            this.filterDstIpDeployInfo.getFilterDstIpUnDeployResult().put(filterDstIpPair, errorCode);
        }
    }

    private List<String> checkCmdResultList(List<String> cmdResultList) {
        ArrayList<String> resultList = new ArrayList<String>();
        Iterator<String> iterator = cmdResultList.iterator();
        while (iterator.hasNext()) {
            String resultStringTemp;
            String resultString = resultStringTemp = iterator.next();
            resultString = resultString.toLowerCase(Locale.ENGLISH);
            boolean isFailed = false;
            if (!"".equals(resultString)) {
                for (Map.Entry<String, String> entry : this.errorMapping.entrySet()) {
                    String key = entry.getKey().toLowerCase(Locale.ENGLISH);
                    Pattern p = Pattern.compile(key);
                    Matcher matcher = p.matcher(resultString);
                    if (!matcher.find()) continue;
                    resultList.add(entry.getValue());
                    isFailed = true;
                    break;
                }
            }
            if (isFailed) continue;
            resultList.add("");
        }
        return resultList;
    }
}

