/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.function.deploy;

import com.hs.atic.util.AticUtil;
import com.hs.atic.util.ZonePairLocker;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.common.ErrorMsg2ResKey;
import com.hs.vsm.secservice.ddos.common.FeaturePair;
import com.hs.vsm.secservice.ddos.common.ServicePair;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.service.data.ZoneDeployResult;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneServiceToUndeploy;
import com.hs.vsm.secservice.sdk.common.util.DeployResultPair;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.AbstractFeature;
import com.hs.vsm.secservice.sdk.frame.model.CmdViewBean;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.common.ZonePair;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZoneDeployThread
extends Thread {
    private static final int RETRY_TIMES = 3;
    private static boolean bThreadrun = true;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private LogicDev logicDev;
    private Map<Long, List<IFeature>> features;
    private ProgressBar progressBar;
    private Boolean isDeviceConnectedOK = true;
    private ZoneDeployResult result;
    private Map<ServicePair, List<FeaturePair>> servicePairToFeaturePairMap;

    public ZoneDeployThread(LogicDev logicDev, Map<Long, List<IFeature>> features, ProgressBar progressBar, ZoneDeployResult result) {
        this.logger.info((Object)"enter ZoneDeployThread");
        this.logger.info((Object)("logicDev:" + logicDev));
        this.logger.info((Object)("features:" + features));
        this.logger.info((Object)("progressBar:" + progressBar.toString()));
        this.features = features;
        this.logicDev = logicDev;
        this.progressBar = progressBar;
        this.result = result;
        this.setPriority(10);
        this.logger.info((Object)"leave ZoneDeployThread");
    }

    public Map<ServicePair, List<FeaturePair>> getServicePairToFeaturePairMap() {
        return this.servicePairToFeaturePairMap;
    }

    public void setServicePairToFeaturePairMap(Map<ServicePair, List<FeaturePair>> servicePairToFeaturePairMap) {
        this.servicePairToFeaturePairMap = servicePairToFeaturePairMap;
    }

    public Boolean getIsDeviceConnectedOK() {
        return this.isDeviceConnectedOK;
    }

    public void setIsDeviceConnectedOK(Boolean isDeviceConnectedOK) {
        this.isDeviceConnectedOK = isDeviceConnectedOK;
    }

    public ZoneDeployResult getResult() {
        return this.result;
    }

    public void setResult(ZoneDeployResult result) {
        this.result = result;
    }

    public LogicDev getLogicDev() {
        return this.logicDev;
    }

    public void setLogicDev(LogicDev logicDev) {
        this.logicDev = logicDev;
    }

    public Map<Long, List<IFeature>> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<Long, List<IFeature>> features) {
        this.features = features;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public static boolean isbThreadrun() {
        return bThreadrun;
    }

    public static void setbThreadrun(boolean bThreadruns) {
        bThreadrun = bThreadruns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info((Object)"enter ZoneDeployThread run");
        this.logger.info((Object)("begin a thread deploy for progressbar:" + this.progressBar.toString()));
        int currentStep = 0;
        int totalStep = this.calcTotalStep();
        try {
            for (Map.Entry<Long, List<IFeature>> singleZonefeatures : this.features.entrySet()) {
                List<IFeature> zonefeatures = singleZonefeatures.getValue();
                currentStep += zonefeatures.size();
                DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo(this.logicDev.getDeviceId());
                AticDevice aticDevice = ZoneReferUtil.getFirewallService().getDeviceByMoid(this.logicDev.getDeviceId().longValue());
                if (aticDevice.getDeviceType() == 8 || aticDevice.getDeviceType() == 9) {
                    this.logicDev.setType(8);
                }
                Set supportAttr = DdosDevCapabilityServiceImpl.getInstance().getAllSupportedAttr(devTypeInfo);
                List<IFeature> sortZonefeatures = null;
                sortZonefeatures = supportAttr.contains("withServiceViewCustomService") ? this.sortFeatures(zonefeatures) : zonefeatures;
                this.deployZoneFeatures(singleZonefeatures.getKey(), sortZonefeatures);
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage());
        }
        finally {
            if (totalStep > currentStep) {
                this.progressBar.next(totalStep - currentStep);
            }
        }
        this.logger.info((Object)("end a thread deploy for progressbar:" + this.progressBar.toString()));
        this.logger.info((Object)"leave ZoneDeployThread run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployZoneFeatures(Long zoneId, List<IFeature> zonefeatures) {
        this.logger.info((Object)("enter deployZoneFeatures progressId:" + this.progressBar.getProgressBarID()));
        int totalStep = zonefeatures.size();
        int currentStep = 0;
        ZonePair zonePair = new ZonePair(this.logicDev.getDeviceId(), zoneId);
        Boolean isZoneDeployOK = true;
        Boolean isTaskCancled = false;
        String errorMsgKey = "--";
        DeployResultPair deployResult = new DeployResultPair();
        deployResult.setErrorMsgKey(errorMsgKey);
        ServicePair servicePair = new ServicePair();
        FeaturePair featurePair = null;
        try {
            ZonePairLocker.getInstance().lock(zonePair);
            for (IFeature feature : zonefeatures) {
                featurePair = new FeaturePair(zoneId, this.logicDev.getDeviceId(), feature.getFeatureType(), feature.getFeatureId());
                if (this.progressBar.isCancled()) {
                    isZoneDeployOK = false;
                    isTaskCancled = true;
                    this.progressBar.next();
                    this.logger.info((Object)("progress id in canceled branch:" + this.progressBar.getProgressBarID() + ":info:" + this.progressBar.toString()));
                    ++currentStep;
                    this.result.addZoneFeatureResult(featurePair, false);
                    continue;
                }
                if (!this.getIsDeviceConnectedOK().booleanValue()) {
                    this.logger.info((Object)"isDeviceConnectedOK is false");
                    isZoneDeployOK = false;
                    this.progressBar.next();
                    ++currentStep;
                    errorMsgKey = "lego.err.630005";
                    deployResult.setErrorMsgKey(errorMsgKey);
                    break;
                }
                this.dealServiceIdAndZoneIdConflict(zoneId, deployResult, servicePair, feature);
                this.progressBar.next();
                this.logger.info((Object)("progress id:" + this.progressBar.getProgressBarID() + ":info:" + this.progressBar.toString()));
                ++currentStep;
                this.result.addZoneFeatureResult(featurePair, deployResult.getIsFeatureDeployOk());
                if (deployResult.getIsFeatureDeployOk().booleanValue()) continue;
                isZoneDeployOK = false;
            }
            this.result.addZoneDeviceResult(zonePair, isZoneDeployOK);
            if (isTaskCancled.booleanValue() && !isZoneDeployOK.booleanValue()) {
                errorMsgKey = "lego.err.630008";
            }
            if (!isTaskCancled.booleanValue() && !isZoneDeployOK.booleanValue()) {
                errorMsgKey = deployResult.getErrorMsgKey();
            }
            this.result.addErrorDetail(zonePair, errorMsgKey);
            this.result.addErrorParam(zonePair, deployResult.getErrorParam());
        }
        catch (LegoCheckedException legoException) {
            this.logger.error((Object)("legoException:" + legoException.getMessage()));
            this.result.addZoneFeatureResult(featurePair, false);
            this.setIsDeviceConnectedOK(false);
            errorMsgKey = "lego.err." + legoException.getErrorCode();
            this.result.addZoneDeviceResult(zonePair, false);
        }
        catch (Exception e) {
            this.logger.error((Object)("unexpected exception: " + e.getMessage()));
            this.result.addZoneFeatureResult(featurePair, false);
            this.setIsDeviceConnectedOK(false);
            this.result.addZoneDeviceResult(zonePair, false);
        }
        finally {
            ZonePairLocker.getInstance().releaseLock(zonePair);
            this.result.addErrorDetail(zonePair, errorMsgKey);
            this.logger.info((Object)("in finally of deployZoneFeatures,totalStep : " + totalStep + "currentStep : " + currentStep));
            if (totalStep > currentStep) {
                this.progressBar.next(totalStep - currentStep);
                this.logger.info((Object)("progress id in finally:" + this.progressBar.getProgressBarID() + ":info:" + this.progressBar.toString()));
            }
        }
        this.logger.info((Object)("leave deployZoneFeatures,progressId:" + this.progressBar.getProgressBarID()));
    }

    private void dealServiceIdAndZoneIdConflict(Long zoneId, DeployResultPair deployResult, ServicePair servicePair, IFeature feature) {
        Map<String, String> errorMapping = ErrorMsg2ResKey.getInstance().getErrorMsgKeyMapping();
        List<String> cmdResult = new ArrayList<String>();
        if (!deployResult.getZoneIdConflictFlag().booleanValue()) {
            FeaturePair curFeature;
            Map<ServicePair, List<FeaturePair>> servicePairToFeaturePairMaps;
            Object featurePairList;
            boolean canDeploy = true;
            if (deployResult.getServiceIdConflictFlag().booleanValue() && (featurePairList = (servicePairToFeaturePairMaps = this.getServicePairToFeaturePairMap()).get(servicePair)).contains(curFeature = new FeaturePair(zoneId, this.logicDev.getDeviceId(), feature.getFeatureType(), feature.getFeatureId()))) {
                canDeploy = false;
            }
            int deployTimes = 0;
            block4: while (canDeploy) {
                this.logger.info((Object)("DeployTimes = " + ++deployTimes));
                canDeploy = false;
                try {
                    cmdResult = (List)feature.doDeploy(this.logicDev, this.result);
                    for (String results : cmdResult) {
                        if (AticUtil.judgmentEcho((String)results)) {
                            this.logger.error((Object)("Failed to deploy because 'The system is busy.', Failed result : " + results));
                            throw new LegoCheckedException(571217L);
                        }
                        if (!results.toLowerCase(Locale.getDefault()).contains("Please specify zone ID first".toLowerCase(Locale.getDefault()))) continue;
                        if (3 <= deployTimes) {
                            this.logger.error((Object)("Failed to deploy because 'Error: Please specify Zone ID first .', Failed times = " + deployTimes));
                            canDeploy = false;
                            continue block4;
                        }
                        canDeploy = true;
                        List<CmdViewBean> cmdViewBeanList = ((AbstractFeature)feature).getCmdViewList();
                        String zoneName = "";
                        for (CmdViewBean cmdViewBean : cmdViewBeanList) {
                            if (!"zone".equalsIgnoreCase(cmdViewBean.getViewName())) continue;
                            zoneName = cmdViewBean.getViewParams().get("zoneName");
                            break;
                        }
                        ArrayList<String> cmdList = new ArrayList<String>();
                        cmdList.add("System");
                        cmdList.add("ddos-Zone name " + zoneName);
                        cmdList.add("Zone-id " + zoneId);
                        cmdList.add("q");
                        CmdUtil.execCmds(this.logicDev.getDeviceId(), cmdList);
                        continue block4;
                    }
                }
                catch (LegoCheckedException e) {
                    if (e.getErrorCode() == 630005L && deployTimes < 3) {
                        canDeploy = true;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e1) {
                            this.logger.error((Object)("Failed to deploy and need retry, Failed times = " + deployTimes));
                        }
                        this.logger.info((Object)("Failed to deploy and need retry, Failed times = " + deployTimes));
                        continue;
                    }
                    this.logger.info((Object)("Failed to deploy, Failed times = " + deployTimes));
                    throw e;
                }
            }
        }
        if (this.zoneIdConflict(cmdResult)) {
            deployResult.setZoneIdConflictFlag(true);
        }
        if (this.serviceIdConflict(cmdResult)) {
            servicePair.setZoneId(zoneId);
            servicePair.setDeviceId(this.logicDev.getDeviceId());
            servicePair.setServiceId(feature.getFeatureId());
            deployResult.setServiceIdConflictFlag(true);
        }
        if (!deployResult.getZoneIdConflictFlag().booleanValue()) {
            if (deployResult.getServiceIdConflictFlag().booleanValue()) {
                FeaturePair curFeature;
                Map<ServicePair, List<FeaturePair>> servicePairToFeaturePairMaps = this.getServicePairToFeaturePairMap();
                List<FeaturePair> featurePairList = servicePairToFeaturePairMaps.get(servicePair);
                if (featurePairList.contains(curFeature = new FeaturePair(zoneId, this.logicDev.getDeviceId(), feature.getFeatureType(), feature.getFeatureId()))) {
                    deployResult.setIsFeatureDeployOk(false);
                    deployResult.setErrorMsgKey("lego.err.630024");
                } else {
                    VsmUtil.getInstance().checkCmdResult(feature.getCmds(), cmdResult, errorMapping, deployResult);
                }
            } else {
                VsmUtil.getInstance().checkCmdResult(feature.getCmds(), cmdResult, errorMapping, deployResult);
            }
        } else {
            deployResult.setIsFeatureDeployOk(false);
            deployResult.setErrorMsgKey("lego.err.630014");
        }
    }

    private boolean serviceIdConflict(List<String> cmdResult) {
        Pattern pattern = Pattern.compile("Service\\s+ID\\s+conflict");
        Matcher matcher = pattern.matcher(cmdResult.toString());
        return matcher.find();
    }

    private boolean zoneIdConflict(List<String> cmdResult) {
        Pattern pattern = Pattern.compile("Zone\\s*ID\\s*conflict");
        Matcher matcher = pattern.matcher(cmdResult.toString());
        return matcher.find();
    }

    private int calcTotalStep() {
        this.logger.info((Object)"enter calcTotalStep");
        int totalStep = 0;
        for (Map.Entry<Long, List<IFeature>> feature : this.features.entrySet()) {
            totalStep += feature.getValue().size();
        }
        this.logger.info((Object)"leave calcTotalStep");
        return totalStep;
    }

    private List<IFeature> sortFeatures(List<IFeature> datas) {
        ArrayList<IFeature> results = new ArrayList<IFeature>();
        ArrayList<IFeature> udpresult = new ArrayList<IFeature>();
        ArrayList<IFeature> undoTcpresult = new ArrayList<IFeature>();
        ArrayList<IFeature> tempresult = new ArrayList<IFeature>();
        for (int i = 0; i < datas.size(); ++i) {
            if (datas.get(i).getFeatureType().indexOf("ZoneServiceToUndeploy") > -1) {
                ZoneServiceForm zoneServiceForm = (ZoneServiceForm)((ZoneServiceToUndeploy)datas.get(i)).getConfigData();
                if ("TCP".equals(zoneServiceForm.getProtocol()) || "HTTP".equals(zoneServiceForm.getProtocol()) || "HTTPS".equals(zoneServiceForm.getProtocol())) {
                    undoTcpresult.add(datas.get(i));
                    continue;
                }
                tempresult.add(datas.get(i));
                continue;
            }
            if (datas.get(i).getFeatureType().toLowerCase(Locale.getDefault()).indexOf("udp") > -1) {
                udpresult.add(datas.get(i));
                continue;
            }
            tempresult.add(datas.get(i));
        }
        results.addAll(tempresult);
        results.addAll(udpresult);
        results.addAll(undoTcpresult);
        return results;
    }
}

