/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.function.undeploy;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.ErrorMsg2ResKey;
import com.hs.vsm.secservice.ddos.common.FilterDevicePair;
import com.hs.vsm.secservice.ddos.common.FilterDeviceZonePair;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.service.data.FilterToUnDeployData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterData;
import com.hs.vsm.secservice.ddos.service.data.feature.FilterZoneData;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterUnDeployThread
extends Thread {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private LogicDev logicDev;
    private boolean isLockOK = false;
    private FilterToUnDeployData filterToUnDeployData;
    private Map<FilterDevicePair, String> filterUnDeployResult;
    private Map<FilterDeviceZonePair, String> filterZoneUnDeployResult;
    private Boolean isDeviceConnectedOK = true;
    private Map<String, String> errorMapping = ErrorMsg2ResKey.getInstance().getErrorMsgKeyMapping();

    public FilterUnDeployThread(LogicDev logicDev, FilterToUnDeployData filterToUnDeployData, Map<FilterDevicePair, String> filterUnDeployResult, Map<FilterDeviceZonePair, String> filterZoneUnDeployResult) {
        this.logicDev = logicDev;
        this.filterToUnDeployData = filterToUnDeployData;
        this.filterUnDeployResult = filterUnDeployResult;
        this.filterZoneUnDeployResult = filterZoneUnDeployResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isLockOK = VsmUtil.getInstance().lock(this.logicDev.getDeviceId());
        try {
            IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
            AticDevice aticDevice = aticDeviceService.getDeviceByMoid(this.logicDev.getDeviceId().longValue());
            if (null != aticDevice && aticDevice.getDeviceType() == 9) {
                IClusterService clusterService = ZoneReferUtil.getClusterService();
                List bindNfaDevice = clusterService.getBindNfaDevice(Long.valueOf(aticDevice.getMoId()));
                for (AticDeviceNfaCluster aticDeviceNfaCluster : bindNfaDevice) {
                    this.logicDev = new LogicDev(aticDeviceNfaCluster.getDeviceId(), 1, "--");
                    this.logicDev.setType(8);
                    this.unDeployFilterZoneFromDevice();
                    this.unDeployFilterFromDevice();
                }
            } else {
                this.unDeployFilterZoneFromDevice();
                this.unDeployFilterFromDevice();
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("undeploy filter thread error, device id : " + this.logicDev.getDeviceId()));
        }
        finally {
            if (this.isLockOK) {
                Locker.getInstance().unlock(this.logicDev.getDeviceId(), 1);
            }
        }
    }

    private void unDeployFilterFromDevice() {
        List<IFeature> unDeployFilterData = this.filterToUnDeployData.getFilterInfoToUnDeployData().get(this.logicDev.getDeviceId());
        if (unDeployFilterData != null && !unDeployFilterData.isEmpty()) {
            for (IFeature feature : unDeployFilterData) {
                String errorCode = "";
                FilterData filterData = (FilterData)feature;
                this.logger.info((Object)("pre undeploy filter by undeploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterData.getFilterInfo().getPkid()));
                try {
                    errorCode = this.getZoneDeployFromFilterErr(filterData.getFilterInfo().getPkid());
                    if ("".equals(errorCode) && this.isLockOK && this.isDeviceConnectedOK.booleanValue()) {
                        filterData.doUndeploy(this.logicDev, null);
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                    if (e.getErrorCode() != 630005L) {
                        this.isDeviceConnectedOK = false;
                    }
                    errorCode = "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                    errorCode = "lego.err.631039";
                }
                this.checkFilterResult(filterData.getFeatureId(), errorCode);
            }
        }
    }

    private String getZoneDeployFromFilterErr(Long filterId) {
        for (Map.Entry<FilterDeviceZonePair, String> deployResult : this.filterZoneUnDeployResult.entrySet()) {
            if (!deployResult.getKey().getFilterId().equals(filterId) || !deployResult.getKey().getDeviceId().equals(this.logicDev.getDeviceId()) || deployResult.getValue() == null || "".equals(deployResult.getValue())) continue;
            return deployResult.getValue();
        }
        return "";
    }

    private void unDeployFilterZoneFromDevice() {
        List<IFeature> unDeployFilterDataZonesData = this.filterToUnDeployData.getFilterZonesToUnDeployData().get(this.logicDev.getDeviceId());
        if (unDeployFilterDataZonesData != null && !unDeployFilterDataZonesData.isEmpty()) {
            for (IFeature feature : unDeployFilterDataZonesData) {
                String errorCode = "";
                FilterZoneData filterZoneData = (FilterZoneData)feature;
                this.logger.info((Object)("pre undeploy filterZone by undeploy,  deviceId : " + this.logicDev.getDeviceId() + "zoneId : " + filterZoneData.getZoneInfoForm().getZoneId() + ", filterId : " + filterZoneData.getFilterInfo().getPkid()));
                try {
                    if (!this.isLockOK) {
                        errorCode = "lego.err.630007";
                    } else if (this.isDeviceConnectedOK.booleanValue()) {
                        List cmdResultList = (List)filterZoneData.doUndeploy(this.logicDev, null);
                        errorCode = this.checkCmdResultList(cmdResultList);
                    } else {
                        errorCode = "lego.err.631039";
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                    if (e.getErrorCode() != 630005L) {
                        this.isDeviceConnectedOK = false;
                    }
                    errorCode = "lego.err." + e.getErrorCode();
                }
                catch (Exception e) {
                    this.logger.error((Object)("deploy filter by deploy error, " + e.getMessage()));
                    errorCode = "lego.err.631039";
                }
                this.checkFilterZoneResult(filterZoneData.getFilterInfo().getPkid(), filterZoneData.getZoneInfoForm().getZoneId(), errorCode, filterZoneData.getDirection());
            }
        }
    }

    private String checkCmdResultList(List<String> cmdResultList) {
        Iterator<String> iterator = cmdResultList.iterator();
        while (iterator.hasNext()) {
            String resultStringTemp;
            String resultString = resultStringTemp = iterator.next();
            if ("".equals(resultString = resultString.toLowerCase(Locale.ENGLISH))) continue;
            for (Map.Entry<String, String> entry : this.errorMapping.entrySet()) {
                String key = entry.getKey().toLowerCase(Locale.ENGLISH);
                Pattern p = Pattern.compile(key);
                Matcher matcher = p.matcher(resultString);
                if (!matcher.find()) continue;
                return entry.getValue();
            }
        }
        return "";
    }

    private void checkFilterResult(Long filterId, String errorCode) {
        FilterDevicePair filterDevicePair = new FilterDevicePair(filterId, this.logicDev.getDeviceId());
        this.filterUnDeployResult.put(filterDevicePair, errorCode);
        this.logger.info((Object)("deploy filter by undeploy,  deviceId : " + this.logicDev.getDeviceId() + ", filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode)));
    }

    private void checkFilterZoneResult(Long filterId, Long zoneId, String errorCode, int direction) {
        FilterDeviceZonePair filterDeviceZonePair = new FilterDeviceZonePair(zoneId, filterId, this.logicDev.getDeviceId(), direction);
        this.filterZoneUnDeployResult.put(filterDeviceZonePair, errorCode);
        this.logger.info((Object)("deploy filterZone result by undeploy,  zoneId : " + zoneId + ", deviceId : " + this.logicDev.getDeviceId() + " filterId : " + filterId + ", errorcode : " + this.getcleanedMessage(errorCode)));
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }
}

