/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.function.undeploy;

import com.hs.atic.sdk.bis.service.IBaseLineService;
import com.hs.atic.sdk.bis.service.IFoundDefaultIdService;
import com.hs.atic.sdk.util.ZonePairCopy;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.zone.dao.ZoneIpStatusDao;
import com.hs.atic.zone.dao.ZoneListIpDao;
import com.hs.atic.zone.dao.ZoneListPortMapDao;
import com.hs.atic.zone.dao.ZoneListPortMapStateDao;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.FeaturePair;
import com.hs.vsm.secservice.ddos.common.ServicePair;
import com.hs.vsm.secservice.ddos.dao.BlackWhiteStatusDao;
import com.hs.vsm.secservice.ddos.dao.FilterDeviceZoneStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneServiceStatusDao;
import com.hs.vsm.secservice.ddos.model.BlackWhiteStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneServiceStatusInfo;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.service.data.ConfigDataTools;
import com.hs.vsm.secservice.ddos.service.data.ZoneConfigData;
import com.hs.vsm.secservice.ddos.service.data.ZoneToUndeployData;
import com.hs.vsm.secservice.ddos.service.data.feature.ZoneDefineInfo;
import com.hs.vsm.secservice.ddos.service.function.Util;
import com.hs.vsm.secservice.ddos.service.function.undeploy.FilterUnDeployCtrl;
import com.hs.vsm.secservice.ddos.service.function.undeploy.ZoneUndeployData;
import com.hs.vsm.secservice.ddos.service.function.undeploy.ZoneUndeployThread;
import com.hs.vsm.secservice.sdk.common.util.CrcUtil;
import com.hs.vsm.secservice.sdk.common.util.Pair;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.ProgressMgr;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.common.ZonePair;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IServiceLearningParamService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyServiceSimple;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.policy.third.service.IPacketTaskService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ZoneUndeployCtrl {
    private static final int SLLEEP_TIME = 1000;
    private static final int LOOP_COUNT = 100;
    private static IBaseLineService baseLineService;
    IServiceLearningParamService serviceLearningParamService;
    private ConfigDataTools configDataTools;
    private IZonePolicyApplyServiceSimple zonePolicyService;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private ZoneServiceStatusDao zoneServiceStatusDao;
    private IAticDeviceService aticDeviceService;
    private IFoundDefaultIdService foundDefaultIdService;
    private ICommonUtilService commonUtilService;
    private IZoneService userService;
    private IFilterDeviceZoneInfoService filterZoneService;
    private FilterUnDeployCtrl filterUnDeployCtrl;
    private IZoneService zoneService;
    private FilterDeviceZoneStatusDao filterDeviceZoneStatusDao;
    private ZoneListIpDao zoneListIpDao;
    private ZoneIpStatusDao zoneIpStatusDao;
    private ZoneListPortMapDao zoneListPortMapDao;
    private ZoneListPortMapStateDao zonePortMapStatusDao;
    private BlackWhiteStatusDao blackWhiteStatusDao;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public Map<Long, String> doUnDeploy(Long zoneId, List<Long> devices, Boolean hasNewRelDevices) {
        this.logger.info((Object)"enter doUndeploy");
        ZoneUndeployData deployData = new ZoneUndeployData();
        Long progressBarId = 54321L;
        ProgressBar progressBar = ProgressMgr.getInstance().createProgressBar(100, progressBarId);
        deployData.setProgressBar(progressBar);
        deployData.setProgressBarId(progressBarId);
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        zoneIdList.add(zoneId);
        deployData.setZoneIdList(zoneIdList);
        this.logger.info((Object)("params zoneIdList:" + zoneIdList));
        this.logger.info((Object)("params progressBarId:" + progressBarId));
        ZoneConfigData zoneConfigData = this.configDataTools.initUndeployData(zoneId, devices, deployData.getProgressBar());
        deployData.setZoneConfigData(zoneConfigData);
        ZoneToUndeployData toUndeploy = new ZoneToUndeployData();
        toUndeploy.initToUndeployData(zoneConfigData);
        Map<LogicDev, List<IFeature>> toUndeployData = toUndeploy.getToUndeployData();
        deployData.setToUndeployData(toUndeployData);
        IPacketTaskService packetTaskService = this.getPacketTaskService();
        int totalStep = this.calcTotalSteps(deployData.getToUndeployData());
        this.logger.info((Object)("totalStep:" + totalStep));
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        deployData.setThreadPool(threadPool);
        if (null != deployData.getProgressBar()) {
            deployData.getProgressBar().setTotalStep(totalStep + 5);
        }
        for (Map.Entry<LogicDev, List<IFeature>> entry : deployData.getToUndeployData().entrySet()) {
            ZoneUndeployThread zoneUndeployThread = new ZoneUndeployThread(entry.getKey(), entry.getValue(), progressBar, deployData.getResult());
            zoneUndeployThread.setPacketTaskService(packetTaskService);
            zoneUndeployThread.setUndoZoneDeviceRel(true);
            deployData.getThreadPool().submit(zoneUndeployThread);
        }
        deployData.getThreadPool().shutdown();
        try {
            if (deployData.getThreadPool().awaitTermination(30L, TimeUnit.MINUTES)) {
                this.logger.info((Object)"zone undeploy thread execute finished.");
            }
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)("zone undeploy thread execute timeout." + e1.getMessage()));
        }
        HashMap<Long, String> resultMap = new HashMap<Long, String>();
        for (Map.Entry<Long, List<Long>> entry : deployData.getZoneConfigData().getZoneID2DeviceIdsMap().entrySet()) {
            Set<Long> deviceIds = new HashSet<Long>();
            int zoneUndeployOkDevice = 0;
            for (Long deviceId : entry.getValue()) {
                ZonePair pair = new ZonePair(deviceId, zoneId);
                if (deployData.getResult().getZoneDeviceUndeployResult().containsKey(pair) && deployData.getResult().getZoneDeviceUndeployResult().get(pair).booleanValue()) {
                    deviceIds.add(deviceId);
                    ++zoneUndeployOkDevice;
                    resultMap.put(pair.getDeviceId(), "UNDEPLOY");
                    continue;
                }
                resultMap.put(pair.getDeviceId(), "PART_SUCCESS");
            }
            if (zoneUndeployOkDevice == entry.getValue().size()) {
                if (0 == this.zoneAssociatedDevicesNum(zoneId, devices)) {
                    this.getBaseLineService().stopBaseLineTaskByZoneId(zoneId);
                    this.serviceLearningParamService.stopServiceLearningTask(zoneId);
                } else {
                    List<ZoneDeviceForm> zoneAssociatedDeviceForms = this.zoneAssociatedDevices(zoneId);
                    deviceIds = this.changeListToSet(entry.getValue());
                    this.serviceLearningParamService.stopServiceLearnintTaskByDevice(zoneId, deviceIds);
                    this.dealServAndBaseLineRemainDev(zoneAssociatedDeviceForms, deviceIds, zoneId);
                }
                this.setZoneDeployStatus(zoneId, entry.getValue(), deployData);
                continue;
            }
            this.serviceLearningParamService.stopServiceLearnintTaskByDevice(zoneId, deviceIds);
            this.setZoneDeployStatus(zoneId, entry.getValue(), deployData);
        }
        this.logger.info((Object)"enter saveDeployStatus");
        this.saveZonePolicyStatus(deployData);
        Util.getInstance().processNext(deployData);
        this.saveServiceStatus(deployData, true);
        Util.getInstance().processNext(deployData);
        this.saveZoneDeviceStatus(deployData, resultMap);
        Util.getInstance().processNext(deployData);
        this.saveZoneFeatureStatus(deployData, zoneId, devices);
        Util.getInstance().processNext(deployData);
        this.logger.info((Object)"leave saveDeployStatus");
        this.logger.info((Object)"enter doUndeploy");
        this.notifyRefeshDefaultZoneData(deployData);
        try {
            this.unDeployFilter(deployData, devices, true);
        }
        catch (Exception exception) {
            ProgressBar progressBar2 = deployData.getProgressBar();
            if (null != progressBar2 && progressBar2.getTotalStep() > progressBar2.getCurrentStep()) {
                progressBar2.next(progressBar2.getTotalStep() - progressBar2.getCurrentStep());
            }
            this.logger.error((Object)("deploy filter exception!" + exception.getMessage()));
        }
        return resultMap;
    }

    private void dealServAndBaseLineRemainDev(List<ZoneDeviceForm> zoneAssociatedDeviceForms, Set<Long> deviceIds, Long zoneId) {
        ArrayList<Long> deviceIdsAssociatedAll = new ArrayList<Long>();
        ArrayList<Long> deviceIdsAssociatedRemain = new ArrayList<Long>();
        Boolean supportServiceLearn = false;
        for (ZoneDeviceForm zoneDeviceForm : zoneAssociatedDeviceForms) {
            deviceIdsAssociatedAll.add(zoneDeviceForm.getDeviceId());
        }
        for (Long deviceIdInAll : deviceIdsAssociatedAll) {
            if (deviceIds.contains(deviceIdInAll)) continue;
            deviceIdsAssociatedRemain.add(deviceIdInAll);
        }
        for (Long deviceId : deviceIdsAssociatedRemain) {
            Boolean temp;
            AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
            if (null == device || !(temp = Boolean.valueOf(this.getCommonUtilService().isSupportSrvLearning(device.getIpAddress()))).booleanValue()) continue;
            supportServiceLearn = temp;
        }
        if (!supportServiceLearn.booleanValue()) {
            this.serviceLearningParamService.stopServiceLearningTask(zoneId);
        }
    }

    private void setZoneDeployStatus(Long zoneId, List<Long> deviceIds, ZoneUndeployData deployData) {
        List<ZoneDeviceForm> zoneDeviceForms = ((ZonePolicyApplyForm)this.zonePolicyService.query(zoneId)).getZoneDeviceForms();
        int deployOkDevice = 0;
        int remainAssociatedDevices = this.zoneAssociatedDevicesNum(zoneId, deviceIds);
        this.specialProcess(remainAssociatedDevices, deployData, zoneId);
        Boolean hasFailed = false;
        Boolean hasChanged = false;
        int undeployDevice = 0;
        for (ZoneDeviceForm deviceForm : zoneDeviceForms) {
            if (deviceIds.contains(deviceForm.getDeviceId())) continue;
            HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
            int index = 0;
            condition.put(index++, zoneId);
            condition.put(index++, deviceForm.getDeviceId());
            List zoneDeviceDeployStatusInfos = this.zoneDeviceDeployStatusDao.queryByHql(" from ZoneDeviceDeployStatusInfo where zoneId = ?0  and deviceId = ?1 ", condition);
            if (null != zoneDeviceDeployStatusInfos && !zoneDeviceDeployStatusInfos.isEmpty()) {
                if (((ZoneDeviceDeployStatusInfo)zoneDeviceDeployStatusInfos.get(0)).getDeployState().booleanValue() && !((ZoneDeviceDeployStatusInfo)zoneDeviceDeployStatusInfos.get(0)).getHasChange().booleanValue()) {
                    ++deployOkDevice;
                    continue;
                }
                if (!((ZoneDeviceDeployStatusInfo)zoneDeviceDeployStatusInfos.get(0)).getDeployState().booleanValue() && !((ZoneDeviceDeployStatusInfo)zoneDeviceDeployStatusInfos.get(0)).getHasChange().booleanValue()) {
                    hasFailed = true;
                    continue;
                }
                if (!((ZoneDeviceDeployStatusInfo)zoneDeviceDeployStatusInfos.get(0)).getHasChange().booleanValue()) continue;
                hasChanged = true;
                continue;
            }
            ++undeployDevice;
        }
        if (deployOkDevice == remainAssociatedDevices) {
            deployData.getResult().getZonePolicyUndeployResult().put(zoneId, "SUCCESS");
        } else if (undeployDevice == remainAssociatedDevices) {
            deployData.getResult().getZonePolicyUndeployResult().put(zoneId, "UNDEPLOY");
        } else if (hasFailed.booleanValue() && !hasChanged.booleanValue()) {
            deployData.getResult().getZonePolicyUndeployResult().put(zoneId, "PART_SUCCESS");
        } else {
            deployData.getResult().getZonePolicyUndeployResult().put(zoneId, "INCREAMENT_UNDEPLOY");
        }
    }

    private void specialProcess(int remainAssociatedDevices, ZoneUndeployData deployData, Long zoneId) {
        if (0 == remainAssociatedDevices) {
            deployData.getResult().getZonePolicyUndeployResult().put(zoneId, "UNDEPLOY");
            return;
        }
    }

    private Set<Long> changeListToSet(List<Long> value) {
        HashSet<Long> deviceIds = new HashSet<Long>();
        if (null != value && !value.isEmpty()) {
            for (Long deviceId : value) {
                deviceIds.add(deviceId);
            }
        }
        return deviceIds;
    }

    private int zoneAssociatedDevicesNum(Long zoneId, List<Long> delDeviceIds) {
        List<ZoneDeviceForm> zoneDeviceList = this.zoneAssociatedDevices(zoneId);
        if (null == delDeviceIds || delDeviceIds.isEmpty()) {
            return zoneDeviceList.size();
        }
        int num = 0;
        for (ZoneDeviceForm zoneDevice : zoneDeviceList) {
            if (delDeviceIds.contains(zoneDevice.getDeviceId())) continue;
            ++num;
        }
        return num;
    }

    private List<ZoneDeviceForm> zoneAssociatedDevices(Long zoneId) {
        ZonePolicyApplyForm zoneBasiPolicy = (ZonePolicyApplyForm)this.zonePolicyService.query(zoneId);
        List<Object> zoneDevices = new ArrayList<ZoneDeviceForm>();
        if (null != zoneBasiPolicy && null == (zoneDevices = zoneBasiPolicy.getZoneDeviceForms())) {
            zoneDevices = new ArrayList();
        }
        return zoneDevices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUndeploy(List<Long> zoneIdList, Long progressBarId, Long adminId) {
        this.logger.info((Object)"enter doUndeploy");
        ZoneUndeployData deployData = new ZoneUndeployData();
        ProgressBar progressBar = ProgressMgr.getInstance().createProgressBar(100, progressBarId);
        deployData.setProgressBar(progressBar);
        deployData.setProgressBarId(progressBarId);
        deployData.setZoneIdList(zoneIdList);
        this.logger.info((Object)("params zoneIdList:" + zoneIdList));
        this.logger.info((Object)("params progressBarId:" + progressBarId));
        this.logger.info((Object)"undeployAllZone : doUndeploy initdata start ----------------------------------------------!");
        this.initData(deployData);
        this.logger.info((Object)"undeployAllZone : doUndeploy initdata end ----------------------------------------------!");
        Boolean isLockZoneOK = false;
        Boolean isLockAdminPairsOk = false;
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        try {
            IPacketTaskService packetTaskService = this.getPacketTaskService();
            if (packetTaskService != null) {
                ArrayList<ZonePair> zonePairListHasEnableCaptureTasks = new ArrayList<ZonePair>();
                this.getZonePairListHasEnableCaptureTasks(zonePairListHasEnableCaptureTasks, zoneIdList, packetTaskService);
                this.getToUndeployAdminPairs(pairs, deployData);
                isLockAdminPairsOk = VsmUtil.getInstance().lockAdminPairs(adminId, pairs);
                isLockZoneOK = VsmUtil.getInstance().lockZones(zoneIdList, "deployOrUndeploy");
                for (Map.Entry<LogicDev, List<IFeature>> deviceData : deployData.getToUndeployData().entrySet()) {
                    ZoneUndeployThread task = new ZoneUndeployThread(deviceData.getKey(), deviceData.getValue(), progressBar, deployData.getResult());
                    task.setZonePairListHasEnableCaptureTasks(zonePairListHasEnableCaptureTasks);
                    task.setPacketTaskService(packetTaskService);
                    deployData.getThreadPool().submit(task);
                }
            }
            deployData.getThreadPool().shutdown();
            try {
                if (deployData.getThreadPool().awaitTermination(400L, TimeUnit.MINUTES)) {
                    this.logger.info((Object)"zone undeploy thread execute finished.");
                }
            }
            catch (InterruptedException e1) {
                this.logger.error((Object)("zone undeploy thread execute timeout." + e1.getMessage()));
            }
            try {
                this.unDeployFilter(deployData, null, false);
            }
            catch (Exception e) {
                ProgressBar pbr = deployData.getProgressBar();
                if (pbr.getTotalStep() > pbr.getCurrentStep()) {
                    pbr.next(pbr.getTotalStep() - pbr.getCurrentStep());
                }
                this.logger.error((Object)("unDeployFilter exception!" + e.getMessage()));
            }
            this.updateUndeployStatus(deployData);
            this.notifyRefeshDefaultZoneData(deployData);
        }
        finally {
            int currentStep;
            int totalStep;
            if (isLockZoneOK.booleanValue()) {
                VsmUtil.getInstance().unlockZones(zoneIdList);
            }
            if (isLockAdminPairsOk.booleanValue()) {
                VsmUtil.getInstance().unLockAdminPairs(adminId, pairs);
            }
            if (null != deployData.getProgressBar() && (totalStep = deployData.getProgressBar().getTotalStep()) > (currentStep = deployData.getProgressBar().getCurrentStep())) {
                progressBar.next(totalStep - currentStep);
            }
        }
        this.logger.info((Object)"enter doUndeploy");
    }

    private void getZonePairListHasEnableCaptureTasks(List<ZonePair> zonePairListHasEnableCaptureTasks, List<Long> zoneIdList, IPacketTaskService packetTaskService) {
        List<ZonePairCopy> zonePairListHasEnableCaptureTasksCopy = null;
        try {
            zonePairListHasEnableCaptureTasksCopy = packetTaskService.getStartPacketTaskList(zoneIdList);
        }
        catch (Exception e) {
            this.logger.error((Object)("call getStartPacketTaskList Exception. " + e.getMessage()));
        }
        if (null != zonePairListHasEnableCaptureTasksCopy && !zonePairListHasEnableCaptureTasksCopy.isEmpty()) {
            for (ZonePairCopy zonePairCopy : zonePairListHasEnableCaptureTasksCopy) {
                ZonePair zonePair = new ZonePair();
                VsmUtil.getInstance().copyProperties(zonePairCopy, zonePair);
                zonePairListHasEnableCaptureTasks.add(zonePair);
            }
        }
    }

    private void getToUndeployAdminPairs(List<Pair> pairs, ZoneUndeployData deployData) {
        for (Map.Entry<LogicDev, List<IFeature>> deviceData : deployData.getToUndeployData().entrySet()) {
            for (IFeature zoneData : deviceData.getValue()) {
                ZoneDefineInfo defineInfo;
                Pair pair;
                if (!(zoneData instanceof ZoneDefineInfo) || pairs.contains(pair = new Pair((defineInfo = (ZoneDefineInfo)zoneData).getFeatureId(), deviceData.getKey().getDeviceId()))) continue;
                pairs.add(pair);
            }
        }
    }

    private void initData(ZoneUndeployData deployData) {
        ZoneConfigData zoneConfigData = this.configDataTools.initUndeployData(deployData.getZoneIdList(), deployData.getProgressBar());
        deployData.setZoneConfigData(zoneConfigData);
        ZoneToUndeployData toUndeploy = new ZoneToUndeployData();
        toUndeploy.initToUndeployData(zoneConfigData);
        Map<LogicDev, List<IFeature>> toUndeployData = toUndeploy.getToUndeployData();
        deployData.setToUndeployData(toUndeployData);
        int totalStep = this.calcTotalSteps(deployData.getToUndeployData());
        this.logger.info((Object)("totalStep:" + totalStep));
        deployData.getProgressBar().setTotalStep(totalStep + 5);
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        deployData.setThreadPool(threadPool);
    }

    private int calcTotalSteps(Map<LogicDev, List<IFeature>> toUndeployData) {
        int steps = 0;
        for (Map.Entry<LogicDev, List<IFeature>> deviceData : toUndeployData.entrySet()) {
            steps += deviceData.getValue().size();
        }
        return steps;
    }

    private void updateUndeployStatus(ZoneUndeployData deployData) {
        for (Map.Entry<Long, List<Long>> zone2device : deployData.getZoneConfigData().getZoneID2DeviceIdsMap().entrySet()) {
            Long zoneId = zone2device.getKey();
            int zoneUndeployOkDevice = 0;
            HashSet<Long> deviceIds = new HashSet<Long>();
            for (Long deviceId : zone2device.getValue()) {
                ZonePair pair = new ZonePair(deviceId, zoneId);
                if (!deployData.getResult().getZoneDeviceUndeployResult().containsKey(pair) || !deployData.getResult().getZoneDeviceUndeployResult().get(pair).booleanValue()) continue;
                deviceIds.add(deviceId);
                ++zoneUndeployOkDevice;
            }
            if (zoneUndeployOkDevice == zone2device.getValue().size()) {
                this.getBaseLineService().stopBaseLineTaskByZoneId(zoneId);
                this.serviceLearningParamService.stopServiceLearningTask(zoneId);
                deployData.getResult().getZonePolicyUndeployResult().put(zoneId, "UNDEPLOY");
                continue;
            }
            this.serviceLearningParamService.stopServiceLearnintTaskByDevice(zoneId, deviceIds);
            deployData.getResult().getZonePolicyUndeployResult().put(zoneId, "PART_SUCCESS");
        }
        this.saveDeployStatus(deployData);
    }

    private void updateZoneIpListState(Long zoneId) {
        this.zoneListIpDao.updateDeployStateByZoneId(zoneId);
        List<Long> pkIds = this.zoneListIpDao.getPkIdsByZoneId(zoneId);
        if (null != pkIds && !pkIds.isEmpty()) {
            this.zoneIpStatusDao.deleteIpByPkIds(pkIds);
        }
    }

    private void updateZonePortMapListState(Long zoneId) {
        this.zoneListPortMapDao.updateDeployStateByZoneId(zoneId);
        List<Long> portMapIds = this.zoneListPortMapDao.getPkIdsByZoneId(zoneId);
        if (null != portMapIds && !portMapIds.isEmpty()) {
            this.zonePortMapStatusDao.deleteIpByPortMapIds(portMapIds);
        }
    }

    private void saveDeployStatus(ZoneUndeployData deployData) {
        this.logger.info((Object)"enter saveDeployStatus");
        this.saveZonePolicyStatus(deployData);
        Util.getInstance().processNext(deployData);
        this.saveServiceStatus(deployData, false);
        Util.getInstance().processNext(deployData);
        this.saveZoneDeviceStatus(deployData);
        Util.getInstance().processNext(deployData);
        this.saveZoneFeatureStatus(deployData, null, null);
        Util.getInstance().processNext(deployData);
        this.logger.info((Object)"leave saveDeployStatus");
    }

    private void saveZonePolicyStatus(ZoneUndeployData deployData) {
        Map<Long, String> zonePolicyUndeployResult = deployData.getResult().getZonePolicyUndeployResult();
        Map<Long, ZonePolicyApplyForm> zonePolicyMap = deployData.getZoneConfigData().getZoneBasicInfoMap();
        for (Map.Entry<Long, String> result : zonePolicyUndeployResult.entrySet()) {
            ZonePolicyApplyForm zonePolicyApplyForm = (ZonePolicyApplyForm)this.zonePolicyService.query(result.getKey());
            zonePolicyApplyForm.setDeployState(result.getValue());
            if ("SUCCESS".equals(result.getValue())) {
                zonePolicyApplyForm.setFilterState(result.getValue());
            } else if ("UNDEPLOY".equals(result.getValue())) {
                Long zoneId = result.getKey();
                zonePolicyApplyForm.setFilterState(result.getValue());
                if (!String.valueOf("NORMAL").equals(zonePolicyMap.get(zoneId).getAbnormalState())) {
                    zonePolicyApplyForm.setAbnormalState("NORMAL");
                }
                this.updateZoneIpListState(zoneId);
                this.updateZonePortMapListState(zoneId);
                this.updateZoneBlackWhiteState(zoneId);
            }
            zonePolicyMap.get(result.getKey()).setDefendState(0);
            zonePolicyApplyForm.setDeployedCrc(CrcUtil.getCrcValue(String.valueOf(0)));
            this.zonePolicyService.update(zonePolicyApplyForm);
        }
    }

    private void updateZoneBlackWhiteState(Long zoneId) {
        List<BlackWhiteStatusInfo> infos = this.blackWhiteStatusDao.queryAllByZoneId(zoneId);
        if (infos.size() > 0) {
            this.blackWhiteStatusDao.deleteList(infos);
        }
    }

    private void saveZoneDeviceStatus(ZoneUndeployData deployData) {
        Map<ZonePair, Boolean> zoneDeviceStatus = deployData.getResult().getZoneDeviceUndeployResult();
        for (Map.Entry<ZonePair, ZoneDeviceDeployStatusInfo> zoneDevice : deployData.getZoneConfigData().getZoneDeviceStatusMap().entrySet()) {
            Boolean flag = zoneDeviceStatus.get(zoneDevice.getKey());
            if (null != flag && flag.booleanValue()) {
                this.zoneDeviceDeployStatusDao.delete(zoneDevice.getValue().getId());
                this.zoneDeviceDeployStatusDao.deleteByDeviceIdAndZoneId(zoneDevice.getValue().getDeviceId(), zoneDevice.getValue().getZoneId());
                continue;
            }
            if (!deployData.getResult().getErrorDetail().containsKey(zoneDevice.getKey())) continue;
            String errorMsgKey = deployData.getResult().getErrorDetail().get(zoneDevice.getKey());
            zoneDevice.getValue().setErrorMsgKey(errorMsgKey);
            zoneDevice.getValue().setDeployState(false);
            zoneDevice.getValue().setDeployTime(new Date());
            this.zoneDeviceDeployStatusDao.update(zoneDevice.getValue());
        }
        this.addErrorMsg(deployData, zoneDeviceStatus);
    }

    private void saveZoneDeviceStatus(ZoneUndeployData deployData, Map<Long, String> resultMap) {
        Map<ZonePair, Boolean> zoneDeviceStatus = deployData.getResult().getZoneDeviceUndeployResult();
        for (Map.Entry<ZonePair, ZoneDeviceDeployStatusInfo> zoneDevice : deployData.getZoneConfigData().getZoneDeviceStatusMap().entrySet()) {
            List<Long> pkIdList;
            List<Long> pkIds;
            if (!zoneDeviceStatus.containsKey(zoneDevice.getKey())) continue;
            if (null != resultMap) {
                this.zoneDeviceDeployStatusDao.deleteByDeviceIdAndZoneId(zoneDevice.getKey().getDeviceId(), zoneDevice.getKey().getZoneId());
            }
            if (null != (pkIds = this.zoneListIpDao.getPkIdsByZoneId(zoneDevice.getKey().getZoneId())) && !pkIds.isEmpty()) {
                this.zoneIpStatusDao.deleteIpByPkIdsAndDeviceId(pkIds, zoneDevice.getKey().getDeviceId());
            }
            if (null == (pkIdList = this.zoneListPortMapDao.getPkIdsByZoneId(zoneDevice.getKey().getZoneId())) || pkIdList.isEmpty()) continue;
            this.zonePortMapStatusDao.deleteIpByPkIdsAndDeviceId(pkIdList, zoneDevice.getKey().getDeviceId());
        }
    }

    private void addErrorMsg(ZoneUndeployData deployData, Map<ZonePair, Boolean> zoneDeviceStatus) {
        long zoneDeviceStatusInDBSize = deployData.getZoneConfigData().getZoneDeviceStatusMap().size();
        int deployFailedSize = 0;
        for (Map.Entry<ZonePair, Boolean> deviceStatus : zoneDeviceStatus.entrySet()) {
            if (deviceStatus.getValue().booleanValue()) continue;
            ++deployFailedSize;
        }
        if ((long)deployFailedSize > zoneDeviceStatusInDBSize) {
            for (Map.Entry<ZonePair, Boolean> zoneDeviceStatusEntry : zoneDeviceStatus.entrySet()) {
                if (zoneDeviceStatusEntry.getValue().booleanValue()) continue;
                ZoneDeviceDeployStatusInfo statusInfo = new ZoneDeviceDeployStatusInfo();
                statusInfo.setZoneId(zoneDeviceStatusEntry.getKey().getZoneId());
                statusInfo.setDeviceId(zoneDeviceStatusEntry.getKey().getDeviceId());
                statusInfo.setDeployState(zoneDeviceStatusEntry.getValue());
                if (deployData.getResult().getErrorDetail().containsKey(zoneDeviceStatusEntry.getKey())) {
                    statusInfo.setDeployTime(new Date());
                    statusInfo.setErrorMsgKey(deployData.getResult().getErrorDetail().get(zoneDeviceStatusEntry.getKey()));
                }
                this.zoneDeviceDeployStatusDao.save(statusInfo);
            }
        }
    }

    private void saveServiceStatus(ZoneUndeployData deployData, Boolean delNE) {
        for (Map.Entry<ServicePair, ZoneServiceStatusInfo> zoneServiceStatus : deployData.getZoneConfigData().getZoneServiceStatusMap().entrySet()) {
            ZonePair zonePair = new ZonePair(zoneServiceStatus.getKey().getDeviceId(), zoneServiceStatus.getKey().getZoneId());
            Boolean flag = deployData.getResult().getZoneDeviceUndeployResult().get(zonePair);
            if (delNE.booleanValue()) {
                this.zoneServiceStatusDao.deleteByDeviceIdAndZoneIdAndServiceId(zoneServiceStatus.getValue().getDeviceId(), zoneServiceStatus.getValue().getZoneId(), zoneServiceStatus.getValue().getServiceId());
                continue;
            }
            if (null == flag || !flag.booleanValue()) continue;
            this.zoneServiceStatusDao.deleteByDeviceIdAndZoneIdAndServiceId(zoneServiceStatus.getValue().getDeviceId(), zoneServiceStatus.getValue().getZoneId(), zoneServiceStatus.getValue().getServiceId());
        }
    }

    private void saveZoneFeatureStatus(ZoneUndeployData deployData, Long zoneId, List<Long> devices) {
        for (Map.Entry<FeaturePair, ZoneFeatureStatusInfo> featurestatus : deployData.getZoneConfigData().getZoneFeatureStatusMap().entrySet()) {
            ZonePair zonePair = new ZonePair(featurestatus.getKey().getDeviceId(), featurestatus.getKey().getZoneId());
            Boolean flag = deployData.getResult().getZoneDeviceUndeployResult().get(zonePair);
            if (null != zoneId && null != devices) {
                for (Long deviceId : devices) {
                    this.zoneFeatureStatusDao.deleteByDeviceIdAndZoneId(deviceId, zoneId);
                }
                continue;
            }
            if (null == flag || !flag.booleanValue()) continue;
            this.zoneFeatureStatusDao.deleteByDeviceIdAndZoneIdAndFeatureId(featurestatus.getValue().getDeviceId(), featurestatus.getValue().getZoneId(), featurestatus.getValue().getFeatureId(), featurestatus.getValue().getFeatureType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUndeploy(Long zoneId, Long adminId, List<Long> unConnDevices) {
        this.logger.info((Object)"enter doUndeploy for del zone");
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        zoneIdList.add(zoneId);
        Long progressBarId = System.currentTimeMillis();
        ZoneUndeployData deployData = new ZoneUndeployData();
        ProgressBar progressBar = ProgressMgr.getInstance().createProgressBar(100, progressBarId);
        deployData.setProgressBar(progressBar);
        deployData.setProgressBarId(progressBarId);
        deployData.setZoneIdList(zoneIdList);
        this.logger.info((Object)("params zoneIdList:" + zoneIdList));
        this.logger.info((Object)("params progressBarId:" + progressBarId));
        this.initData(deployData);
        Boolean isLockAdminPairsOk = false;
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        try {
            this.getToUndeployAdminPairs(pairs, deployData);
            isLockAdminPairsOk = VsmUtil.getInstance().lockAdminPairs(adminId, pairs);
            for (Map.Entry<LogicDev, List<IFeature>> deviceData : deployData.getToUndeployData().entrySet()) {
                ZoneUndeployThread task = new ZoneUndeployThread(deviceData.getKey(), deviceData.getValue(), progressBar, deployData.getResult());
                task.setZonePairListHasEnableCaptureTasks(deployData.getZoneConfigData().getZonePairListHasEnableCaptureTasks());
                task.setUnConnDevices(unConnDevices);
                deployData.getThreadPool().submit(task);
            }
            deployData.getThreadPool().shutdown();
            try {
                if (deployData.getThreadPool().awaitTermination(30L, TimeUnit.MINUTES)) {
                    this.logger.info((Object)"zone undeploy thread execute finished.");
                }
            }
            catch (InterruptedException e1) {
                this.logger.error((Object)("zone undeploy thread execute timeout. " + e1.getMessage()));
            }
            this.updateUndeployStatus(deployData);
            try {
                for (Map.Entry<LogicDev, List<IFeature>> deviceData : deployData.getToUndeployData().entrySet()) {
                    AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceData.getKey().getDeviceId().longValue());
                    if (null == aticDevice) continue;
                    this.unDeployFilter(deployData, null, true);
                }
            }
            catch (Exception e) {
                ProgressBar pbr = deployData.getProgressBar();
                if (null != pbr && pbr.getTotalStep() > pbr.getCurrentStep()) {
                    pbr.next(pbr.getTotalStep() - pbr.getCurrentStep());
                }
                this.logger.error((Object)("deploy filter exception!" + e.getMessage()));
            }
            this.notifyRefeshDefaultZoneData(deployData);
        }
        finally {
            int currentStep;
            int totalStep;
            if (isLockAdminPairsOk.booleanValue()) {
                VsmUtil.getInstance().unLockAdminPairs(adminId, pairs);
            }
            if (null != deployData.getProgressBar() && (totalStep = deployData.getProgressBar().getTotalStep()) > (currentStep = deployData.getProgressBar().getCurrentStep())) {
                progressBar.next(totalStep - currentStep);
            }
        }
        this.logger.info((Object)"leave doUndeploy for del zone");
    }

    private void unDeployFilter(ZoneUndeployData deployData, List<Long> deviceIds, boolean isRemove) {
        List<Long> zoneIdList = deployData.getZoneIdList();
        if (isRemove) {
            if (null != deviceIds && !deviceIds.isEmpty()) {
                Set<Long> filterIds = this.filterZoneService.delFilterRelationByDeviceIds(zoneIdList.get(0), deviceIds);
                this.logger.info((Object)("del zone device relation of filterids : " + filterIds));
                this.filterUnDeployCtrl.doUnDeployWithZone(zoneIdList.get(0), deviceIds, null, null, null);
            } else {
                this.filterZoneService.delFilterRelationByZoneId(zoneIdList.get(0));
                this.filterUnDeployCtrl.doUnDeployWithZone(deployData.getZoneIdList(), null, null, null);
            }
        } else {
            this.filterUnDeployCtrl.doUnDeployWithZone(deployData.getZoneIdList(), null, null, null);
        }
        Util.getInstance().processNext(deployData);
    }

    private void notifyRefeshDefaultZoneData(ZoneUndeployData deployData) {
        try {
            Boolean hasDefaultZone = false;
            Map<Long, ZoneInfoForm> zoneInfoMap = deployData.getZoneConfigData().getZoneInfoMap();
            for (Map.Entry<Long, ZoneInfoForm> entry : zoneInfoMap.entrySet()) {
                if (!Constant.ZONE_TYPE_OF_DEFAULT.equals(entry.getValue().getZoneType())) continue;
                hasDefaultZone = true;
            }
            if (hasDefaultZone.booleanValue()) {
                this.getFoundDefaultIdService().refeshDefaultZoneData();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("refeshDefaultZoneData error : " + e.getMessage()));
        }
    }

    private IFoundDefaultIdService getFoundDefaultIdService() {
        for (int i = 0; null == this.foundDefaultIdService && i < 100; ++i) {
            try {
                this.foundDefaultIdService = ZoneReferUtil.getFoundDefaultIdService();
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
            }
        }
        return this.foundDefaultIdService;
    }

    private IBaseLineService getBaseLineService() {
        for (int i = 0; null == baseLineService && i < 100; ++i) {
            try {
                baseLineService = ZoneReferUtil.getBaselineService();
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
            }
        }
        return baseLineService;
    }

    public IPacketTaskService getPacketTaskService() {
        IPacketTaskService packetTaskService = null;
        packetTaskService = ZoneReferUtil.getPacketTaskService();
        return packetTaskService;
    }

    public void undeployAllZone() {
        List<ZoneInfoForm> allZone = this.zoneService.getAll();
        if (null != allZone && !allZone.isEmpty()) {
            ArrayList<Long> zoneIds = new ArrayList<Long>();
            for (ZoneInfoForm each : allZone) {
                zoneIds.add(each.getZoneId());
            }
            this.doUndeploy(zoneIds, (Long)0L, 0L);
        }
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public FilterUnDeployCtrl getFilterUnDeployCtrl() {
        return this.filterUnDeployCtrl;
    }

    public void setFilterUnDeployCtrl(FilterUnDeployCtrl filterUnDeployCtrl) {
        this.filterUnDeployCtrl = filterUnDeployCtrl;
    }

    public IFilterDeviceZoneInfoService getFilterZoneService() {
        return this.filterZoneService;
    }

    public void setFilterZoneService(IFilterDeviceZoneInfoService filterZoneService) {
        this.filterZoneService = filterZoneService;
    }

    public FilterDeviceZoneStatusDao getFilterDeviceZoneStatusDao() {
        return this.filterDeviceZoneStatusDao;
    }

    public void setFilterDeviceZoneStatusDao(FilterDeviceZoneStatusDao filterDeviceZoneStatusDao) {
        this.filterDeviceZoneStatusDao = filterDeviceZoneStatusDao;
    }

    public IZoneService getUserService() {
        return this.userService;
    }

    public void setUserService(IZoneService userService) {
        this.userService = userService;
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public ZoneServiceStatusDao getZoneServiceStatusDao() {
        return this.zoneServiceStatusDao;
    }

    public void setZoneServiceStatusDao(ZoneServiceStatusDao zoneServiceStatusDao) {
        this.zoneServiceStatusDao = zoneServiceStatusDao;
    }

    public ConfigDataTools getConfigDataTools() {
        return this.configDataTools;
    }

    public void setConfigDataTools(ConfigDataTools configDataTools) {
        this.configDataTools = configDataTools;
    }

    public IZonePolicyApplyServiceSimple getZonePolicyService() {
        return this.zonePolicyService;
    }

    public void setZonePolicyService(IZonePolicyApplyServiceSimple zonePolicyService) {
        this.zonePolicyService = zonePolicyService;
    }

    public IServiceLearningParamService getServiceLearningParamService() {
        return this.serviceLearningParamService;
    }

    public void setServiceLearningParamService(IServiceLearningParamService serviceLearningParamService) {
        this.serviceLearningParamService = serviceLearningParamService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public ZoneListIpDao getZoneListIpDao() {
        return this.zoneListIpDao;
    }

    public void setZoneListIpDao(ZoneListIpDao zoneListIpDao) {
        this.zoneListIpDao = zoneListIpDao;
    }

    public ZoneIpStatusDao getZoneIpStatusDao() {
        return this.zoneIpStatusDao;
    }

    public void setZoneIpStatusDao(ZoneIpStatusDao zoneIpStatusDao) {
        this.zoneIpStatusDao = zoneIpStatusDao;
    }

    public ZoneListPortMapDao getZoneListPortMapDao() {
        return this.zoneListPortMapDao;
    }

    public void setZoneListPortMapDao(ZoneListPortMapDao zoneListPortMapDao) {
        this.zoneListPortMapDao = zoneListPortMapDao;
    }

    public ZoneListPortMapStateDao getZonePortMapStatusDao() {
        return this.zonePortMapStatusDao;
    }

    public void setZonePortMapStatusDao(ZoneListPortMapStateDao zonePortMapStatusDao) {
        this.zonePortMapStatusDao = zonePortMapStatusDao;
    }

    public BlackWhiteStatusDao getBlackWhiteStatusDao() {
        return this.blackWhiteStatusDao;
    }

    public void setBlackWhiteStatusDao(BlackWhiteStatusDao blackWhiteStatusDao) {
        this.blackWhiteStatusDao = blackWhiteStatusDao;
    }
}

