/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.function.undeploy;

import com.hs.atic.sdk.util.ZonePairCopy;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.service.data.ZoneUndeployResult;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.common.ZonePair;
import com.huawei.atic.policy.third.service.IPacketTaskService;
import java.util.ArrayList;
import java.util.List;

public class ZoneUndeployThread
extends Thread {
    private static boolean bThreadrun = true;
    private List<ZonePair> zonePairListHasEnableCaptureTasks = new ArrayList<ZonePair>();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private LogicDev logicDev;
    private List<IFeature> features;
    private ProgressBar progressBar;
    private int currentStep = 0;
    private int totalStep = 0;
    private String errorMsgKey = "--";
    private IPacketTaskService packetTaskService;
    private List<Long> unConnDevices;
    private Boolean undoZoneDeviceRel;
    private ZoneUndeployResult result;

    public ZoneUndeployThread(LogicDev logicDev, List<IFeature> features, ProgressBar progressBar, ZoneUndeployResult result) {
        this.features = features;
        this.logicDev = logicDev;
        this.progressBar = progressBar;
        this.result = result;
        this.setPriority(10);
    }

    public Boolean getUndoZoneDeviceRel() {
        return this.undoZoneDeviceRel;
    }

    public List<Long> getUnConnDevices() {
        return this.unConnDevices;
    }

    public void setUnConnDevices(List<Long> unConnDevices) {
        this.unConnDevices = unConnDevices;
    }

    public IPacketTaskService getPacketTaskService() {
        return this.packetTaskService;
    }

    public void setPacketTaskService(IPacketTaskService packetTaskService) {
        this.packetTaskService = packetTaskService;
    }

    public List<ZonePair> getZonePairListHasEnableCaptureTasks() {
        return this.zonePairListHasEnableCaptureTasks;
    }

    public void setZonePairListHasEnableCaptureTasks(List<ZonePair> zonePairListHasEnableCaptureTasks) {
        this.zonePairListHasEnableCaptureTasks = zonePairListHasEnableCaptureTasks;
    }

    public ZoneUndeployResult getResult() {
        return this.result;
    }

    public void setResult(ZoneUndeployResult result) {
        this.result = result;
    }

    public LogicDev getLogicDev() {
        return this.logicDev;
    }

    public void setLogicDev(LogicDev logicDev) {
        this.logicDev = logicDev;
    }

    public List<IFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<IFeature> features) {
        this.features = features;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public static boolean isbThreadrun() {
        return bThreadrun;
    }

    public static void setbThreadrun(boolean bThreadruns) {
        bThreadrun = bThreadruns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (IFeature feature : this.features) {
                ZonePair zonePair = new ZonePair(this.logicDev.getDeviceId(), feature.getFeatureId());
                if (null == this.unConnDevices || !this.unConnDevices.contains(this.logicDev.getDeviceId())) {
                    if (!this.dealPacketTask(zonePair).booleanValue()) continue;
                    if (this.progressBar.isCancled()) {
                        this.logger.info((Object)("progressbar in isCanceled branch: " + this.progressBar.toString()));
                        this.dealResult(zonePair, false, String.valueOf(630008));
                        this.progressBar.next();
                        ++this.currentStep;
                        this.logger.info((Object)("zonePair : [" + zonePair.getZoneId() + "," + zonePair.getDeviceId() + "]    errorMsgKey : " + this.errorMsgKey));
                        continue;
                    }
                    try {
                        this.logger.info((Object)("timeBeforeUndeployFeature : " + System.currentTimeMillis()));
                        List cmdResult = (List)feature.doUndeploy(this.logicDev, null);
                        if (null != cmdResult) {
                            for (String results : cmdResult) {
                                if (AticUtil.judgmentEcho((String)results)) {
                                    this.dealResult(zonePair, false, String.valueOf(571217));
                                    continue;
                                }
                                this.dealResult(zonePair, true, "--");
                            }
                        }
                        this.progressBar.next();
                        ++this.currentStep;
                    }
                    catch (LegoCheckedException legoException) {
                        this.logger.error((Object)legoException.getMessage());
                        this.logger.info((Object)("timeAftUnconn : " + System.currentTimeMillis()));
                        this.dealResult(zonePair, false, Long.valueOf(legoException.getErrorCode()).toString());
                        this.progressBar.next();
                        ++this.currentStep;
                        this.addUnConnDevices(this.logicDev.getDeviceId());
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e.getMessage());
                        this.dealResult(zonePair, false, String.valueOf(630006));
                        this.progressBar.next();
                        ++this.currentStep;
                        this.addUnConnDevices(this.logicDev.getDeviceId());
                    }
                    continue;
                }
                this.logger.info((Object)"inUnConnDevice branch");
                this.logger.info((Object)("unConnDevices : " + this.unConnDevices.toString() + "deviceId : " + this.logicDev.getDeviceId() + "isNotConn : " + this.unConnDevices.contains(this.logicDev.getDeviceId())));
                this.dealResult(zonePair, false, this.errorMsgKey);
                this.progressBar.next();
                ++this.currentStep;
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage());
        }
        finally {
            if (this.totalStep > this.currentStep) {
                this.progressBar.next(this.totalStep - this.currentStep);
            }
        }
    }

    private Boolean dealPacketTask(ZonePair zonePair) {
        ZonePairCopy zonePairCopy = new ZonePairCopy();
        VsmUtil.getInstance().copyProperties(zonePair, zonePairCopy);
        if (null != this.getUndoZoneDeviceRel() && this.getUndoZoneDeviceRel().booleanValue()) {
            BatchOperationResult batchDelPacketResult = this.packetTaskService.stopAndDelPacketTaskByZonePair(zonePairCopy);
            if (batchDelPacketResult != null && batchDelPacketResult.getFailCount() > 0) {
                this.dealResult(zonePair, false, String.valueOf(570627L));
                this.progressBar.next();
                ++this.currentStep;
                return false;
            }
        } else {
            String errordetail;
            List<ZonePair> zonePairListHasEnableCaptureTask = this.getZonePairListHasEnableCaptureTasks();
            if (null != zonePairListHasEnableCaptureTask && !zonePairListHasEnableCaptureTask.isEmpty() && zonePairListHasEnableCaptureTask.contains(zonePair) && !"success".equals(errordetail = this.packetTaskService.stopPacketTaskByZonePair(zonePairCopy))) {
                this.logger.info((Object)("progressbar in stopPacketTaskByZonePair branch: " + this.getcleanedMessage(this.progressBar.toString())));
                this.dealResult(zonePair, false, errordetail);
                this.progressBar.next();
                ++this.currentStep;
                this.logger.info((Object)("zonePair : [" + zonePair.getZoneId() + "," + zonePair.getDeviceId() + "]    errorMsgKey : " + this.errorMsgKey));
                return false;
            }
        }
        return true;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void addUnConnDevices(Long deviceId) {
        if (null != this.unConnDevices && !this.unConnDevices.contains(deviceId)) {
            this.unConnDevices.add(deviceId);
        }
    }

    private void dealResult(ZonePair zonePair, boolean isSuccess, String errorCode) {
        this.errorMsgKey = isSuccess ? errorCode : (errorCode.startsWith("lego.err.") ? errorCode : "lego.err." + errorCode);
        this.result.addZoneDeviceResult(zonePair, isSuccess);
        this.result.addErrorDetail(zonePair, this.errorMsgKey);
    }

    public void setUndoZoneDeviceRel(Boolean undoZoneDeviceRel) {
        this.undoZoneDeviceRel = undoZoneDeviceRel;
    }
}

