/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.npfilter.data;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.FilterDevicePair;
import com.hs.vsm.secservice.ddos.dao.NPFilterDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterDeviceInfoDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterDeviceStatusDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterRuleDao;
import com.hs.vsm.secservice.ddos.model.NPFilterDeviceInfo;
import com.hs.vsm.secservice.ddos.model.NPFilterDeviceStatusInfo;
import com.hs.vsm.secservice.ddos.model.NPFilterInfo;
import com.hs.vsm.secservice.ddos.model.NPFilterRuleInfo;
import com.hs.vsm.secservice.ddos.service.data.feature.NPFilterData;
import com.hs.vsm.secservice.ddos.service.npfilter.data.NPFilterDeployInfo;
import com.hs.vsm.secservice.ddos.service.npfilter.data.NPFilterDeployResult;
import com.hs.vsm.secservice.ddos.service.npfilter.data.NPFilterDeployThread;
import com.hs.vsm.secservice.sdk.common.util.CrcUtil;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterRuleForm;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NPFilterDeployCtrl {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private NPFilterDao npFilterDao;
    private NPFilterRuleDao npFilterRuleDao;
    private NPFilterDeviceInfoDao npFilterDeviceInfoDao;
    private NPFilterDeviceStatusDao npFilterDeviceStatusDao;
    private IAticDeviceService aticDeviceService;

    public Map<Long, Set<Long>> doDeployWithFilter(Long filterId, Long progressBarId, ProgressBar progressBar, Long adminId) {
        FilterDevicePair filterDevicePair;
        this.logger.info((Object)("NPFilter -> into doDeployWithFilter, filterId : " + filterId));
        ArrayList<FilterDevicePair> deployTempList = new ArrayList<FilterDevicePair>();
        ArrayList<FilterDevicePair> undeployTempList = new ArrayList<FilterDevicePair>();
        ArrayList<FilterDevicePair> deployedTempList = new ArrayList<FilterDevicePair>();
        List<NPFilterDeviceInfo> filterDeviceInfoList = this.npFilterDeviceInfoDao.getByFilterId(filterId);
        List<NPFilterDeviceStatusInfo> filterDeviceStatusInfoList = this.npFilterDeviceStatusDao.getInfoByFilterId(filterId);
        List<NPFilterDeviceStatusInfo> filterDeviceDeployInfoList = this.npFilterDeviceStatusDao.getDeployedByFilterId(filterId);
        for (NPFilterDeviceInfo filterDeviceInfo : filterDeviceInfoList) {
            filterDevicePair = new FilterDevicePair(filterDeviceInfo.getFilterId(), filterDeviceInfo.getDeviceId());
            deployTempList.add(filterDevicePair);
            this.logger.info((Object)("NPFilter -> pre to deploy info : " + filterDevicePair.toString()));
        }
        if (filterDeviceStatusInfoList != null) {
            for (NPFilterDeviceStatusInfo filterDeviceStatusInfo : filterDeviceStatusInfoList) {
                filterDevicePair = new FilterDevicePair(filterDeviceStatusInfo.getFilterId(), filterDeviceStatusInfo.getDeviceId());
                undeployTempList.add(filterDevicePair);
                this.logger.info((Object)("NPFilter -> deployed info : " + filterDevicePair.toString()));
            }
        }
        if (filterDeviceDeployInfoList != null) {
            for (NPFilterDeviceStatusInfo filterDeviceStatusInfo : filterDeviceDeployInfoList) {
                filterDevicePair = new FilterDevicePair(filterDeviceStatusInfo.getFilterId(), filterDeviceStatusInfo.getDeviceId());
                deployedTempList.add(filterDevicePair);
                this.logger.info((Object)("NPFilter -> deployed info : " + filterDevicePair.toString()));
            }
        }
        ArrayList<FilterDevicePair> deployFilterDevicePairTempList = new ArrayList<FilterDevicePair>(deployTempList);
        ArrayList<FilterDevicePair> undeployFilterDevicePairTempList = new ArrayList<FilterDevicePair>(undeployTempList);
        undeployFilterDevicePairTempList.removeAll(deployTempList);
        deployFilterDevicePairTempList.removeAll(deployedTempList);
        NPFilterDeployInfo filterDeployInfo = new NPFilterDeployInfo();
        filterDeployInfo.setProgressBar(progressBar);
        filterDeployInfo.setProgressBarId(progressBarId);
        filterDeployInfo = this.doDeploy(deployFilterDevicePairTempList, undeployFilterDevicePairTempList, filterDeployInfo);
        Map<Long, Set<Long>> resultMap = this.getReturnResultMap(filterDeployInfo);
        this.logger.info((Object)("NPFilter -> deploy filter, filterId : " + filterId + ", result : " + resultMap));
        return resultMap;
    }

    public NPFilterDeployInfo doDeploy(List<FilterDevicePair> deployFilterDevicePairList, List<FilterDevicePair> undeployFilterDevicePairList, NPFilterDeployInfo filterDeployInfo) {
        try {
            this.initDeviceUnDeployFilterMap(undeployFilterDevicePairList, filterDeployInfo);
            this.initFilterDeployInfo(deployFilterDevicePairList, filterDeployInfo);
            this.startNPFilterDeployThreads(filterDeployInfo);
            this.dealDeployResult(filterDeployInfo);
            return filterDeployInfo;
        }
        catch (Exception e) {
            this.logger.error((Object)("NPFilter -> deploy NPFilter error : " + e.getMessage()));
            return null;
        }
    }

    private Map<Long, Set<Long>> getReturnResultMap(NPFilterDeployInfo filterDeployInfo) {
        HashMap<Long, Set<Long>> returnResultMap = null;
        if (null != filterDeployInfo) {
            Map<Long, Set<Long>> filterDeployResultMap = this.getResultMapWithFilterDeploy(filterDeployInfo.getFilterDeployResult());
            Map<Long, Set<Long>> filterUnDeployResultMap = this.getResultMapWithFilterDeploy(filterDeployInfo.getFilterUnDeployResult());
            if (null != filterDeployResultMap || null != filterUnDeployResultMap) {
                returnResultMap = new HashMap<Long, Set<Long>>();
                if (null != filterDeployResultMap) {
                    returnResultMap.putAll(filterDeployResultMap);
                }
                if (null != filterUnDeployResultMap) {
                    returnResultMap.putAll(filterUnDeployResultMap);
                }
            }
        }
        return returnResultMap;
    }

    private Map<Long, Set<Long>> getResultMapWithFilterDeploy(Map<FilterDevicePair, NPFilterDeployResult> filterDeployResult) {
        if (filterDeployResult.isEmpty()) {
            return null;
        }
        HashMap<Long, Set<Long>> filterDeployResultMap = new HashMap<Long, Set<Long>>();
        for (Map.Entry<FilterDevicePair, NPFilterDeployResult> resultMapEntry : filterDeployResult.entrySet()) {
            Long deviceId = resultMapEntry.getKey().getDeviceId();
            String errorCode = resultMapEntry.getValue().getErrorMsgKey();
            if (errorCode == null || "".equals(errorCode) || filterDeployResultMap.get(deviceId) != null) continue;
            filterDeployResultMap.put(deviceId, new HashSet());
        }
        return filterDeployResultMap;
    }

    private void initDeviceUnDeployFilterMap(List<FilterDevicePair> undeployFilterDevicePairList, NPFilterDeployInfo filterDeployInfo) {
        HashMap<Long, List<IFeature>> deviceUnDeployFilterMap = new HashMap<Long, List<IFeature>>();
        if (undeployFilterDevicePairList != null && !undeployFilterDevicePairList.isEmpty()) {
            for (FilterDevicePair filterDevicePair : undeployFilterDevicePairList) {
                NPFilterInfo npFilterInfo;
                Long filterId = filterDevicePair.getFilterId();
                Long deviceId = filterDevicePair.getDeviceId();
                if (!filterDeployInfo.getDeviceIdSet().contains(deviceId)) {
                    AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
                    if (null != aticDevice) {
                        filterDeployInfo.addDeviceId4Set(deviceId);
                    } else {
                        this.logger.warn((Object)("NPFilter -> Device deviceId : " + deviceId + " is not exist."));
                        continue;
                    }
                }
                if (null != (npFilterInfo = this.npFilterDao.getById(filterId))) {
                    NPFilterData npFilterData = new NPFilterData(npFilterInfo);
                    if (null == deviceUnDeployFilterMap.get(deviceId)) {
                        deviceUnDeployFilterMap.put(deviceId, new ArrayList());
                    }
                    ((List)deviceUnDeployFilterMap.get(deviceId)).add(npFilterData);
                    continue;
                }
                this.logger.error((Object)("NPFilter -> NPFilterInfo filterId : " + filterId + " is not exist."));
            }
            filterDeployInfo.setFilterInfoToUnDeployData(deviceUnDeployFilterMap);
        }
    }

    private void dealDeployResult(NPFilterDeployInfo filterDeployInfo) {
        this.dealFilterUnDeployResult(filterDeployInfo.getFilterUnDeployResult());
        this.dealFilterDeployResult(filterDeployInfo.getFilterDeployResult(), filterDeployInfo.getNpFilterCrcMap());
    }

    private void dealFilterUnDeployResult(Map<FilterDevicePair, NPFilterDeployResult> filterUnDeployResult) {
        for (Map.Entry<FilterDevicePair, NPFilterDeployResult> filterUnDeployResultEntry : filterUnDeployResult.entrySet()) {
            Long filterId = filterUnDeployResultEntry.getKey().getFilterId();
            Long deviceId = filterUnDeployResultEntry.getKey().getDeviceId();
            if ("".equals(filterUnDeployResultEntry.getValue().getErrorMsgKey())) {
                this.npFilterDeviceStatusDao.deleteByFilterIdAndDeviceId(filterId, deviceId);
                continue;
            }
            NPFilterDeviceInfo npfilterDeviceInfo = new NPFilterDeviceInfo();
            npfilterDeviceInfo.setDeviceId(deviceId);
            npfilterDeviceInfo.setFilterId(filterId);
            this.npFilterDeviceInfoDao.create(npfilterDeviceInfo);
        }
    }

    private void dealFilterDeployResult(Map<FilterDevicePair, NPFilterDeployResult> filterDeployResult, Map<Long, Long> filterCrcMap) {
        for (Map.Entry<FilterDevicePair, NPFilterDeployResult> filterDeployResultEntry : filterDeployResult.entrySet()) {
            Long filterId = filterDeployResultEntry.getKey().getFilterId();
            Long deviceId = filterDeployResultEntry.getKey().getDeviceId();
            String errCode = filterDeployResultEntry.getValue().getErrorMsgKey();
            String errParam = filterDeployResultEntry.getValue().getErrorParam();
            NPFilterDeviceStatusInfo info = this.npFilterDeviceStatusDao.getInfoByFilterIdAndDeviceId(filterId, deviceId);
            if (null == info) {
                info = new NPFilterDeviceStatusInfo();
                info.setFilterId(filterId);
                info.setDeviceId(deviceId);
            }
            if ("".equals(errCode)) {
                info.setDeployState("SUCCESS");
                info.setErrorCode("--");
                info.setErrorParam(null);
            } else {
                info.setDeployState("FAIL");
                info.setErrorCode(errCode);
                info.setErrorParam(errParam);
            }
            Long crc = filterCrcMap.get(filterId);
            if (null == crc) {
                crc = CrcUtil.getCrcValue(0L);
            }
            info.setDeployTime(new Date());
            info.setDeployCrc(crc);
            this.npFilterDeviceStatusDao.createOrUpdate(info);
        }
    }

    private void startNPFilterDeployThreads(NPFilterDeployInfo filterDeployInfo) {
        Set<Long> deviceIdSet = filterDeployInfo.getDeviceIdSet();
        for (Long deviceId : deviceIdSet) {
            LogicDev logicDev = new LogicDev(deviceId, 1, "--");
            NPFilterDeployThread filterDeployThread = new NPFilterDeployThread(logicDev, filterDeployInfo);
            filterDeployInfo.getFilterDeployThreadPool().submit(filterDeployThread);
            this.logger.info((Object)("NPFilter -> start NPFilter deploy thread , deviceId : " + deviceId));
        }
        filterDeployInfo.getFilterDeployThreadPool().shutdown();
        try {
            if (filterDeployInfo.getFilterDeployThreadPool().awaitTermination(10L, TimeUnit.MINUTES)) {
                this.logger.info((Object)"NPFilter -> NPFilter deploy thread execute finished.");
            }
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)("NPFilter -> NPFilter deploy thread execute timeout." + e1.getMessage()));
        }
    }

    private void initFilterDeployInfo(List<FilterDevicePair> deployFilterDevicePairList, NPFilterDeployInfo filterDeployInfo) {
        this.logger.info((Object)"NPFilter -> init NPFilter deploy info");
        HashMap<Long, List<IFeature>> deviceDeployFilterMap = new HashMap<Long, List<IFeature>>();
        if (deployFilterDevicePairList != null && !deployFilterDevicePairList.isEmpty()) {
            for (FilterDevicePair filterDevicePair : deployFilterDevicePairList) {
                NPFilterRuleInfo npFilterRuleInfo;
                Long filterId = filterDevicePair.getFilterId();
                Long deviceId = filterDevicePair.getDeviceId();
                NPFilterInfo npFilterInfo = filterDeployInfo.getNpFilterInfoByFilterId(filterId);
                if (null == npFilterInfo) {
                    npFilterInfo = this.npFilterDao.getById(filterId);
                    if (null != npFilterInfo) {
                        filterDeployInfo.addNpFilterInfo4Map(filterId, npFilterInfo);
                    } else {
                        this.logger.error((Object)("NPFilter -> NPFilter filterId : " + filterId + " is not exist."));
                        continue;
                    }
                }
                if (null == (npFilterRuleInfo = filterDeployInfo.getNpFilterRuleInfoByFilterId(filterId)) && null != (npFilterRuleInfo = this.npFilterRuleDao.queryByFilterId(filterId))) {
                    filterDeployInfo.addNpFilterRuleInfo4Map(filterId, npFilterRuleInfo);
                }
                NPFilterData npFilterData = new NPFilterData(npFilterInfo, npFilterRuleInfo);
                if (null == deviceDeployFilterMap.get(deviceId)) {
                    deviceDeployFilterMap.put(deviceId, new ArrayList());
                }
                ((List)deviceDeployFilterMap.get(deviceId)).add(npFilterData);
                filterDeployInfo.addDeviceId4Set(deviceId);
                NPFilterForm npFilterForm = new NPFilterForm();
                VsmUtil.getInstance().copyProperties(npFilterInfo, npFilterForm);
                if (null != npFilterRuleInfo) {
                    NPFilterRuleForm npFilterRuleForm = new NPFilterRuleForm();
                    VsmUtil.getInstance().copyProperties(npFilterRuleInfo, npFilterRuleForm);
                    npFilterForm.setNpFilterRuleForm(npFilterRuleForm);
                }
                Long crc = npFilterForm.getBasicCalcCrc();
                filterDeployInfo.addNpFilterCrc4Map(filterId, crc);
            }
            filterDeployInfo.setFilterInfoToDeployData(deviceDeployFilterMap);
        }
        ThreadPoolExecutor filterDeployThreadPool = this.initFilterDeployThreadPool();
        filterDeployInfo.setFilterDeployThreadPool(filterDeployThreadPool);
    }

    private ThreadPoolExecutor initFilterDeployThreadPool() {
        this.logger.info((Object)"NPFilter -> init NPFilter deploy thread pool");
        ThreadPoolExecutor filterDeployThreadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        return filterDeployThreadPool;
    }

    public NPFilterDao getNpFilterDao() {
        return this.npFilterDao;
    }

    public void setNpFilterDao(NPFilterDao npFilterDao) {
        this.npFilterDao = npFilterDao;
    }

    public NPFilterRuleDao getNpFilterRuleDao() {
        return this.npFilterRuleDao;
    }

    public void setNpFilterRuleDao(NPFilterRuleDao npFilterRuleDao) {
        this.npFilterRuleDao = npFilterRuleDao;
    }

    public NPFilterDeviceInfoDao getNpFilterDeviceInfoDao() {
        return this.npFilterDeviceInfoDao;
    }

    public void setNpFilterDeviceInfoDao(NPFilterDeviceInfoDao npFilterDeviceInfoDao) {
        this.npFilterDeviceInfoDao = npFilterDeviceInfoDao;
    }

    public NPFilterDeviceStatusDao getNpFilterDeviceStatusDao() {
        return this.npFilterDeviceStatusDao;
    }

    public void setNpFilterDeviceStatusDao(NPFilterDeviceStatusDao npFilterDeviceStatusDao) {
        this.npFilterDeviceStatusDao = npFilterDeviceStatusDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

