/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.service.npfilter.data;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.FilterDevicePair;
import com.hs.vsm.secservice.ddos.dao.NPFilterDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterDeviceInfoDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterDeviceStatusDao;
import com.hs.vsm.secservice.ddos.dao.NPFilterRuleDao;
import com.hs.vsm.secservice.ddos.model.NPFilterDeviceInfo;
import com.hs.vsm.secservice.ddos.model.NPFilterDeviceStatusInfo;
import com.hs.vsm.secservice.ddos.model.NPFilterInfo;
import com.hs.vsm.secservice.ddos.service.data.feature.NPFilterData;
import com.hs.vsm.secservice.ddos.service.npfilter.data.NPFilterDeployInfo;
import com.hs.vsm.secservice.ddos.service.npfilter.data.NPFilterDeployResult;
import com.hs.vsm.secservice.ddos.service.npfilter.data.NPFilterDeployThread;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.frame.model.IFeature;
import com.hs.vsm.secservice.sdk.frame.model.LogicDev;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NPFilterUnDeployCtrl {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private NPFilterDao npFilterDao;
    private NPFilterRuleDao npFilterRuleDao;
    private NPFilterDeviceInfoDao npFilterDeviceInfoDao;
    private NPFilterDeviceStatusDao npFilterDeviceStatusDao;

    public void doUnDeployWithFilter(List<Long> filterIdList, Long progressBarId, ProgressBar progressBar, Long adminId) {
        this.logger.info((Object)("NPFilter-> into doUnDeployWithFilter, filterIdList : " + filterIdList.toString()));
        ArrayList<FilterDevicePair> undeployFilterDevicePairTempList = new ArrayList<FilterDevicePair>();
        ArrayList<FilterDevicePair> undeployedFilterDevicePairTempList = new ArrayList<FilterDevicePair>();
        NPFilterDeployInfo filterUnDeployInfo = new NPFilterDeployInfo();
        filterUnDeployInfo.setProgressBar(progressBar);
        filterUnDeployInfo.setProgressBarId(progressBarId);
        for (Long filterId : filterIdList) {
            List<NPFilterDeviceInfo> filterDeviceInfoList = this.npFilterDeviceInfoDao.getByFilterId(filterId);
            for (NPFilterDeviceInfo filterDeviceInfo : filterDeviceInfoList) {
                FilterDevicePair filterDevicePair = new FilterDevicePair(filterDeviceInfo.getFilterId(), filterDeviceInfo.getDeviceId());
                undeployFilterDevicePairTempList.add(filterDevicePair);
                this.logger.info((Object)("NPFilter-> pre to undeploy info : " + filterDevicePair.toString()));
            }
            List<NPFilterDeviceStatusInfo> filterDeviceStatusInfoList = this.npFilterDeviceStatusDao.getInfoByFilterId(filterId);
            for (NPFilterDeviceStatusInfo filterDeviceStatusInfo : filterDeviceStatusInfoList) {
                FilterDevicePair filterDevicePair = new FilterDevicePair(filterDeviceStatusInfo.getFilterId(), filterDeviceStatusInfo.getDeviceId());
                undeployedFilterDevicePairTempList.add(filterDevicePair);
                filterUnDeployInfo.addDeviceId4Set(filterDeviceStatusInfo.getDeviceId());
                this.logger.info((Object)("NPFilter-> pre undo deployed info : " + filterDevicePair.toString()));
            }
            undeployFilterDevicePairTempList.removeAll(undeployedFilterDevicePairTempList);
            this.deleteNPFilterDeviceData(undeployFilterDevicePairTempList);
        }
        this.doUnDeploy(undeployedFilterDevicePairTempList, filterUnDeployInfo);
        this.logger.info((Object)"NPFilter-> leave doUnDeployWithFilter.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnDeploy(List<FilterDevicePair> undeployFilterDevicePairList, NPFilterDeployInfo filterUnDeployInfo) {
        Boolean isLockFilterOk = false;
        HashSet<Long> filetrIdSet = new HashSet<Long>();
        try {
            this.initFilterUnDeployInfo(undeployFilterDevicePairList, filterUnDeployInfo, filetrIdSet);
            if (!filetrIdSet.isEmpty()) {
                isLockFilterOk = this.lockFilters(filetrIdSet);
            }
            this.startFilterUnDeployThreads(filterUnDeployInfo);
            this.dealUnDeployResult(filterUnDeployInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)("NPFilter-> deploy NPFilter error : " + e.getMessage()));
        }
        finally {
            if (isLockFilterOk.booleanValue() && !filetrIdSet.isEmpty()) {
                this.unLockFilters(filetrIdSet);
            }
        }
    }

    private void dealUnDeployResult(NPFilterDeployInfo filterUnDeployInfo) {
        for (Map.Entry<FilterDevicePair, NPFilterDeployResult> filterUnDeployResultEntry : filterUnDeployInfo.getFilterUnDeployResult().entrySet()) {
            Long filterId = filterUnDeployResultEntry.getKey().getFilterId();
            Long deviceId = filterUnDeployResultEntry.getKey().getDeviceId();
            if (!"".equals(filterUnDeployResultEntry.getValue().getErrorMsgKey())) continue;
            this.npFilterDeviceInfoDao.deleteByFilterIdAndDeviceId(filterId, deviceId);
            this.npFilterDeviceStatusDao.deleteByFilterIdAndDeviceId(filterId, deviceId);
        }
    }

    private void startFilterUnDeployThreads(NPFilterDeployInfo filterUnDeployInfo) {
        Set<Long> deviceIdSet = filterUnDeployInfo.getDeviceIdSet();
        for (Long deviceId : deviceIdSet) {
            LogicDev logicDev = new LogicDev(deviceId, 1, "--");
            NPFilterDeployThread filterUnDeployThread = new NPFilterDeployThread(logicDev, filterUnDeployInfo);
            filterUnDeployInfo.getFilterDeployThreadPool().submit(filterUnDeployThread);
            this.logger.info((Object)("NPFilter-> start NPFilter undeploy thread , deviceId : " + deviceId));
        }
        filterUnDeployInfo.getFilterDeployThreadPool().shutdown();
        try {
            if (filterUnDeployInfo.getFilterDeployThreadPool().awaitTermination(180L, TimeUnit.MINUTES)) {
                this.logger.info((Object)"NPFilter-> NPFilter undeploy thread execute finished.");
            }
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)("NPFilter-> NPFilter undeploy thread execute timeout." + e1.getMessage()));
        }
    }

    private void unLockFilters(Set<Long> filterIdSet) {
        this.logger.info((Object)"NPFilter-> unlock NPFilters by undeploy filter");
        VsmUtil.getInstance().unlockFilters(filterIdSet);
    }

    private Boolean lockFilters(Set<Long> filterIdSet) {
        this.logger.info((Object)"NPFilter-> lock NPFilters by undeploy filter");
        VsmUtil.getInstance().lockFilters(filterIdSet);
        return true;
    }

    private void initFilterUnDeployInfo(List<FilterDevicePair> undeployFilterDevicePairList, NPFilterDeployInfo filterUnDeployInfo, Set<Long> filetrIdSet) {
        this.logger.info((Object)"NPFilter-> init NPFilter undeploy info");
        HashMap<Long, List<IFeature>> deviceUnDeployFilterMap = new HashMap<Long, List<IFeature>>();
        if (!undeployFilterDevicePairList.isEmpty()) {
            for (FilterDevicePair filterDevicePair : undeployFilterDevicePairList) {
                Long filterId = filterDevicePair.getFilterId();
                Long deviceId = filterDevicePair.getDeviceId();
                NPFilterDeviceStatusInfo npFilterDeviceStatusInfo = this.npFilterDeviceStatusDao.getInfoByFilterIdAndDeviceId(filterId, deviceId);
                NPFilterInfo npFilterInfo = this.npFilterDao.getById(filterId);
                if (null == npFilterInfo) {
                    this.npFilterDeviceStatusDao.deleteByFilterId(filterId);
                    this.logger.warn((Object)("NPFilter-> NPFilterInfo filterId : " + filterId + " is not exist."));
                    continue;
                }
                if (null == npFilterDeviceStatusInfo) continue;
                NPFilterData npFilterData = new NPFilterData(npFilterInfo);
                if (null == deviceUnDeployFilterMap.get(deviceId)) {
                    deviceUnDeployFilterMap.put(deviceId, new ArrayList());
                }
                ((List)deviceUnDeployFilterMap.get(deviceId)).add(npFilterData);
                filetrIdSet.add(filterId);
            }
            filterUnDeployInfo.addFilterInfoToUnDeployData(deviceUnDeployFilterMap);
        }
        ThreadPoolExecutor filterUnDeployThreadPool = this.initFilterUnDeployThreadPool();
        filterUnDeployInfo.setFilterDeployThreadPool(filterUnDeployThreadPool);
    }

    private void deleteNPFilterDeviceData(List<FilterDevicePair> needDelFilterDevicePairList) {
        if (null != needDelFilterDevicePairList && !needDelFilterDevicePairList.isEmpty()) {
            for (FilterDevicePair filterDevicePair : needDelFilterDevicePairList) {
                Long filterId = filterDevicePair.getFilterId();
                Long deviceId = filterDevicePair.getDeviceId();
                this.npFilterDeviceInfoDao.deleteByFilterIdAndDeviceId(filterId, deviceId);
            }
        }
    }

    private ThreadPoolExecutor initFilterUnDeployThreadPool() {
        this.logger.info((Object)"NPFilter-> init NPFilter undeploy thread pool");
        ThreadPoolExecutor filterUnDeployThreadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        return filterUnDeployThreadPool;
    }

    public NPFilterDao getNpFilterDao() {
        return this.npFilterDao;
    }

    public void setNpFilterDao(NPFilterDao npFilterDao) {
        this.npFilterDao = npFilterDao;
    }

    public NPFilterRuleDao getNpFilterRuleDao() {
        return this.npFilterRuleDao;
    }

    public void setNpFilterRuleDao(NPFilterRuleDao npFilterRuleDao) {
        this.npFilterRuleDao = npFilterRuleDao;
    }

    public NPFilterDeviceInfoDao getNpFilterDeviceInfoDao() {
        return this.npFilterDeviceInfoDao;
    }

    public void setNpFilterDeviceInfoDao(NPFilterDeviceInfoDao npFilterDeviceInfoDao) {
        this.npFilterDeviceInfoDao = npFilterDeviceInfoDao;
    }

    public NPFilterDeviceStatusDao getNpFilterDeviceStatusDao() {
        return this.npFilterDeviceStatusDao;
    }

    public void setNpFilterDeviceStatusDao(NPFilterDeviceStatusDao npFilterDeviceStatusDao) {
        this.npFilterDeviceStatusDao = npFilterDeviceStatusDao;
    }
}

