/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.policyengine.commandutil;

import com.hs.vsm.secservice.policyengine.commandutil.ParseException;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CommandUtil {
    private static final Logger LOGGER = Logger.getLogger(CommandUtil.class);

    public static String getFileName(String xmlFilePath) {
        int index = xmlFilePath.lastIndexOf("/");
        if (index == -1) {
            return xmlFilePath;
        }
        String fileName = xmlFilePath.substring(index).substring(1);
        return fileName;
    }

    public boolean validCommandTplStr(String commandTplStr) {
        if (!this.validBracket(commandTplStr)) {
            return false;
        }
        if (!this.validSpecialChar(commandTplStr)) {
            return false;
        }
        return this.validEdge(commandTplStr);
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public boolean validNeedVar(String commandTplStr, Map<String, String> map) {
        LOGGER.info((Object)("map to valid need var pass in : " + CommandUtil.getcleanedMessage(map.toString())));
        String commandStr = commandTplStr;
        commandStr = this.delBracket(commandStr);
        Pattern p = Pattern.compile("\\$[a-zA-Z][a-zA-Z0-9_-]{0,63}");
        Matcher m = p.matcher(commandStr);
        while (m.find()) {
            String keyVar = m.group().substring(1);
            LOGGER.info((Object)("keyVar : " + CommandUtil.getcleanedMessage(keyVar)));
            if (map.containsKey(keyVar) && map.get(keyVar) != null && !map.get(keyVar).trim().equals("")) continue;
            LOGGER.info((Object)"the need char has no input value");
            throw new ParseException(112, commandStr + 112 + "the need char has no input value");
        }
        return true;
    }

    private String delBracket(String commandTplStr) {
        Matcher mBig;
        String commandStr = commandTplStr;
        Pattern pMidBracket = Pattern.compile("\\[[^\\[\\]\\{\\}]*\\]");
        Pattern pBigBracket = Pattern.compile("\\{[^\\[\\]\\{\\}]*\\}");
        Matcher mMid = pMidBracket.matcher(commandStr);
        if (mMid.find()) {
            int startIndex = mMid.start();
            int endIndex = mMid.end();
            commandStr = commandStr.substring(0, startIndex) + commandStr.substring(endIndex);
        }
        if ((mBig = pBigBracket.matcher(commandStr)).find()) {
            int startIndex = mBig.start();
            int endIndex = mBig.end();
            commandStr = commandStr.substring(0, startIndex) + commandStr.substring(endIndex);
        }
        if (commandStr.indexOf("[") == -1 && commandStr.indexOf("{") == -1) {
            return commandStr;
        }
        commandStr = this.delBracket(commandStr);
        return commandStr;
    }

    private boolean validEdge(String commandTplStr) {
        Pattern pEdge1 = Pattern.compile("\\[\\s*\\]");
        Matcher mEdge1 = pEdge1.matcher(commandTplStr);
        if (mEdge1.find()) {
            LOGGER.info((Object)"command item exist no content in bracket");
            throw new ParseException(111, commandTplStr + 111 + "command item exist no content in bracket");
        }
        Pattern pEdge2 = Pattern.compile("\\{\\s*\\}");
        Matcher mEdge2 = pEdge2.matcher(commandTplStr);
        if (mEdge2.find()) {
            LOGGER.info((Object)"command item exist no content in big bracket");
            throw new ParseException(111, commandTplStr + 111 + "command item exist no content in big bracket");
        }
        return true;
    }

    private boolean validSpecialChar(String commandTplStr) {
        Pattern chineseReg = Pattern.compile("[\u4e00-\u9fa5]+");
        Matcher mC = chineseReg.matcher(commandTplStr);
        if (mC.find()) {
            LOGGER.info((Object)(CommandUtil.getcleanedMessage(commandTplStr) + " contains chinese char"));
            throw new ParseException(106, commandTplStr + 106 + " contains chinese char");
        }
        Pattern qJReg = Pattern.compile("[\uff00-\uffff]+");
        Matcher mQJ = qJReg.matcher(commandTplStr);
        if (mQJ.find()) {
            LOGGER.info((Object)(CommandUtil.getcleanedMessage(commandTplStr) + " contains quanjiao char"));
            throw new ParseException(107, commandTplStr + 107 + " contains quanjiao char");
        }
        return true;
    }

    private boolean validBracket(String commandTplStr) {
        if (commandTplStr.indexOf("[") == -1 && commandTplStr.indexOf("{") == -1) {
            return true;
        }
        LinkedList<String> midBracketList = new LinkedList<String>();
        LinkedList<String> bigBracketList = new LinkedList<String>();
        for (int i = 0; i < commandTplStr.length(); ++i) {
            char tmpChar = commandTplStr.charAt(i);
            if (tmpChar == '{') {
                bigBracketList.addFirst(tmpChar + "");
                continue;
            }
            if (tmpChar == '}') {
                if (!bigBracketList.isEmpty()) {
                    bigBracketList.removeFirst();
                    continue;
                }
                LOGGER.info((Object)(CommandUtil.getcleanedMessage(commandTplStr) + " right big brackets great than left"));
                throw new ParseException(100, commandTplStr + 100 + " right big brackets great than left");
            }
            if (tmpChar == '[') {
                midBracketList.addFirst(tmpChar + "");
                continue;
            }
            if (tmpChar != ']') continue;
            if (!midBracketList.isEmpty()) {
                midBracketList.removeFirst();
                continue;
            }
            LOGGER.info((Object)(CommandUtil.getcleanedMessage(commandTplStr) + " right mid brackets great than left"));
            throw new ParseException(101, commandTplStr + 101 + " right mid brackets great than left");
        }
        if (!bigBracketList.isEmpty()) {
            LOGGER.info((Object)(CommandUtil.getcleanedMessage(commandTplStr) + " left big brackets great than right"));
            throw new ParseException(102, commandTplStr + 102 + " left big brackets great than right");
        }
        if (!midBracketList.isEmpty()) {
            LOGGER.info((Object)(CommandUtil.getcleanedMessage(commandTplStr) + " left mid brackets great than right"));
            throw new ParseException(103, commandTplStr + 103 + " left mid brackets great than right");
        }
        return true;
    }

    public String changeTabToSpace(String commandStr) {
        String commandTplStr = commandStr;
        Pattern p = Pattern.compile("\\s+");
        Matcher m = p.matcher(commandTplStr);
        while (m.find()) {
            commandTplStr = commandTplStr.replace(m.group(), " ");
        }
        return commandTplStr;
    }

    public String charEncode(String value) {
        return value == null || "".equals(value.trim()) ? value : value.replaceAll("\\{", "leftbigbracket").replaceAll("\\}", "rightbigbracket").replaceAll("\\|", "verticalsplit").replaceAll("\\$", "dollarvariable").replaceAll("\\[", "leftmidbracket").replaceAll("\\]", "rightmidbracket");
    }

    public String charDecode(String value) {
        return value == null || "".equals(value.trim()) ? value : value.replaceAll("leftbigbracket", "{").replaceAll("rightbigbracket", "}").replaceAll("verticalsplit", "|").replaceAll("leftmidbracket", "[").replaceAll("rightmidbracket", "]").replaceAll("dollarvariable", "\\$");
    }
}

