/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.sdk.module.ddos.form;

import com.hs.vsm.secservice.sdk.common.util.CrcUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.IcmpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.OtherDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SipDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TopNStudyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.UdpDefendPolicyForm;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZoneServiceForm
implements Serializable {
    private static final long serialVersionUID = 7401814537648672610L;
    private static Logger logger = Logger.getLogger(ZoneServiceForm.class);
    private static final Map<String, List<String>> SERVICETYPE2POLICYS = new HashMap<String, List<String>>();
    private TcpDefendPolicyForm tcpDefendPolicyForm = null;
    private UdpDefendPolicyForm udpDefendPolicyForm = null;
    private IcmpDefendPolicyForm icmpDefendPolicyForm = null;
    private HttpDefendPolicyForm httpDefendPolicyForm = null;
    private DnsDefendPolicyForm dnsDefendPolicyForm = null;
    private HttpsDefendPolicyForm httpsDefendPolicyForm = null;
    private SipDefendPolicyForm sipDefendPolicyForm = null;
    private OtherDefendPolicyForm otherDefendPolicyForm = null;
    private TopNStudyForm topNStudyForm = null;
    private NfaPolicyEditForm nfaPolicyEditForm = null;
    private Long pkid;
    private Long zoneId;
    private Long deviceId;
    private String deviceName;
    private String deviceIp;
    private String serviceName;
    private String description;
    private Integer serviceType;
    private String serviceTypeDescription;
    private String protocol;
    private Integer protocolNum;
    private String appType;
    private String appSubType;
    private String portList;
    private String ipList;
    private Long currentCrc = CrcUtil.getCrcValue(0);
    private Long deployedCrc = CrcUtil.getCrcValue(0);
    private Boolean deployState = false;
    private int infoFrom;
    private Long serviceGroupId;
    private Integer direction = 1;
    private Integer portType;

    public String getCalcCrcString() {
        StringBuffer buffer = new StringBuffer();
        String baseInfo = "ZoneServiceForm [deviceId=" + this.deviceId + ", ipList=" + this.ipList + ", portList=" + this.portList + ", protocol=" + this.protocol + ", serviceType=" + this.serviceType + ", serviceName=" + this.serviceName + ", description=" + this.description + ", protocolNum=" + this.protocolNum + ", portType=" + this.portType + "]";
        buffer.append(baseInfo);
        List<String> policys = ZoneServiceForm.getService2policy().get(this.protocol);
        buffer.append(this.calcPolicyFormCrc(policys));
        if (null != this.nfaPolicyEditForm) {
            buffer.append(this.nfaPolicyEditForm.getCalcCrcString());
        }
        return buffer.toString();
    }

    public String getCalcCrcStringOfBasicInfo() {
        String baseInfo = "ZoneServiceForm [deviceId=" + this.deviceId + ", portList=" + this.portList + ", protocol=" + this.protocol + ", serviceType=" + this.serviceType + ", serviceName=" + this.serviceName + ", protocolNum=" + this.protocolNum + ", portType=" + this.portType + "]";
        return baseInfo;
    }

    public String getCrcStringOfServiceIpInfo() {
        String baseInfo = "ServiceIpForm [deviceId=" + this.deviceId + ", ipList=" + this.ipList + ", portList=" + this.portList + ", description=" + this.description + "]";
        return baseInfo;
    }

    private String calcPolicyFormCrc(List<String> policys) {
        ArrayList<String> list = new ArrayList<String>();
        if (policys.contains("TCP") && this.getTcpDefendPolicyForm() != null) {
            list.add(this.getTcpDefendPolicyForm().getCalcCrcString());
        }
        if (policys.contains("UDP") && this.getUdpDefendPolicyForm() != null) {
            list.add(this.getUdpDefendPolicyForm().getCalcCrcString());
        }
        if (policys.contains("ICMP") && this.getIcmpDefendPolicyForm() != null) {
            list.add(this.getIcmpDefendPolicyForm().getCalcCrcString());
        }
        if (policys.contains("HTTP") && this.getHttpDefendPolicyForm() != null) {
            list.add(this.getHttpDefendPolicyForm().getCalcCrcString());
        }
        if (policys.contains("HTTPS") && this.getHttpsDefendPolicyForm() != null) {
            list.add(this.getHttpsDefendPolicyForm().getCalcCrcString());
        }
        if (policys.contains("DNS") && this.getDnsDefendPolicyForm() != null) {
            list.add(this.getDnsDefendPolicyForm().getCalcCrcString());
        }
        if (policys.contains("SIP") && this.getSipDefendPolicyForm() != null) {
            list.add(this.getSipDefendPolicyForm().getCalcCrcString());
        }
        if (policys.contains("Other") && this.getOtherDefendPolicyForm() != null) {
            list.add(this.getOtherDefendPolicyForm().getCalcCrcString());
        }
        if (policys.contains("TOPNSTUDY") && this.getTopNStudyForm() != null) {
            list.add(this.getTopNStudyForm().getCalcCrcString());
        }
        return ((Object)list).toString();
    }

    public void setCurrentValue(String key, int value) {
        NfaPolicyForm nfaPolicyForm = null;
        if (key.contains("sipFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getSipFlood();
        }
        if (key.contains("dnsQueryFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getDnsQueryFlood();
        }
        if (key.contains("dnsReplyFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getDnsReplyFlood();
        }
        if (key.contains("httpFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getHttpFlood();
        }
        if (key.contains("httpsFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getHttpsFlood();
        }
        if (key.contains("icmpFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getIcmpFlood();
        }
        if (key.contains("otherFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getOtherFlood();
        }
        if (key.contains("tcpAckFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getTcpAckFlood();
        }
        if (key.contains("tcpFragment")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getTcpFragmentFlood();
        }
        if (key.contains("tcpRstFin")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getTcpRstFinFlood();
        }
        if (key.contains("tcpSynFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getTcpSynFlood();
        }
        if (key.contains("udpFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getUdpFlood();
        }
        if (key.contains("udpFragment")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getUdpFragmentFlood();
        }
        if (key.contains("hostTotal")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getHostTotal();
        }
        if (null != nfaPolicyForm && key.contains("PpsThreshold")) {
            nfaPolicyForm.setPpsThreshold(Long.valueOf(value));
            nfaPolicyForm.setPpsUnit("pps");
        } else if (null != nfaPolicyForm && key.contains("BpsThreshold")) {
            nfaPolicyForm.setBpsThreshold(Long.valueOf(value));
            nfaPolicyForm.setBpsUnit("Kbps");
        }
        Collection<Serializable> forms = this.getForms();
        this.setFieldValue(forms, key, value);
    }

    public void setCurrentValue(String key, int value, String paraUnit) {
        NfaPolicyForm nfaPolicyForm = null;
        if (key.contains("sipFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getSipFlood();
        }
        if (key.contains("dnsQueryFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getDnsQueryFlood();
        }
        if (key.contains("dnsReplyFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getDnsReplyFlood();
        }
        if (key.contains("httpFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getHttpFlood();
        }
        if (key.contains("httpsFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getHttpsFlood();
        }
        if (key.contains("icmpFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getIcmpFlood();
        }
        if (key.contains("otherFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getOtherFlood();
        }
        if (key.contains("tcpAckFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getTcpAckFlood();
        }
        if (key.contains("tcpFragment")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getTcpFragmentFlood();
        }
        if (key.contains("tcpRstFin")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getTcpRstFinFlood();
        }
        if (key.contains("tcpSynFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getTcpSynFlood();
        }
        if (key.contains("udpFlood")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getUdpFlood();
        }
        if (key.contains("udpFragment")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getUdpFragmentFlood();
        }
        if (key.contains("hostTotal")) {
            nfaPolicyForm = this.nfaPolicyEditForm.getHostTotal();
        }
        if (null != nfaPolicyForm && key.contains("PpsThreshold")) {
            nfaPolicyForm.setPpsThreshold(Long.valueOf(value));
            if (paraUnit != null) {
                nfaPolicyForm.setPpsUnit(paraUnit);
            } else {
                nfaPolicyForm.setPpsUnit("pps");
            }
        } else if (null != nfaPolicyForm && key.contains("BpsThreshold")) {
            nfaPolicyForm.setBpsThreshold(Long.valueOf(value));
            nfaPolicyForm.setBpsUnit("Kbps");
        }
        Collection<Serializable> forms = this.getForms();
        this.setFieldValue(forms, key, value);
    }

    private void setFieldValue(Collection<Serializable> forms, String key, int value) {
        for (Serializable o : forms) {
            try {
                Field field = o.getClass().getDeclaredField(key);
                field.setAccessible(true);
                field.set(o, value);
            }
            catch (RuntimeException e) {
                logger.error((Object)"set field value with reflect exception in ZoneServiceForm");
            }
            catch (Exception e) {
                logger.error((Object)"set field value with reflect exception in ZoneServiceForm");
            }
        }
    }

    public int getCurrentValue(String key) {
        Collection<Serializable> forms = this.getForms();
        return this.getFieldValue(forms, key);
    }

    private int getFieldValue(Collection<Serializable> forms, String key) {
        for (Serializable o : forms) {
            try {
                Field field = o.getClass().getDeclaredField(key);
                field.setAccessible(true);
                Number fieldValue = (Number)field.get(o);
                if (null == fieldValue) {
                    return 0;
                }
                return fieldValue.intValue();
            }
            catch (NoSuchFieldException e) {
                logger.error((Object)"get field value with reflect NoSuchFieldException in ZoneServiceForm");
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)"get field value with reflect IllegalArgumentException in ZoneServiceForm");
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"get field value with reflect IllegalAccessException in ZoneServiceForm");
            }
        }
        return 0;
    }

    private Collection<Serializable> getForms() {
        ArrayList<Serializable> forms = new ArrayList<Serializable>();
        if (this.getProtocol().equals("HTTP")) {
            forms.add(this.getTcpDefendPolicyForm());
            forms.add(this.getHttpDefendPolicyForm());
        }
        if (this.getProtocol().equals("HTTPS")) {
            forms.add(this.getTcpDefendPolicyForm());
            forms.add(this.getHttpsDefendPolicyForm());
        }
        if (this.getProtocol().equals("SIP")) {
            forms.add(this.getUdpDefendPolicyForm());
            forms.add(this.getSipDefendPolicyForm());
        }
        if (this.getProtocol().equals("DNS")) {
            forms.add(this.getUdpDefendPolicyForm());
            forms.add(this.getDnsDefendPolicyForm());
        }
        if (this.getProtocol().equals("TCP")) {
            forms.add(this.getTcpDefendPolicyForm());
        }
        if (this.getProtocol().equals("UDP")) {
            forms.add(this.getUdpDefendPolicyForm());
        }
        if (this.getProtocol().equals("Other")) {
            forms.add(this.getOtherDefendPolicyForm());
        }
        if (this.getProtocol().equals("DEFAULT")) {
            forms.add(this.getTcpDefendPolicyForm() == null ? new TcpDefendPolicyForm() : this.getTcpDefendPolicyForm());
            forms.add(this.getUdpDefendPolicyForm() == null ? new UdpDefendPolicyForm() : this.getUdpDefendPolicyForm());
            forms.add(this.getDnsDefendPolicyForm() == null ? new DnsDefendPolicyForm() : this.getDnsDefendPolicyForm());
            forms.add(this.getSipDefendPolicyForm() == null ? new SipDefendPolicyForm() : this.getSipDefendPolicyForm());
            forms.add(this.getHttpDefendPolicyForm() == null ? new HttpDefendPolicyForm() : this.getHttpDefendPolicyForm());
            forms.add(this.getHttpsDefendPolicyForm() == null ? new HttpsDefendPolicyForm() : this.getHttpsDefendPolicyForm());
            forms.add(this.getIcmpDefendPolicyForm() == null ? new IcmpDefendPolicyForm() : this.getIcmpDefendPolicyForm());
            forms.add(this.getOtherDefendPolicyForm() == null ? new OtherDefendPolicyForm() : this.getOtherDefendPolicyForm());
            forms.add(this.getTopNStudyForm() == null ? new TopNStudyForm() : this.getTopNStudyForm());
        }
        return forms;
    }

    public Long getCurrentCrc() {
        return this.currentCrc;
    }

    public Long getDeployedCrc() {
        return this.deployedCrc;
    }

    public Boolean getDeployState() {
        return this.deployState;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public DnsDefendPolicyForm getDnsDefendPolicyForm() {
        return this.dnsDefendPolicyForm;
    }

    public HttpDefendPolicyForm getHttpDefendPolicyForm() {
        return this.httpDefendPolicyForm;
    }

    public HttpsDefendPolicyForm getHttpsDefendPolicyForm() {
        return this.httpsDefendPolicyForm;
    }

    public IcmpDefendPolicyForm getIcmpDefendPolicyForm() {
        return this.icmpDefendPolicyForm;
    }

    public int getInfoFrom() {
        return this.infoFrom;
    }

    public String getIpList() {
        return this.ipList;
    }

    public OtherDefendPolicyForm getOtherDefendPolicyForm() {
        return this.otherDefendPolicyForm;
    }

    public Long getPkid() {
        return this.pkid;
    }

    public String getPortList() {
        return this.portList;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Integer getProtocolNum() {
        return this.protocolNum;
    }

    public Long getServiceGroupId() {
        return this.serviceGroupId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Integer getServiceType() {
        return this.serviceType;
    }

    public String getServiceTypeDescription() {
        return this.serviceTypeDescription;
    }

    public SipDefendPolicyForm getSipDefendPolicyForm() {
        return this.sipDefendPolicyForm;
    }

    public TcpDefendPolicyForm getTcpDefendPolicyForm() {
        return this.tcpDefendPolicyForm;
    }

    public UdpDefendPolicyForm getUdpDefendPolicyForm() {
        return this.udpDefendPolicyForm;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setAppSubType(String appSubType) {
        this.appSubType = appSubType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public void setCurrentCrc(Long currentCrc) {
        this.currentCrc = currentCrc;
    }

    public void setDeployedCrc(Long deployedCrc) {
        this.deployedCrc = deployedCrc;
    }

    public void setDeployState(Boolean deployState) {
        this.deployState = deployState;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public void setDnsDefendPolicyForm(DnsDefendPolicyForm dnsDefendPolicyForm) {
        this.dnsDefendPolicyForm = dnsDefendPolicyForm;
    }

    public void setHttpDefendPolicyForm(HttpDefendPolicyForm httpDefendPolicyForm) {
        this.httpDefendPolicyForm = httpDefendPolicyForm;
    }

    public void setHttpsDefendPolicyForm(HttpsDefendPolicyForm httpsDefendPolicyForm) {
        this.httpsDefendPolicyForm = httpsDefendPolicyForm;
    }

    public void setIcmpDefendPolicyForm(IcmpDefendPolicyForm icmpDefendPolicyForm) {
        this.icmpDefendPolicyForm = icmpDefendPolicyForm;
    }

    public void setInfoFrom(int infoFrom) {
        this.infoFrom = infoFrom;
    }

    public void setIpList(String ipList) {
        this.ipList = ipList;
    }

    public void setOtherDefendPolicyForm(OtherDefendPolicyForm otherDefendPolicyForm) {
        this.otherDefendPolicyForm = otherDefendPolicyForm;
    }

    public void setPkid(Long pkid) {
        this.pkid = pkid;
    }

    public void setPortList(String portList) {
        this.portList = portList;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setProtocolNum(Integer protocolNum) {
        this.protocolNum = protocolNum;
    }

    public void setServiceGroupId(Long serviceGroupId) {
        this.serviceGroupId = serviceGroupId;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    public void setServiceTypeDescription(String serviceTypeDescription) {
        this.serviceTypeDescription = serviceTypeDescription;
    }

    public void setSipDefendPolicyForm(SipDefendPolicyForm sipDefendPolicyForm) {
        this.sipDefendPolicyForm = sipDefendPolicyForm;
    }

    public void setTcpDefendPolicyForm(TcpDefendPolicyForm tcpDefendPolicyForm) {
        this.tcpDefendPolicyForm = tcpDefendPolicyForm;
    }

    public void setUdpDefendPolicyForm(UdpDefendPolicyForm udpDefendPolicyForm) {
        this.udpDefendPolicyForm = udpDefendPolicyForm;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public NfaPolicyEditForm getNfaPolicyEditForm() {
        return this.nfaPolicyEditForm;
    }

    public void setNfaPolicyEditForm(NfaPolicyEditForm nfaPolicyEditForm) {
        this.nfaPolicyEditForm = nfaPolicyEditForm;
    }

    public static Map<String, List<String>> getService2policy() {
        return SERVICETYPE2POLICYS;
    }

    public String getAppSubType() {
        return this.appSubType;
    }

    public String getAppType() {
        return this.appType;
    }

    public TopNStudyForm getTopNStudyForm() {
        return this.topNStudyForm;
    }

    public void setTopNStudyForm(TopNStudyForm topNStudyForm) {
        this.topNStudyForm = topNStudyForm;
    }

    public String toString() {
        return "ZoneServiceForm [deviceId=" + this.deviceId + ", ipList=" + this.ipList + ", portList=" + this.portList + ", protocol=" + this.protocol + ", serviceType=" + this.serviceType + ", serviceName=" + this.serviceName + ", direction=" + this.direction + ", portType=" + this.portType + "]";
    }

    public Integer getDirection() {
        return this.direction;
    }

    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    public Integer getPortType() {
        return this.portType;
    }

    public void setPortType(Integer portType) {
        this.portType = portType;
    }

    static {
        ArrayList<String> defaultType = new ArrayList<String>();
        defaultType.add("TCP");
        defaultType.add("UDP");
        defaultType.add("DNS");
        defaultType.add("SIP");
        defaultType.add("HTTP");
        defaultType.add("HTTPS");
        defaultType.add("ICMP");
        defaultType.add("Other");
        defaultType.add("DESTZONE");
        defaultType.add("TOPNSTUDY");
        defaultType.add("NFA");
        ArrayList<String> tcp = new ArrayList<String>();
        tcp.add("TCP");
        ArrayList<String> udp = new ArrayList<String>();
        udp.add("UDP");
        ArrayList<String> http = new ArrayList<String>();
        http.add("HTTP");
        http.add("TCP");
        ArrayList<String> https = new ArrayList<String>();
        https.add("HTTPS");
        https.add("TCP");
        ArrayList<String> sip = new ArrayList<String>();
        sip.add("SIP");
        sip.add("UDP");
        ArrayList<String> other = new ArrayList<String>();
        other.add("Other");
        SERVICETYPE2POLICYS.put("DEFAULT", defaultType);
        SERVICETYPE2POLICYS.put("TCP", tcp);
        SERVICETYPE2POLICYS.put("UDP", udp);
        SERVICETYPE2POLICYS.put("HTTP", http);
        SERVICETYPE2POLICYS.put("HTTPS", https);
        SERVICETYPE2POLICYS.put("SIP", sip);
        SERVICETYPE2POLICYS.put("Other", other);
    }
}

