/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fds.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public final class FileUtil {
    private static FileUtil instance;
    private static Log logger;
    private static ReentrantLock lock;

    private FileUtil() {
    }

    public static FileUtil geInstance() {
        lock.lock();
        try {
            FileUtil fileUtil = instance == null ? (FileUtil)FileUtil.class.newInstance() : instance;
            return fileUtil;
        }
        catch (InstantiationException e) {
            FileUtil fileUtil = null;
            return fileUtil;
        }
        catch (IllegalAccessException e) {
            FileUtil fileUtil = null;
            return fileUtil;
        }
        finally {
            lock.unlock();
        }
    }

    public static String hashCode(byte[] inputText) {
        return FileUtil.encrypt(inputText, "SHA-256");
    }

    public static String hashCodeMD(byte[] inputText) {
        return FileUtil.encrypt(inputText, "MD5");
    }

    public static String parenthesesFilter(String str) {
        String innerContent = null;
        String regx = ".*?\\[(.*?)\\].*?";
        Pattern pattern = Pattern.compile(regx);
        Matcher matcher = pattern.matcher(str);
        if (matcher.matches()) {
            innerContent = matcher.group(1);
        }
        return innerContent;
    }

    private static String encrypt(byte[] inputText, String algorithmName) {
        if (inputText == null) {
            throw new IllegalArgumentException("inputText is null");
        }
        String encryptText = null;
        try {
            MessageDigest m = MessageDigest.getInstance(algorithmName);
            m.update(inputText);
            byte[] s = m.digest();
            return FileUtil.hex(s);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage());
            return encryptText;
        }
    }

    private static String hex(byte[] arr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(Integer.toHexString(arr[i] & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static void createDirectory(String path) {
        File file = new File(path);
        if (!(file.exists() || file.isDirectory() || file.mkdir())) {
            logger.info((Object)"file.mkdir( ) failed!");
        }
    }

    public static void cleanDirectory(String path) {
        File file = new File(path);
        if (file.isFile()) {
            if (!file.delete()) {
                logger.info((Object)"file.delete() failed!");
            }
        } else {
            File[] files = file.listFiles();
            if (null == files) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() || files[i].delete()) continue;
                logger.info((Object)"backupFile.delete() failed!");
            }
        }
    }

    public static void moveFile2Backup(String curDirPath) throws IOException {
        String backupDirPath = curDirPath.replace("import4restful", "import4restful" + File.separator + "backup");
        File curFile = new File(curDirPath);
        File backupFile = new File(backupDirPath);
        if (backupFile.exists() && !backupFile.delete()) {
            logger.info((Object)"backupFile.delete() failed!");
        }
        if (curFile.exists()) {
            if (!backupFile.getParentFile().exists() && !backupFile.getParentFile().mkdir()) {
                logger.info((Object)"backupFile.getParentFile().mkdir() failed!");
            }
            FileUtils.moveFileToDirectory((File)curFile, (File)backupFile.getParentFile(), (boolean)true);
        }
    }

    public static List<String> getFileNameList(String path) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        File file = new File(path);
        if (file.isFile() && ZoneUtil.checkFileTypeIsXml(file)) {
            fileNameList.add(file.getName());
        } else {
            File[] files = file.listFiles();
            if (null == files || files.length <= 0) {
                return fileNameList;
            }
            for (File file2 : files) {
                if (!file2.isFile() || !ZoneUtil.checkFileTypeIsXml(file2)) continue;
                fileNameList.add(file2.getName());
            }
        }
        return fileNameList;
    }

    static {
        logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
        lock = new ReentrantLock();
    }
}

