/*
 * Decompiled with CFR 0.152.
 */
package com.restful.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.hs.atic.highdefense.domain.service.IDefenseConfigService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.XmlUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import com.huawei.atic.util.CommonUtil;
import com.restful.service.RestHighDefenseService;
import com.restful.util.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

@Path(value="/defense")
@Produces(value={"application/json"})
public class RestHighDefenseServiceImpl
implements RestHighDefenseService {
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REST);
    private IDefenseConfigService defenseConfigService;

    public IDefenseConfigService getDefenseConfigService() {
        return this.defenseConfigService;
    }

    public void setDefenseConfigService(IDefenseConfigService defenseConfigService) {
        this.defenseConfigService = defenseConfigService;
    }

    @Override
    @POST
    @Path(value="/updategroup")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String updateDefenseGroup(String json) {
        this.logger.info((Object)"updateDefenseGroup restful start");
        this.logger.info((Object)("json" + json));
        try {
            String remoteAddr = ServletActionContext.getRequest().getRemoteAddr();
            String localAddr = this.getInstallXmlIp();
            if (!remoteAddr.equals(localAddr)) {
                this.logger.error((Object)"remote address is error!");
                return "remote address is error!";
            }
            MyTypeReference type = new MyTypeReference();
            Map obj = (Map)JSONUtil.getInstance().fromJSON(json, type);
            if (null == obj) {
                this.logger.error((Object)"query params is null!");
                return "query params is null!";
            }
            this.logger.info((Object)("obj" + obj));
            String licenseNumber = (String)obj.get("licenseNumber");
            String defenseBindwidth = (String)obj.get("defenseBindwidth");
            String expirationDate = (String)obj.get("expirationDate");
            String ddosDeviceId = (String)obj.get("ddosDeviceId");
            String localIp = (String)obj.get("Ip");
            if (!localIp.equals(CommonUtil.getInstallXmlIp())) {
                this.logger.error((Object)("Abnormal attack! ip: " + localIp));
                return "Abnormal attack!";
            }
            if (AticUtil.isNull((String)licenseNumber) || AticUtil.isNull((String)defenseBindwidth) || !AticUtil.isNum((String)defenseBindwidth).booleanValue() || defenseBindwidth.startsWith("0")) {
                this.logger.error((Object)"param error");
                return "param error";
            }
            if (!AticUtil.isNull((String)expirationDate) && (1 != AticUtil.timeComparison((String)(expirationDate + " 00:00:00"), (String)(AticUtil.convertTime2DayString((long)(System.currentTimeMillis() / 1000L)) + " 00:00:00")) || AticUtil.isNull((String)ddosDeviceId) || !AticUtil.isNum((String)ddosDeviceId).booleanValue() || ddosDeviceId.startsWith("0"))) {
                this.logger.error((Object)"expirationDate error!");
                return "expirationDate error!";
            }
            if (AticUtil.isNull((String)expirationDate)) {
                this.defenseConfigService.deleteDefenseConfig(licenseNumber, Integer.parseInt(defenseBindwidth));
            } else {
                this.defenseConfigService.updateDefenseConfig(licenseNumber, Integer.parseInt(defenseBindwidth), Long.parseLong(ddosDeviceId), expirationDate);
            }
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)("updateDefenseGroup NumberFormatException :" + e.getMessage()));
            return e.getMessage() + "";
        }
        catch (IOException e) {
            this.logger.error((Object)("updateDefenseGroup IOException :" + e.getMessage()));
            return e.getMessage() + "";
        }
        return "success";
    }

    public String getInstallXmlIp() {
        String serverIpAddress = "";
        try {
            String path = AticInstallUtil.getInstance().getLegoPlatInstalledXMLPath();
            SAXReader saxReader = new SAXReader();
            XmlUtil.setSecureFeatureForSaxReader((SAXReader)saxReader);
            Document doc = saxReader.read(new File(path));
            Element element = (Element)doc.selectSingleNode("//entry/string[text()='lego.base.serverIpAddress']");
            serverIpAddress = element.getParent().selectSingleNode("com.huawei.elog.base.model.ContextPropVal").selectSingleNode("value").getText();
        }
        catch (DocumentException e) {
            this.logger.error((Object)"RestHighDefenseServiceImpl getInstallXmlIp error");
        }
        catch (SAXException e) {
            this.logger.error((Object)"RestHighDefenseServiceImpl setFeature error");
        }
        return serverIpAddress;
    }

    private static class MyTypeReference<T>
    extends TypeReference<T> {
    }
}

