/*
 * Decompiled with CFR 0.152.
 */
package com.restful.util;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.service.IUserService;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;

public class PermissionCheckUtil {
    public static Response checkPermissionByDeviceIp(String userName, List<String> deviceIpList) {
        IAticDeviceService aticDeviceService = ZoneBisUtil.getIFirewallService();
        ArrayList<Long> moIdList = new ArrayList<Long>();
        AticDevice aticDevice = null;
        String ip = null;
        for (int i = 0; i < deviceIpList.size(); ++i) {
            ip = deviceIpList.get(i);
            aticDevice = aticDeviceService.getDeviceByIp(ip);
            if (null == aticDevice) continue;
            moIdList.add(aticDevice.getMoId());
        }
        return PermissionCheckUtil.checkRestfulUserSecurity(userName, moIdList);
    }

    public static Response checkPermissionByZoneName(String userName, String zoneName) {
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        ArrayList<Long> moIdList = new ArrayList<Long>();
        ZoneInfoForm form = zoneService.getZoneByName(zoneName);
        if (null != form) {
            moIdList.add(form.getMoId());
        }
        return PermissionCheckUtil.checkRestfulUserSecurity(userName, moIdList);
    }

    public static Response checkPermissionByCollectorIp(String userName, List<String> collectorIpList) {
        ICollectorService collectorService = ZoneReferUtil.getICollectorService();
        ArrayList<Long> moIdList = new ArrayList<Long>();
        CollectorInfo collectorInfo = null;
        String collectorIp = null;
        for (int i = 0; i < collectorIpList.size(); ++i) {
            collectorIp = collectorIpList.get(i);
            collectorInfo = collectorService.getCollectorInfo(collectorIp);
            if (null == collectorInfo) continue;
            moIdList.add(collectorInfo.getId());
        }
        return PermissionCheckUtil.checkRestfulUserSecurity(userName, moIdList);
    }

    public static Response checkRestfulUserSecurity(String userName, List<Long> moIdList) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(200);
        try {
            IUserService userService = (IUserService)ServiceContext.getInstance().getService("userService", IUserService.class);
            UserInfo userInfoByName = userService.getUserInfoByName(userName, false);
            if (!userInfoByName.isIsAdmin()) {
                BisUtil.checkRestfulUserSecurity(moIdList, (long)userInfoByName.getId(), (boolean)userInfoByName.isIsAdmin());
            }
        }
        catch (LegoCheckedException e) {
            responseBuilder.status(455);
            responseBuilder.entity((Object)"The current user does not have the resources for this.");
            return responseBuilder.build();
        }
        return responseBuilder.build();
    }
}

