/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.util;

import com.hs.atic.analysis.util.Pair;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.bis.form.IpLocation;
import com.hs.atic.sdk.bis.form.LocationCustomForm;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AnalysisUtil {
    public static int getDeviceDdos(AticDevice firewall) {
        int ddosType = 1;
        if (null != firewall) {
            ddosType = firewall.getDdosType();
        }
        return ddosType;
    }

    public static List<Pair<String, String>> getDefaultProtocolList() {
        ArrayList<Pair<String, String>> protocolList = new ArrayList<Pair<String, String>>();
        protocolList.add(new Pair<String, String>("1", "TCP"));
        protocolList.add(new Pair<String, String>("2", "UDP"));
        protocolList.add(new Pair<String, String>("3", "ICMP"));
        protocolList.add(new Pair<String, String>("4", "OTHER"));
        return protocolList;
    }

    public static List<AticDevice> getAllDetectList4Cluster(IAticDeviceService firewallService, long userId) {
        List detectDeviceList = firewallService.getDetectDevice(userId);
        ArrayList<AticDevice> returnList = new ArrayList<AticDevice>();
        IClusterService clusterService = (IClusterService)ServiceContext.getInstance().getService("clusterService", IClusterService.class);
        for (AticDevice tempDev : detectDeviceList) {
            if (clusterService.isBelongCluster(Long.valueOf(tempDev.getMoId()))) continue;
            returnList.add(tempDev);
        }
        return returnList;
    }

    public static String getIpLocationName(int ipLocationId) {
        ILocationCustomService locationCustomService;
        LocationCustomForm locationCustomForm;
        ILibraryFileService libraryFileService = ReportBisUtil.getLibraryFileService();
        Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
        String language = locale.getLanguage();
        IpLocation ipLocation = (IpLocation)libraryFileService.getIpLocationMap().get(ipLocationId);
        String ipLocationName = "";
        ipLocationName = null != ipLocation ? (language.equalsIgnoreCase("zh") ? ipLocation.getLocationNameZh() : ipLocation.getLocationNameEn()) : (ipLocationId >= 3000 ? (null != (locationCustomForm = (locationCustomService = ReportBisUtil.getLocationCustomService()).findById(Long.valueOf(ipLocationId))) ? locationCustomForm.getLocationName() : AticUtil.getText((String)"atic.bis.location.unknownLoc") + ipLocationId) : AticUtil.getText((String)"atic.bis.location.unknownLoc") + ipLocationId);
        return ipLocationName;
    }

    public static Map<String, String> getLogAttackStatus() {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("0", "atic.analysis.exact.log.status.end");
        resultMap.put("1", "atic.analysis.exact.log.status.abnormal");
        resultMap.put("2", "atic.analysis.exact.log.status.attack");
        return resultMap;
    }
}

