/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.homepage.util;

import com.hs.atic.homepage.form.HomePageEntityForm;
import com.hs.atic.homepage.util.ZoneCompareData4CompareFlow;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.homepage.model.ZoneCompareMemoryDataKey;
import com.hs.atic.sdk.homepage.model.ZoneCompareObj;
import com.hs.atic.sdk.homepage.model.ZoneCompareTrafficObj;
import com.hs.atic.sdk.homepage.service.IHomePageService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CollectZoneComTraffic {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DASHBOARD);

    public void collect() {
        try {
            List<ZoneCompareObj> zoneComList = this.getZoneCompareObjList();
            this.logger.info((Object)("When collect zone traffic .The ZoneCompareObj are :" + this.getcleanedMessage(zoneComList.toString()) + ". "));
            if (zoneComList.isEmpty()) {
                return;
            }
            IDataStatService dataStatService = CollectZoneComTraffic.getIDataStatService();
            List zoneCompareDataList = dataStatService.queryDashboardData(zoneComList);
            if (zoneCompareDataList == null || zoneCompareDataList.isEmpty()) {
                return;
            }
            this.processZoneData(zoneCompareDataList);
            this.deleteOverdueDeviceData(zoneComList);
        }
        catch (Exception e) {
            this.logger.error((Object)("collect error:" + e.getMessage()));
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<ZoneCompareObj> getZoneCompareObjList() {
        ArrayList<ZoneCompareObj> zoneComList = new ArrayList<ZoneCompareObj>();
        IHomePageService iHomePageService = CollectZoneComTraffic.getIHomePageService();
        List<HomePageEntityForm> formList = iHomePageService.getHomePageEntityByFlowType(2);
        List<HomePageEntityForm> formListDis = iHomePageService.getHomePageEntityByFlowType(4);
        if (null != formListDis && !formListDis.isEmpty()) {
            formList.addAll(formListDis);
        }
        ServiceContext context = ServiceContext.getInstance();
        IAticDeviceService aticDeviceService = (IAticDeviceService)context.getService("aticDeviceService", IAticDeviceService.class);
        ICollectorDeviceService collectorDeviceService = (ICollectorDeviceService)context.getService("collectorDeviceService", ICollectorDeviceService.class);
        ICollectorService collectorService = (ICollectorService)context.getService("collectorService", ICollectorService.class);
        for (HomePageEntityForm form : formList) {
            if (form.getDeviceIp().equals("-1") || form.getDeviceIp().equals("-2")) {
                this.processAllCleanOrDetectDevice(zoneComList, form, aticDeviceService, collectorDeviceService, collectorService);
                continue;
            }
            this.processSingleDevice(zoneComList, form, aticDeviceService, collectorDeviceService, collectorService);
        }
        return zoneComList;
    }

    private void processSingleDevice(List<ZoneCompareObj> zoneComList, HomePageEntityForm form, IAticDeviceService aticDeviceService, ICollectorDeviceService collectorDeviceService, ICollectorService collectorService) {
        AticDevice device = aticDeviceService.getDeviceByIp(form.getDeviceIp());
        if (null == device || null == device.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceIp = " + form.getDeviceIp()));
            return;
        }
        Long collectorId = collectorDeviceService.getCollectorIdByDevId(Long.valueOf(device.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,deviceId = " + device.getMoId()));
            return;
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            return;
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            return;
        }
        String collectorIp = collectorInfo.getIpAddress();
        ZoneCompareObj zoneCompareObj = new ZoneCompareObj();
        zoneCompareObj.setDeviceIp(form.getDeviceIp());
        zoneCompareObj.setDevType(form.getDeviceType().intValue());
        zoneCompareObj.setCollectorIp(collectorIp);
        zoneCompareObj.setZoneId(form.getZoneId());
        zoneCompareObj.setMax(true);
        zoneCompareObj.setDirection(form.getDirection().intValue());
        if (null != form.getStatisticType() && form.getStatisticType() == 2) {
            zoneCompareObj.setMax(true);
        }
        if (!AticUtil.isNull((String)form.getZoneIp())) {
            zoneCompareObj.setZoneIp(AticUtil.formatIpAddress((String)form.getZoneIp()));
        }
        zoneComList.add(zoneCompareObj);
    }

    private void processAllCleanOrDetectDevice(List<ZoneCompareObj> zoneComList, HomePageEntityForm form, IAticDeviceService aticDeviceService, ICollectorDeviceService collectorDeviceService, ICollectorService collectorService) {
        List deviceList = aticDeviceService.getAllDevice();
        for (AticDevice device : deviceList) {
            if (device.getDeviceType() != 1) continue;
            Long collectorId = collectorDeviceService.getCollectorIdByDevId(Long.valueOf(device.getMoId()));
            if (null == collectorId) {
                this.logger.error((Object)("no collector exist,firewallId = " + device.getMoId()));
                continue;
            }
            CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
            if (null == collectorInfo) {
                this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
                continue;
            }
            if (2 == collectorInfo.getStatus()) {
                this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
                continue;
            }
            String collectorIp = collectorInfo.getIpAddress();
            ZoneCompareObj zoneCompareObj = new ZoneCompareObj();
            ZoneCompareObj zoneCompareObjDetece = new ZoneCompareObj();
            zoneCompareObj.setDeviceIp(device.getIpAddress());
            zoneCompareObj.setDirection(form.getDirection().intValue());
            zoneCompareObjDetece.setDeviceIp(device.getIpAddress());
            zoneCompareObjDetece.setDirection(form.getDirection().intValue());
            if (device.getDdosType() == 2) {
                zoneCompareObj.setDevType(0);
                zoneCompareObjDetece.setDevType(1);
            } else {
                zoneCompareObj.setDevType(device.getDdosType());
            }
            zoneCompareObj.setCollectorIp(collectorIp);
            zoneCompareObjDetece.setCollectorIp(collectorIp);
            zoneCompareObj.setZoneId(form.getZoneId());
            zoneCompareObj.setMax(true);
            zoneCompareObjDetece.setMax(true);
            if (null != form.getStatisticType() && form.getStatisticType() == 2) {
                zoneCompareObj.setMax(true);
                zoneCompareObjDetece.setMax(true);
            }
            zoneCompareObjDetece.setZoneId(form.getZoneId());
            if (!AticUtil.isNull((String)form.getZoneIp())) {
                zoneCompareObj.setZoneIp(AticUtil.formatIpAddress((String)form.getZoneIp()));
                zoneCompareObjDetece.setZoneIp(AticUtil.formatIpAddress((String)form.getZoneIp()));
            }
            zoneComList.add(zoneCompareObj);
            if (device.getDdosType() != 2) continue;
            zoneComList.add(zoneCompareObjDetece);
        }
    }

    private static IHomePageService getIHomePageService() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            IHomePageService iHomePageService = (IHomePageService)context.getService("homePageServiceImpl", IHomePageService.class);
            if (iHomePageService != null) {
                return iHomePageService;
            }
            throw new LegoCheckedException(570506L);
        }
        throw new LegoCheckedException(570506L);
    }

    private static IDataStatService getIDataStatService() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            IDataStatService dataStatService = (IDataStatService)ServiceContext.getInstance().getService("dataStatService", IDataStatService.class);
            if (dataStatService != null) {
                return dataStatService;
            }
            throw new LegoCheckedException(570506L);
        }
        throw new LegoCheckedException(570506L);
    }

    private void deleteOverdueDeviceData(List<ZoneCompareObj> zoneComList) {
        Map<ZoneCompareMemoryDataKey, List<ZoneCompareTrafficObj>> allDevIfDataMap = ZoneCompareData4CompareFlow.getInstance().getAllZoneCompareDataMap();
        if (zoneComList == null || zoneComList.isEmpty()) {
            allDevIfDataMap.clear();
            return;
        }
        ArrayList<String> deviceIpList = new ArrayList<String>();
        for (ZoneCompareObj temp : zoneComList) {
            deviceIpList.add(temp.getDeviceIp());
        }
        Iterator<Map.Entry<ZoneCompareMemoryDataKey, List<ZoneCompareTrafficObj>>> iterator = allDevIfDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ZoneCompareMemoryDataKey, List<ZoneCompareTrafficObj>> entry = iterator.next();
            String deviceIp = entry.getKey().getDeviceIp();
            if (!deviceIpList.contains(deviceIp)) {
                iterator.remove();
                continue;
            }
            long twoHourBeforTime = System.currentTimeMillis() / 1000L - 7200L;
            Iterator<ZoneCompareTrafficObj> iter = entry.getValue().iterator();
            while (iter.hasNext()) {
                if (iter.next().getLogTime() >= twoHourBeforTime) continue;
                iter.remove();
            }
        }
    }

    private void processZoneData(List<ZoneCompareTrafficObj> zoneCompareDataList) {
        Map<ZoneCompareMemoryDataKey, List<ZoneCompareTrafficObj>> allDevIfDataMap = ZoneCompareData4CompareFlow.getInstance().getAllZoneCompareDataMap();
        for (ZoneCompareTrafficObj item : zoneCompareDataList) {
            List<Object> temp;
            ZoneCompareMemoryDataKey zoneCompareMemoryDataKey = new ZoneCompareMemoryDataKey();
            zoneCompareMemoryDataKey.setDeviceIp(item.getDeviceIp());
            zoneCompareMemoryDataKey.setDeviceType(item.getDeviceType());
            zoneCompareMemoryDataKey.setZoneId(item.getZoneId());
            zoneCompareMemoryDataKey.setMax(item.isMax());
            zoneCompareMemoryDataKey.setDirection(item.getDirection());
            if (!AticUtil.isNull((String)item.getZoneIp())) {
                zoneCompareMemoryDataKey.setZoneIp(item.getZoneIp());
            }
            if (allDevIfDataMap.containsKey(zoneCompareMemoryDataKey)) {
                temp = allDevIfDataMap.get(zoneCompareMemoryDataKey);
                if (null == temp || temp.isEmpty()) {
                    allDevIfDataMap.remove(zoneCompareMemoryDataKey);
                    continue;
                }
                long lastLogTime = ((ZoneCompareTrafficObj)temp.get(temp.size() - 1)).getLogTime();
                if (lastLogTime == item.getLogTime()) continue;
                allDevIfDataMap.get(zoneCompareMemoryDataKey).add(item);
                continue;
            }
            temp = new ArrayList();
            temp.add(item);
            allDevIfDataMap.put(zoneCompareMemoryDataKey, temp);
        }
    }
}

