/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.base.dataprotect.service;

import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.base.dataprotect.util.LegoDataProtector;
import java.io.UnsupportedEncodingException;

public class DataProtectService
implements IDataProtectService {
    public static final String CHARSETNAME = "UTF-8";

    @Override
    public String sdpEncrypt(long domainId, String pucPlainText) {
        return LegoDataProtector.sdpEncrypt(domainId, pucPlainText);
    }

    @Override
    public String sdpEncryptInitData(String pucPlainText) {
        return LegoDataProtector.sdpEncryptInitData(pucPlainText);
    }

    @Override
    public String sdpDecrypt(long domainId, String pucCipherText) {
        String plainText = LegoDataProtector.sdpDecrypt(domainId, pucCipherText);
        return plainText;
    }

    @Override
    public String sdpDecryptInitData(String pucCipherText) {
        String plainText = LegoDataProtector.sdpDecryptInitData(pucCipherText);
        return plainText;
    }

    @Override
    public String sdpProtectPwd(String pucPlainText) {
        return LegoDataProtector.sdpProtectPwd(pucPlainText);
    }

    public String sdpProtectPwdInitData(String pucPlainText) {
        return LegoDataProtector.sdpProtectPwdInitData(pucPlainText);
    }

    @Override
    public boolean sdpVerifyPwd(String pucPlainText, String pucCipherText) {
        boolean result = LegoDataProtector.sdpVerifyPwd(pucPlainText, pucCipherText);
        return result;
    }

    @Override
    public String sdpHmac(String pucPlainText) {
        return LegoDataProtector.sdpHmac(pucPlainText);
    }

    @Override
    public String sdpEncrypt(long domainId, StringBuffer pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = new StringBuffer();
        }
        byte[] pucPlainBytes = new byte[]{};
        try {
            pucPlainBytes = pucPlainText.toString().getBytes(CHARSETNAME);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UnsupportedEncodingException: " + e.getMessage());
        }
        return LegoDataProtector.sdpEncrypt(domainId, pucPlainBytes);
    }

    @Override
    public String sdpEncryptInitData(StringBuffer pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = new StringBuffer();
        }
        byte[] pucPlainBytes = new byte[]{};
        try {
            pucPlainBytes = pucPlainText.toString().getBytes(CHARSETNAME);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UnsupportedEncodingException: " + e.getMessage());
        }
        return LegoDataProtector.sdpEncryptInitData(pucPlainBytes);
    }

    @Override
    public StringBuffer sdpDecrypt(String pucCipherText, long domainId) {
        StringBuffer pucPlain = null;
        byte[] plainText = LegoDataProtector.sdpDecrypt(pucCipherText, domainId);
        try {
            String pucStrPlain = new String(plainText, CHARSETNAME);
            pucPlain = new StringBuffer(pucStrPlain);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UnsupportedEncodingException: " + e.getMessage());
        }
        return pucPlain;
    }

    @Override
    public StringBuffer sdpDecryptInitDataByte(String pucCipherText) {
        StringBuffer pucPlain = null;
        byte[] plainText = LegoDataProtector.sdpDecryptInitDataByte(pucCipherText);
        try {
            String pucStrPlain = new String(plainText, CHARSETNAME);
            pucPlain = new StringBuffer(pucStrPlain);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UnsupportedEncodingException: " + e.getMessage());
        }
        return pucPlain;
    }

    @Override
    public String sdpProtectPwd(StringBuffer pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = new StringBuffer();
        }
        byte[] pucPlainBytes = new byte[]{};
        try {
            pucPlainBytes = pucPlainText.toString().getBytes(CHARSETNAME);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UnsupportedEncodingException: " + e.getMessage());
        }
        return LegoDataProtector.sdpProtectPwd(pucPlainBytes);
    }

    public String sdpProtectPwdInitData(StringBuffer pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = new StringBuffer();
        }
        byte[] pucPlainBytes = new byte[]{};
        try {
            pucPlainBytes = pucPlainText.toString().getBytes(CHARSETNAME);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UnsupportedEncodingException: " + e.getMessage());
        }
        return LegoDataProtector.sdpProtectPwdInitData(pucPlainBytes);
    }

    @Override
    public boolean sdpVerifyPwd(StringBuffer pucPlainText, String pucCipherText) {
        if (null == pucPlainText) {
            pucPlainText = new StringBuffer();
        }
        byte[] pucPlainBytes = new byte[]{};
        try {
            pucPlainBytes = pucPlainText.toString().getBytes(CHARSETNAME);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UnsupportedEncodingException: " + e.getMessage());
        }
        boolean result = LegoDataProtector.sdpVerifyPwd(pucPlainBytes, pucCipherText);
        return result;
    }

    @Override
    public String sdpHmac(StringBuffer pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = new StringBuffer();
        }
        byte[] pucPlainBytes = new byte[]{};
        try {
            pucPlainBytes = pucPlainText.toString().getBytes(CHARSETNAME);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UnsupportedEncodingException: " + e.getMessage());
        }
        return LegoDataProtector.sdpHmac(pucPlainBytes);
    }
}

