/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.base.persistance.dao;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.ICommonDao;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class CommonDaoImpl
extends HibernateDaoSupport
implements ICommonDao {
    private static final Log LOGGER = LogFactory.getInstance(Module.ATIC_CORE_BASE);

    @Override
    public Serializable save(Object entity) {
        return super.getHibernateTemplate().save(entity);
    }

    @Override
    public void saveOrUpdate(Object entity) {
        super.getHibernateTemplate().flush();
        super.getHibernateTemplate().clear();
        super.getHibernateTemplate().saveOrUpdate(entity);
    }

    @Override
    public void saveAll(Set<?> entity) {
        for (Object enti : entity) {
            super.getHibernateTemplate().saveOrUpdate(enti);
        }
    }

    @Override
    public void delete(Object entity) {
        super.getHibernateTemplate().delete(entity);
    }

    @Override
    public void deleteAll(List<?> list) {
        super.getHibernateTemplate().deleteAll(list);
    }

    @Override
    public void update(Object entity) {
        super.getHibernateTemplate().flush();
        super.getHibernateTemplate().clear();
        super.getHibernateTemplate().update(entity);
    }

    @Override
    public Object get(Class<?> entityClass, Serializable id) {
        return super.getHibernateTemplate().get(entityClass, id);
    }

    @Override
    public List<?> find(String hql, Object value) {
        if (null == value) {
            return null;
        }
        return this.getHibernateTemplate().find(hql, value);
    }

    @Override
    public List<?> findPage(String hql, int firstRowIndex, int totalRow) {
        FindPageHiberCallBack callBack = new FindPageHiberCallBack(hql, firstRowIndex, totalRow);
        return (List)new HibernateTemplate(this.getSessionFactory()).execute(callBack);
    }

    @Override
    public List<?> findPage(String hql, int firstRowIndex, int totalRow, Map<Integer, String> param) {
        FindPageTotalCallBack callBack = new FindPageTotalCallBack(hql, firstRowIndex, totalRow, param);
        return (List)this.getHibernateTemplate().execute(callBack);
    }

    @Override
    public long getTotalCount(String hql) {
        return (Long)super.getHibernateTemplate().find(hql, new Object[0]).listIterator().next();
    }

    @Override
    public long getTotalCount(String hql, Object ... values) {
        return (Long)this.getHibernateTemplate().find(hql, values).listIterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTotalCount(String hql, Map<Integer, String> param) {
        Session session = null;
        Query query = null;
        Long totalCount = 0L;
        try {
            session = this.getHibernateTemplate().getSessionFactory().openSession();
            query = session.createQuery(hql);
            Set<Map.Entry<Integer, String>> entrys = param.entrySet();
            for (Map.Entry<Integer, String> entry : entrys) {
                query.setString(entry.getKey(), entry.getValue());
            }
            totalCount = (Long)query.uniqueResult();
        }
        catch (RuntimeException e) {
            LOGGER.error("getTotalCount exception when choose database");
        }
        finally {
            if (null != session) {
                try {
                    session.close();
                }
                catch (HibernateException e) {
                    this.logger.error("getTotalCount session close failed");
                }
            }
        }
        return totalCount;
    }

    @Override
    public List<?> findByHql(String hql) {
        return super.getHibernateTemplate().find(hql, new Object[0]);
    }

    @Override
    public List<?> findByHql(String hql, Object ... values) {
        FindByHqlHqlCallBack callBack = new FindByHqlHqlCallBack(hql, values);
        return (List)this.getHibernateTemplate().execute(callBack);
    }

    @Override
    public List<?> findByHql(String hql, Map<Integer, String> param) {
        FindByHqlParCallBack callBack = new FindByHqlParCallBack(hql, param);
        return (List)this.getHibernateTemplate().execute(callBack);
    }

    @Override
    public List<?> findByHqlKey(String hql, Map<String, Object> params) {
        FindByHqlKeyCallBack callBack = new FindByHqlKeyCallBack(hql, params);
        return (List)this.getHibernateTemplate().execute(callBack);
    }

    @Override
    public int updateByHql(String hql) {
        return super.getHibernateTemplate().bulkUpdate(hql, new Object[0]);
    }

    public void updateByHql(String hql, Object ... values) {
        UpdateByHqlCallBack callBack = new UpdateByHqlCallBack(hql, values);
        this.getHibernateTemplate().execute(callBack);
    }

    @Override
    public List<?> findBySql(String sql) {
        FindBySqlStrCallBack callBack = new FindBySqlStrCallBack(sql);
        return (List)super.getHibernateTemplate().execute(callBack);
    }

    @Override
    public List<?> findBySql(String sql, Object ... values) {
        FindBySqlCallBack callBack = new FindBySqlCallBack(sql, values);
        return (List)super.getHibernateTemplate().execute(callBack);
    }

    @Override
    public int updateBySql(String sql) {
        UpdateByStringCallBack callback = new UpdateByStringCallBack(sql);
        return (Integer)super.getHibernateTemplate().execute(callback);
    }

    @Override
    public Integer updateBySql(String sql, Object ... values) {
        UpdateBySqlCallBack callBack = new UpdateBySqlCallBack(sql, values);
        return (Integer)this.getHibernateTemplate().execute(callBack);
    }

    @Override
    public List<?> findPageBySql(Class<?> entityClass, String sql, int firstRowIndex, int totalRow) {
        Session session = null;
        SQLQuery queryObject = null;
        session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
        queryObject = session.createSQLQuery(sql).addEntity(entityClass);
        queryObject.setFirstResult(firstRowIndex);
        queryObject.setMaxResults(totalRow);
        return queryObject.list();
    }

    public int deleteBatch(String hql, Map<Integer, Object> mapParam) {
        Query queryNew = this.currentSession().createQuery(hql);
        Set<Map.Entry<Integer, Object>> entrys = mapParam.entrySet();
        for (Map.Entry<Integer, Object> entry : entrys) {
            queryNew.setParameter(entry.getKey(), entry.getValue());
        }
        return queryNew.executeUpdate();
    }

    private static final class UpdateBySqlCallBack
    implements HibernateCallback {
        private String sql;
        private Object[] values;

        public UpdateBySqlCallBack(String sql, Object[] values) {
            this.sql = sql;
            this.values = values;
        }

        public Integer doInHibernate(Session session) {
            NativeQuery query = session.createSQLQuery(this.sql);
            if (this.values != null && this.values.length > 0) {
                for (int i = 0; i < this.values.length; ++i) {
                    query.setParameter(i, this.values[i]);
                }
            }
            return query.executeUpdate();
        }
    }

    private static final class UpdateByStringCallBack
    implements HibernateCallback {
        private String sql;

        public UpdateByStringCallBack(String sql) {
            this.sql = sql;
        }

        public Object doInHibernate(Session session) {
            return session.createSQLQuery(this.sql).executeUpdate();
        }
    }

    private static final class FindBySqlCallBack
    implements HibernateCallback {
        private String sql;
        private Object[] values;

        public FindBySqlCallBack(String sql, Object[] values) {
            this.sql = sql;
            this.values = values;
        }

        public Object doInHibernate(Session session) {
            NativeQuery query = session.createSQLQuery(this.sql);
            if (this.values != null && this.values.length > 0) {
                for (int i = 0; i < this.values.length; ++i) {
                    query.setParameter(i, this.values[i]);
                }
            }
            return query.list();
        }
    }

    private static final class FindBySqlStrCallBack
    implements HibernateCallback {
        private String sql;

        public FindBySqlStrCallBack(String sql) {
            this.sql = sql;
        }

        public Object doInHibernate(Session session) {
            return session.createSQLQuery(this.sql).list();
        }
    }

    private static final class UpdateByHqlCallBack
    implements HibernateCallback {
        private String hql;
        private Object[] values;

        public UpdateByHqlCallBack(String hql, Object[] values) {
            this.hql = hql;
            this.values = values;
        }

        public Integer doInHibernate(Session session) {
            Query query = session.createQuery(this.hql);
            if (this.values != null && this.values.length > 0) {
                for (int i = 0; i < this.values.length; ++i) {
                    query.setParameter(i, this.values[i]);
                }
            }
            return query.executeUpdate();
        }
    }

    private static final class FindByHqlKeyCallBack
    implements HibernateCallback {
        private String hql;
        private Map<String, Object> params;

        public FindByHqlKeyCallBack(String hql, Map<String, Object> params) {
            this.hql = hql;
            this.params = params;
        }

        public Object doInHibernate(Session session) {
            Query query = session.createQuery(this.hql);
            for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                if (entry.getValue() instanceof Collection) {
                    query.setParameterList(entry.getKey(), (Collection)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Object[]) {
                    query.setParameterList(entry.getKey(), (Object[])entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Long) {
                    query.setLong(entry.getKey(), Long.parseLong(entry.getValue().toString()));
                    continue;
                }
                if (entry.getValue() instanceof Integer) {
                    query.setInteger(entry.getKey(), Integer.parseInt(entry.getValue().toString()));
                    continue;
                }
                query.setParameter(entry.getKey(), (Object)entry.getValue().toString());
            }
            return query.list();
        }
    }

    private static final class FindByHqlParCallBack
    implements HibernateCallback {
        private String hql;
        private Map<Integer, String> param;

        public FindByHqlParCallBack(String hql, Map<Integer, String> param) {
            this.hql = hql;
            this.param = param;
        }

        public Object doInHibernate(Session session) {
            Query query = session.createQuery(this.hql);
            Set<Map.Entry<Integer, String>> entrys = this.param.entrySet();
            for (Map.Entry<Integer, String> entry : entrys) {
                query.setString(entry.getKey(), entry.getValue());
            }
            return query.list();
        }
    }

    private static final class FindByHqlHqlCallBack
    implements HibernateCallback {
        private String hql;
        private Object[] values;

        public FindByHqlHqlCallBack(String hql, Object[] values) {
            this.hql = hql;
            this.values = values;
        }

        public Object doInHibernate(Session session) {
            Query query = session.createQuery(this.hql);
            if (this.values != null && this.values.length > 0) {
                for (int i = 0; i < this.values.length; ++i) {
                    query.setParameter(i, this.values[i]);
                }
            }
            return query.list();
        }
    }

    private static final class FindPageTotalCallBack
    implements HibernateCallback {
        private String hql;
        private int firstRowIndex;
        private int totalRow;
        private Map<Integer, String> param;

        public FindPageTotalCallBack(String hql, int firstRowIndex, int totalRow, Map<Integer, String> param) {
            this.hql = hql;
            this.firstRowIndex = firstRowIndex;
            this.totalRow = totalRow;
            this.param = param;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery(this.hql);
            for (Map.Entry<Integer, String> next : this.param.entrySet()) {
                Integer key = next.getKey();
                String value = next.getValue();
                q.setString(key, value);
            }
            q.setFirstResult(this.firstRowIndex);
            q.setMaxResults(this.totalRow);
            return q.list();
        }
    }

    private static final class FindPageHiberCallBack
    implements HibernateCallback {
        private String hql;
        private int firstRowIndex;
        private int totalRow;

        public FindPageHiberCallBack(String hql, int firstRowIndex, int totalRow) {
            this.hql = hql;
            this.firstRowIndex = firstRowIndex;
            this.totalRow = totalRow;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery(this.hql);
            q.setFirstResult(this.firstRowIndex);
            q.setMaxResults(this.totalRow);
            return q.list();
        }
    }
}

