/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.log;

import com.hs.lego.core.log.CrashThreadHandler;
import com.hs.lego.core.log.LogUtil;
import com.hs.lego.core.log.ZipThread;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class ZipRollingFileAppender
extends RollingFileAppender {
    private long nextRollover = 0L;
    private final Object lock = new Object();

    public ZipRollingFileAppender() {
        LogUtil.getInstance().cacheAppender(this);
    }

    public ZipRollingFileAppender(ZipRollingFileAppender appender, String filePath) throws IOException {
        this.setFile(filePath, appender.getAppend(), appender.getBufferedIO(), appender.getBufferSize());
        super.setLayout(appender.getLayout());
        super.setMaximumFileSize(appender.getMaximumFileSize());
        super.setMaxBackupIndex(appender.getMaxBackupIndex());
    }

    @Override
    public void rollOver() {
        if (null != this.qw && this.qw instanceof CountingQuietWriter) {
            long size = ((CountingQuietWriter)this.qw).getCount();
            LogLog.debug("rolling over count=" + size);
            this.nextRollover = size + this.maxFileSize;
        }
        boolean renameSucceeded = true;
        String zipFilePath = "";
        if (this.maxBackupIndex > 0) {
            File file = new File(this.fileName + '.' + this.maxBackupIndex + ".zip");
            if (file.exists()) {
                renameSucceeded = file.delete();
            }
            for (int i = this.maxBackupIndex - 1; i >= 1 && renameSucceeded; --i) {
                file = new File(this.fileName + "." + i + ".zip");
                if (!file.exists()) continue;
                File target = new File(this.fileName + '.' + (i + 1) + ".zip");
                LogLog.debug("Renaming file " + file.getName() + " to " + target.getName());
                renameSucceeded = file.renameTo(target);
            }
            if (renameSucceeded) {
                File target = new File(this.fileName + "." + 1);
                if (target.exists()) {
                    this.deleteFileAndDirectory(target);
                }
                target = new File(this.fileName + "." + 1);
                try {
                    zipFilePath = target.getCanonicalPath();
                }
                catch (IOException e) {
                    LogLog.error("rollOver exception cant't get Path.");
                }
                this.closeFile();
                file = new File(this.fileName);
                LogLog.debug("Renaming file " + file.getName() + " to " + target.getName());
                renameSucceeded = file.renameTo(target);
                if (!renameSucceeded) {
                    this.setFileWithoutException(this.fileName, true, this.bufferedIO, this.bufferSize);
                }
            }
        }
        if (renameSucceeded) {
            this.setFileWithoutException(this.fileName, false, this.bufferedIO, this.bufferSize);
            this.nextRollover = 0L;
            ZipThread thread = new ZipThread();
            thread.setTarget(zipFilePath);
            thread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            thread.start();
        }
    }

    private void deleteFileAndDirectory(File target) {
        File[] fileList;
        Boolean result;
        if (target.isFile() && !(result = Boolean.valueOf(target.delete())).booleanValue()) {
            LogLog.debug("delete file error");
        }
        if (target.isDirectory() && null != (fileList = target.listFiles())) {
            for (int i = 0; i < fileList.length; ++i) {
                this.deleteFileAndDirectory(fileList[i]);
            }
        }
        if (!(result = Boolean.valueOf(target.delete())).booleanValue()) {
            LogLog.debug("delete file error");
        }
    }

    private void setFileWithoutException(String filename, boolean isAppend, boolean bufferedio, int buffersize) {
        try {
            this.setFile(filename, isAppend, bufferedio, buffersize);
        }
        catch (IOException e) {
            LogLog.error("setFile(" + this.fileName + ", false) call failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.setFile(fileName, append, this.bufferedIO, this.bufferSize);
            if (append && this.qw instanceof CountingQuietWriter) {
                File f = new File(fileName);
                ((CountingQuietWriter)this.qw).setCount(f.length());
            }
        }
    }

    @Override
    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    @Override
    protected void subAppend(LoggingEvent event) {
        long size;
        super.subAppend(event);
        if (null != this.fileName && null != this.qw && this.qw instanceof CountingQuietWriter && (size = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize && size >= this.nextRollover) {
            this.rollOver();
        }
    }
}

