/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.helpers.LogLog;

public class ZipThread
extends Thread {
    private static final int BUFFEREDSIZE = 1024;
    private String target;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        FileInputStream in;
        ZipOutputStream zos;
        FileOutputStream fout;
        String zipName;
        File file;
        block10: {
            file = FileUtils.getFile((String[])new String[]{this.target});
            zipName = this.target + ".zip";
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            File zipFile = FileUtils.getFile((String[])new String[]{zipName});
            if (null == file) {
                LogLog.error("ZipThread-run failed caused by null file.");
                return;
            }
            if (null == zipFile) {
                LogLog.error("ZipThread-run failed caused by null zipFile.");
                return;
            }
            this.createFile(zipFile);
            fout = null;
            zos = null;
            in = null;
            fout = new FileOutputStream(zipFile);
            zos = new ZipOutputStream(fout);
            String zipEntryName = new StringBuffer().append(file.getName().substring(0, file.getName().indexOf(".log."))).append("_").append(df.format(new Date())).append(".log").toString();
            zos.putNextEntry(new ZipEntry(zipEntryName));
            if (file.exists()) break block10;
            this.closeZipOutputStream(zos);
            this.closeFileOutputStream(fout);
            this.closeFileInputStream(in);
            if (file.delete()) return;
            LogLog.error("ZipThread-run file.delete() call failed!");
            return;
        }
        try {
            int c;
            in = new FileInputStream(file);
            byte[] by = new byte[1024];
            while ((c = in.read(by)) != -1) {
                zos.write(by, 0, c);
            }
            zos.flush();
            this.closeZipOutputStream(zos);
            this.closeFileOutputStream(fout);
            this.closeFileInputStream(in);
            if (file.delete()) return;
        }
        catch (FileNotFoundException e) {
            LogLog.error("ZipThread-run new FileOutputStream (" + zipName + ") call failed.");
            this.closeZipOutputStream(zos);
            this.closeFileOutputStream(fout);
            this.closeFileInputStream(in);
            if (file.delete()) return;
            LogLog.error("ZipThread-run file.delete() call failed!");
            return;
        }
        catch (IOException e2) {
            LogLog.error("ZipThread-run putNextEntry(new ZipEntry(" + this.target + ")) call failed.");
            this.closeZipOutputStream(zos);
            this.closeFileOutputStream(fout);
            this.closeFileInputStream(in);
            if (file.delete()) return;
            {
                catch (Throwable throwable) {
                    this.closeZipOutputStream(zos);
                    this.closeFileOutputStream(fout);
                    this.closeFileInputStream(in);
                    if (file.delete()) throw throwable;
                    LogLog.error("ZipThread-run file.delete() call failed!");
                    throw throwable;
                }
            }
            LogLog.error("ZipThread-run file.delete() call failed!");
            return;
        }
        LogLog.error("ZipThread-run file.delete() call failed!");
        return;
    }

    private void closeZipOutputStream(ZipOutputStream zos) {
        try {
            if (null != zos) {
                zos.close();
            }
        }
        catch (IOException e) {
            LogLog.error("zos.close() call failed.");
        }
    }

    private void closeFileOutputStream(FileOutputStream fout) {
        try {
            if (null != fout) {
                fout.close();
            }
        }
        catch (IOException e) {
            LogLog.error("fout.close() call failed.");
        }
    }

    private void closeFileInputStream(FileInputStream in) {
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (IOException e) {
            LogLog.error("in.close() call failed.");
        }
    }

    private void createFile(File zipFile) {
        if (!zipFile.exists()) {
            try {
                if (zipFile.createNewFile()) {
                    LogLog.debug("createNewFile success.");
                }
            }
            catch (IOException e) {
                LogLog.error("createNewFile call failed.");
            }
        }
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

