/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify.send;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class SyslogServer {
    protected final transient Log logger = LogFactory.getInstance(Module.ATIC_CORE_BASE);
    private String host;
    private int port;
    private DatagramSocket socket;

    public SyslogServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String toString() {
        return "SyslogServer [host=" + this.host + ", port=" + this.port + "]";
    }

    public void sendSyslog(byte[] logBytes) {
        try {
            if (this.socket == null) {
                this.socket = new DatagramSocket();
            }
            DatagramPacket packet = new DatagramPacket(logBytes, logBytes.length, InetAddress.getByName(this.host), this.port);
            this.socket.send(packet);
        }
        catch (IOException e) {
            this.socket = null;
            this.logger.error("sendSyslog socket error");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SyslogServer) {
            SyslogServer server = (SyslogServer)o;
            return server.getHost().equals(this.host);
        }
        return false;
    }

    public int hashCode() {
        return (this.host + this.port).hashCode();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

