/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify.service;

import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.lego.core.log.CrashThreadHandler;
import com.hs.lego.core.notify.send.SyslogSendThread;
import com.hs.lego.core.notify.send.SyslogServer;
import com.hs.lego.core.system.notify.sdk.model.SyslogBean;
import com.hs.lego.core.system.notify.sdk.service.ISyslogSendService;
import com.huawei.secsyslog.ServerInfoObj;
import com.huawei.secsyslog.SysLogClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SyslogSendServiceImpl
implements ISyslogSendService {
    private Map<String, SyslogServerEntity> syslogServerMap = new HashMap<String, SyslogServerEntity>();

    @Override
    public void sendSyslog(String keyIpPort, SyslogBean logBean) {
        SyslogSendThread.getInstance().addSyslog(keyIpPort, logBean);
    }

    @Override
    public void setSyslogServer() {
        ArrayList<SyslogServer> syslogServerList = new ArrayList<SyslogServer>();
        ArrayList<ServerInfoObj> serverInfoList = new ArrayList<ServerInfoObj>();
        for (Map.Entry<String, SyslogServerEntity> serverMap : this.syslogServerMap.entrySet()) {
            SyslogServerEntity server = serverMap.getValue();
            ServerInfoObj info = new ServerInfoObj();
            info.setIp(server.getServerIp());
            info.setPort(server.getServerPort());
            serverInfoList.add(info);
            SyslogServer syslog = new SyslogServer(server.getServerIp(), server.getServerPort());
            syslogServerList.add(syslog);
        }
        SyslogSendThread syslogSendThread = SyslogSendThread.getInstance();
        SysLogClient sysLogClientOld = syslogSendThread.getSysLogClient();
        if (null != sysLogClientOld) {
            sysLogClientOld.stopClient();
        }
        syslogSendThread.setLogServers(syslogServerList);
        SysLogClient sysLogClient = new SysLogClient(null, serverInfoList, null, null);
        sysLogClient.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
        sysLogClient.start();
        syslogSendThread.setSysLogClient(sysLogClient);
    }

    @Override
    public Map<String, Object> getSyslogServerMapKeysAndValues() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<SyslogServerEntity> values = new ArrayList<SyslogServerEntity>();
        for (Map.Entry<String, SyslogServerEntity> serverMap : this.syslogServerMap.entrySet()) {
            keys.add(serverMap.getKey());
            values.add(serverMap.getValue());
        }
        resultMap.put("keys", keys);
        resultMap.put("values", values);
        return resultMap;
    }

    @Override
    public SyslogServerEntity getSyslogServerMap(String keyIpPort) {
        return this.syslogServerMap.get(keyIpPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putSyslogServerMap(String keyIpPort, SyslogServerEntity syslogServer) {
        Map<String, SyslogServerEntity> map = this.syslogServerMap;
        synchronized (map) {
            this.syslogServerMap.put(keyIpPort, syslogServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSyslogServerMap(String keyIpPort) {
        Map<String, SyslogServerEntity> map = this.syslogServerMap;
        synchronized (map) {
            this.syslogServerMap.remove(keyIpPort);
        }
    }
}

