/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect;

import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class KmcManager {
    private static KmcFiles currKmcFiles = null;
    private KmcFiles kmcFileNames = null;

    public KmcManager(KmcFiles kmcFileNames) {
        this.kmcFileNames = kmcFileNames;
    }

    public static void loadKmcLib(String libFolderPath) {
        try {
            String osName = System.getProperty("os.name");
            if (null == osName) {
                return;
            }
            if (osName.equals("SunOS") || osName.equals("AIX") || osName.equals("Linux")) {
                System.load(libFolderPath + "/libsecurec.so");
                System.load(libFolderPath + "/libcrypto.so.1.0.0");
                System.load(libFolderPath + "/libssl.so");
                System.load(libFolderPath + "/libKMC.so");
                System.load(libFolderPath + "/libSDP.so");
            } else {
                System.load(libFolderPath + "/libcrypto-1_1-x64.dll");
                System.load(libFolderPath + "/pthreadVC2.dll");
                System.load(libFolderPath + "/libsecurec.dll");
                System.load(libFolderPath + "/libSDP4j.dll");
            }
        }
        catch (UnsatisfiedLinkError ule) {
            Runtime.getRuntime().exit(0);
        }
        catch (Exception e) {
            Runtime.getRuntime().exit(0);
        }
    }

    public void doBeforeUse() {
        if (this.kmcFileNames != null && !this.kmcFileNames.equals(currKmcFiles)) {
            this.reload();
        }
    }

    private void init() {
        this.wsecInitialize(this.kmcFileNames.getKeyStoreFile(), this.kmcFileNames.getKeyStoreBakFile(), this.kmcFileNames.getKmcCfgFile(), this.kmcFileNames.getKmcCfgBakFile(), this.kmcFileNames.getLogConfigFile());
        KmcManager.setCurrKmcFiles(this.kmcFileNames);
    }

    public static void setCurrKmcFiles(KmcFiles dcurrKmcFiles) {
        currKmcFiles = dcurrKmcFiles;
    }

    private void reload() {
        if (null != currKmcFiles) {
            this.wsecFinalize();
        }
        this.init();
    }

    private native long wsecInitialize(String var1, String var2, String var3, String var4, String var5);

    private native long wsecFinalize();

    private native long sdpGetCipherDataLen(long var1);

    public long sdpGetCipherDataLenWrapper(long ulPlainTextLen) {
        return this.sdpGetCipherDataLen(ulPlainTextLen);
    }

    private native long sdpEncrypt(long var1, byte[] var3, long var4, byte[] var6, Long var7);

    public long sdpEncryptWrapper(long ulDomain, byte[] pucPlainText, long ulPTLen, byte[] pucCipherText, Long pulCTLen) {
        return this.sdpEncrypt(ulDomain, pucPlainText, ulPTLen, pucCipherText, pulCTLen);
    }

    private native long sdpDecrypt(long var1, byte[] var3, long var4, byte[] var6, Integer var7);

    public long sdpDecryptWrapper(long ulDomain, byte[] pucCipherText, long ulCTLen, byte[] pucPlainText, Integer pulPTLen) {
        return this.sdpDecrypt(ulDomain, pucCipherText, ulCTLen, pucPlainText, pulPTLen);
    }

    private native long sdpGetPwdCipherLen(long var1);

    public long sdpGetPwdCipherLenWrapper(long ulPlainTextLen) {
        return this.sdpGetPwdCipherLen(ulPlainTextLen);
    }

    private native long sdpProtectPwd(byte[] var1, long var2, byte[] var4, long var5);

    public long sdpProtectPwdWrapper(byte[] pucPlainText, long ulPTLen, byte[] pucCipherText, long ulCTLen) {
        return this.sdpProtectPwd(pucPlainText, ulPTLen, pucCipherText, ulCTLen);
    }

    private native long sdpVerifyPwd(byte[] var1, long var2, byte[] var4, long var5);

    public long sdpVerifyPwdWrapper(byte[] pucPlainText, long ulPTLen, byte[] pucCipherText, long ulCLen) {
        return this.sdpVerifyPwd(pucPlainText, ulPTLen, pucCipherText, ulCLen);
    }

    private native long dhGenPublicKey(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public long dhGenPublicKeyWrapper(byte[] privateKey, byte[] publicKey, byte[] p, byte[] g) {
        return this.dhGenPublicKey(privateKey, publicKey, p, g);
    }

    public byte[] sdpHmac(byte[] pucPlainText) {
        MessageDigest md = null;
        String encName = "SHA-256";
        try {
            md = MessageDigest.getInstance(encName);
            md.update(pucPlainText);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("sdpHmac.no such mothed");
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("sdpHmac exception mothed not found");
        }
    }
}

