/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect.util;

import com.hs.lego.core.base.dataprotect.service.DataProtectService;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.exception.LegoCheckedException;

public abstract class DataProtectServiceConst {
    private static volatile IDataProtectService dataProtectService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDataProtectService getDataProtectService() {
        if (null != dataProtectService) return dataProtectService;
        Class<DataProtectServiceConst> clazz = DataProtectServiceConst.class;
        synchronized (DataProtectServiceConst.class) {
            if (null != dataProtectService) return dataProtectService;
            dataProtectService = new DataProtectService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dataProtectService;
        }
    }

    public static String sdpEncryptInitData(String pucCipherText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            System.out.println(errorMsg);
            throw new LegoCheckedException(102L, errorMsg);
        }
        result = srv.sdpEncryptInitData(pucCipherText);
        return result;
    }

    public static String sdpDecryptInitData(String pucCipherText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            System.out.println(errorMsg);
            throw new LegoCheckedException(102L, errorMsg);
        }
        result = srv.sdpDecryptInitData(pucCipherText);
        return result;
    }

    public static String sdpEncryptInitData(StringBuffer pucCipherText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            System.out.println(errorMsg);
            throw new LegoCheckedException(102L, errorMsg);
        }
        result = srv.sdpEncryptInitData(pucCipherText);
        return result;
    }

    public static StringBuffer sdpDecryptInitDataBuffer(String pucCipherText) {
        StringBuffer result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            System.out.println(errorMsg);
            throw new LegoCheckedException(102L, errorMsg);
        }
        result = srv.sdpDecryptInitDataByte(pucCipherText);
        return result;
    }

    public static String sdpEncryptLocal(String pucPlainText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "DataProtectServiceConst.sdpEncryptLocal getDataProtectService fail";
            System.out.println(errorMsg);
            throw new LegoCheckedException(102L, errorMsg);
        }
        result = srv.sdpEncrypt(0L, pucPlainText);
        return result;
    }

    public static String sdpDecryptLocal(String pucCipherText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "DataProtectServiceConst.sdpDecryptLocal getDataProtectService fail";
            System.out.println(errorMsg);
            throw new LegoCheckedException(102L, errorMsg);
        }
        result = srv.sdpDecrypt(0L, pucCipherText);
        return result;
    }

    public static String sdpEncryptLocal(StringBuffer pucPlainText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "DataProtectServiceConst.sdpEncryptLocal getDataProtectService fail";
            System.out.println(errorMsg);
            throw new LegoCheckedException(102L, errorMsg);
        }
        result = srv.sdpEncrypt(0L, pucPlainText);
        return result;
    }

    public static StringBuffer sdpDecryptLocalBuffer(String pucCipherText) {
        StringBuffer result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "DataProtectServiceConst.sdpDecryptLocal getDataProtectService fail";
            System.out.println(errorMsg);
            throw new LegoCheckedException(102L, errorMsg);
        }
        result = srv.sdpDecrypt(pucCipherText, 0L);
        return result;
    }

    public static String sdpProtectPwdLocal(StringBuffer pucPlainText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            System.out.println(errorMsg);
            throw new LegoCheckedException(102L, errorMsg);
        }
        result = srv.sdpProtectPwd(pucPlainText);
        return result;
    }

    public static boolean sdpVerifyPwdLocal(StringBuffer pucPlainText, String pucCipherText) {
        boolean result = false;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            System.out.println(errorMsg);
            throw new LegoCheckedException(102L, errorMsg);
        }
        result = srv.sdpVerifyPwd(pucPlainText, pucCipherText);
        return result;
    }

    public static void setDataProtectService(IDataProtectService dataProtectService) {
        DataProtectServiceConst.dataProtectService = dataProtectService;
    }
}

