/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect.util;

import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.xml.sax.SAXException;

public class DecryptUtil {
    public static void main(String[] args) {
        DecryptUtil.readDBFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readDBFile() {
        String filePath = ".." + File.separator + "legoPlatInstalled.xml";
        FileInputStream fileInputStream = null;
        try {
            File file = new File(filePath);
            fileInputStream = new FileInputStream(file);
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setExpandEntityReferences(false);
            dbf.setXIncludeAware(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = new DOMReader().read(db.parse(fileInputStream));
            if (null == document) {
                return;
            }
            Element root = document.getRootElement();
            List elementsList = root.element("propMap").elements("entry");
            if (null != elementsList && !elementsList.isEmpty()) {
                DecryptUtil.readXmlElement(elementsList);
            }
        }
        catch (SAXException e) {
            System.out.println("SAXException: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            System.out.println("ParserConfigurationException: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("IOException: " + e.getMessage());
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    System.out.println("IOException: " + e.getMessage());
                }
            }
        }
    }

    private static void readXmlElement(List<Element> elementsList) {
        for (Element element : elementsList) {
            String keyString = element.elementText("string");
            if (keyString.equalsIgnoreCase("lego.db.username")) {
                String userName = element.element("com.huawei.elog.base.model.ContextPropVal").elementText("value");
                System.out.println("username=" + userName);
            }
            if (!keyString.equalsIgnoreCase("lego.db.password.encrypt")) continue;
            String password = DataProtectServiceConst.sdpDecryptLocal(element.element("com.huawei.elog.base.model.ContextPropVal").elementText("value"));
            System.out.println("password=" + password);
        }
    }
}

