/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.file.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class PropertiesLoader {
    private PropertiesLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(String fileFullPath, boolean fromClassPath) throws IOException {
        InputStream in = null;
        Properties prop = null;
        try {
            if (fromClassPath) {
                ClassLoader clazzLoader = PropertiesLoader.class.getClassLoader();
                if (null != clazzLoader) {
                    in = clazzLoader.getResourceAsStream(fileFullPath);
                }
            } else {
                in = new FileInputStream(fileFullPath);
            }
            if (in != null) {
                prop = new Properties();
                if (fileFullPath.endsWith("xml")) {
                    prop.loadFromXML(in);
                } else {
                    prop.load(in);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("close error", e);
            }
        }
        return prop;
    }
}

